/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.memoryanalyzer.DuplicatedBitmapAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.Printer;
import com.android.tools.perflib.heap.memoryanalyzer.Report;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DuplicatedBitmapReport
implements Report {
    private List<AnalysisResultEntry<?>> results;

    @Override
    public void generate(List<AnalysisResultEntry<?>> data) {
        ArrayList<DuplicatedBitmapAnalyzerTask.DuplicatedBitmapEntry> bitmapEntries = new ArrayList<DuplicatedBitmapAnalyzerTask.DuplicatedBitmapEntry>();
        for (AnalysisResultEntry<?> entry : data) {
            if (entry instanceof DuplicatedBitmapAnalyzerTask.DuplicatedBitmapEntry) {
                bitmapEntries.add((DuplicatedBitmapAnalyzerTask.DuplicatedBitmapEntry)entry);
                continue;
            }
            this.results = null;
            return;
        }
        Collections.sort(bitmapEntries, Collections.reverseOrder((o1, o2) -> DuplicatedBitmapReport.getConsumedBytes(o1) - DuplicatedBitmapReport.getConsumedBytes(o2)));
        this.results = new ArrayList();
        this.results.addAll(bitmapEntries);
    }

    @Override
    public void print(Printer printer) {
        DuplicatedBitmapAnalyzerTask task = new DuplicatedBitmapAnalyzerTask();
        printer.addHeading(2, task.getTaskName() + " Report");
        printer.addParagraph(task.getTaskDescription());
        if (this.results == null || this.results.isEmpty()) {
            printer.addParagraph("No issues found.");
            return;
        }
        for (AnalysisResultEntry<?> entry : this.results) {
            if (entry.getOffender().getOffenders().size() < 1 || !(entry instanceof DuplicatedBitmapAnalyzerTask.DuplicatedBitmapEntry)) continue;
            Instance firstInstance = (Instance)entry.getOffender().getOffenders().get(0);
            printer.addHeading(3, printer.formatInstance(firstInstance));
            printer.addImage(firstInstance);
            int size = ((DuplicatedBitmapAnalyzerTask.DuplicatedBitmapEntry)entry).getByteArraySize();
            String bytes = Integer.toString(size);
            int duplicates = entry.getOffender().getOffenders().size();
            printer.startTable("Bytes", "Duplicates", "Total Bytes Consumed");
            printer.addRow(bytes, Integer.toString(duplicates), Integer.toString(size * duplicates));
            printer.endTable();
            printer.startTable("All Duplicates");
            List<?> instances = entry.getOffender().getOffenders();
            for (Instance instance : instances) {
                printer.addRow(printer.formatInstance(instance));
            }
            printer.endTable();
        }
    }

    private static int getConsumedBytes(DuplicatedBitmapAnalyzerTask.DuplicatedBitmapEntry entry) {
        return entry.getByteArraySize() * entry.getOffender().getOffenders().size();
    }
}

