/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Visitor;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.Deque;

public class NonRecursiveVisitor
implements Visitor {
    protected final Deque<Instance> mStack = new ArrayDeque<Instance>();
    protected final LongOpenHashSet mSeen = new LongOpenHashSet();

    protected void defaultAction(Instance instance) {
    }

    @Override
    public void visitRootObj(RootObj root2) {
        this.defaultAction(root2);
    }

    @Override
    public void visitArrayInstance(ArrayInstance instance) {
        this.defaultAction(instance);
    }

    @Override
    public void visitClassInstance(ClassInstance instance) {
        this.defaultAction(instance);
    }

    @Override
    public void visitClassObj(ClassObj instance) {
        this.defaultAction(instance);
    }

    @Override
    public void visitLater(Instance parent, Instance child) {
        this.mStack.push(child);
    }

    public void doVisit(Iterable<? extends Instance> startNodes) {
        for (Instance instance : startNodes) {
            if (instance instanceof RootObj) {
                instance.accept(this);
                continue;
            }
            this.visitLater(null, instance);
        }
        while (!this.mStack.isEmpty()) {
            Instance node = this.mStack.pop();
            if (!this.mSeen.add(node.getId())) continue;
            node.accept(this);
        }
    }
}

