/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.analyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AnalysisReport {
    private Set<Listener> mListeners = new HashSet<Listener>();
    private List<AnalysisResultEntry<?>> mAnalysisResults = new ArrayList();
    private volatile boolean mCompleted = false;
    private volatile boolean mCancelled = false;

    public void addAnalysisResultEntries(List<AnalysisResultEntry<?>> entries) {
        this.mAnalysisResults.addAll(entries);
        for (Listener listener2 : this.mListeners) {
            listener2.onResultsAdded(entries);
        }
    }

    public void setCompleted() {
        if (this.mCompleted || this.mCancelled) {
            return;
        }
        this.mCompleted = true;
        for (Listener listener2 : this.mListeners) {
            listener2.onAnalysisComplete();
        }
    }

    public void setCancelled() {
        if (this.mCompleted || this.mCancelled) {
            return;
        }
        this.mCancelled = true;
        for (Listener listener2 : this.mListeners) {
            listener2.onAnalysisCancelled();
        }
    }

    public void addResultListeners(Set<Listener> listeners) {
        this.mListeners.addAll(listeners);
    }

    public void removeResultListener(Set<Listener> listener2) {
        this.mListeners.removeAll(listener2);
    }

    public static interface Listener {
        public void onResultsAdded(List<AnalysisResultEntry<?>> var1);

        public void onAnalysisComplete();

        public void onAnalysisCancelled();
    }
}

