/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nJ\u0013\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\bJ$\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0015\u001a\u00020\u000eJ&\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0015\u001a\u00020\u000eJ$\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0015\u001a\u00020\u000eJ&\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0015\u001a\u00020\u000eJ$\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\n2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u001a\u001a\u00020\u000eJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\bJ\u0006\u0010\u001d\u001a\u00020\u000eJ\u001a\u0010\u001e\u001a\u00020\u00002\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0 J\b\u0010!\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/model/PathVariables;", "", "<init>", "()V", "pathVariables", "", "Lcom/android/tools/lint/model/PathVariables$PathVariable;", "add", "", "name", "", "dir", "Ljava/io/File;", "sort", "", "contains", "get", "clear", "toPathString", "file", "relativeTo", "unix", "toPathStringIfMatched", "fullPath", "fromPathString", "path", "allowMissingPathVariable", "other", "normalize", "any", "filter", "predicate", "Lkotlin/Function1;", "toString", "PathVariable", "Companion", "android.sdktools.lint-model"})
@SourceDebugExtension(value={"SMAP\nPathVariables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathVariables.kt\ncom/android/tools/lint/model/PathVariables\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,309:1\n295#2,2:310\n295#2,2:313\n295#2,2:315\n295#2,2:317\n1#3:312\n*S KotlinDebug\n*F\n+ 1 PathVariables.kt\ncom/android/tools/lint/model/PathVariables\n*L\n50#1:310,2\n139#1:313,2\n150#1:315,2\n178#1:317,2\n*E\n"})
public final class PathVariables {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PathVariable> pathVariables = new ArrayList();
    @NotNull
    private static final String CANONICALIZED = "_canonical";
    @NotNull
    private static final Comparator<PathVariable> PATH_COMPARATOR;

    @JvmOverloads
    public final void add(@NotNull String name, @NotNull File dir, boolean sort) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        PathVariables.Companion.checkPathVariableName(name);
        PathVariable variable = new PathVariable(name, dir);
        this.pathVariables.add(variable);
        if (sort) {
            this.sort();
        }
    }

    public static /* synthetic */ void add$default(PathVariables pathVariables, String string2, File file, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        pathVariables.add(string2, file, bl);
    }

    public final boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.get(name) != null;
    }

    @Nullable
    public final File get(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.pathVariables;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PathVariable it = (PathVariable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PathVariable pathVariable = v0;
        return pathVariable != null ? pathVariable.getDir() : null;
    }

    public final void sort() {
        CollectionsKt.sortWith(this.pathVariables, PATH_COMPARATOR);
    }

    public final void clear() {
        this.pathVariables.clear();
    }

    @NotNull
    public final String toPathString(@NotNull File file, @Nullable File relativeTo, boolean unix) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        File file2 = relativeTo;
        return this.toPathString(string2, file2 != null ? file2.getPath() : null, unix);
    }

    public static /* synthetic */ String toPathString$default(PathVariables pathVariables, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathString(file, file2, bl);
    }

    @Nullable
    public final String toPathStringIfMatched(@NotNull File file, @Nullable File relativeTo, boolean unix) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        File file2 = relativeTo;
        return this.toPathStringIfMatched(string2, file2 != null ? file2.getPath() : null, unix);
    }

    public static /* synthetic */ String toPathStringIfMatched$default(PathVariables pathVariables, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathStringIfMatched(file, file2, bl);
    }

    @NotNull
    public final String toPathString(@NotNull String fullPath, @Nullable String relativeTo, boolean unix) {
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        String string2 = this.toPathStringIfMatched(fullPath, relativeTo, unix);
        if (string2 == null) {
            String it = fullPath;
            boolean bl = false;
            string2 = unix ? StringsKt.replace$default((String)it, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it;
        }
        return string2;
    }

    public static /* synthetic */ String toPathString$default(PathVariables pathVariables, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathString(string2, string3, bl);
    }

    @Nullable
    public final String toPathStringIfMatched(@NotNull String fullPath, @Nullable String relativeTo, boolean unix) {
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        for (PathVariable pathVariable : this.pathVariables) {
            String prefix = pathVariable.component1();
            File root2 = pathVariable.component2();
            String string2 = root2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            if (!StringsKt.startsWith$default((String)fullPath, (String)string2, (boolean)false, (int)2, null)) continue;
            if (Intrinsics.areEqual((Object)fullPath, (Object)root2.getPath())) {
                return "$" + StringsKt.removeSuffix((String)prefix, (CharSequence)CANONICALIZED);
            }
            if (fullPath.length() <= root2.getPath().length() || fullPath.charAt(root2.getPath().length()) != File.separatorChar) continue;
            String string3 = fullPath.substring(root2.getPath().length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String relative = string3;
            String it = "$" + StringsKt.removeSuffix((String)prefix, (CharSequence)CANONICALIZED) + relative;
            boolean bl = false;
            return unix ? StringsKt.replace$default((String)it, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it;
        }
        if (relativeTo != null && StringsKt.startsWith$default((String)fullPath, (String)relativeTo, (boolean)false, (int)2, null) && fullPath.length() > relativeTo.length() && fullPath.charAt(relativeTo.length()) == File.separatorChar) {
            String string4 = fullPath.substring(relativeTo.length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String it = string4;
            boolean bl = false;
            return unix ? StringsKt.replace$default((String)it, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it;
        }
        return null;
    }

    public static /* synthetic */ String toPathStringIfMatched$default(PathVariables pathVariables, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathStringIfMatched(string2, string3, bl);
    }

    @NotNull
    public final File fromPathString(@NotNull String path, @Nullable File relativeTo, boolean allowMissingPathVariable) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)"$", (boolean)false, (int)2, null)) {
            Object object;
            Object v6;
            String name;
            block16: {
                boolean hasBraces = path.length() > 1 && path.charAt(1) == '{';
                int n = path.length();
                for (int i = 1; i < n; ++i) {
                    Object object2;
                    Object v1;
                    String varName;
                    char c;
                    block15: {
                        c = path.charAt(i);
                        if ((!hasBraces || path.charAt(i - 1) != '}') && (hasBraces || Character.isJavaIdentifierPart(c))) continue;
                        String string2 = path.substring(1, i);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        varName = string2;
                        Iterable $this$firstOrNull$iv = this.pathVariables;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PathVariable it = (PathVariable)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)varName)) continue;
                            v1 = element$iv;
                            break block15;
                        }
                        v1 = null;
                    }
                    if ((object2 = (PathVariable)v1) == null || (object2 = ((PathVariable)object2).getDir()) == null) {
                        if (allowMissingPathVariable) {
                            object2 = new File("$" + varName);
                        } else {
                            throw new IllegalStateException(("Path variable $" + varName + " referenced in " + path + " not provided to serialization").toString());
                        }
                    }
                    Object dir = object2;
                    int relativeStart = switch (c) {
                        case '/', '\\' -> i + 1;
                        default -> i;
                    };
                    String string3 = path.substring(relativeStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    return new File((File)dir, string3);
                }
                String string4 = path.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                name = string4;
                Iterable $this$firstOrNull$iv = this.pathVariables;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PathVariable it = (PathVariable)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v6 = element$iv;
                    break block16;
                }
                v6 = null;
            }
            if ((object = (PathVariable)v6) == null || (object = ((PathVariable)object).getDir()) == null) {
                if (allowMissingPathVariable) {
                    object = new File("$" + name);
                } else {
                    throw new IllegalStateException(("Path variable $" + name + " referenced in " + path + " not provided to serialization").toString());
                }
            }
            return object;
        }
        File file = new File(path);
        if (relativeTo != null && !file.isAbsolute()) {
            File parentFile;
            if ((StringsKt.startsWith$default((String)path, (String)"../", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"..\\", (boolean)false, (int)2, null)) && (parentFile = relativeTo.getParentFile()) != null) {
                String string5 = path.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                return new File(parentFile, string5);
            }
            return new File(relativeTo, path);
        }
        return file;
    }

    public static /* synthetic */ File fromPathString$default(PathVariables pathVariables, String string2, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.fromPathString(string2, file, bl);
    }

    public final void add(@NotNull PathVariables other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (PathVariable variable : other.pathVariables) {
            Object v0;
            block3: {
                String name = variable.getName();
                PathVariables.Companion.checkPathVariableName(name);
                Iterable $this$firstOrNull$iv = this.pathVariables;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PathVariable it = (PathVariable)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((PathVariable)v0 != null) {
                PathVariable it;
                boolean bl = false;
                this.pathVariables.remove(it);
            }
            this.pathVariables.add(variable);
        }
        this.sort();
    }

    public final void normalize() {
        if (this.pathVariables.isEmpty()) {
            return;
        }
        for (PathVariable variable : CollectionsKt.toList((Iterable)this.pathVariables)) {
            try {
                boolean bl;
                boolean bl2 = bl = !StringsKt.endsWith$default((String)variable.getName(), (String)CANONICALIZED, (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                File canonical = variable.getDir().getCanonicalFile();
                if (Intrinsics.areEqual((Object)canonical.getPath(), (Object)variable.getDir().getPath())) continue;
                String string3 = variable.getName() + CANONICALIZED;
                Intrinsics.checkNotNull((Object)canonical);
                this.add(string3, canonical, false);
            }
            catch (IOException iOException) {}
        }
        this.sort();
    }

    public final boolean any() {
        return !((Collection)this.pathVariables).isEmpty();
    }

    @NotNull
    public final PathVariables filter(@NotNull Function1<? super String, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        PathVariables filtered = new PathVariables();
        for (PathVariable variable : this.pathVariables) {
            if (!((Boolean)predicate.invoke((Object)variable.getName())).booleanValue()) continue;
            filtered.pathVariables.add(variable);
        }
        return filtered;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.pathVariables, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmOverloads
    public final void add(@NotNull String name, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        PathVariables.add$default(this, name, dir, false, 4, null);
    }

    private static final Comparable PATH_COMPARATOR$lambda$0(PathVariable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Boolean.valueOf(StringsKt.endsWith$default((String)it.getName(), (String)CANONICALIZED, (boolean)false, (int)2, null));
    }

    private static final Comparable PATH_COMPARATOR$lambda$1(PathVariable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(-it.getDir().getPath().length());
    }

    private static final Comparable PATH_COMPARATOR$lambda$2(PathVariable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getDir().getPath());
    }

    private static final Comparable PATH_COMPARATOR$lambda$3(PathVariable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getName());
    }

    static {
        Function1[] function1Array = new Function1[]{PathVariables::PATH_COMPARATOR$lambda$0, PathVariables::PATH_COMPARATOR$lambda$1, PathVariables::PATH_COMPARATOR$lambda$2, PathVariables::PATH_COMPARATOR$lambda$3};
        PATH_COMPARATOR = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/model/PathVariables$Companion;", "", "<init>", "()V", "CANONICALIZED", "", "isPrivatePathVariable", "", "path", "PATH_COMPARATOR", "Ljava/util/Comparator;", "Lcom/android/tools/lint/model/PathVariables$PathVariable;", "Lkotlin/Comparator;", "parse", "Lcom/android/tools/lint/model/PathVariables;", "s", "checkPathVariableName", "", "name", "startsWithVariable", "variable", "android.sdktools.lint-model"})
    @SourceDebugExtension(value={"SMAP\nPathVariables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathVariables.kt\ncom/android/tools/lint/model/PathVariables$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,309:1\n1255#2,2:310\n127#2,2:312\n*S KotlinDebug\n*F\n+ 1 PathVariables.kt\ncom/android/tools/lint/model/PathVariables$Companion\n*L\n282#1:310,2\n285#1:312,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isPrivatePathVariable(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return !StringsKt.startsWith$default((String)path, (String)"{", (boolean)false, (int)2, null);
        }

        @NotNull
        public final PathVariables parse(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            PathVariables variables = new PathVariables();
            Set names = new LinkedHashSet();
            char[] cArray = new char[]{';'};
            for (String pair2 : StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                if (StringsKt.isBlank((CharSequence)pair2)) continue;
                int index2 = StringsKt.indexOf$default((CharSequence)pair2, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (index2 <= 0 || index2 == pair2.length() - 1 || StringsKt.startsWith$default((String)pair2, (String)"$$", (boolean)false, (int)2, null)) {
                    throw new IllegalStateException(("Invalid path descriptor " + pair2 + ", expected name=path-prefix").toString());
                }
                String string2 = pair2.substring(0, index2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String name = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (!names.add(name)) continue;
                String string3 = pair2.substring(index2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                File prefix = new File(((Object)StringsKt.trim((CharSequence)string3)).toString());
                variables.add(name, prefix, false);
            }
            variables.sort();
            return variables;
        }

        /*
         * WARNING - void declaration
         */
        private final void checkPathVariableName(String name) {
            if (StringsKt.startsWith$default((CharSequence)name, (char)'{', (boolean)false, (int)2, null)) {
                if (!StringsKt.endsWith$default((CharSequence)name, (char)'}', (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name, (String)"}_canonical", (boolean)false, (int)2, null)) {
                    throw new IllegalStateException(("Invalid path variable name " + name + ", missing ending \"}\".").toString());
                }
            } else {
                boolean bl;
                char it;
                Sequence $this$any$iv;
                block6: {
                    $this$any$iv = StringsKt.asSequence((CharSequence)name);
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        it = ((Character)element$iv2).charValue();
                        boolean bl2 = false;
                        if (!(!Character.isJavaIdentifierPart(it))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (bl) {
                    String string2;
                    Object element$iv2;
                    block7: {
                        void $this$first$iv;
                        $this$any$iv = StringsKt.asSequence((CharSequence)name);
                        string2 = name;
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            it = ((Character)element$iv2).charValue();
                            boolean bl3 = false;
                            if (!(!Character.isJavaIdentifierPart(it))) continue;
                            break block7;
                        }
                        throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    String string3 = "Invalid path variable name " + string2 + ". Contains illegal character \"" + element$iv2 + "\".";
                    throw new IllegalStateException(string3.toString());
                }
            }
        }

        public final boolean startsWithVariable(@NotNull String path, @NotNull String variable) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            if (StringsKt.startsWith$default((String)path, (String)"$", (boolean)false, (int)2, null)) {
                boolean hasBraces = path.length() > 1 && path.charAt(1) == '{';
                int n = path.length();
                for (int i = 1; i < n; ++i) {
                    char c = path.charAt(i);
                    if ((!hasBraces || path.charAt(i - 1) != '}') && (hasBraces || Character.isJavaIdentifierPart(c))) continue;
                    return i - 1 == variable.length() && StringsKt.regionMatches$default((String)path, (int)1, (String)variable, (int)0, (int)variable.length(), (boolean)false, (int)16, null);
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/model/PathVariables$PathVariable;", "", "name", "", "dir", "Ljava/io/File;", "<init>", "(Ljava/lang/String;Ljava/io/File;)V", "getName", "()Ljava/lang/String;", "getDir", "()Ljava/io/File;", "toString", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "android.sdktools.lint-model"})
    private static final class PathVariable {
        @NotNull
        private final String name;
        @NotNull
        private final File dir;

        public PathVariable(@NotNull String name, @NotNull File dir) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            this.name = name;
            this.dir = dir;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final File getDir() {
            return this.dir;
        }

        @NotNull
        public String toString() {
            return this.name + "=" + this.dir;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final File component2() {
            return this.dir;
        }

        @NotNull
        public final PathVariable copy(@NotNull String name, @NotNull File dir) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            return new PathVariable(name, dir);
        }

        public static /* synthetic */ PathVariable copy$default(PathVariable pathVariable, String string2, File file, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = pathVariable.name;
            }
            if ((n & 2) != 0) {
                file = pathVariable.dir;
            }
            return pathVariable.copy(string2, file);
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.dir.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathVariable)) {
                return false;
            }
            PathVariable pathVariable = (PathVariable)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)pathVariable.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dir, (Object)pathVariable.dir);
        }
    }
}

