/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelDependencyGraph;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/model/LintModelDependenciesWriter;", "Lcom/android/tools/lint/model/LintModelWriter;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "variantName", "", "artifactName", "writer", "Ljava/io/Writer;", "<init>", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/lang/String;Ljava/lang/String;Ljava/io/Writer;)V", "writeDependencies", "", "dependencies", "Lcom/android/tools/lint/model/LintModelDependencies;", "writeDependencyGraph", "tag", "graph", "Lcom/android/tools/lint/model/LintModelDependencyGraph;", "indent", "", "addDependencies", "item", "Lcom/android/tools/lint/model/LintModelDependency;", "map", "", "writeDependency", "library", "android.sdktools.lint-model"})
final class LintModelDependenciesWriter
extends LintModelWriter {
    public LintModelDependenciesWriter(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @NotNull String variantName, @NotNull String artifactName, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(adapter, new PrintWriter(writer));
    }

    public /* synthetic */ LintModelDependenciesWriter(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, String string2, String string3, Writer writer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            writer = lintModelSerializationAdapter.getWriter(LintModelSerialization.TargetFile.DEPENDENCIES, string2, string3);
        }
        this(lintModelSerializationAdapter, string2, string3, writer);
    }

    public final void writeDependencies(@NotNull LintModelDependencies dependencies) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        int indent = 0;
        this.indent(indent);
        this.getPrinter().println("<dependencies>");
        this.writeDependencyGraph("compile", dependencies.getCompileDependencies(), indent + 1);
        this.writeDependencyGraph("package", dependencies.getPackageDependencies(), indent + 1);
        this.indent(indent);
        this.getPrinter().println("</dependencies>");
        this.getPrinter().close();
    }

    private final void writeDependencyGraph(String tag, LintModelDependencyGraph graph2, int indent) {
        LinkedHashMap graphItems = new LinkedHashMap();
        if (graph2.getRoots().isEmpty()) {
            return;
        }
        for (LintModelDependency item : graph2.getRoots()) {
            this.addDependencies(item, graphItems);
        }
        this.indent(indent);
        this.getPrinter().print("<");
        this.getPrinter().print(tag);
        String roots = CollectionsKt.joinToString$default((Iterable)graph2.getRoots(), (CharSequence)",", null, null, (int)0, null, LintModelDependenciesWriter::writeDependencyGraph$lambda$0, (int)30, null);
        this.printAttribute(this.getPrinter(), "roots", roots, indent);
        this.getPrinter().println(">");
        for (Map.Entry item : ((Map)graphItems).entrySet()) {
            this.writeDependency((LintModelDependency)item.getValue(), indent + 1);
        }
        this.indent(indent);
        this.getPrinter().print("</");
        this.getPrinter().print(tag);
        this.getPrinter().println(">");
    }

    private final void addDependencies(LintModelDependency item, Map<String, LintModelDependency> map2) {
        if (map2.containsKey(item.getIdentifier())) {
            return;
        }
        map2.put(item.getIdentifier(), item);
        for (LintModelDependency dependency : item.getDependencies()) {
            this.addDependencies(dependency, map2);
        }
    }

    private final void writeDependency(LintModelDependency library2, int indent) {
        String roots;
        this.indent(indent);
        this.getPrinter().print("<dependency");
        this.printName(this.getPrinter(), library2.getIdentifier(), indent);
        this.printAttribute(this.getPrinter(), "simpleName", library2.getArtifactName(), indent);
        String requestedCoordinates = library2.getRequestedCoordinates();
        if (requestedCoordinates != null) {
            this.printAttribute(this.getPrinter(), "requested", requestedCoordinates, indent);
        }
        if (((CharSequence)(roots = CollectionsKt.joinToString$default((Iterable)library2.getDependencies(), (CharSequence)",", null, null, (int)0, null, LintModelDependenciesWriter::writeDependency$lambda$0, (int)30, null))).length() > 0) {
            this.printAttribute(this.getPrinter(), "dependencies", roots, indent);
        }
        this.getPrinter().println("/>");
    }

    private static final CharSequence writeDependencyGraph$lambda$0(LintModelDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIdentifier();
    }

    private static final CharSequence writeDependency$lambda$0(LintModelDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIdentifier();
    }
}

