/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.OtherFileScanner;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u001e\u0010\u0012\u001a\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/client/api/OtherFileVisitor;", "", "detectors", "", "Lcom/android/tools/lint/detector/api/Detector;", "<init>", "(Ljava/util/List;)V", "files", "Ljava/util/EnumMap;", "Lcom/android/tools/lint/detector/api/Scope;", "Ljava/io/File;", "scan", "", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "collectFiles", "", "file", "android.sdktools.lint-api"})
public final class OtherFileVisitor {
    @NotNull
    private final List<Detector> detectors;
    @NotNull
    private final EnumMap<Scope, List<File>> files;

    public OtherFileVisitor(@NotNull List<? extends Detector> detectors) {
        Intrinsics.checkNotNullParameter(detectors, (String)"detectors");
        this.detectors = detectors;
        this.files = new EnumMap(Scope.class);
    }

    public final void scan(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main2) {
        List<File> manifestFiles;
        ArrayList<File> files;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = project.getDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
        File projectFolder = file;
        EnumSet<Scope> scopes = EnumSet.noneOf(Scope.class);
        for (Detector detector : this.detectors) {
            Intrinsics.checkNotNull((Object)detector, (String)"null cannot be cast to non-null type com.android.tools.lint.detector.api.OtherFileScanner");
            OtherFileScanner iterator = (OtherFileScanner)((Object)detector);
            EnumSet<Scope> applicable = iterator.getApplicableFiles();
            if (applicable.contains((Object)Scope.OTHER)) {
                scopes = Scope.ALL;
                break;
            }
            scopes.addAll((Collection<Scope>)applicable);
        }
        List<File> subset = project.getSubset();
        if (scopes.contains((Object)Scope.RESOURCE_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                for (File file2 : subset) {
                    if (!SdkUtils.endsWith((CharSequence)file2.getPath(), (CharSequence)".xml") || Intrinsics.areEqual((Object)file2.getName(), (Object)"AndroidManifest.xml")) continue;
                    files.add(file2);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.RESOURCE_FILE, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File res : project.getResourceFolders()) {
                    Intrinsics.checkNotNull(files);
                    List list2 = files;
                    Intrinsics.checkNotNull((Object)res);
                    this.collectFiles(list2, res);
                }
                File file2 = new File(projectFolder, "assets");
                if (file2.exists()) {
                    Intrinsics.checkNotNull(files);
                    this.collectFiles((List<File>)files, file2);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.RESOURCE_FILE, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.JAVA_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList<File>(subset.size());
                for (File file3 : subset) {
                    String string2 = file3.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    if (!StringsKt.endsWith$default((String)string2, (String)".java", (boolean)false, (int)2, null)) {
                        String string3 = file3.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                        if (!StringsKt.endsWith$default((String)string3, (String)".kt", (boolean)false, (int)2, null)) continue;
                    }
                    files.add(file3);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.JAVA_FILE, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File srcFolder : project.getJavaSourceFolders()) {
                    Intrinsics.checkNotNull(files);
                    List list3 = files;
                    Intrinsics.checkNotNull((Object)srcFolder);
                    this.collectFiles(list3, srcFolder);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.JAVA_FILE, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.CLASS_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file3 : subset) {
                    String string4 = file3.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                    if (!StringsKt.endsWith$default((String)string4, (String)".class", (boolean)false, (int)2, null)) continue;
                    files.add(file3);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.CLASS_FILE, files);
                }
            } else {
                files = Lists.newArrayListWithExpectedSize((int)100);
                for (File classFolder : project.getJavaClassFolders()) {
                    Intrinsics.checkNotNull(files);
                    List list4 = files;
                    Intrinsics.checkNotNull((Object)classFolder);
                    this.collectFiles(list4, classFolder);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.CLASS_FILE, files);
                }
            }
        }
        if (scopes.contains((Object)Scope.MANIFEST)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file3 : subset) {
                    if (!Intrinsics.areEqual((Object)file3.getName(), (Object)"AndroidManifest.xml")) continue;
                    files.add(file3);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.MANIFEST, files);
                }
            } else {
                List<File> list5 = project.getManifestFiles();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"getManifestFiles(...)");
                manifestFiles = list5;
                ((Map)this.files).put(Scope.MANIFEST, manifestFiles);
            }
        }
        if (scopes.contains((Object)Scope.GRADLE_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file3 : subset) {
                    String string5 = file3.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string5, (String)".gradle", (boolean)false, (int)2, null)) {
                        String string6 = file3.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                        if (!StringsKt.endsWith$default((String)string6, (String)".kts", (boolean)false, (int)2, null)) {
                            String string7 = file3.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getName(...)");
                            if (!StringsKt.endsWith$default((String)string7, (String)".dcl", (boolean)false, (int)2, null)) continue;
                        }
                    }
                    files.add(file3);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.GRADLE_FILE, files);
                }
            } else {
                List<File> list6 = project.getGradleBuildScripts();
                Intrinsics.checkNotNullExpressionValue(list6, (String)"getGradleBuildScripts(...)");
                manifestFiles = list6;
                ((Map)this.files).put(Scope.GRADLE_FILE, manifestFiles);
            }
        }
        if (scopes.contains((Object)Scope.PROGUARD_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file3 : subset) {
                    String string8 = file3.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getName(...)");
                    if (!StringsKt.startsWith$default((String)string8, (String)"proguard", (boolean)false, (int)2, null)) continue;
                    files.add(file3);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.PROPERTY_FILE, files);
                }
            } else {
                List<File> list7 = project.getProguardFiles();
                Intrinsics.checkNotNullExpressionValue(list7, (String)"getProguardFiles(...)");
                manifestFiles = list7;
                ((Map)this.files).put(Scope.PROGUARD_FILE, manifestFiles);
            }
        }
        if (scopes.contains((Object)Scope.PROPERTY_FILE)) {
            if (subset != null && !subset.isEmpty()) {
                files = new ArrayList(subset.size());
                for (File file3 : subset) {
                    String string9 = file3.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string9, (String)".properties", (boolean)false, (int)2, null)) continue;
                    files.add(file3);
                }
                if (!files.isEmpty()) {
                    ((Map)this.files).put(Scope.PROPERTY_FILE, files);
                }
            } else {
                List<File> list8 = project.getPropertyFiles();
                Intrinsics.checkNotNullExpressionValue(list8, (String)"getPropertyFiles(...)");
                List<File> propertyFiles = list8;
                ((Map)this.files).put(Scope.PROPERTY_FILE, propertyFiles);
            }
        }
        for (Map.Entry entry : ((Map)this.files).entrySet()) {
            Scope scope = (Scope)((Object)entry.getKey());
            List files2 = (List)entry.getValue();
            ArrayList<Detector> applicable = new ArrayList<Detector>(this.detectors.size());
            for (Detector detector : this.detectors) {
                Intrinsics.checkNotNull((Object)detector, (String)"null cannot be cast to non-null type com.android.tools.lint.detector.api.OtherFileScanner");
                OtherFileScanner fileScanner = (OtherFileScanner)((Object)detector);
                EnumSet<Scope> appliesTo = fileScanner.getApplicableFiles();
                if (!appliesTo.contains((Object)Scope.OTHER) && !appliesTo.contains((Object)scope)) continue;
                applicable.add(detector);
            }
            if (applicable.isEmpty()) continue;
            for (File file3 : files2) {
                Iterator iterator;
                Context context2 = new Context(driver, project, main2, file3, null, 16, null);
                Intrinsics.checkNotNullExpressionValue(applicable.iterator(), (String)"iterator(...)");
                while (iterator.hasNext()) {
                    Detector detector = (Detector)iterator.next();
                    detector.beforeCheckFile(context2);
                    detector.run(context2);
                    detector.afterCheckFile(context2);
                    int n = driver.getFileCount();
                    driver.setFileCount(n + 1);
                }
            }
        }
    }

    private final void collectFiles(List<File> files, File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    Intrinsics.checkNotNull((Object)child);
                    this.collectFiles(files, child);
                }
            }
        } else {
            files.add(file);
        }
    }
}

