/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.PrettyPaths;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.model.PathVariables;
import com.android.utils.CharSequenceReader;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 _2\u00020\u0001:\u0003]^_B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\b@J\u000e\u0010A\u001a\u00020#2\u0006\u0010B\u001a\u00020CJ:\u0010A\u001a\u00020#2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u00192\b\u0010I\u001a\u0004\u0018\u00010J2\u000e\u0010K\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001eH\u0002J\u0018\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0019H\u0002J\u0012\u0010P\u001a\u0004\u0018\u00010N2\u0006\u0010Q\u001a\u00020\u0019H\u0002J\u001e\u0010R\u001a\u00020#2\u0006\u0010D\u001a\u00020E2\u0006\u0010S\u001a\u00020\u00192\u0006\u0010T\u001a\u00020\u0019J\u0010\u0010U\u001a\u0004\u0018\u00010\u00192\u0006\u0010V\u001a\u00020\u0019J\u0016\u0010W\u001a\u00020;2\u0006\u0010V\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0019J\b\u0010X\u001a\u00020;H\u0002J\u0006\u0010Y\u001a\u00020;J\u000e\u0010Z\u001a\u00020;2\u0006\u0010\u0004\u001a\u00020\u0005J\u001c\u0010Z\u001a\u00020;*\u0002002\u0006\u0010[\u001a\u00020\\2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010RN\u0010\u0017\u001aB\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001b0\u001b \u001a* \u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u001c\u001a*\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001e0\u001dj\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u001e`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010%\"\u0004\b-\u0010'R\"\u0010.\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0011\u00105\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0010R\u001c\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "value", "", "foundErrorCount", "getFoundErrorCount", "()I", "foundWarningCount", "getFoundWarningCount", "foundHintCount", "getFoundHintCount", "totalCount", "getTotalCount", "messageToEntry", "Lcom/google/common/collect/ArrayListMultimap;", "", "kotlin.jvm.PlatformType", "Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "idToMessages", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "gradleCachePaths", "", "writeOnClose", "", "getWriteOnClose", "()Z", "setWriteOnClose", "(Z)V", "removeFixed", "getRemoveFixed", "setRemoveFixed", "omitLineNumbers", "getOmitLineNumbers", "setOmitLineNumbers", "entriesToWrite", "", "Lcom/android/tools/lint/client/api/LintBaseline$ReportedEntry;", "getEntriesToWrite", "()Ljava/util/List;", "setEntriesToWrite", "(Ljava/util/List;)V", "fixedCount", "getFixedCount", "attributes", "", "hasUntrimmedMessages", "reportBaselineIssues", "", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "reportBaselineIssues$android_sdktools_lint_api", "findAndMark", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "alreadyChecked", "isSimilarGradleCachePath", "pathWithinGradleCaches", "", "otherPath", "tryGetPathWithinGradleCaches", "path", "sameMessage", "new", "old", "getAttribute", "name", "setAttribute", "readBaselineFile", "close", "write", "writer", "Ljava/io/Writer;", "ReportedEntry", "Entry", "Companion", "android.sdktools.lint-api"})
@SourceDebugExtension(value={"SMAP\nLintBaseline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintBaseline.kt\ncom/android/tools/lint/client/api/LintBaseline\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1267:1\n1#2:1268\n1563#3:1269\n1634#3,3:1270\n608#4:1273\n1321#4,2:1274\n*S KotlinDebug\n*F\n+ 1 LintBaseline.kt\ncom/android/tools/lint/client/api/LintBaseline\n*L\n401#1:1269\n401#1:1270,3\n713#1:1273\n714#1:1274,2\n*E\n"})
public final class LintBaseline {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintClient client;
    @NotNull
    private File file;
    private int foundErrorCount;
    private int foundWarningCount;
    private int foundHintCount;
    private int totalCount;
    private final ArrayListMultimap<String, Entry> messageToEntry;
    @NotNull
    private final HashMap<String, Set<String>> idToMessages;
    @NotNull
    private final List<String> gradleCachePaths;
    private boolean writeOnClose;
    private boolean removeFixed;
    private boolean omitLineNumbers;
    @Nullable
    private List<ReportedEntry> entriesToWrite;
    @Nullable
    private Map<String, String> attributes;
    private boolean hasUntrimmedMessages;
    @NotNull
    public static final String VARIANT_ALL = "all";
    @NotNull
    public static final String VARIANT_FATAL = "fatal";

    /*
     * WARNING - void declaration
     */
    public LintBaseline(@NotNull LintClient client, @NotNull File file) {
        List list2;
        void $this$gradleCachePaths_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.client = client;
        this.file = file;
        this.messageToEntry = ArrayListMultimap.create((int)100, (int)20);
        this.idToMessages = new HashMap(30);
        LintBaseline lintBaseline = this;
        LintBaseline lintBaseline2 = this;
        boolean bl = false;
        File file2 = $this$gradleCachePaths_u24lambda_u240.client.getPathVariables().get("GRADLE_USER_HOME");
        if (file2 == null) {
            list2 = CollectionsKt.emptyList();
        } else {
            File gradleHome = file2;
            List paths = new ArrayList();
            paths.add(gradleHome.getPath() + File.separator + "caches" + File.separator);
            try {
                File gradleHomeCanon = gradleHome.getCanonicalFile();
                if (!Intrinsics.areEqual((Object)gradleHome.getPath(), (Object)gradleHomeCanon.getPath())) {
                    paths.add(gradleHomeCanon.getPath() + File.separator + "caches" + File.separator);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            list2 = paths;
        }
        lintBaseline2.gradleCachePaths = list2;
        this.readBaselineFile();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.file = file;
    }

    public final int getFoundErrorCount() {
        return this.foundErrorCount;
    }

    public final int getFoundWarningCount() {
        return this.foundWarningCount;
    }

    public final int getFoundHintCount() {
        return this.foundHintCount;
    }

    public final int getTotalCount() {
        return this.totalCount;
    }

    public final boolean getWriteOnClose() {
        return this.writeOnClose;
    }

    public final void setWriteOnClose(boolean writeOnClose) {
        if (writeOnClose) {
            int count = this.totalCount > 0 ? this.totalCount + 10 : 30;
            this.entriesToWrite = new ArrayList(count);
        }
        this.writeOnClose = writeOnClose;
    }

    public final boolean getRemoveFixed() {
        return this.removeFixed;
    }

    public final void setRemoveFixed(boolean bl) {
        this.removeFixed = bl;
    }

    public final boolean getOmitLineNumbers() {
        return this.omitLineNumbers;
    }

    public final void setOmitLineNumbers(boolean bl) {
        this.omitLineNumbers = bl;
    }

    @Nullable
    public final List<ReportedEntry> getEntriesToWrite() {
        return this.entriesToWrite;
    }

    public final void setEntriesToWrite(@Nullable List<ReportedEntry> list2) {
        this.entriesToWrite = list2;
    }

    public final int getFixedCount() {
        return this.totalCount - this.foundErrorCount - this.foundWarningCount - this.foundHintCount;
    }

    public final void reportBaselineIssues$android_sdktools_lint_api(@NotNull LintDriver driver, @NotNull Project project) {
        int fixedCount;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.foundErrorCount > 0 || this.foundWarningCount > 0 || this.foundHintCount > 0) {
            LintClient client = driver.getClient();
            File baselineFile = this.file;
            String message = Companion.describeBaselineFilter(this.foundErrorCount, this.foundWarningCount, this.foundHintCount, LintBaseline.Companion.getDisplayPath(client, project, baselineFile));
            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.BASELINE_USED, message, baselineFile, null, null, null, null, null, project, null, driver, null, 5616, null);
        }
        if (!((fixedCount = this.getFixedCount()) <= 0 || this.writeOnClose && this.removeFixed)) {
            Object id;
            LintClient client = driver.getClient();
            File baselineFile = this.file;
            HashMap ids = Maps.newHashMap();
            for (Entry entry : this.messageToEntry.values()) {
                id = entry.getIssueId();
                if (IssueRegistry.Companion.isDeletedIssueId((String)id)) continue;
                Integer count = (Integer)ids.get(id);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                Intrinsics.checkNotNull((Object)ids);
                ((Map)ids).put(id, count);
            }
            if (ids.isEmpty()) {
                return;
            }
            ArrayList sorted = Lists.newArrayList((Iterable)ids.keySet());
            Intrinsics.checkNotNull((Object)sorted);
            CollectionsKt.sort((List)sorted);
            StringBuilder issueTypes = new StringBuilder();
            Iterator iterator = sorted.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            id = iterator;
            while (id.hasNext()) {
                String id2 = (String)id.next();
                if (((CharSequence)issueTypes).length() > 0) {
                    issueTypes.append(", ");
                }
                issueTypes.append(id2);
                Integer count = (Integer)ids.get(id2);
                if (count == null || count <= 1) continue;
                issueTypes.append(" (").append(String.valueOf(count)).append(")");
            }
            Locale locale = Locale.getDefault();
            String string2 = "%1$d errors/warnings were listed in the baseline file (%2$s) but not found in the project; perhaps they have been fixed?";
            Object[] objectArray = new Object[]{fixedCount, TextFormat.TEXT.convertTo(LintBaseline.Companion.getDisplayPath(client, project, baselineFile), TextFormat.RAW)};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            Object message = string3;
            if (LintClient.Companion.isGradle() && project.getBuildModule() != null) {
                Object object = project.getBuildModule();
                boolean bl = object != null && (object = object.getLintOptions()) != null ? !object.getCheckDependencies() : false;
                if (bl) {
                    message = (String)message + " Another possible explanation is that lint recently stopped analyzing (and including results from) dependent projects by default. You can turn this back on with `android.lintOptions.checkDependencies=true`.";
                }
            }
            message = (String)message + " Unmatched issue types: " + issueTypes;
            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.BASELINE_FIXED, (String)message, baselineFile, null, null, null, null, null, project, null, driver, null, 5616, null);
        }
    }

    public final boolean findAndMark(@NotNull Incident incident) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Issue issue = incident.getIssue();
        Location location = incident.getLocation();
        String message = incident.getMessage();
        Severity severity = incident.getSeverity();
        boolean found = this.findAndMark(issue, location, message, severity, null);
        if (this.writeOnClose && (!this.removeFixed || found) && this.entriesToWrite != null && Companion.shouldBaseline(issue.getId())) {
            List<ReportedEntry> list2 = this.entriesToWrite;
            Intrinsics.checkNotNull(list2);
            list2.add(new ReportedEntry(incident));
        }
        return found;
    }

    private final boolean findAndMark(Issue issue, Location location, String message, Severity severity, Set<String> alreadyChecked) {
        Set<String> messages;
        Object entry2;
        if (((CharSequence)message).length() == 0) {
            return false;
        }
        List entries = this.messageToEntry.get((Object)message);
        if (entries.isEmpty()) {
            Set<String> messages2 = this.idToMessages.get(issue.getId());
            Collection collection = messages2;
            if (!(collection == null || collection.isEmpty()) && (messages2.size() > 1 || messages2.size() == 1 && !Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)messages2), (Object)message))) {
                Set<String> set2 = alreadyChecked;
                if (set2 == null) {
                    Object object;
                    Object $this$findAndMark_u24lambda_u240 = object = (Set)new LinkedHashSet();
                    boolean bl = false;
                    $this$findAndMark_u24lambda_u240.add(message);
                    set2 = object;
                }
                Set<String> checked = set2;
                for (String oldMessage : messages2) {
                    if (!checked.add(oldMessage) || !this.sameMessage(issue, message, oldMessage) || !this.findAndMark(issue, location, oldMessage, severity, checked)) continue;
                    return true;
                }
            }
            return false;
        }
        File file = location.getFile();
        String path = file.getPath();
        Lazy pathWithinGradleCaches = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> LintBaseline.findAndMark$lambda$1(this, path));
        String issueId = issue.getId();
        for (Object entry2 : entries) {
            if (entry2 == null || !Intrinsics.areEqual((Object)((Entry)entry2).getIssueId(), (Object)issueId) && (!IssueRegistry.Companion.isDeletedIssueId(((Entry)entry2).getIssueId()) || !Intrinsics.areEqual((Object)IssueRegistry.Companion.getNewId(((Entry)entry2).getIssueId()), (Object)issueId))) continue;
            Intrinsics.checkNotNull((Object)path);
            if (!Companion.isSamePathSuffix(path, ((Entry)entry2).getPath())) {
                if (pathWithinGradleCaches.getValue() == null) continue;
                Object object = pathWithinGradleCaches.getValue();
                Intrinsics.checkNotNull((Object)object);
                if (!this.isSimilarGradleCachePath((CharSequence)object, ((Entry)entry2).getPath())) continue;
            }
            Object curr = entry2;
            while (((Entry)curr).getPrevious() != null) {
                curr = ((Entry)curr).getPrevious();
            }
            while (curr != null) {
                String currMessage = ((Entry)curr).getMessage();
                this.messageToEntry.remove((Object)currMessage, curr);
                List remaining = this.messageToEntry.get((Object)currMessage);
                if (remaining.isEmpty()) {
                    Set<String> set3 = this.idToMessages.get(issue.getId());
                    if (set3 != null) {
                        set3.remove(currMessage);
                    }
                }
                curr = ((Entry)curr).getNext();
            }
            Severity severity2 = severity;
            if (severity2 == null) {
                severity2 = issue.getDefaultSeverity();
            }
            Severity effectiveSeverity = severity2;
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveSeverity.ordinal()]) {
                case 1: 
                case 2: {
                    int n = this.foundErrorCount;
                    this.foundErrorCount = n + 1;
                    break;
                }
                case 3: {
                    int n = this.foundWarningCount;
                    this.foundWarningCount = n + 1;
                    break;
                }
                case 4: {
                    int n = this.foundHintCount;
                    this.foundHintCount = n + 1;
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return true;
        }
        if (this.hasUntrimmedMessages && !((entry2 = (Collection)(messages = this.idToMessages.get(issue.getId()))) == null || entry2.isEmpty()) && (messages.size() > 1 || messages.size() == 1 && !Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)messages), (Object)message))) {
            Set<String> set4 = alreadyChecked;
            if (set4 == null) {
                Object object;
                Object $this$findAndMark_u24lambda_u242 = object = (Set)new LinkedHashSet();
                boolean bl = false;
                $this$findAndMark_u24lambda_u242.add(message);
                set4 = object;
            }
            Set<String> checked = set4;
            for (String oldMessage : messages) {
                if (!checked.add(oldMessage) || !this.sameMessage(issue, message, oldMessage) || !this.findAndMark(issue, location, oldMessage, severity, checked)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSimilarGradleCachePath(CharSequence pathWithinGradleCaches, String otherPath) {
        void $this$mapTo$iv$iv;
        CharSequence charSequence = this.tryGetPathWithinGradleCaches(otherPath);
        if (charSequence == null) {
            return false;
        }
        CharSequence otherPathWithinGradleCaches = charSequence;
        Object[] objectArray = new CharSequence[]{pathWithinGradleCaches, otherPathWithinGradleCaches};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CharSequence charSequence2 = (CharSequence)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"/", "\\"};
            collection.add(StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        List chunks = (List)destination$iv$iv;
        if (((List)chunks.get(0)).size() != ((List)chunks.get(1)).size()) {
            return false;
        }
        boolean diffFound = false;
        int n = ((Collection)chunks.get(0)).size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual(((List)chunks.get(0)).get(i), ((List)chunks.get(1)).get(i))) continue;
            if (diffFound) {
                return false;
            }
            diffFound = true;
        }
        return true;
    }

    private final CharSequence tryGetPathWithinGradleCaches(String path) {
        for (String gradleCachePath : this.gradleCachePaths) {
            if (!Companion.pathStartsWith(path, gradleCachePath)) continue;
            return path.subSequence(gradleCachePath.length(), path.length());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean sameMessage(@NotNull Issue issue, @NotNull String string2, @NotNull String old) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"new");
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        switch (issue.getId()) {
            case "InvalidPackage": {
                boolean bl = LintBaseline.Companion.sameSuffixFrom("not included in", string2, old);
                return bl;
            }
            case "IconDensities": {
                return true;
            }
            case "UselessLeaf": {
                return true;
            }
            case "NonResizeableActivity": {
                return true;
            }
            case "ScopedStorage": {
                boolean bl = LintBaseline.Companion.sameSuffixFrom("MANAGE_EXTERNAL_STORAGE", string2, old);
                return bl;
            }
            case "SmallSp": {
                boolean bl = LintBaseline.Companion.sameSuffixFrom("sp:", string2, old);
                return bl;
            }
            case "BatteryLife": {
                String s = "Use of REQUEST_IGNORE_BATTERY_OPTIMIZATIONS";
                if (!StringsKt.startsWith$default((String)old, (String)s, (boolean)false, (int)2, null)) return false;
                if (!StringsKt.startsWith$default((String)string2, (String)s, (boolean)false, (int)2, null)) return false;
                return true;
            }
            case "ContentDescription": {
                boolean bl = com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, StringsKt.removePrefix((String)old, (CharSequence)"[Accessibility] "), string2, 0, 0, 12, null);
                return bl;
            }
            case "HardcodedText": {
                boolean bl = com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, StringsKt.removePrefix((String)old, (CharSequence)"[I18N] "), string2, 0, 0, 12, null);
                return bl;
            }
            case "NewApi": 
            case "InlinedApi": 
            case "UnusedAttribute": {
                if (StringsKt.contains$default((CharSequence)string2, (char)'`', (boolean)false, (int)2, null) && Companion.symbolsMatch(old, string2) && StringsKt.regionMatches$default((String)old, (int)0, (String)string2, (int)0, (int)4, (boolean)false, (int)16, null)) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)old, (Object)"This Kotlin extension function will be hidden by java.util.SequencedCollection starting in API 35")) {
                    return StringsKt.startsWith$default((String)string2, (String)old, (boolean)false, (int)2, null);
                }
                String suffix = " (called from ";
                boolean bl = Companion.stringsEquivalent(StringsKt.substringBeforeLast$default((String)old, (String)suffix, null, (int)2, null), StringsKt.substringBeforeLast$default((String)string2, (String)suffix, null, (int)2, null), (Function2<? super String, ? super Integer, Boolean>)((Function2)LintBaseline::sameMessage$lambda$0));
                return bl;
            }
            case "ObsoleteSdkInt": {
                boolean bl;
                String s1 = "Unnecessary; SDK_INT is";
                String s2 = "Unnecessary; `SDK_INT` is";
                if ((StringsKt.startsWith$default((String)old, (String)s1, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)old, (String)s2, (boolean)false, (int)2, null)) && StringsKt.contains$default((CharSequence)old, (CharSequence)" is never ", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)string2, (String)s1, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)string2, (String)s2, (boolean)false, (int)2, null)) {
                    bl = StringsKt.contains$default((CharSequence)string2, (CharSequence)" is never ", (boolean)false, (int)2, null);
                    return bl;
                }
                bl = com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, old, string2, 0, 0, 12, null);
                return bl;
            }
            case "MinSdkTooLow": {
                return true;
            }
            case "GetLocales": 
            case "OverrideAbstract": 
            case "WebpUnsupported": {
                boolean bl = Companion.stringsEquivalent(old, string2, (Function2<? super String, ? super Integer, Boolean>)((Function2)LintBaseline::sameMessage$lambda$1));
                return bl;
            }
            case "FontValidation": {
                boolean bl = Companion.stringsEquivalent(old, string2, (Function2<? super String, ? super Integer, Boolean>)((Function2)LintBaseline::sameMessage$lambda$2));
                return bl;
            }
            case "RestrictedApi": {
                int index1 = StringsKt.indexOf$default((CharSequence)old, (char)'(', (int)0, (boolean)false, (int)6, null);
                int index2 = StringsKt.indexOf$default((CharSequence)string2, (char)'(', (int)0, (boolean)false, (int)6, null);
                if (index1 != -1) {
                    if (index1 != index2) return false;
                    if (!StringsKt.regionMatches$default((String)old, (int)0, (String)string2, (int)0, (int)index1, (boolean)false, (int)16, null)) return false;
                    return true;
                }
                boolean bl = com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, old, string2, 0, 0, 12, null);
                return bl;
            }
            case "IconMissingDensityFolder": 
            case "IconXmlAndPng": {
                boolean bl = com.android.tools.lint.client.api.LintBaseline$Companion.sameWithAbsolutePath$default(Companion, string2, old, null, null, 12, null);
                return bl;
            }
            case "MissingQuantity": {
                boolean bl = LintBaseline.Companion.sameSuffixFrom("should also be defined", string2, old);
                return bl;
            }
            case "RtlCompat": {
                boolean bl = Companion.stringsEquivalent(old, string2, (Function2<? super String, ? super Integer, Boolean>)((Function2)LintBaseline::sameMessage$lambda$3));
                return bl;
            }
            case "UnknownIssueId": 
            case "ParserError": 
            case "LintWarning": 
            case "CannotEnableHidden": 
            case "LintError": 
            case "LintBaseline": 
            case "LintBaselineFixed": 
            case "ObsoleteLintCustomCheck": {
                boolean bl = com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, old, string2, 0, 0, 12, null);
                return bl;
            }
            default: {
                boolean bl;
                if (com.android.tools.lint.client.api.LintBaseline$Companion.stringsEquivalent$default(Companion, old, string2, 0, 0, 12, null)) return true;
                try {
                    bl = issue.getImplementation().getDetectorClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).sameMessage(issue, string2, old);
                }
                catch (Throwable throwable) {
                    return false;
                }
                if (!bl) return false;
                return true;
            }
        }
    }

    @Nullable
    public final String getAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, String> map2 = this.attributes;
        return map2 != null ? map2.get(name) : null;
    }

    public final void setAttribute(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map map2 = this.attributes;
        if (map2 == null) {
            Map newMap;
            LintBaseline $this$setAttribute_u24lambda_u240 = this;
            boolean bl = false;
            $this$setAttribute_u24lambda_u240.attributes = newMap = (Map)new LinkedHashMap();
            map2 = newMap;
        }
        Map attributes = map2;
        attributes.put((String)name, (String)value);
    }

    /*
     * Unable to fully structure code
     */
    private final void readBaselineFile() {
        xml = this.client.readFile(this.file);
        if (xml.length() == 0) {
            return;
        }
        try {
            parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput((Reader)new CharSequenceReader(xml));
            issue = null;
            message = null;
            path = null;
            currentEntry = null;
            pathVariables = this.client.getPathVariables();
            while (parser.next() != 1) {
                eventType = parser.getEventType();
                if (eventType == 3) {
                    tag = parser.getName();
                    if (Intrinsics.areEqual((Object)tag, (Object)"location")) {
                        if (issue != null && message != null && path != null && StringsKt.isBlank((CharSequence)message) == false) {
                            v0 = PathVariables.fromPathString$default(pathVariables, path, null, false, 6, null).getPath();
                            if (v0 == null) {
                                v0 = path;
                            }
                            path = v0;
                            entry = new Entry(issue, message, path);
                            if (currentEntry != null) {
                                currentEntry.setNext(entry);
                            }
                            entry.setPrevious(currentEntry);
                            currentEntry = entry;
                            this.messageToEntry.put((Object)entry.getMessage(), (Object)entry);
                            v1 = this.idToMessages.get(issue);
                            if (v1 == null) {
                                it = var13_16 = new HashSet<E>();
                                $i$a$-also-LintBaseline$readBaselineFile$messages$1 = false;
                                ((Map)this.idToMessages).put(issue, it);
                                v1 = (Set)var13_16;
                            }
                            messages = v1;
                            messages.add((String)message);
                            if (CharsKt.isWhitespace((char)message.charAt(0)) && !this.hasUntrimmedMessages && !Intrinsics.areEqual((Object)message, (Object)StringsKt.trimIndent((String)message))) {
                                this.hasUntrimmedMessages = true;
                            }
                        }
                    } else if (Intrinsics.areEqual((Object)tag, (Object)"issue")) {
                        if (issue != null && !IssueRegistry.Companion.isDeletedIssueId(issue)) {
                            entry = this.totalCount;
                            this.totalCount = entry + 1;
                        }
                        issue = null;
                        message = null;
                        path = null;
                        currentEntry = null;
                    }
                } else if (eventType != 2) continue;
                n = parser.getAttributeCount();
                block16: for (i = 0; i < n; ++i) {
                    name = parser.getAttributeName(i);
                    value = parser.getAttributeValue(i);
                    var13_16 = name;
                    if (var13_16 == null) ** GOTO lbl-1000
                    tmp = -1;
                    switch (var13_16.hashCode()) {
                        case 3143036: {
                            if (var13_16.equals("file")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 3159: {
                            if (var13_16.equals("by")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case -1268779017: {
                            if (var13_16.equals("format")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 3355: {
                            if (var13_16.equals("id")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case 954925063: {
                            if (var13_16.equals("message")) {
                                tmp = 4;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 3: {
                            issue = value;
                            continue block16;
                        }
                        case 4: {
                            if (parser.getDepth() != 2) continue block16;
                            message = value;
                            continue block16;
                        }
                        case 1: {
                            path = value;
                            continue block16;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            if (parser.getDepth() != 1) continue block16;
                            Intrinsics.checkNotNull((Object)name);
                            Intrinsics.checkNotNull((Object)value);
                            this.setAttribute(name, value);
                        }
                        case 2: 
                    }
                }
            }
        }
        catch (XmlPullParserException e) {
            this.client.log(e, null, new Object[0]);
        }
    }

    public final void close() {
        if (this.writeOnClose) {
            this.write(this.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(@NotNull File file) {
        boolean mkdirs2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !(mkdirs2 = parentFile.mkdirs())) {
            Object[] objectArray = new Object[]{parentFile};
            this.client.log(null, "Couldn't create %1$s", objectArray);
            return;
        }
        try {
            Object mkdirs2 = file;
            Object object = Charsets.UTF_8;
            int n = 8192;
            Object object2 = mkdirs2;
            object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), (Charset)object);
            mkdirs2 = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
            object = null;
            try {
                BufferedWriter writer = (BufferedWriter)mkdirs2;
                boolean bl = false;
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                writer.write("<");
                writer.write("issues");
                writer.write(" format=\"5\"");
                String revision = this.client.getClientDisplayRevision();
                if (revision != null) {
                    String string2 = " by=\"lint %1$s\"";
                    Object[] objectArray = new Object[]{revision};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    writer.write(string3);
                }
                Map<String, String> map2 = this.attributes;
                if (map2 != null) {
                    void $this$forEach$iv;
                    Sequence $this$sortedBy$iv;
                    Map<String, String> map3 = map2;
                    boolean bl2 = false;
                    Sequence sequence2 = MapsKt.asSequence(map3);
                    boolean $i$f$sortedBy = false;
                    $this$sortedBy$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Map.Entry it = (Map.Entry)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                            it = (Map.Entry)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                        }
                    });
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Map.Entry it = (Map.Entry)element$iv;
                        boolean bl3 = false;
                        writer.write(" " + it.getKey() + "=\"" + XmlUtils.toXmlAttributeValue((String)((String)it.getValue())) + "\"");
                    }
                }
                writer.write(">\n");
                this.totalCount = 0;
                if (this.entriesToWrite != null) {
                    List<ReportedEntry> list2 = this.entriesToWrite;
                    Intrinsics.checkNotNull(list2);
                    CollectionsKt.sort(list2);
                    List<ReportedEntry> list3 = this.entriesToWrite;
                    Intrinsics.checkNotNull(list3);
                    for (ReportedEntry entry : list3) {
                        this.write(entry, writer, this.client);
                        int n2 = this.totalCount;
                        this.totalCount = n2 + 1;
                    }
                }
                writer.write("\n</");
                writer.write("issues");
                writer.write(">\n");
                writer.close();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)mkdirs2, (Throwable)object);
            }
        }
        catch (IOException ioe) {
            this.client.log(ioe, null, new Object[0]);
        }
    }

    private final void write(ReportedEntry $this$write, Writer writer, LintClient client) {
        try {
            writer.write("\n");
            LintBaseline.Companion.indent(writer, 1);
            writer.write("<");
            writer.write("issue");
            LintBaseline.Companion.writeAttribute(writer, 2, "id", $this$write.getIssue$android_sdktools_lint_api().getId());
            LintBaseline.Companion.writeAttribute(writer, 2, "message", $this$write.getMessage$android_sdktools_lint_api());
            writer.write(">\n");
            for (Location currentLocation = $this$write.getLocation$android_sdktools_lint_api(); currentLocation != null; currentLocation = currentLocation.getSecondary()) {
                int line;
                LintBaseline.Companion.indent(writer, 2);
                writer.write("<");
                writer.write("location");
                String path = PrettyPaths.Companion.getPath(currentLocation.getFile(), $this$write.getProject$android_sdktools_lint_api(), client, true, true, client.getPathVariables(), false, false, true);
                LintBaseline.Companion.writeAttribute(writer, 3, "file", path);
                Position position = currentLocation.getStart();
                int n = line = position != null ? position.getLine() : -1;
                if (line >= 0 && !this.omitLineNumbers) {
                    LintBaseline.Companion.writeAttribute(writer, 3, "line", String.valueOf(line + 1));
                }
                writer.write("/>\n");
            }
            LintBaseline.Companion.indent(writer, 1);
            writer.write("</");
            writer.write("issue");
            writer.write(">\n");
        }
        catch (IOException ioe) {
            client.log(ioe, null, new Object[0]);
        }
    }

    private static final CharSequence findAndMark$lambda$1(LintBaseline this$0, String $path) {
        Intrinsics.checkNotNull((Object)$path);
        return this$0.tryGetPathWithinGradleCaches($path);
    }

    private static final boolean sameMessage$lambda$0(String s, int i) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return com.android.tools.lint.client.api.LintBaseline$Companion.tokenPrecededBy$default(Companion, s, "min is ", i, '\u0000', 4, null) || com.android.tools.lint.client.api.LintBaseline$Companion.tokenPrecededBy$default(Companion, s, "API level ", i, '\u0000', 4, null) || com.android.tools.lint.client.api.LintBaseline$Companion.tokenPrecededBy$default(Companion, s, "version ", i, '\u0000', 4, null);
    }

    private static final boolean sameMessage$lambda$1(String s, int i) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return com.android.tools.lint.client.api.LintBaseline$Companion.tokenPrecededBy$default(Companion, s, "minSdkVersion is ", i, '\u0000', 4, null);
    }

    private static final boolean sameMessage$lambda$2(String s, int i) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return Companion.tokenPrecededBy(s, "`minSdkVersion`", i, '=');
    }

    private static final boolean sameMessage$lambda$3(String s, int i) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return com.android.tools.lint.client.api.LintBaseline$Companion.tokenPrecededBy$default(Companion, s, "project specifies ", i, '\u0000', 4, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J&\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0014\u0010\u0013\u001a\u00020\b*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0007J\"\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J*\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u0005J\u0016\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005J\u0016\u0010&\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005J*\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\b\b\u0002\u0010*\u001a\u00020\f2\b\b\u0002\u0010+\u001a\u00020\fJ\u0016\u0010,\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005J$\u0010-\u001a\u00020\b*\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\f2\b\b\u0002\u00100\u001a\u000201J0\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b03J(\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0002J\u0018\u00108\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$Companion;", "", "<init>", "()V", "VARIANT_ALL", "", "VARIANT_FATAL", "shouldBaseline", "", "id", "describeBaselineFilter", "errors", "", "warnings", "hints", "baselineDisplayPath", "isSamePathSuffix", "path", "suffix", "pathStartsWith", "prefix", "getDisplayPath", "client", "Lcom/android/tools/lint/client/api/LintClient;", "project", "Lcom/android/tools/lint/detector/api/Project;", "file", "Ljava/io/File;", "sameSuffixFrom", "target", "new", "old", "sameWithAbsolutePath", "relative", "full", "prefixMatchLength", "a", "b", "suffixMatchLength", "stringsEquivalent", "s1", "s2", "start1", "start2", "symbolsMatch", "tokenPrecededBy", "prev", "offset", "separator", "", "skipTokenAt", "Lkotlin/Function2;", "writeAttribute", "", "writer", "Ljava/io/Writer;", "indent", "name", "value", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldBaseline(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return !Intrinsics.areEqual((Object)id, (Object)IssueRegistry.LINT_ERROR.getId()) && !Intrinsics.areEqual((Object)id, (Object)IssueRegistry.LINT_WARNING.getId()) && !Intrinsics.areEqual((Object)id, (Object)IssueRegistry.BASELINE_USED.getId()) && !Intrinsics.areEqual((Object)id, (Object)IssueRegistry.BASELINE_FIXED.getId());
        }

        @NotNull
        public final String describeBaselineFilter(int errors, int warnings, int hints, @NotNull String baselineDisplayPath) {
            Intrinsics.checkNotNullParameter((Object)baselineDisplayPath, (String)"baselineDisplayPath");
            String counts = Lint.describeCounts$default(errors, warnings, hints, false, true, false, 32, null);
            String escapedPath = TextFormat.TEXT.convertTo(baselineDisplayPath, TextFormat.RAW);
            return errors + warnings == 1 ? counts + " was filtered out because it is listed in the baseline file, " + escapedPath : counts + " were filtered out because they are listed in the baseline file, " + escapedPath;
        }

        public final boolean isSamePathSuffix(@NotNull String path, @NotNull String suffix) {
            char c;
            int begin;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            int i = path.length() - 1;
            int j = suffix.length() - 1;
            for (begin = 0; begin < j && ((c = suffix.charAt(begin)) == '.' || c == '/' || c == '\\'); ++begin) {
            }
            if (j - begin > i) {
                return false;
            }
            while (j > begin) {
                int c2;
                int c1 = path.charAt(i);
                if (c1 != (c2 = suffix.charAt(j))) {
                    if (c1 == 92) {
                        c1 = 47;
                    }
                    if (c2 == 92) {
                        c2 = 47;
                    }
                    if (c1 != c2) {
                        return false;
                    }
                }
                --i;
                --j;
            }
            return true;
        }

        @VisibleForTesting
        public final boolean pathStartsWith(@NotNull String $this$pathStartsWith, @NotNull String prefix) {
            int i;
            Intrinsics.checkNotNullParameter((Object)$this$pathStartsWith, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            if (prefix.length() > $this$pathStartsWith.length()) {
                return false;
            }
            if (((CharSequence)prefix).length() == 0) {
                return true;
            }
            for (i = 0; i < prefix.length(); ++i) {
                int t;
                int p = prefix.charAt(i);
                if (p == 92) {
                    p = 47;
                }
                if ((t = $this$pathStartsWith.charAt(i)) == 92) {
                    t = 47;
                }
                if (p == t) continue;
                return false;
            }
            if (prefix.charAt(i - 1) == '/' || prefix.charAt(i - 1) == '\\') {
                return true;
            }
            if (prefix.length() == $this$pathStartsWith.length()) {
                return true;
            }
            return $this$pathStartsWith.charAt(i) == '/' || $this$pathStartsWith.charAt(i) == '\\';
        }

        private final String getDisplayPath(LintClient client, Project project, File file) {
            String path = file.getPath();
            if (project == null) {
                String string2 = path;
                Intrinsics.checkNotNull((Object)string2);
                return string2;
            }
            String string3 = path;
            Intrinsics.checkNotNull((Object)string3);
            String string4 = project.getReferenceDir().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
            if (StringsKt.startsWith$default((String)string3, (String)string4, (boolean)false, (int)2, null)) {
                int chop = project.getReferenceDir().getPath().length();
                if (path.length() > chop && path.charAt(chop) == File.separatorChar) {
                    ++chop;
                }
                String string5 = path;
                Intrinsics.checkNotNull((Object)string5);
                String string6 = string5.substring(chop);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                path = string6;
                if (((CharSequence)path).length() == 0) {
                    path = file.getName();
                }
            } else if (file.isAbsolute() && file.exists()) {
                String string7 = client.getRelativePath(project.getReferenceDir(), file);
                if (string7 == null) {
                    string7 = file.getPath();
                }
                path = string7;
            }
            String string8 = path;
            Intrinsics.checkNotNull((Object)string8);
            return string8;
        }

        private final boolean sameSuffixFrom(String target2, String string2, String old) {
            int i1 = StringsKt.indexOf$default((CharSequence)string2, (String)target2, (int)0, (boolean)false, (int)6, null);
            int i2 = StringsKt.indexOf$default((CharSequence)old, (String)target2, (int)0, (boolean)false, (int)6, null);
            return i1 != -1 && i2 != -1 && this.stringsEquivalent(string2, old, i1 + target2.length(), i2 + target2.length());
        }

        public final boolean sameWithAbsolutePath(@NotNull String relative, @NotNull String full, @NotNull String prefix, @NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
            Intrinsics.checkNotNullParameter((Object)full, (String)"full");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            if (!(StringsKt.startsWith$default((String)relative, (String)prefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)full, (String)prefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)relative, (String)suffix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)full, (String)suffix, (boolean)false, (int)2, null))) {
                return false;
            }
            if (relative.length() > full.length()) {
                return false;
            }
            int first = this.prefixMatchLength(relative, full);
            int last = this.suffixMatchLength(relative, full);
            int relativeLength = relative.length() - first - last;
            return StringsKt.regionMatches$default((String)relative, (int)first, (String)full, (int)(full.length() - last - relativeLength), (int)relativeLength, (boolean)false, (int)16, null);
        }

        public static /* synthetic */ boolean sameWithAbsolutePath$default(Companion companion, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 4) != 0) {
                string4 = "";
            }
            if ((n & 8) != 0) {
                string5 = "";
            }
            return companion.sameWithAbsolutePath(string2, string3, string4, string5);
        }

        public final int prefixMatchLength(@NotNull String a, @NotNull String b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int n = ((CharSequence)a).length();
            for (int i = 0; i < n; ++i) {
                char bc;
                if (i == b.length()) {
                    return i;
                }
                char ac = a.charAt(i);
                if (ac == (bc = b.charAt(i))) continue;
                return i;
            }
            return a.length();
        }

        public final int suffixMatchLength(@NotNull String a, @NotNull String b) {
            char bc;
            char ac;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int ai = a.length() - 1;
            int bi = b.length() - 1;
            int index2 = 0;
            while (ai >= 0 && bi >= 0 && (ac = a.charAt(ai--)) == (bc = b.charAt(bi--))) {
                ++index2;
            }
            return index2;
        }

        public final boolean stringsEquivalent(@NotNull String s1, @NotNull String s2, int start1, int start2) {
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            int i1 = start1;
            int i2 = start2;
            int n1 = s1.length();
            int n2 = s2.length();
            if (start1 == n1 || start2 == n2) {
                return true;
            }
            while (true) {
                char c2;
                char c1;
                if ((c1 = s1.charAt(i1)) != (c2 = s2.charAt(i2))) {
                    while (i1 < n1 && (s1.charAt(i1) == '`' || CharsKt.isWhitespace((char)s1.charAt(i1)))) {
                        ++i1;
                    }
                    while (i2 < n2 && (s2.charAt(i2) == '`' || CharsKt.isWhitespace((char)s2.charAt(i2)))) {
                        ++i2;
                    }
                    if (i1 == n1 || i2 == n2) {
                        return true;
                    }
                    if (s1.charAt(i1) != s2.charAt(i2)) {
                        int http = StringsKt.lastIndexOf$default((CharSequence)s1, (String)"http", (int)i1, (boolean)false, (int)4, null);
                        if (http != -1) {
                            int blank1 = StringsKt.indexOf$default((CharSequence)s1, (char)' ', (int)http, (boolean)false, (int)4, null);
                            int blank2 = StringsKt.indexOf$default((CharSequence)s2, (char)' ', (int)http, (boolean)false, (int)4, null);
                            if (blank1 == -1 || blank2 == -1) {
                                return true;
                            }
                            if (i1 < blank1) {
                                i1 = blank1;
                                i2 = blank2;
                                continue;
                            }
                        }
                        if (s1.charAt(i1) != '/' && s1.charAt(i1) != '\\' || s2.charAt(i2) != '/' && s2.charAt(i2) != '\\') {
                            return false;
                        }
                    }
                }
                if (++i1 == n1 || ++i2 == n2) break;
            }
            return true;
        }

        public static /* synthetic */ boolean stringsEquivalent$default(Companion companion, String string2, String string3, int n, int n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            return companion.stringsEquivalent(string2, string3, n, n2);
        }

        public final boolean symbolsMatch(@NotNull String s1, @NotNull String s2) {
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            int symbolStart = StringsKt.indexOf$default((CharSequence)s1, (char)'`', (int)0, (boolean)false, (int)6, null);
            if (symbolStart == -1) {
                return false;
            }
            int symbolStart2 = 0;
            while (symbolStart != -1) {
                int symbolEnd = StringsKt.indexOf$default((CharSequence)s1, (char)'`', (int)(symbolStart + 1), (boolean)false, (int)4, null);
                if (symbolEnd == -1) {
                    return false;
                }
                if ((symbolStart2 = StringsKt.indexOf$default((CharSequence)s2, (char)'`', (int)symbolStart2, (boolean)false, (int)4, null)) == -1) {
                    return false;
                }
                int symbolEnd2 = StringsKt.indexOf$default((CharSequence)s2, (char)'`', (int)(symbolStart2 + 1), (boolean)false, (int)4, null);
                if (symbolEnd2 == -1 || symbolEnd2 - symbolStart2 != symbolEnd - symbolStart || !StringsKt.regionMatches$default((String)s1, (int)symbolStart, (String)s2, (int)symbolStart2, (int)(symbolEnd - symbolStart), (boolean)false, (int)16, null)) {
                    return false;
                }
                symbolStart = StringsKt.indexOf$default((CharSequence)s1, (char)'`', (int)(symbolEnd + 1), (boolean)false, (int)4, null);
                symbolStart2 = symbolEnd2 + 1;
            }
            return true;
        }

        public final boolean tokenPrecededBy(@NotNull String $this$tokenPrecededBy, @NotNull String prev, int offset, char separator) {
            int i;
            Intrinsics.checkNotNullParameter((Object)$this$tokenPrecededBy, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            if (offset < 0 || offset >= $this$tokenPrecededBy.length()) {
                throw new IndexOutOfBoundsException("index: " + offset + ", size: " + $this$tokenPrecededBy.length());
            }
            for (i = offset; i > 0 && $this$tokenPrecededBy.charAt(i) != separator && $this$tokenPrecededBy.charAt(i - 1) != ' '; --i) {
            }
            return (i -= prev.length()) < 0 ? false : StringsKt.regionMatches((String)$this$tokenPrecededBy, (int)i, (String)prev, (int)0, (int)prev.length(), (boolean)false);
        }

        public static /* synthetic */ boolean tokenPrecededBy$default(Companion companion, String string2, String string3, int n, char c, int n2, Object object) {
            if ((n2 & 4) != 0) {
                c = (char)32;
            }
            return companion.tokenPrecededBy(string2, string3, n, c);
        }

        public final boolean stringsEquivalent(@NotNull String s1, @NotNull String s2, @NotNull Function2<? super String, ? super Integer, Boolean> skipTokenAt) {
            Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
            Intrinsics.checkNotNullParameter(skipTokenAt, (String)"skipTokenAt");
            int i1 = 0;
            int i2 = 0;
            int n1 = s1.length();
            int n2 = s2.length();
            block0: while (true) {
                if (i1 < n1 && (CharsKt.isWhitespace((char)s1.charAt(i1)) || s1.charAt(i1) == '`')) {
                    ++i1;
                    continue;
                }
                while (i2 < n2 && (CharsKt.isWhitespace((char)s2.charAt(i2)) || s2.charAt(i2) == '`')) {
                    ++i2;
                }
                if (i1 >= n1) {
                    return i2 >= n2;
                }
                if (i2 >= n2) {
                    return false;
                }
                if (s1.charAt(i1) != s2.charAt(i2)) {
                    if (((Boolean)skipTokenAt.invoke((Object)s1, (Object)i1)).booleanValue()) {
                        while (i1 < n1 && !CharsKt.isWhitespace((char)s1.charAt(i1))) {
                            ++i1;
                        }
                        while (true) {
                            if (i2 >= n2 || CharsKt.isWhitespace((char)s2.charAt(i2))) continue block0;
                            ++i2;
                        }
                    }
                    return false;
                }
                ++i1;
                ++i2;
            }
        }

        private final void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
            writer.write("\n");
            this.indent(writer, indent);
            writer.write(name);
            writer.write("=\"");
            writer.write(XmlUtils.toXmlAttributeValue((String)value));
            writer.write("\"");
        }

        private final void indent(Writer writer, int indent) throws IOException {
            for (int level = 0; level < indent; ++level) {
                writer.write("    ");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "", "issueId", "", "message", "path", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getIssueId", "()Ljava/lang/String;", "getMessage", "getPath", "next", "getNext", "()Lcom/android/tools/lint/client/api/LintBaseline$Entry;", "setNext", "(Lcom/android/tools/lint/client/api/LintBaseline$Entry;)V", "previous", "getPrevious", "setPrevious", "android.sdktools.lint-api"})
    private static final class Entry {
        @NotNull
        private final String issueId;
        @NotNull
        private final String message;
        @NotNull
        private final String path;
        @Nullable
        private Entry next;
        @Nullable
        private Entry previous;

        public Entry(@NotNull String issueId, @NotNull String message, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.issueId = issueId;
            this.message = message;
            this.path = path;
        }

        @NotNull
        public final String getIssueId() {
            return this.issueId;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @Nullable
        public final Entry getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Entry entry) {
            this.next = entry;
        }

        @Nullable
        public final Entry getPrevious() {
            return this.previous;
        }

        public final void setPrevious(@Nullable Entry entry) {
            this.previous = entry;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/client/api/LintBaseline$ReportedEntry;", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "<init>", "(Lcom/android/tools/lint/detector/api/Incident;)V", "getIncident", "()Lcom/android/tools/lint/detector/api/Incident;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "getIssue$android_sdktools_lint_api", "()Lcom/android/tools/lint/detector/api/Issue;", "project", "Lcom/android/tools/lint/detector/api/Project;", "getProject$android_sdktools_lint_api", "()Lcom/android/tools/lint/detector/api/Project;", "location", "Lcom/android/tools/lint/detector/api/Location;", "getLocation$android_sdktools_lint_api", "()Lcom/android/tools/lint/detector/api/Location;", "message", "", "getMessage$android_sdktools_lint_api", "()Ljava/lang/String;", "compareTo", "", "other", "android.sdktools.lint-api"})
    @SourceDebugExtension(value={"SMAP\nLintBaseline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintBaseline.kt\ncom/android/tools/lint/client/api/LintBaseline$ReportedEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1267:1\n1#2:1268\n*E\n"})
    public static final class ReportedEntry
    implements Comparable<ReportedEntry> {
        @NotNull
        private final Incident incident;
        @NotNull
        private final String message;

        /*
         * WARNING - void declaration
         */
        public ReportedEntry(@NotNull Incident incident) {
            void $this$incident_u24lambda_u240;
            Incident incident2;
            Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
            Incident incident3 = incident2 = IncidentKt.copySafe(incident);
            ReportedEntry reportedEntry = this;
            boolean bl = false;
            $this$incident_u24lambda_u240.setProject(incident.getProject());
            reportedEntry.incident = incident2;
            this.message = incident.getMessage();
        }

        @NotNull
        public final Incident getIncident() {
            return this.incident;
        }

        @NotNull
        public final Issue getIssue$android_sdktools_lint_api() {
            return this.incident.getIssue();
        }

        @Nullable
        public final Project getProject$android_sdktools_lint_api() {
            return this.incident.getProject();
        }

        @NotNull
        public final Location getLocation$android_sdktools_lint_api() {
            return this.incident.getLocation();
        }

        @NotNull
        public final String getMessage$android_sdktools_lint_api() {
            return this.message;
        }

        @Override
        public int compareTo(@NotNull ReportedEntry other) {
            File secondaryFile2;
            Location secondary2;
            Location secondary1;
            int otherLine;
            String id2;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int categoryDelta = this.getIssue$android_sdktools_lint_api().getCategory().compareTo(other.getIssue$android_sdktools_lint_api().getCategory());
            if (categoryDelta != 0) {
                return categoryDelta;
            }
            int priorityDelta = other.getIssue$android_sdktools_lint_api().getPriority() - this.getIssue$android_sdktools_lint_api().getPriority();
            if (priorityDelta != 0) {
                return priorityDelta;
            }
            String id1 = this.getIssue$android_sdktools_lint_api().getId();
            int idDelta = id1.compareTo(id2 = other.getIssue$android_sdktools_lint_api().getId());
            if (idDelta != 0) {
                return idDelta;
            }
            File file = this.getLocation$android_sdktools_lint_api().getFile();
            File otherFile = other.getLocation$android_sdktools_lint_api().getFile();
            String string2 = file.getName();
            String string3 = otherFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            int fileDelta = string2.compareTo(string3);
            if (fileDelta != 0) {
                return fileDelta;
            }
            Position position = this.getLocation$android_sdktools_lint_api().getStart();
            int line = position != null ? position.getLine() : -1;
            Position position2 = other.getLocation$android_sdktools_lint_api().getStart();
            int n = otherLine = position2 != null ? position2.getLine() : -1;
            if (line != otherLine) {
                return line - otherLine;
            }
            int delta = this.message.compareTo(other.message);
            if (delta != 0) {
                return delta;
            }
            delta = file.compareTo(otherFile);
            if (delta != 0) {
                return delta;
            }
            Location location = secondary1 = this.getLocation$android_sdktools_lint_api().getSecondary();
            File secondaryFile1 = location != null ? location.getFile() : null;
            Location location2 = secondary2 = other.getLocation$android_sdktools_lint_api().getSecondary();
            File file2 = secondaryFile2 = location2 != null ? location2.getFile() : null;
            if (secondaryFile1 != null) {
                return secondaryFile2 != null ? secondaryFile1.compareTo(secondaryFile2) : -1;
            }
            if (secondaryFile2 != null) {
                return 1;
            }
            if (line != -1 && otherLine != -1) {
                Position position3 = this.getLocation$android_sdktools_lint_api().getStart();
                Position position4 = other.getLocation$android_sdktools_lint_api().getStart();
                delta = (position3 != null ? position3.getColumn() : -1) - (position4 != null ? position4.getColumn() : -1);
                if (delta != 0) {
                    return delta;
                }
            }
            return 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.INFORMATIONAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.IGNORE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

