/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.WearDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/WearRecentsDetector;", "Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "getApplicableReferenceNames", "visitReference", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Issues", "android.sdktools.lint-checks"})
public final class WearRecentsDetector
extends WearDetector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"activity");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.isWearProject()) {
            return;
        }
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "excludeFromRecents")) {
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "noHistory")) {
                context2.report(ISSUE, context2.getLocation(element), "In addition to `excludeFromRecents`, set `noHistory` flag to avoid showing this activity in recents", this.fix().name("Set noHistory").set("http://schemas.android.com/apk/res/android", "noHistory", "true").build());
            }
            return;
        }
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "taskAffinity")) {
            LintFix[] lintFixArray = new LintFix[2];
            lintFixArray[0] = this.fix().name("Set `taskAffinity`").set("http://schemas.android.com/apk/res/android", "taskAffinity", "").autoFix().build();
            LintFix[] lintFixArray2 = new LintFix[]{this.fix().set("http://schemas.android.com/apk/res/android", "excludeFromRecents", "true").build(), this.fix().set("http://schemas.android.com/apk/res/android", "noHistory", "true").build()};
            lintFixArray[1] = this.fix().name("Exclude from recents").composite(lintFixArray2).autoFix();
            context2.report(ISSUE, context2.getLocation(element), "Set `taskAffinity` for Wear activities to make them appear correctly in recents", this.fix().alternatives(lintFixArray));
        }
    }

    @Override
    @NotNull
    public List<String> getApplicableReferenceNames() {
        Object[] objectArray = new String[]{"FLAG_ACTIVITY_NEW_TASK", "FLAG_ACTIVITY_CLEAR_TOP"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitReference(@NotNull JavaContext context2, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        if (!this.isWearProject()) {
            return;
        }
        Context.report$default(context2, ISSUE, context2.getLocation((UElement)reference), "Avoid using `FLAG_ACTIVITY_NEW_TASK` and `FLAG_ACTIVITY_CLEAR_TOP`", null, 8, null);
    }

    static {
        Object object = new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)WearRecentsDetector.class, (EnumSet<Scope>)EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), (EnumSet<Scope>)object);
        object = Issue.Companion;
        Category category = Category.USABILITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)object, "WearRecents", "Wear OS: Recents and app resume", "\n          In recents, correctly represent your app's activities, consistent with device implementation.\n        ", implementation, null, category, 0, severity, true, null, null, null, 3664, null).addMoreInfo("https://developer.android.com/training/wearables/apps/launcher");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/WearRecentsDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

