/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.WatchFaceFormatUtils;
import com.android.tools.lint.checks.WearDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/WatchFaceFormatVersionDetector;", "Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/Detector$XmlScanner;", "<init>", "()V", "hasWffVersionProperty", "", "beforeCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "getApplicableElements", "", "", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "afterCheckFile", "Companion", "android.sdktools.lint-checks"})
public final class WatchFaceFormatVersionDetector
extends WearDetector
implements Detector.XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasWffVersionProperty;
    @JvmField
    @NotNull
    public static final Issue MISSING_VERSION_ISSUE;
    @JvmField
    @NotNull
    public static final Issue INVALID_VERSION_ISSUE;

    @Override
    public void beforeCheckFile(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super.beforeCheckFile(context2);
        this.hasWffVersionProperty = false;
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"property");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!Intrinsics.areEqual((Object)element.getTagName(), (Object)"property")) {
            return;
        }
        if (!Intrinsics.areEqual((Object)element.getParentNode().getNodeName(), (Object)"application")) {
            return;
        }
        if (!Intrinsics.areEqual((Object)element.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)"com.google.wear.watchface.format.version")) {
            return;
        }
        this.hasWffVersionProperty = true;
        Attr wffVersionValueAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "value");
        if (wffVersionValueAttribute == null) {
            context2.report(MISSING_VERSION_ISSUE, context2.getNameLocation(element), "The `android:value` attribute is missing", this.fix().set("http://schemas.android.com/apk/res/android", "value", "1").build());
            return;
        }
        String string3 = wffVersionValueAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
        if (Lint.isManifestPlaceHolderExpression(string3)) {
            Project project = context2.getProject();
            String string4 = wffVersionValueAttribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getValue(...)");
            string2 = Lint.resolvePlaceHolders$default(project, string4, null, null, 12, null);
            if (string2 == null) {
                return;
            }
        } else {
            string2 = wffVersionValueAttribute.getValue();
        }
        String wffVersion = string2;
        Intrinsics.checkNotNull((Object)wffVersion);
        if (StringsKt.toIntOrNull((String)wffVersion) == null) {
            Context.report$default(context2, INVALID_VERSION_ISSUE, context2.getLocation(wffVersionValueAttribute), "The Watch Face Format version is invalid", null, 8, null);
            return;
        }
    }

    @Override
    public void afterCheckFile(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.isWearProject()) {
            return;
        }
        if (this.hasWffVersionProperty) {
            return;
        }
        if (!WatchFaceFormatUtils.INSTANCE.hasDeclarativeWatchFaceFile(context2.getProject())) {
            return;
        }
        Object object = context2 instanceof XmlContext ? (XmlContext)context2 : null;
        if (object == null || (object = ((XmlContext)object).document) == null) {
            return;
        }
        Object manifest = object;
        Element element = XmlUtils.getFirstSubTagByName((Node)manifest.getDocumentElement(), (String)"application");
        if (element == null) {
            return;
        }
        Element application = element;
        Context.report$default(context2, MISSING_VERSION_ISSUE, ((XmlContext)context2).getNameLocation(application), "The Watch Face Format version property must be set", null, 8, null);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(WatchFaceFormatVersionDetector.class, Scope.MANIFEST_SCOPE);
        MISSING_VERSION_ISSUE = Issue.Companion.create$default(companion, "WatchFaceFormatMissingVersion", "The Watch Face Format version is missing", "\n             When creating a watch face using the Watch Face Format, you need to add the \"com.google.wear.watchface.format.version\" application \\\n             property. This property specifies which feature version the Watch Face Format is using.\n\n             Add the property to your application element:\n             ```xml\n             <property android:name=\"com.google.wear.watchface.format.version\"\n                       android:value=\"1\" />\n             ```\n          ", implementation, "https://developer.android.com/training/wearables/wff/setup#declare-wff-use", category, 7, severity, false, true, null, null, 3328, null).addMoreInfo("https://developer.android.com/training/wearables/wff/features");
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = new Implementation(WatchFaceFormatVersionDetector.class, Scope.MANIFEST_SCOPE);
        INVALID_VERSION_ISSUE = Issue.Companion.create$default(companion, "WatchFaceFormatInvalidVersion", "The Watch Face Format version is invalid", "\n               The Watch Face Format version must be an integer literal or a placeholder and cannot reference a resource.\n            ", implementation, "https://developer.android.com/training/wearables/wff/features", category, 7, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/WatchFaceFormatVersionDetector$Companion;", "", "<init>", "()V", "MISSING_VERSION_ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "INVALID_VERSION_ISSUE", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

