/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.WatchFaceFormatUtils;
import com.android.tools.lint.checks.WearDetector;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/WatchFaceFormatDeclaresHasNoCodeDetector;", "Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/Detector$XmlScanner;", "<init>", "()V", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "isFalse", "", "Lorg/w3c/dom/Attr;", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nWatchFaceFormatDeclaresHasNoCodeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WatchFaceFormatDeclaresHasNoCodeDetector.kt\ncom/android/tools/lint/checks/WatchFaceFormatDeclaresHasNoCodeDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1617#2,9:110\n1869#2:119\n1870#2:121\n1626#2:122\n1740#2,3:123\n1#3:120\n*S KotlinDebug\n*F\n+ 1 WatchFaceFormatDeclaresHasNoCodeDetector.kt\ncom/android/tools/lint/checks/WatchFaceFormatDeclaresHasNoCodeDetector\n*L\n84#1:110,9\n84#1:119\n84#1:121\n84#1:122\n85#1:123,3\n84#1:120\n*E\n"})
public final class WatchFaceFormatDeclaresHasNoCodeDetector
extends WearDetector
implements Detector.XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    public void afterCheckFile(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.isWearProject()) {
            return;
        }
        XmlContext xmlContext = context2 instanceof XmlContext ? (XmlContext)context2 : null;
        if (xmlContext == null) {
            return;
        }
        XmlContext xmlContext2 = xmlContext;
        Element root2 = xmlContext2.document.getDocumentElement();
        Element element = XmlUtils.getFirstSubTagByName((Node)root2, (String)"application");
        if (element == null) {
            return;
        }
        Element application = element;
        if (!WatchFaceFormatUtils.INSTANCE.hasWatchFaceFormatVersionProperty(application) && !WatchFaceFormatUtils.INSTANCE.hasDeclarativeWatchFaceFile(context2.getProject())) {
            return;
        }
        Attr hasCodeAttribute = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "hasCode");
        if (hasCodeAttribute != null && this.isFalse(hasCodeAttribute, context2)) {
            return;
        }
        Attr attr = hasCodeAttribute;
        context2.report(ISSUE, context2.getLocation(attr != null ? (Node)attr : (Node)application, hasCodeAttribute != null ? LocationType.DEFAULT : LocationType.NAME), "Applications using Watch Face Format must declare `hasCode=false`", this.fix().set("http://schemas.android.com/apk/res/android", "hasCode", "false").build());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isFalse(Attr $this$isFalse, Context context2) {
        boolean bl;
        block5: {
            void $this$all$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            ResourceUrl resourceUrl = ResourceUrl.parse((String)$this$isFalse.getValue());
            if (resourceUrl == null) {
                return Intrinsics.areEqual((Object)$this$isFalse.getValue(), (Object)"false");
            }
            List list2 = context2.getClient().getResources(context2.getProject(), ResourceRepositoryScope.PROJECT_ONLY).getResources(ResourceNamespace.RES_AUTO, resourceUrl.type, resourceUrl.name);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getResources(...)");
            Iterable iterable = list2;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                ResourceItem it = (ResourceItem)element$iv$iv;
                boolean bl3 = false;
                ResourceValue resourceValue = it.getResourceValue();
                if ((resourceValue != null ? resourceValue.getValue() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)"false")) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(WatchFaceFormatDeclaresHasNoCodeDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "WatchFaceFormatDeclaresHasNoCode", "The `hasCode` attribute should be set to `false`", "Watch Face Format is a resource-only format, so the `hasCode` attribute should be set to `false` to reflect this.", implementation, "https://developer.android.com/training/wearables/wff/setup#declare-wff-use", category, 7, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/WatchFaceFormatDeclaresHasNoCodeDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

