/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

public class SetJavaScriptEnabledDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create("SetJavaScriptEnabled", "Using `setJavaScriptEnabled`", "Your code should not invoke `setJavaScriptEnabled` if you are not sure that your app really requires JavaScript support.", Category.SECURITY, 6, Severity.WARNING, new Implementation(SetJavaScriptEnabledDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://goo.gle/SetJavaScriptEnabled").addMoreInfo("https://developer.android.com/training/articles/security-tips").setAndroidSpecific(true);

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call2, PsiMethod method) {
        Object constant;
        List arguments = call2.getValueArguments();
        if (arguments.size() == 1 && (constant = ConstantEvaluator.evaluate(context2, (UElement)arguments.get(0))) != null && !Boolean.FALSE.equals(constant)) {
            context2.report(ISSUE, (UElement)call2, context2.getLocation((UElement)call2), "Using `setJavaScriptEnabled` can introduce XSS vulnerabilities into your application, review carefully");
        }
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setJavaScriptEnabled");
    }
}

