/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.VersionChecks;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00020\t*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\t*\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\t*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/SdkSuppressDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "isTestCaseClassTestMethod", "Lorg/jetbrains/uast/UMethod;", "isTestCaseClass", "Lorg/jetbrains/uast/UClass;", "isInstanceOf", "Lcom/intellij/psi/PsiClass;", "qualifiedName", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nSdkSuppressDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkSuppressDetector.kt\ncom/android/tools/lint/checks/SdkSuppressDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n19652#2,2:177\n12637#2,2:180\n1#3:179\n*S KotlinDebug\n*F\n+ 1 SdkSuppressDetector.kt\ncom/android/tools/lint/checks/SdkSuppressDetector\n*L\n123#1:177,2\n173#1:180,2\n*E\n"})
public final class SdkSuppressDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(SdkSuppressDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES));
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String TEST_ANNOTATION = "org.junit.Test";
    @NotNull
    private static final String TEST_CASE_CLASS = "junit.framework.TestCase";

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{VersionChecks.REQUIRES_API_ANNOTATION.oldName(), VersionChecks.REQUIRES_API_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type == AnnotationUsageType.DEFINITION;
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        String name;
        LintFix lintFix;
        String source;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (!context2.isTestSource()) {
            return;
        }
        UAnnotation annotation = annotationInfo.getAnnotation();
        UElement annotated = annotation.getUastParent();
        if (!(annotated instanceof UClass) && !(annotated instanceof UMethod)) {
            return;
        }
        PsiElement modifierOwner = annotated.getJavaPsi();
        if (modifierOwner instanceof PsiModifierListOwner && !context2.getEvaluator().isPublic((PsiModifierListOwner)modifierOwner)) {
            return;
        }
        if (annotated instanceof UMethod && !((UMethod)annotated).hasAnnotation(TEST_ANNOTATION) && !this.isTestCaseClassTestMethod((UMethod)annotated)) {
            return;
        }
        if (annotated instanceof UClass && !this.isTestCaseClass((UClass)annotated)) {
            boolean bl;
            block10: {
                UMethod[] $this$none$iv = ((UClass)annotated).getMethods();
                boolean $i$f$none = false;
                int n = $this$none$iv.length;
                for (int i = 0; i < n; ++i) {
                    UMethod element$iv;
                    UMethod it = element$iv = $this$none$iv[i];
                    boolean bl2 = false;
                    if (!it.hasAnnotation(TEST_ANNOTATION)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        PsiElement psiElement = annotation.getSourcePsi();
        String string2 = source = psiElement != null ? psiElement.getText() : null;
        if (source != null) {
            int it = StringsKt.indexOf$default((CharSequence)source, (char)'=', (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            int index2 = it != -1 ? it : StringsKt.indexOf$default((CharSequence)source, (char)'(', (int)0, (boolean)false, (int)6, null);
            int valueStart = index2 + 1;
            String string3 = source.substring(valueStart);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            lintFix = this.fix().replace().text(source).with("@androidx.test.filters.SdkSuppress(minSdkVersion=" + value).range(context2.getLocation(element)).reformat(true).shortenNames().build();
        } else {
            lintFix = null;
        }
        LintFix fix2 = lintFix;
        StringBuilder message = new StringBuilder("Don't use @RequiresApi from tests; use @SdkSuppress");
        UDeclaration uDeclaration = (UDeclaration)annotated;
        String string4 = uDeclaration instanceof UMethod ? ((UMethod)annotated).getName() : (uDeclaration instanceof UVariable ? ((NavigationItem)annotated).getName() : (name = uDeclaration instanceof UClass ? ((UClass)annotated).getName() : null));
        if (name != null) {
            message.append(" on `" + name + "`");
        }
        message.append(" instead");
        Location location = context2.getNameLocation(element);
        String string5 = message.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        context2.report(ISSUE, element, location, string5, fix2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTestCaseClassTestMethod(UMethod $this$isTestCaseClassTestMethod) {
        if (!StringsKt.startsWith$default((String)$this$isTestCaseClassTestMethod.getName(), (String)"test", (boolean)false, (int)2, null)) return false;
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)$this$isTestCaseClassTestMethod));
        if (uClass == null) return false;
        if (!this.isTestCaseClass(uClass)) return false;
        return true;
    }

    private final boolean isTestCaseClass(UClass $this$isTestCaseClass) {
        return this.isInstanceOf($this$isTestCaseClass.getJavaPsi(), TEST_CASE_CLASS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isInstanceOf(@NotNull PsiClass $this$isInstanceOf, @NotNull String qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)$this$isInstanceOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)$this$isInstanceOf.getQualifiedName())) return true;
        PsiClass[] psiClassArray = $this$isInstanceOf.getSupers();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getSupers(...)");
        Object[] $this$any$iv = psiClassArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            PsiClass it = (PsiClass)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.isInstanceOf(it, qualifiedName)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "UseSdkSuppress", "Using `@SdkSuppress` instead of `@RequiresApi`", "\n          In tests, you should be using `@SdkSuppress` instead of `@RequiresApi`. \\\n          The `@RequiresApi` annotation is used to propagate a version requirement \\\n          out to the caller of the API -- but the testing framework is only looking \\\n          for `@SdkSuppress`, which it uses to skip tests that are intended for \\\n          newer versions.\n          ", implementation, null, category, 4, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/SdkSuppressDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "TEST_ANNOTATION", "", "TEST_CASE_CLASS", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

