/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J0\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001c\"\b\b\u0000\u0010\u001d*\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001d0\u001fH\u0002J \u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020\u0011H\u0002J(\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\f\u0010)\u001a\u00020\t*\u00020'H\u0002J0\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010+\u001a\b\u0012\u0004\u0012\u00020'0,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u000e\u0010/\u001a\u0004\u0018\u00010\u0007*\u00020'H\u0002J\u001a\u00100\u001a\u00020\t2\b\u00101\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u00102\u001a\u0004\u0018\u0001032\b\u00101\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u00065"}, d2={"Lcom/android/tools/lint/checks/ResourceTypeDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "isResourceAnnotation", "signature", "checkColor", "argument", "checkHalfFloat", "getParentSequence", "Lkotlin/sequences/Sequence;", "T", "clz", "Ljava/lang/Class;", "checkPx", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "outermostQualified", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "reportUnitMismatch", "unit", "Lcom/android/resources/ResourceType;", "typeUnit", "isDimension", "checkResourceType", "expectedTypes", "Ljava/util/EnumSet;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "getMarkerTypeDescription", "typeArrayFromArrayLiteral", "node", "getMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nResourceTypeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceTypeDetector.kt\ncom/android/tools/lint/checks/ResourceTypeDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,651:1\n1#2:652\n1310#3,2:653\n*S KotlinDebug\n*F\n+ 1 ResourceTypeDetector.kt\ncom/android/tools/lint/checks/ResourceTypeDetector\n*L\n365#1:653,2\n*E\n"})
public final class ResourceTypeDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ResourceTypeDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue RESOURCE_TYPE;
    @JvmField
    @NotNull
    public static final Issue COLOR_USAGE;
    @JvmField
    @NotNull
    public static final Issue HALF_FLOAT;

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{ResourceEvaluator.COLOR_INT_ANNOTATION.oldName(), ResourceEvaluator.COLOR_INT_ANNOTATION.newName(), ResourceEvaluator.DIMENSION_ANNOTATION.oldName(), ResourceEvaluator.DIMENSION_ANNOTATION.newName(), ResourceEvaluator.PX_ANNOTATION.oldName(), ResourceEvaluator.PX_ANNOTATION.newName(), AnnotationDetectorKt.HALF_FLOAT_ANNOTATION.oldName(), AnnotationDetectorKt.HALF_FLOAT_ANNOTATION.newName(), ResourceEvaluator.ANIMATOR_RES_ANNOTATION.oldName(), ResourceEvaluator.ANIMATOR_RES_ANNOTATION.newName(), ResourceEvaluator.ANIM_RES_ANNOTATION.oldName(), ResourceEvaluator.ANIM_RES_ANNOTATION.newName(), ResourceEvaluator.ANY_RES_ANNOTATION.oldName(), ResourceEvaluator.ANY_RES_ANNOTATION.newName(), ResourceEvaluator.ARRAY_RES_ANNOTATION.oldName(), ResourceEvaluator.ARRAY_RES_ANNOTATION.newName(), ResourceEvaluator.ATTR_RES_ANNOTATION.oldName(), ResourceEvaluator.ATTR_RES_ANNOTATION.newName(), ResourceEvaluator.BOOL_RES_ANNOTATION.oldName(), ResourceEvaluator.BOOL_RES_ANNOTATION.newName(), ResourceEvaluator.COLOR_RES_ANNOTATION.oldName(), ResourceEvaluator.COLOR_RES_ANNOTATION.newName(), ResourceEvaluator.FONT_RES_ANNOTATION.oldName(), ResourceEvaluator.FONT_RES_ANNOTATION.newName(), ResourceEvaluator.DIMEN_RES_ANNOTATION.oldName(), ResourceEvaluator.DIMEN_RES_ANNOTATION.newName(), ResourceEvaluator.DRAWABLE_RES_ANNOTATION.oldName(), ResourceEvaluator.DRAWABLE_RES_ANNOTATION.newName(), ResourceEvaluator.FRACTION_RES_ANNOTATION.oldName(), ResourceEvaluator.FRACTION_RES_ANNOTATION.newName(), ResourceEvaluator.ID_RES_ANNOTATION.oldName(), ResourceEvaluator.ID_RES_ANNOTATION.newName(), ResourceEvaluator.INTEGER_RES_ANNOTATION.oldName(), ResourceEvaluator.INTEGER_RES_ANNOTATION.newName(), ResourceEvaluator.INTERPOLATOR_RES_ANNOTATION.oldName(), ResourceEvaluator.INTERPOLATOR_RES_ANNOTATION.newName(), ResourceEvaluator.LAYOUT_RES_ANNOTATION.oldName(), ResourceEvaluator.LAYOUT_RES_ANNOTATION.newName(), ResourceEvaluator.MENU_RES_ANNOTATION.oldName(), ResourceEvaluator.MENU_RES_ANNOTATION.newName(), ResourceEvaluator.NAVIGATION_RES_ANNOTATION.oldName(), ResourceEvaluator.NAVIGATION_RES_ANNOTATION.newName(), ResourceEvaluator.PLURALS_RES_ANNOTATION.oldName(), ResourceEvaluator.PLURALS_RES_ANNOTATION.newName(), ResourceEvaluator.RAW_RES_ANNOTATION.oldName(), ResourceEvaluator.RAW_RES_ANNOTATION.newName(), ResourceEvaluator.STRING_RES_ANNOTATION.oldName(), ResourceEvaluator.STRING_RES_ANNOTATION.newName(), ResourceEvaluator.STYLEABLE_RES_ANNOTATION.oldName(), ResourceEvaluator.STYLEABLE_RES_ANNOTATION.newName(), ResourceEvaluator.STYLE_RES_ANNOTATION.oldName(), ResourceEvaluator.STYLE_RES_ANNOTATION.newName(), ResourceEvaluator.TRANSITION_RES_ANNOTATION.oldName(), ResourceEvaluator.TRANSITION_RES_ANNOTATION.newName(), ResourceEvaluator.XML_RES_ANNOTATION.oldName(), ResourceEvaluator.XML_RES_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type != AnnotationUsageType.DEFINITION;
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        String qualifiedName = annotationInfo.getQualifiedName();
        if (Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.COLOR_INT_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.COLOR_INT_ANNOTATION.newName())) {
            this.checkColor(context2, element);
        } else if (Intrinsics.areEqual((Object)qualifiedName, (Object)AnnotationDetectorKt.HALF_FLOAT_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)qualifiedName, (Object)AnnotationDetectorKt.HALF_FLOAT_ANNOTATION.newName())) {
            this.checkHalfFloat(context2, element);
        } else if (Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.DIMENSION_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.DIMENSION_ANNOTATION.newName()) || Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.PX_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)qualifiedName, (Object)ResourceEvaluator.PX_ANNOTATION.newName())) {
            this.checkPx(context2, element, annotationInfo.getAnnotation());
        } else if (this.isResourceAnnotation(qualifiedName)) {
            UastBinaryOperator operator;
            if (usageInfo.anyCloser((Function1<? super AnnotationInfo, Boolean>)((Function1)arg_0 -> ResourceTypeDetector.visitAnnotationUsage$lambda$0(this, arg_0)))) {
                return;
            }
            UElement expression = UastUtils.skipParenthesizedExprUp((UElement)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)true));
            if (expression instanceof UBinaryExpression && (operator = ((UBinaryExpression)expression).getOperator()) instanceof UastBinaryOperator.ComparisonOperator && operator != UastBinaryOperator.EQUALS && operator != UastBinaryOperator.NOT_EQUALS && operator != UastBinaryOperator.IDENTITY_EQUALS && operator != UastBinaryOperator.IDENTITY_NOT_EQUALS) {
                Location location = context2.getLocation(expression);
                String string2 = "Comparing resource types (`@%1$s`) other than equality is dangerous and usually wrong;  some resource types set top bit which turns the value negative";
                Object[] objectArray = new Object[]{AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.removeFrom(qualifiedName)};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                JavaContext.report$default(context2, RESOURCE_TYPE, expression, location, string3, null, 16, null);
                return;
            }
            EnumSet<ResourceType> types = ResourceEvaluator.getTypesFromAnnotationList(usageInfo.getAnnotations());
            if (types != null) {
                if (types.contains(ResourceType.STYLEABLE) && usageInfo.getType() == AnnotationUsageType.ASSIGNMENT_LHS) {
                    return;
                }
                PsiElement psiElement = usageInfo.getReferenced();
                this.checkResourceType(context2, element, types, psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null);
            }
        }
    }

    private final boolean isResourceAnnotation(String signature) {
        return ResourceEvaluator.getTypeFromAnnotationSignature(signature) != null || ResourceEvaluator.ANY_RES_ANNOTATION.isEquals(signature) || AndroidPlatformAnnotations.Companion.isPlatformAnnotation(signature) && ResourceEvaluator.getTypeFromAnnotationSignature(AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(signature)) != null;
    }

    private final void checkColor(JavaContext context2, UElement argument) {
        if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getThenExpression();
                Intrinsics.checkNotNull((Object)uExpression);
                this.checkColor(context2, (UElement)uExpression);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                UExpression uExpression = ((UIfExpression)argument).getElseExpression();
                Intrinsics.checkNotNull((Object)uExpression);
                this.checkColor(context2, (UElement)uExpression);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkColor(context2, (UElement)((UParenthesizedExpression)argument).getExpression());
            return;
        }
        EnumSet<ResourceType> types = ResourceEvaluator.getResourceTypes(context2.getEvaluator(), argument);
        if (types != null && types.contains(ResourceType.COLOR)) {
            String string2 = "Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`";
            Object[] objectArray = new Object[]{argument.asSourceString()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            String message = string3;
            this.report(context2, COLOR_USAGE, argument, context2.getLocation(argument), message);
        }
    }

    private final void checkHalfFloat(JavaContext context2, UElement argument) {
        UExpression curr;
        if (argument instanceof UIfExpression) {
            UExpression elseExpression;
            UExpression thenExpression = ((UIfExpression)argument).getThenExpression();
            if (thenExpression != null) {
                this.checkColor(context2, (UElement)thenExpression);
            }
            if ((elseExpression = ((UIfExpression)argument).getElseExpression()) != null) {
                this.checkColor(context2, (UElement)elseExpression);
            }
            return;
        }
        EnumSet<ResourceType> types = ResourceEvaluator.getResourceTypes(context2.getEvaluator(), argument);
        if (types != null && !types.isEmpty()) {
            String type = types.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE) ? "dimension" : (types.contains(ResourceEvaluator.DIMENSION_SP_MARKER_TYPE) ? "sp dimension" : (types.contains(ResourceEvaluator.DIMENSION_DP_MARKER_TYPE) ? "dp dimension" : (types.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? "color" : "resource id")));
            String string2 = "Expected a half float here, not a %1$s";
            Object[] objectArray = new Object[]{type};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            String message = string3;
            this.report(context2, HALF_FLOAT, argument, context2.getLocation(argument), message);
            return;
        }
        Iterator iterator = this.getParentSequence(argument, UExpression.class).iterator();
        while (iterator.hasNext() && !((curr = (UExpression)iterator.next()) instanceof UBinaryExpressionWithType)) {
            PsiType expressionType = curr.getExpressionType();
            if (expressionType == null || Intrinsics.areEqual((Object)PsiTypes.shortType(), (Object)expressionType)) continue;
            if (Intrinsics.areEqual((Object)PsiTypes.voidType(), (Object)expressionType) || Intrinsics.areEqual((Object)PsiTypes.booleanType(), (Object)expressionType) || Intrinsics.areEqual((Object)PsiTypes.byteType(), (Object)expressionType) || Intrinsics.areEqual((Object)expressionType.getCanonicalText(), (Object)"android.util.Half")) break;
            String string4 = "Half-float type in expression widened to %1$s";
            Object[] objectArray = new Object[]{expressionType.getCanonicalText()};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            String message = string5;
            this.report(context2, HALF_FLOAT, argument, context2.getLocation(argument), message);
            break;
        }
    }

    private final <T extends UElement> Sequence<T> getParentSequence(UElement element, Class<? extends T> clz) {
        UElement seed = UastUtils.getParentOfType((UElement)element, clz, (boolean)false);
        Function1 nextFunction = arg_0 -> ResourceTypeDetector.getParentSequence$lambda$0(clz, arg_0);
        return SequencesKt.generateSequence((Object)seed, (Function1)nextFunction);
    }

    private final void checkPx(JavaContext context2, UElement argument, UAnnotation annotation) {
        if (argument instanceof UIfExpression) {
            UExpression it;
            UExpression uExpression = ((UIfExpression)argument).getThenExpression();
            if (uExpression != null) {
                it = uExpression;
                boolean bl = false;
                this.checkPx(context2, (UElement)it, annotation);
            }
            UExpression uExpression2 = ((UIfExpression)argument).getElseExpression();
            if (uExpression2 != null) {
                it = uExpression2;
                boolean bl = false;
                this.checkPx(context2, (UElement)it, annotation);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkPx(context2, (UElement)((UParenthesizedExpression)argument).getExpression(), annotation);
            return;
        }
        EnumSet<ResourceType> enumSet = ResourceEvaluator.getResourceTypes(context2.getEvaluator(), argument);
        if (enumSet == null) {
            return;
        }
        EnumSet<ResourceType> types = enumSet;
        if (types.contains(ResourceType.DIMEN)) {
            String message = "Should pass resolved pixel dimension instead of resource id here: `getResources().getDimension*(" + argument.asSourceString() + ")`";
            this.report(context2, RESOURCE_TYPE, argument, context2.getLocation(argument), message);
        } else {
            Object object;
            ResourceType unit;
            block17: {
                ResourceType resourceType = ResourceEvaluator.getTypeFromAnnotation(annotation);
                if (resourceType == null) {
                    return;
                }
                unit = resourceType;
                Intrinsics.checkNotNullExpressionValue((Object)ResourceEvaluator.DIMENSION_MARKERS, (String)"DIMENSION_MARKERS");
                Object[] $this$firstOrNull$iv = ResourceEvaluator.DIMENSION_MARKERS;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ResourceType it = (ResourceType)element$iv;
                    boolean bl = false;
                    if (!types.contains(it)) continue;
                    object = element$iv;
                    break block17;
                }
                object = null;
            }
            ResourceType resourceType = (ResourceType)object;
            if (resourceType == null) {
                return;
            }
            ResourceType typeUnit = resourceType;
            if (unit != typeUnit && this.isDimension(unit)) {
                this.reportUnitMismatch(unit, typeUnit, context2, argument);
            } else {
                UElement selector;
                UQualifiedReferenceExpression uQualifiedReferenceExpression = this.outermostQualified(argument);
                if (uQualifiedReferenceExpression == null) {
                    return;
                }
                UQualifiedReferenceExpression outer = uQualifiedReferenceExpression;
                if (argument == UastLintUtilsKt.findSelector((UElement)outer.getReceiver()) && (selector = UastLintUtilsKt.findSelector((UElement)outer)) instanceof USimpleNameReferenceExpression) {
                    if (unit != ResourceEvaluator.DIMENSION_DP_MARKER_TYPE && (Intrinsics.areEqual((Object)((USimpleNameReferenceExpression)selector).getIdentifier(), (Object)"dp") || Intrinsics.areEqual((Object)((USimpleNameReferenceExpression)selector).getResolvedName(), (Object)"getDp"))) {
                        ResourceType resourceType2 = ResourceEvaluator.DIMENSION_DP_MARKER_TYPE;
                        Intrinsics.checkNotNullExpressionValue((Object)resourceType2, (String)"DIMENSION_DP_MARKER_TYPE");
                        this.reportUnitMismatch(resourceType2, unit, context2, argument);
                    } else if (unit != ResourceEvaluator.DIMENSION_SP_MARKER_TYPE && (Intrinsics.areEqual((Object)((USimpleNameReferenceExpression)selector).getIdentifier(), (Object)"sp") || Intrinsics.areEqual((Object)((USimpleNameReferenceExpression)selector).getResolvedName(), (Object)"getSp"))) {
                        ResourceType resourceType3 = ResourceEvaluator.DIMENSION_SP_MARKER_TYPE;
                        Intrinsics.checkNotNullExpressionValue((Object)resourceType3, (String)"DIMENSION_SP_MARKER_TYPE");
                        this.reportUnitMismatch(resourceType3, unit, context2, argument);
                    }
                }
            }
        }
    }

    private final UQualifiedReferenceExpression outermostQualified(UElement $this$outermostQualified) {
        UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)$this$outermostQualified.getUastParent());
        UQualifiedReferenceExpression uQualifiedReferenceExpression = uElement instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement : null;
        if (uQualifiedReferenceExpression == null) {
            return null;
        }
        UQualifiedReferenceExpression curr = uQualifiedReferenceExpression;
        while (true) {
            UQualifiedReferenceExpression parent;
            UElement uElement2;
            UQualifiedReferenceExpression uQualifiedReferenceExpression2 = (uElement2 = UastUtils.skipParenthesizedExprUp((UElement)curr.getUastParent())) instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement2 : null;
            if (uQualifiedReferenceExpression2 == null) {
                return curr;
            }
            curr = parent = uQualifiedReferenceExpression2;
        }
    }

    private final void reportUnitMismatch(ResourceType unit, ResourceType typeUnit, JavaContext context2, UElement argument) {
        String expected = this.getMarkerTypeDescription(unit);
        String actual = this.getMarkerTypeDescription(typeUnit);
        String message = "Mismatched @Dimension units here; expected " + expected + " but received " + actual;
        this.report(context2, RESOURCE_TYPE, argument, context2.getLocation(argument), message);
    }

    private final boolean isDimension(ResourceType $this$isDimension) {
        return $this$isDimension == ResourceEvaluator.DIMENSION_MARKER_TYPE || $this$isDimension == ResourceEvaluator.DIMENSION_DP_MARKER_TYPE || $this$isDimension == ResourceEvaluator.DIMENSION_SP_MARKER_TYPE;
    }

    private final void checkResourceType(JavaContext context2, UElement argument, EnumSet<ResourceType> expectedTypes, PsiMethod calledMethod) {
        Object object;
        UExpression call2;
        EnumSet<ResourceType> actual = ResourceEvaluator.getResourceTypes(context2.getEvaluator(), argument);
        if (actual == null && (!UastLintUtils.Companion.isNumber(argument) || UastLintUtils.Companion.isZero(argument) || UastLintUtils.Companion.isMinusOne(argument))) {
            return;
        }
        if (actual != null && (!Sets.intersection((Set)actual, (Set)expectedTypes).isEmpty() || expectedTypes.contains(ResourceType.DRAWABLE) && (actual.contains(ResourceType.COLOR) || actual.contains(ResourceType.MIPMAP)))) {
            return;
        }
        if (expectedTypes.contains(ResourceType.STYLEABLE) && expectedTypes.size() == 1 && calledMethod != null && context2.getEvaluator().isMemberInClass((PsiMember)calledMethod, "android.content.res.TypedArray") && (call2 = (UExpression)UastUtils.getParentOfType((UElement)argument, UCallExpression.class, (boolean)false)) instanceof UCallExpression) {
            UExpression uExpression = ((UCallExpression)call2).getReceiver();
            if (this.typeArrayFromArrayLiteral((UElement)(uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null), context2)) {
                return;
            }
        }
        if (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE)) {
            ResourceType resourceType = ResourceEvaluator.COLOR_INT_MARKER_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"COLOR_INT_MARKER_TYPE");
            object = "Expected a color resource id (`R.color.`) but received " + this.getMarkerTypeDescription(resourceType);
        } else if (expectedTypes.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE)) {
            object = "Should pass resolved color instead of resource id here: `getResources().getColor(" + argument.asSourceString() + ")`";
        } else if (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE)) {
            ResourceType resourceType = ResourceEvaluator.DIMENSION_MARKER_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"DIMENSION_MARKER_TYPE");
            object = "Expected a dimension resource id (`R.dimen.`) but received " + this.getMarkerTypeDescription(resourceType);
        } else if (expectedTypes.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE)) {
            object = "Should pass resolved pixel size instead of resource id here: `getResources().getDimension*(" + argument.asSourceString() + ")`";
        } else if (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.DIMENSION_SP_MARKER_TYPE)) {
            ResourceType resourceType = ResourceEvaluator.DIMENSION_SP_MARKER_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"DIMENSION_SP_MARKER_TYPE");
            object = "Expected a dimension resource id (`R.dimen.`) but received " + this.getMarkerTypeDescription(resourceType);
        } else if (expectedTypes.contains(ResourceEvaluator.DIMENSION_SP_MARKER_TYPE)) {
            object = "Should pass resolved scale-independent (sp) pixel size instead of resource id here: `getResources().getDimension*(" + argument.asSourceString() + ")`";
        } else if (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.DIMENSION_DP_MARKER_TYPE)) {
            ResourceType resourceType = ResourceEvaluator.DIMENSION_DP_MARKER_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"DIMENSION_DP_MARKER_TYPE");
            object = "Expected a dimension resource id (`R.dimen.`) but received " + this.getMarkerTypeDescription(resourceType);
        } else {
            object = expectedTypes.contains(ResourceEvaluator.DIMENSION_DP_MARKER_TYPE) ? "Should pass resolved density-independent (dp) pixel size instead of resource id here: `getResources().getDimension*(" + argument.asSourceString() + ")`" : (Intrinsics.areEqual(expectedTypes, ResourceEvaluator.getAnyRes()) ? "Expected resource identifier (`R`.type.`name`)" : "Expected resource of type " + CollectionsKt.joinToString$default((Iterable)expectedTypes, (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null));
        }
        String message = object;
        this.report(context2, RESOURCE_TYPE, argument, context2.getLocation(argument), message);
    }

    private final String getMarkerTypeDescription(ResourceType $this$getMarkerTypeDescription) {
        ResourceType resourceType = $this$getMarkerTypeDescription;
        return resourceType == ResourceEvaluator.COLOR_INT_MARKER_TYPE ? "an RGB integer" : (resourceType == ResourceEvaluator.DIMENSION_MARKER_TYPE ? "a pixel integer" : (resourceType == ResourceEvaluator.DIMENSION_SP_MARKER_TYPE ? "a scale-independent (sp) integer" : (resourceType == ResourceEvaluator.DIMENSION_DP_MARKER_TYPE ? "density-independent (dp) integer" : (resourceType == ResourceEvaluator.ANY_RES_MARKER_TYPE ? "resource id of any type" : null))));
    }

    private final boolean typeArrayFromArrayLiteral(UElement node, JavaContext context2) {
        if (node == null) {
            return false;
        }
        UCallExpression expression = this.getMethodCall(node);
        if (expression != null) {
            List expressions;
            String name = expression.getMethodName();
            if (name != null && Intrinsics.areEqual((Object)"obtainStyledAttributes", (Object)name) && !((Collection)(expressions = expression.getValueArguments())).isEmpty()) {
                int arg = 0;
                if (expressions.size() == 1) {
                    arg = 0;
                } else if (expressions.size() == 2) {
                    PsiType type;
                    for (arg = 0; arg < expressions.size() && !((type = ((UExpression)expressions.get(arg)).getExpressionType()) instanceof PsiArrayType); ++arg) {
                    }
                    if (arg == expressions.size()) {
                        return false;
                    }
                } else if (expressions.size() == 4) {
                    arg = 1;
                } else {
                    return false;
                }
                return ConstantEvaluator.isArrayLiteral((UElement)expressions.get(arg));
            }
            return false;
        }
        if (node instanceof UReferenceExpression) {
            PsiVariable variable;
            UExpression lastAssignment;
            PsiElement resolved = ((UReferenceExpression)node).resolve();
            if (resolved instanceof PsiVariable && (lastAssignment = UastLintUtils.Companion.findLastAssignment(variable = (PsiVariable)resolved, node)) != null) {
                return this.typeArrayFromArrayLiteral((UElement)lastAssignment, context2);
            }
        } else {
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                return true;
            }
            if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                return true;
            }
            if (node instanceof UParenthesizedExpression) {
                return this.typeArrayFromArrayLiteral((UElement)((UParenthesizedExpression)node).getExpression(), context2);
            }
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                UBinaryExpressionWithType castExpression = (UBinaryExpressionWithType)node;
                UExpression operand = castExpression.getOperand();
                return this.typeArrayFromArrayLiteral((UElement)operand, context2);
            }
        }
        return false;
    }

    private final UCallExpression getMethodCall(UElement node) {
        UElement last;
        if (node instanceof UQualifiedReferenceExpression && UastExpressionUtils.isMethodCall((UElement)(last = UastLintUtilsKt.findSelector(node)))) {
            Intrinsics.checkNotNull((Object)last, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            return (UCallExpression)last;
        }
        return node != null && UastExpressionUtils.isMethodCall((UElement)node) ? (UCallExpression)node : null;
    }

    private static final boolean visitAnnotationUsage$lambda$0(ResourceTypeDetector this$0, AnnotationInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isResourceAnnotation(it.getQualifiedName());
    }

    private static final UElement getParentSequence$lambda$0(Class $clz, UElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UastUtils.getParentOfType((UElement)it, (Class)$clz, (boolean)true);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        RESOURCE_TYPE = Issue.Companion.create$default(companion, "ResourceType", "Wrong Resource Type", "\n                Ensures that resource id's passed to APIs are of the right type; for \\\n                example, calling `Resources.getColor(R.string.name)` is wrong.", implementation, null, category, 7, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        COLOR_USAGE = Issue.Companion.create$default(companion, "ResourceAsColor", "Should pass resolved color instead of resource id", "\n                Methods that take a color in the form of an integer should be passed an \\\n                RGB triple, not the actual color resource id. You must call \\\n                `getResources().getColor(resource)` to resolve the actual color value first.\n\n                Similarly, methods that take a dimension integer should be passed an \\\n                actual dimension (call `getResources().getDimension(resource)`", implementation, null, category, 7, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        HALF_FLOAT = Issue.Companion.create$default(companion, "HalfFloat", "Incorrect Half Float", "\n                Half-precision floating point are stored in a short data type, and should be \\\n                manipulated using the `android.util.Half` class. This check flags usages \\\n                where it appears that these values are used incorrectly.", implementation, null, category, 7, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/ResourceTypeDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RESOURCE_TYPE", "Lcom/android/tools/lint/detector/api/Issue;", "COLOR_USAGE", "HALF_FLOAT", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

