/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.ide.common.util.PathStringUtil;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000e\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\rH\u0002J6\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\rH\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\rH\u0002J0\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u0017H\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\u001cH\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\u0006\u0010\"\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u001cH\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\rH\u0002J.\u0010&\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cH\u0002\u00a8\u0006*"}, d2={"Lcom/android/tools/lint/checks/PurposeDeclarationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "checkMergedProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "evaluatePermissionRequest", "element", "Lorg/w3c/dom/Element;", "computeRequiresPurposeSdkRange", "Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;", "purposeTypeSdkRange", "projectMinSdk", "", "projectTargetSdk", "usesPermissionSdkRange", "validateDeclaredPurposes", "", "permissionElement", "possiblePurposes", "", "purposeTag", "requiredRange", "validatePurposeResourceString", "getValidCoverageRanges", "", "purposeElements", "validPurposesMap", "mergeRanges", "ranges", "subtractRanges", "source", "toSubtract", "formatRange", "range", "reportMissingPurposeErrors", "permissionName", "missingPurposeErrorMessages", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nPurposeDeclarationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurposeDeclarationDetector.kt\ncom/android/tools/lint/checks/PurposeDeclarationDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,537:1\n1#2:538\n1#2:549\n1617#3,9:539\n1869#3:548\n1870#3:550\n1626#3:551\n1056#3:552\n*S KotlinDebug\n*F\n+ 1 PurposeDeclarationDetector.kt\ncom/android/tools/lint/checks/PurposeDeclarationDetector\n*L\n253#1:549\n253#1:539,9\n253#1:548\n253#1:550\n253#1:551\n282#1:552\n*E\n"})
public final class PurposeDeclarationDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ATTR_MIN_SDK = "minSdkVersion";
    @NotNull
    private static final String ATTR_MAX_SDK = "maxSdkVersion";
    @NotNull
    private static final String ATTR_REQUIRES_PURPOSE_MIN = "requiresPurposeMinTargetSdkVersion";
    @NotNull
    private static final String ATTR_REQUIRES_PURPOSE_MAX = "requiresPurposeMaxSdkVersion";
    @NotNull
    private static final String ATTR_REQUIRES_PURPOSE_STRING_MIN = "requiresPurposeStringMinTargetSdkVersion";
    @NotNull
    private static final String ATTR_REQUIRES_PURPOSE_STRING_MAX = "requiresPurposeStringMaxSdkVersion";
    private static final int MIN_SDK_VERSION_DEFAULT = 1;
    private static final int ANDROID_D_SDK_VERSION = 38;
    private static final int MAX_PURPOSE_STRING_RESOURCES_TO_CHECK = 100;
    private static final int MAX_PURPOSE_STRING_TO_REPORT = 2;
    private static final int MAX_PURPOSE_STRING_LENGTH = 300;
    private static final int RECOMMENDED_PURPOSE_STRING_LENGTH = 150;
    private static final int MAX_SDK_VERSION_DEFAULT = 999999;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(PurposeDeclarationDetector.class, Scope.MANIFEST_SCOPE);
    @JvmField
    @NotNull
    public static final Issue MISSING_PURPOSE;
    @JvmField
    @NotNull
    public static final Issue INVALID_PURPOSE_STRING;
    @NotNull
    private static final ConcurrentHashMap<String, Map<String, Companion.PermissionInfo>> cache;

    @Override
    public void checkMergedProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getMainProject().getTargetSdkVersion().getFeatureLevel() < 38) {
            return;
        }
        Node node = context2.getMainProject().getMergedManifest();
        if (node == null || (node = node.getDocumentElement()) == null) {
            return;
        }
        Node root2 = node;
        Element element = XmlUtils.getFirstSubTag((Node)root2);
        while (element != null) {
            if (Intrinsics.areEqual((Object)element.getTagName(), (Object)"uses-permission") || Intrinsics.areEqual((Object)element.getTagName(), (Object)"uses-permission-sdk-23")) {
                this.evaluatePermissionRequest(context2, element);
            }
            element = XmlUtils.getNextTag((Node)element);
        }
    }

    private final void evaluatePermissionRequest(Context context2, Element element) {
        String purposeError;
        String string2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (string2 == null) {
            return;
        }
        String permissionName = string2;
        Map permissionsMap = PurposeDeclarationDetector.Companion.getPermissionsMap(context2.getMainProject());
        Companion.PermissionInfo permissionInfo = (Companion.PermissionInfo)permissionsMap.get(permissionName);
        if (permissionInfo == null) {
            return;
        }
        Companion.PermissionInfo permissionInfo2 = permissionInfo;
        int projectMinSdk = context2.getMainProject().getMinSdkVersion().getFeatureLevel();
        String string3 = element.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_MIN_SDK);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeNS(...)");
        Integer n = StringsKt.toIntOrNull((String)string3);
        int usesPermissionMinSdkVersion = n != null ? n : 1;
        int projectTargetSdk = context2.getMainProject().getTargetSdkVersion().getFeatureLevel();
        String string4 = element.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_MAX_SDK);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAttributeNS(...)");
        Integer n2 = StringsKt.toIntOrNull((String)string4);
        int usesPermissionMaxSdkVersion = n2 != null ? n2 : 999999;
        Companion.SdkRange usesPermissionSdkRange = new Companion.SdkRange(usesPermissionMinSdkVersion, usesPermissionMaxSdkVersion);
        List missingPurposeErrorMessages = new ArrayList();
        String string5 = purposeError = this.validateDeclaredPurposes(element, permissionInfo2.getValidPurposes(), "purpose", this.computeRequiresPurposeSdkRange(permissionInfo2.getRequiresPurposeSdkRange(), projectMinSdk, projectTargetSdk, usesPermissionSdkRange));
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            missingPurposeErrorMessages.add(it);
        }
        if (!context2.getMainProject().isLibrary()) {
            String purposeStringError;
            String string6 = purposeStringError = this.validatePurposeResourceString(context2, element, this.computeRequiresPurposeSdkRange(permissionInfo2.getRequiresPurposeStringSdkRange(), projectMinSdk, projectTargetSdk, usesPermissionSdkRange));
            if (string6 != null) {
                String it = string6;
                boolean bl = false;
                missingPurposeErrorMessages.add(it);
            }
        }
        this.reportMissingPurposeErrors(context2, permissionName, element, missingPurposeErrorMessages);
    }

    private final Companion.SdkRange computeRequiresPurposeSdkRange(Companion.SdkRange purposeTypeSdkRange, int projectMinSdk, int projectTargetSdk, Companion.SdkRange usesPermissionSdkRange) {
        int minPurposeStringSdk = Math.max(purposeTypeSdkRange.getMin(), Math.max(projectMinSdk, usesPermissionSdkRange.getMin()));
        int maxPurposeStringSdk = Math.min(purposeTypeSdkRange.getMax(), Math.min(projectTargetSdk, usesPermissionSdkRange.getMax()));
        return new Companion.SdkRange(minPurposeStringSdk, maxPurposeStringSdk);
    }

    private final String validateDeclaredPurposes(Element permissionElement, Map<String, Companion.SdkRange> possiblePurposes, String purposeTag, Companion.SdkRange requiredRange) {
        if (requiredRange.getMin() > requiredRange.getMax()) {
            return null;
        }
        Iterable iterable = XmlUtils.getSubTagsByName((Node)permissionElement, (String)purposeTag);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getSubTagsByName(...)");
        List purposeElements = CollectionsKt.toList((Iterable)iterable);
        if (purposeElements.isEmpty()) {
            return "missing one or more `<" + purposeTag + ">` tags required for API level(s) " + this.formatRange(requiredRange);
        }
        List<Companion.SdkRange> validCoverageRanges = this.getValidCoverageRanges(purposeElements, possiblePurposes);
        List<Companion.SdkRange> uncoveredRanges = this.subtractRanges(requiredRange, validCoverageRanges);
        if (!((Collection)uncoveredRanges).isEmpty()) {
            String formattedUncoveredRanges = CollectionsKt.joinToString$default((Iterable)uncoveredRanges, null, null, null, (int)0, null, arg_0 -> PurposeDeclarationDetector.validateDeclaredPurposes$lambda$0(this, arg_0), (int)31, null);
            return "missing one or more `<" + purposeTag + ">` tags required for API level(s) " + formattedUncoveredRanges;
        }
        return null;
    }

    private final String validatePurposeResourceString(Context context2, Element permissionElement, Companion.SdkRange requiredRange) {
        Attr purposeStringAttr;
        if (requiredRange.getMin() > requiredRange.getMax()) {
            return null;
        }
        Attr attr = purposeStringAttr = permissionElement.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "purposeString");
        CharSequence charSequence = attr != null ? attr.getValue() : null;
        if (charSequence == null || charSequence.length() == 0) {
            return "missing `purposeString` attribute";
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)purposeStringAttr.getValue());
        if (resourceUrl == null || resourceUrl.type != ResourceType.STRING) {
            Context.report$default(context2, MISSING_PURPOSE, context2.getLocation(purposeStringAttr, LocationType.VALUE), "`purposeString` must reference a string resource (e.g. `@string/my_purpose_resource`)", null, 8, null);
            return null;
        }
        ResourceRepository resources = context2.getClient().getResources(context2.getMainProject(), ResourceRepositoryScope.ALL_DEPENDENCIES);
        List list2 = resources.getResources(ResourceNamespace.TODO(), resourceUrl.type, resourceUrl.name);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getResources(...)");
        List purposeResources = CollectionsKt.take((Iterable)list2, (int)100);
        List failingResourceNames = new ArrayList();
        for (ResourceItem resource : purposeResources) {
            Object object = resource.getResourceValue();
            if (object == null || (object = object.getValue()) == null) continue;
            Object purposeString = object;
            if (StringsKt.isBlank((CharSequence)((CharSequence)purposeString)) || ((String)purposeString).length() > 300) {
                CharSequence charSequence2;
                String qualifierString = resource.getConfiguration().getQualifierString();
                List list3 = failingResourceNames;
                String string2 = resourceUrl.name;
                CharSequence charSequence3 = qualifierString;
                if (charSequence3.length() == 0) {
                    String string3 = string2;
                    List list4 = list3;
                    boolean bl = false;
                    String string4 = "Default";
                    list3 = list4;
                    string2 = string3;
                    charSequence2 = string4;
                } else {
                    charSequence2 = charSequence3;
                }
                list3.add(string2 + " (" + charSequence2 + ")");
            }
            if (failingResourceNames.size() != 2) continue;
        }
        if (!((Collection)failingResourceNames).isEmpty()) {
            Context.report$default(context2, INVALID_PURPOSE_STRING, context2.getLocation(purposeStringAttr, LocationType.VALUE), "The referenced `purposeString` must be non-blank and have no more than 300 characters. Invalid example(s) include: " + CollectionsKt.joinToString$default((Iterable)failingResourceNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), null, 8, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Companion.SdkRange> getValidCoverageRanges(List<? extends Element> purposeElements, Map<String, Companion.SdkRange> validPurposesMap) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = purposeElements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Companion.SdkRange sdkRange;
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Element purposeElement = (Element)element$iv$iv;
            boolean bl2 = false;
            String it = string2 = purposeElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            String string3 = ((CharSequence)it).length() > 0 ? string2 : null;
            if (string3 == null) {
                sdkRange = null;
            } else {
                String declaredPurposeName = string3;
                if (validPurposesMap.get(declaredPurposeName) == null) {
                    sdkRange = null;
                } else {
                    Companion.SdkRange platformRange;
                    String string4 = purposeElement.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_MIN_SDK);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAttributeNS(...)");
                    Integer n = StringsKt.toIntOrNull((String)string4);
                    int purposeMinSdk = n != null ? n : 1;
                    String string5 = purposeElement.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_MAX_SDK);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAttributeNS(...)");
                    Integer n2 = StringsKt.toIntOrNull((String)string5);
                    int purposeMaxSdk = n2 != null ? n2 : 999999;
                    int effectiveMin = Math.max(platformRange.getMin(), purposeMinSdk);
                    int effectiveMax = Math.min(platformRange.getMax(), purposeMaxSdk);
                    sdkRange = effectiveMin <= effectiveMax ? new Companion.SdkRange(effectiveMin, effectiveMax) : null;
                }
            }
            if (sdkRange == null) continue;
            Companion.SdkRange it$iv$iv = sdkRange;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List effectiveRanges = (List)destination$iv$iv;
        return this.mergeRanges(effectiveRanges);
    }

    private final List<Companion.SdkRange> mergeRanges(List<Companion.SdkRange> ranges) {
        if (ranges.size() <= 1) {
            return ranges;
        }
        Iterable $this$sortedBy$iv = ranges;
        boolean $i$f$sortedBy = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Companion.SdkRange it = (Companion.SdkRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getMin());
                it = (Companion.SdkRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getMin()));
            }
        });
        List merged = new ArrayList();
        Companion.SdkRange currentMerge = (Companion.SdkRange)CollectionsKt.first((List)sortedRanges);
        int n = sortedRanges.size();
        for (int i = 1; i < n; ++i) {
            Companion.SdkRange nextRange = (Companion.SdkRange)sortedRanges.get(i);
            if (nextRange.getMin() <= currentMerge.getMax() + 1) {
                currentMerge = new Companion.SdkRange(currentMerge.getMin(), Math.max(currentMerge.getMax(), nextRange.getMax()));
                continue;
            }
            merged.add(currentMerge);
            currentMerge = nextRange;
        }
        merged.add(currentMerge);
        return merged;
    }

    private final List<Companion.SdkRange> subtractRanges(Companion.SdkRange source, List<Companion.SdkRange> toSubtract) {
        List uncovered = new ArrayList();
        int currentSdk = source.getMin();
        for (Companion.SdkRange subtractRange : toSubtract) {
            if (currentSdk < subtractRange.getMin()) {
                uncovered.add(new Companion.SdkRange(currentSdk, Math.min(source.getMax(), subtractRange.getMin() - 1)));
            }
            if ((currentSdk = Math.max(currentSdk, subtractRange.getMax() + 1)) <= source.getMax()) continue;
        }
        if (currentSdk <= source.getMax()) {
            uncovered.add(new Companion.SdkRange(currentSdk, source.getMax()));
        }
        return uncovered;
    }

    private final String formatRange(Companion.SdkRange range) {
        return range.getMin() == range.getMax() ? String.valueOf(range.getMin()) : range.getMin() + "-" + range.getMax();
    }

    private final void reportMissingPurposeErrors(Context context2, String permissionName, Element permissionElement, List<String> missingPurposeErrorMessages) {
        if (missingPurposeErrorMessages.isEmpty()) {
            return;
        }
        String detailsString = CollectionsKt.joinToString$default((Iterable)missingPurposeErrorMessages, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
        String finalMessage = permissionName + " permission is missing required purpose attributes/elements: " + detailsString;
        Context.report$default(context2, MISSING_PURPOSE, Context.getLocation$default(context2, permissionElement, null, 2, null), finalMessage, null, 8, null);
    }

    private static final CharSequence validateDeclaredPurposes$lambda$0(PurposeDeclarationDetector this$0, Companion.SdkRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.formatRange(it);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = IMPLEMENTATION;
        MISSING_PURPOSE = Issue.Companion.create$default(companion, "MissingPurpose", "Missing purpose for permission", "\n              When requesting a permission that requires purpose declaration, appropriate tags \\\n              and/or attributes must be defined based on the required purpose types. Failure to do \\\n              so will lead to unexpected runtime issues.\n\n              Purpose: If a permission requires purpose, at least one `<purpose>` child tag must \\\n              be declared. This tag must use appropriate preset valid purpose string found in the \\\n              permission's documentation. The declared purpose(s) must cover all API levels for \\\n              which the permission requires purpose.\n\n              Purpose String: If a permission requires a purpose string, `android:purposeString` \\\n              attribute must be declared with a string resource referencing appropriate localized \\\n              string(s) including the reason for why the permission is required by the app.\n              ", implementation, null, category, 10, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.FATAL;
        implementation = IMPLEMENTATION;
        INVALID_PURPOSE_STRING = Issue.Companion.create$default(companion, "InvalidPurposeString", "Invalid purpose string for permission", "\n              If a permission requires a purpose string, a valid `android:purposeString` attribute \\\n              should be declared. This attribute must reference a localized string resource that's \\\n              no more than 300 characters (150 recommended) \\\n              for all locales the app supports as the text is displayed on user-facing surfaces.\n              ", implementation, null, category, 9, severity, false, true, null, null, 3344, null);
        cache = new ConcurrentHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\"#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion;", "", "<init>", "()V", "ATTR_MIN_SDK", "", "ATTR_MAX_SDK", "ATTR_REQUIRES_PURPOSE_MIN", "ATTR_REQUIRES_PURPOSE_MAX", "ATTR_REQUIRES_PURPOSE_STRING_MIN", "ATTR_REQUIRES_PURPOSE_STRING_MAX", "MIN_SDK_VERSION_DEFAULT", "", "ANDROID_D_SDK_VERSION", "MAX_PURPOSE_STRING_RESOURCES_TO_CHECK", "MAX_PURPOSE_STRING_TO_REPORT", "MAX_PURPOSE_STRING_LENGTH", "RECOMMENDED_PURPOSE_STRING_LENGTH", "MAX_SDK_VERSION_DEFAULT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MISSING_PURPOSE", "Lcom/android/tools/lint/detector/api/Issue;", "INVALID_PURPOSE_STRING", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$PermissionInfo;", "clearPermissionsMap", "", "getPermissionsMap", "project", "Lcom/android/tools/lint/detector/api/Project;", "computePermissionsMap", "SdkRange", "PermissionInfo", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nPurposeDeclarationDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurposeDeclarationDetector.kt\ncom/android/tools/lint/checks/PurposeDeclarationDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,537:1\n1#2:538\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final void clearPermissionsMap() {
            cache.clear();
        }

        private final Map<String, PermissionInfo> getPermissionsMap(Project project) {
            Object object = project.getBuildTarget();
            if (object == null || (object = object.hashString()) == null) {
                return this.computePermissionsMap(project);
            }
            Object targetHash = object;
            Map map2 = cache.computeIfAbsent(targetHash, arg_0 -> Companion.getPermissionsMap$lambda$1(arg_0 -> Companion.getPermissionsMap$lambda$0(project, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
            return map2;
        }

        private final Map<String, PermissionInfo> computePermissionsMap(Project project) {
            File dataFile;
            Path path;
            IAndroidTarget iAndroidTarget = project.getBuildTarget();
            if (iAndroidTarget != null && (path = iAndroidTarget.getPath(29)) != null) {
                Comparable<Path> it = path;
                boolean bl = false;
                File file = new File(it.toString());
                it = file;
                boolean bl2 = false;
                v0 = ((File)it).exists() ? file : null;
            } else {
                v0 = dataFile = null;
            }
            if (dataFile == null) {
                return MapsKt.emptyMap();
            }
            Map mapBuilder = new LinkedHashMap();
            try {
                LintClient client = project.getClient();
                PathString path2 = PathStringUtil.toPathString(dataFile);
                XmlPullParser xmlPullParser = client.createXmlPullParser(path2);
                if (xmlPullParser == null) {
                    return MapsKt.emptyMap();
                }
                XmlPullParser parser2 = xmlPullParser;
                while (parser2.next() != 1) {
                    int event;
                    int requiresPurposeStringMaxSdk;
                    String permissionName;
                    String string2;
                    if (parser2.getEventType() != 2 || !Intrinsics.areEqual((Object)parser2.getName(), (Object)"permission")) continue;
                    String it = string2 = parser2.getAttributeValue(null, "name");
                    boolean bl = false;
                    CharSequence charSequence = it;
                    if ((!(charSequence == null || charSequence.length() == 0) ? string2 : null) == null) continue;
                    permissionName = permissionName;
                    Object object = parser2.getAttributeValue(null, PurposeDeclarationDetector.ATTR_REQUIRES_PURPOSE_MIN);
                    int requiresPurposeMinSdk = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 999999;
                    Object object2 = parser2.getAttributeValue(null, PurposeDeclarationDetector.ATTR_REQUIRES_PURPOSE_MAX);
                    int requiresPurposeMaxSdk = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 999999;
                    Object object3 = parser2.getAttributeValue(null, PurposeDeclarationDetector.ATTR_REQUIRES_PURPOSE_STRING_MIN);
                    int requiresPurposeStringMinSdk = object3 != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 999999;
                    Object object4 = parser2.getAttributeValue(null, PurposeDeclarationDetector.ATTR_REQUIRES_PURPOSE_STRING_MAX);
                    int n = object4 != null && (object4 = StringsKt.toIntOrNull((String)object4)) != null ? (Integer)object4 : (requiresPurposeStringMaxSdk = 999999);
                    if (requiresPurposeMinSdk == 999999 && requiresPurposeStringMinSdk == 999999) continue;
                    Map purposeMap = new LinkedHashMap();
                    int depth = parser2.getDepth();
                    while ((event = parser2.next()) != 1 && (event != 3 || parser2.getDepth() != depth)) {
                        String purposeName;
                        String string3;
                        if (event != 2 || !Intrinsics.areEqual((Object)parser2.getName(), (Object)"valid-purpose")) continue;
                        String it2 = string3 = parser2.getAttributeValue(null, "name");
                        boolean bl3 = false;
                        CharSequence charSequence2 = it2;
                        if ((!(charSequence2 == null || charSequence2.length() == 0) ? string3 : null) == null) continue;
                        purposeName = purposeName;
                        Object object5 = parser2.getAttributeValue(null, PurposeDeclarationDetector.ATTR_MIN_SDK);
                        if (object5 == null || (object5 = StringsKt.toIntOrNull((String)object5)) == null) {
                            continue;
                        }
                        int purposeMinSdk = (Integer)object5;
                        Object object6 = parser2.getAttributeValue(null, PurposeDeclarationDetector.ATTR_MAX_SDK);
                        int purposeMaxSdk = object6 != null && (object6 = StringsKt.toIntOrNull((String)object6)) != null ? (Integer)object6 : 999999;
                        purposeMap.put(purposeName, new SdkRange(purposeMinSdk, purposeMaxSdk));
                    }
                    if (!(!purposeMap.isEmpty())) {
                        if (requiresPurposeStringMinSdk == 999999) continue;
                    }
                    mapBuilder.put(permissionName, new PermissionInfo(new SdkRange(requiresPurposeMinSdk, requiresPurposeMaxSdk), new SdkRange(requiresPurposeStringMinSdk, requiresPurposeStringMaxSdk), MapsKt.toMap((Map)purposeMap)));
                }
            }
            catch (Exception exception) {
                return MapsKt.emptyMap();
            }
            return MapsKt.toMap((Map)mapBuilder);
        }

        private static final Map getPermissionsMap$lambda$0(Project $project, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.computePermissionsMap($project);
        }

        private static final Map getPermissionsMap$lambda$1(Function1 $tmp0, Object p0) {
            return (Map)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$PermissionInfo;", "", "requiresPurposeSdkRange", "Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;", "requiresPurposeStringSdkRange", "validPurposes", "", "", "<init>", "(Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;Ljava/util/Map;)V", "getRequiresPurposeSdkRange", "()Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;", "getRequiresPurposeStringSdkRange", "getValidPurposes", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.lint-checks"})
        private static final class PermissionInfo {
            @NotNull
            private final SdkRange requiresPurposeSdkRange;
            @NotNull
            private final SdkRange requiresPurposeStringSdkRange;
            @NotNull
            private final Map<String, SdkRange> validPurposes;

            public PermissionInfo(@NotNull SdkRange requiresPurposeSdkRange, @NotNull SdkRange requiresPurposeStringSdkRange, @NotNull Map<String, SdkRange> validPurposes) {
                Intrinsics.checkNotNullParameter((Object)requiresPurposeSdkRange, (String)"requiresPurposeSdkRange");
                Intrinsics.checkNotNullParameter((Object)requiresPurposeStringSdkRange, (String)"requiresPurposeStringSdkRange");
                Intrinsics.checkNotNullParameter(validPurposes, (String)"validPurposes");
                this.requiresPurposeSdkRange = requiresPurposeSdkRange;
                this.requiresPurposeStringSdkRange = requiresPurposeStringSdkRange;
                this.validPurposes = validPurposes;
            }

            @NotNull
            public final SdkRange getRequiresPurposeSdkRange() {
                return this.requiresPurposeSdkRange;
            }

            @NotNull
            public final SdkRange getRequiresPurposeStringSdkRange() {
                return this.requiresPurposeStringSdkRange;
            }

            @NotNull
            public final Map<String, SdkRange> getValidPurposes() {
                return this.validPurposes;
            }

            @NotNull
            public final SdkRange component1() {
                return this.requiresPurposeSdkRange;
            }

            @NotNull
            public final SdkRange component2() {
                return this.requiresPurposeStringSdkRange;
            }

            @NotNull
            public final Map<String, SdkRange> component3() {
                return this.validPurposes;
            }

            @NotNull
            public final PermissionInfo copy(@NotNull SdkRange requiresPurposeSdkRange, @NotNull SdkRange requiresPurposeStringSdkRange, @NotNull Map<String, SdkRange> validPurposes) {
                Intrinsics.checkNotNullParameter((Object)requiresPurposeSdkRange, (String)"requiresPurposeSdkRange");
                Intrinsics.checkNotNullParameter((Object)requiresPurposeStringSdkRange, (String)"requiresPurposeStringSdkRange");
                Intrinsics.checkNotNullParameter(validPurposes, (String)"validPurposes");
                return new PermissionInfo(requiresPurposeSdkRange, requiresPurposeStringSdkRange, validPurposes);
            }

            public static /* synthetic */ PermissionInfo copy$default(PermissionInfo permissionInfo, SdkRange sdkRange, SdkRange sdkRange2, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    sdkRange = permissionInfo.requiresPurposeSdkRange;
                }
                if ((n & 2) != 0) {
                    sdkRange2 = permissionInfo.requiresPurposeStringSdkRange;
                }
                if ((n & 4) != 0) {
                    map2 = permissionInfo.validPurposes;
                }
                return permissionInfo.copy(sdkRange, sdkRange2, map2);
            }

            @NotNull
            public String toString() {
                return "PermissionInfo(requiresPurposeSdkRange=" + this.requiresPurposeSdkRange + ", requiresPurposeStringSdkRange=" + this.requiresPurposeStringSdkRange + ", validPurposes=" + this.validPurposes + ")";
            }

            public int hashCode() {
                int result2 = this.requiresPurposeSdkRange.hashCode();
                result2 = result2 * 31 + this.requiresPurposeStringSdkRange.hashCode();
                result2 = result2 * 31 + ((Object)this.validPurposes).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PermissionInfo)) {
                    return false;
                }
                PermissionInfo permissionInfo = (PermissionInfo)other;
                if (!Intrinsics.areEqual((Object)this.requiresPurposeSdkRange, (Object)permissionInfo.requiresPurposeSdkRange)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.requiresPurposeStringSdkRange, (Object)permissionInfo.requiresPurposeStringSdkRange)) {
                    return false;
                }
                return Intrinsics.areEqual(this.validPurposes, permissionInfo.validPurposes);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/PurposeDeclarationDetector$Companion$SdkRange;", "", "min", "", "max", "<init>", "(II)V", "getMin", "()I", "getMax", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "android.sdktools.lint-checks"})
        private static final class SdkRange {
            private final int min;
            private final int max;

            public SdkRange(int min, int max) {
                this.min = min;
                this.max = max;
            }

            public final int getMin() {
                return this.min;
            }

            public final int getMax() {
                return this.max;
            }

            public final int component1() {
                return this.min;
            }

            public final int component2() {
                return this.max;
            }

            @NotNull
            public final SdkRange copy(int min, int max) {
                return new SdkRange(min, max);
            }

            public static /* synthetic */ SdkRange copy$default(SdkRange sdkRange, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = sdkRange.min;
                }
                if ((n3 & 2) != 0) {
                    n2 = sdkRange.max;
                }
                return sdkRange.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "SdkRange(min=" + this.min + ", max=" + this.max + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.min);
                result2 = result2 * 31 + Integer.hashCode(this.max);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SdkRange)) {
                    return false;
                }
                SdkRange sdkRange = (SdkRange)other;
                if (this.min != sdkRange.min) {
                    return false;
                }
                return this.max == sdkRange.max;
            }
        }
    }
}

