/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.ApiClassOwner;
import com.android.tools.lint.checks.PrivateApiClass;
import com.android.tools.lint.checks.PrivateApiParserKt;
import com.android.tools.lint.checks.Restriction;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0006H\u0002R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR9\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/PrivateApiParser;", "", "<init>", "()V", "classes", "Ljava/util/HashMap;", "", "Lcom/android/tools/lint/checks/PrivateApiClass;", "Lkotlin/collections/HashMap;", "getClasses", "()Ljava/util/HashMap;", "containers", "Lcom/android/tools/lint/checks/ApiClassOwner;", "getContainers", "parse", "", "stream", "Ljava/io/InputStream;", "addClass", "name", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nPrivateApiParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivateApiParser.kt\ncom/android/tools/lint/checks/PrivateApiParser\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,89:1\n382#2,7:90\n*S KotlinDebug\n*F\n+ 1 PrivateApiParser.kt\ncom/android/tools/lint/checks/PrivateApiParser\n*L\n38#1:90,7\n*E\n"})
public final class PrivateApiParser {
    @NotNull
    private final HashMap<String, PrivateApiClass> classes = new HashMap(24000);
    @NotNull
    private final HashMap<String, ApiClassOwner<PrivateApiClass>> containers = new HashMap(7000);

    @NotNull
    public final HashMap<String, PrivateApiClass> getClasses() {
        return this.classes;
    }

    @NotNull
    public final HashMap<String, ApiClassOwner<PrivateApiClass>> getContainers() {
        return this.containers;
    }

    public final void parse(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Reader reader = new InputStreamReader(stream, Charsets.UTF_8);
        int n = 8192;
        TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), arg_0 -> PrivateApiParser.parse$lambda$0(this, arg_0));
    }

    private final PrivateApiClass addClass(String name) {
        boolean bl;
        PrivateApiClass cls = this.classes.get(name);
        boolean bl2 = bl = cls == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        cls = new PrivateApiClass(name);
        String string3 = cls.getContainerName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getContainerName(...)");
        String containerName = string3;
        int len = containerName.length();
        boolean isClass = len < name.length() && name.charAt(len) == '$';
        ApiClassOwner<PrivateApiClass> container = this.containers.get(containerName);
        if (container == null) {
            container = new ApiClassOwner(containerName, isClass);
            ((Map)this.containers).put(containerName, container);
        } else if (container.isClass() != isClass) {
            throw new RuntimeException("\"" + containerName + "\" is both a package and a class");
        }
        container.addClass((PrivateApiClass)((ApiClassBase)cls));
        return cls;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parse$lambda$0(PrivateApiParser this$0, String line) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String[] stringArray = new String[]{",", "->"};
        List items = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (items.size() < 3) {
            return Unit.INSTANCE;
        }
        String className = PrivateApiParserKt.access$fromSignature((String)items.get(0));
        if (StringsKt.contains$default((CharSequence)className, (CharSequence)"$$Lambda", (boolean)false, (int)2, null)) {
            return Unit.INSTANCE;
        }
        Restriction restriction = PrivateApiParserKt.access$parse((String)items.get(2));
        if (restriction == Restriction.ALLOW || restriction == Restriction.UNKNOWN) {
            return Unit.INSTANCE;
        }
        Map map2 = this$0.classes;
        String key$iv = className;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PrivateApiClass answer$iv = this$0.addClass(className);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        PrivateApiClass clazz = (PrivateApiClass)object;
        String member = (String)items.get(1);
        if (StringsKt.contains$default((CharSequence)member, (CharSequence)":", (boolean)false, (int)2, null)) {
            String[] stringArray2 = new String[]{":"};
            List parts = StringsKt.split$default((CharSequence)member, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            clazz.addField$android_sdktools_lint_checks((String)parts.get(0), restriction);
        } else if (StringsKt.contains$default((CharSequence)member, (CharSequence)"(", (boolean)false, (int)2, null)) {
            String string2 = member.substring(0, StringsKt.indexOf$default((CharSequence)member, (char)')', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            clazz.addMethod$android_sdktools_lint_checks(string2, restriction);
        } else {
            System.out.println("Unrecognized entry: " + line);
        }
        return Unit.INSTANCE;
    }
}

