/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/LayoutInflationDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "layoutsWithRootLayoutParams", "", "", "pendingErrors", "", "Lcom/android/utils/Pair;", "Lcom/android/tools/lint/detector/api/Location;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "visitDocument", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "getApplicableMethodNames", "", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "hasLayoutParams", "", "name", "Companion", "android.sdktools.lint-checks"})
public final class LayoutInflationDetector
extends LayoutDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<String> layoutsWithRootLayoutParams;
    @Nullable
    private List<Pair<String, Location>> pendingErrors;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String ERROR_MESSAGE = "Avoid passing `null` as the view root (needed to resolve layout parameters on the inflated layout's root element)";

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List<Pair<String, Location>> list2 = this.pendingErrors;
        if (list2 == null) {
            return;
        }
        List<Pair<String, Location>> pendingErrors = list2;
        for (Pair<String, Location> pair2 : pendingErrors) {
            Location location;
            String inflatedLayout = (String)pair2.getFirst();
            if (this.layoutsWithRootLayoutParams == null) continue;
            Set<String> set2 = this.layoutsWithRootLayoutParams;
            Intrinsics.checkNotNull(set2);
            if (!CollectionsKt.contains((Iterable)set2, (Object)inflatedLayout) || (Location)pair2.getSecond() == null) continue;
            Context.report$default(context2, ISSUE, location, ERROR_MESSAGE, null, 8, null);
        }
    }

    @Override
    public void visitDocument(@NotNull XmlContext context2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element root2 = document.getDocumentElement();
        if (root2 != null) {
            NamedNodeMap attributes = root2.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = attributes.item(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr");
                Attr attribute = (Attr)node;
                if (attribute.getLocalName() == null) continue;
                String string2 = attribute.getLocalName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalName(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)"layout_", (boolean)false, (int)2, null)) continue;
                Set set2 = this.layoutsWithRootLayoutParams;
                if (set2 == null) {
                    LayoutInflationDetector $this$visitDocument_u24lambda_u240 = this;
                    boolean bl = false;
                    HashSet hashSet = new HashSet(20);
                    $this$visitDocument_u24lambda_u240.layoutsWithRootLayoutParams = hashSet;
                    set2 = hashSet;
                }
                Set layouts = set2;
                String string3 = context2.file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                layouts.add((String)Lint.getBaseName(string3));
                break;
            }
        }
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"inflate");
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (node.getReceiver() == null) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() < 2) {
            return;
        }
        UExpression second = (UExpression)arguments.get(1);
        if (!UastLiteralUtils.isNullLiteral((UElement)((UElement)second))) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        ResourceReference resourceReference = ResourceReference.Companion.get((UElement)first);
        if (resourceReference == null) {
            return;
        }
        ResourceReference reference = resourceReference;
        if (LayoutInflationDetector.Companion.isUsedWithAlertDialog(context2, node)) {
            return;
        }
        String layoutName = reference.getName();
        if (context2.getScope().contains((Object)Scope.RESOURCE_FILE)) {
            if (!context2.getDriver().isSuppressed(context2, ISSUE, (UElement)node)) {
                List list2 = this.pendingErrors;
                if (list2 == null) {
                    LayoutInflationDetector $this$visitMethodCall_u24lambda_u240 = this;
                    boolean bl = false;
                    ArrayList arrayList = new ArrayList();
                    $this$visitMethodCall_u24lambda_u240.pendingErrors = arrayList;
                    list2 = arrayList;
                }
                List pending = list2;
                Location location = context2.getLocation((UElement)second);
                Pair pair2 = Pair.of((Object)layoutName, (Object)location);
                Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"of(...)");
                pending.add((Pair<String, Location>)pair2);
            }
        } else if (this.hasLayoutParams(context2, layoutName)) {
            JavaContext.report$default(context2, ISSUE, (UElement)node, context2.getLocation((UElement)second), ERROR_MESSAGE, null, 16, null);
        }
    }

    private final boolean hasLayoutParams(JavaContext context2, String name) {
        ResourceRepositoryScope scope;
        Project project;
        LintClient client = context2.getClient();
        ResourceRepository resources = client.getResources(project = context2.getProject(), scope = context2.isGlobalAnalysis() ? ResourceRepositoryScope.LOCAL_DEPENDENCIES : ResourceRepositoryScope.PROJECT_ONLY);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, name);
        if (items.isEmpty()) {
            return true;
        }
        for (ResourceItem item : items) {
            if (item.getSource() == null) {
                return true;
            }
            try {
                PathString source;
                XmlPullParser parser2 = client.createXmlPullParser(source);
                if (parser2 == null || !Companion.hasLayoutParams(parser2)) continue;
                return true;
            }
            catch (XmlPullParserException e) {
                context2.log(e, "Could not read/parse inflated layout", new Object[0]);
                return true;
            }
            catch (IOException e) {
                context2.log(e, "Could not read/parse inflated layout", new Object[0]);
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean hasLayoutParams(@NotNull XmlPullParser parser2) throws XmlPullParserException, IOException {
        return Companion.hasLayoutParams(parser2);
    }

    static {
        Object object = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)LayoutInflationDetector.class, Scope.JAVA_AND_RESOURCE_FILES, (EnumSet<Scope>)object);
        object = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)object, "InflateParams", "Layout Inflation without a Parent", "\n                    When inflating a layout, avoid passing in null as the parent view, since \\\n                    otherwise any layout parameters on the root of the inflated layout will be \\\n                    ignored.", implementation, "https://www.bignerdranch.com/blog/understanding-androids-layoutinflater-inflate/", category, 5, severity, false, null, null, null, 3840, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/LayoutInflationDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "ERROR_MESSAGE", "", "isUsedWithAlertDialog", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "isAlertBuilder", "s", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "cls", "Lcom/intellij/psi/PsiClass;", "hasLayoutParams", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUsedWithAlertDialog(JavaContext context2, UCallExpression call2) {
            UElement uElement = UastUtils.getParentOfType$default((UElement)((UElement)call2), UVariable.class, (boolean)false, (int)2, null);
            if (uElement == null) {
                return false;
            }
            UElement variable = uElement;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)variable, UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return false;
            }
            UMethod method = uMethod;
            PsiElement sourcePsi = variable.getSourcePsi();
            PsiElement javaPsi = variable.getJavaPsi();
            Ref isAlertBuilderUsage = new Ref((Object)false);
            method.accept((UastVisitor)new AbstractUastVisitor(sourcePsi, javaPsi, (Ref<Boolean>)isAlertBuilderUsage, context2){
                final /* synthetic */ PsiElement $sourcePsi;
                final /* synthetic */ PsiElement $javaPsi;
                final /* synthetic */ Ref<Boolean> $isAlertBuilderUsage;
                final /* synthetic */ JavaContext $context;
                {
                    this.$sourcePsi = $sourcePsi;
                    this.$javaPsi = $javaPsi;
                    this.$isAlertBuilderUsage = $isAlertBuilderUsage;
                    this.$context = $context;
                }

                public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.checkUsage(node);
                    return super.visitSimpleNameReferenceExpression(node);
                }

                private final void checkUsage(USimpleNameReferenceExpression node) {
                    PsiElement psiElement = node.resolve();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement resolved = psiElement;
                    if (!Intrinsics.areEqual((Object)resolved, (Object)this.$sourcePsi) && !Intrinsics.areEqual((Object)resolved, (Object)this.$javaPsi)) {
                        return;
                    }
                    UElement uElement = node.getUastParent();
                    UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
                    if (uCallExpression == null) {
                        return;
                    }
                    UCallExpression setViewCall = uCallExpression;
                    if (!Intrinsics.areEqual((Object)"setView", (Object)setViewCall.getMethodName())) {
                        return;
                    }
                    UExpression uExpression = setViewCall.getReceiver();
                    if (uExpression == null) {
                        return;
                    }
                    UExpression receiver = uExpression;
                    PsiType psiType = receiver.getExpressionType();
                    if (psiType == null) {
                        return;
                    }
                    PsiType psiType2 = psiType;
                    String string2 = psiType2.getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
                    if (com.android.tools.lint.checks.LayoutInflationDetector$Companion.access$isAlertBuilder(LayoutInflationDetector.Companion, string2)) {
                        this.$isAlertBuilderUsage.set((Object)true);
                    } else {
                        JavaEvaluator evaluator = this.$context.getEvaluator();
                        PsiClass psiClass = evaluator.getTypeClass(psiType2);
                        if (psiClass == null) {
                            return;
                        }
                        PsiClass typeClass = psiClass;
                        PsiMethod[] psiMethodArray = typeClass.getMethods();
                        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
                        for (PsiMethod m : psiMethodArray) {
                            PsiClass returnClass;
                            PsiType returnType;
                            if (m.getReturnType() == null || returnType instanceof PsiPrimitiveType || evaluator.getTypeClass(returnType) == null || returnClass == typeClass || !com.android.tools.lint.checks.LayoutInflationDetector$Companion.access$isAlertBuilder(LayoutInflationDetector.Companion, evaluator, returnClass)) continue;
                            this.$isAlertBuilderUsage.set((Object)true);
                            break;
                        }
                    }
                }
            });
            Object object = isAlertBuilderUsage.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (Boolean)object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAlertBuilder(String s) {
            String string2 = s;
            switch (string2.hashCode()) {
                case -1763359899: {
                    if (string2.equals("android.app.AlertDialog.Builder")) return true;
                    break;
                }
                case 768695572: {
                    if (string2.equals("androidx.appcompat.app.AlertDialog.Builder")) return true;
                    break;
                }
                case 1413679300: {
                    if (string2.equals("com.google.android.material.dialog.MaterialAlertDialogBuilder")) return true;
                    break;
                }
                case -1145139499: {
                    if (!string2.equals("android.support.v7.app.AlertDialog.Builder")) break;
                    return true;
                }
            }
            boolean bl = StringsKt.contains$default((CharSequence)s, (CharSequence)"AlertDialog", (boolean)false, (int)2, null);
            return bl;
        }

        private final boolean isAlertBuilder(JavaEvaluator evaluator, PsiClass cls) {
            return !evaluator.inheritsFrom(cls, "android.app.Dialog", true) ? false : evaluator.inheritsFrom(cls, "android.app.AlertDialog", false) || evaluator.inheritsFrom(cls, "android.support.v7.app.AlertDialog", false) || evaluator.inheritsFrom(cls, "androidx.appcompat.app.AlertDialog", false);
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean hasLayoutParams(@NotNull XmlPullParser parser2) throws XmlPullParserException, IOException {
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            while (true) {
                int event = parser2.next();
                switch (event) {
                    case 2: {
                        int n = parser2.getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            String prefix;
                            String string2 = parser2.getAttributeName(i);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeName(...)");
                            if (!StringsKt.startsWith$default((String)string2, (String)"layout_", (boolean)false, (int)2, null) || (prefix = parser2.getAttributePrefix(i)) == null || !(((CharSequence)prefix).length() > 0) || !Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)parser2.getNamespace(prefix))) continue;
                            return true;
                        }
                        return false;
                    }
                    case 1: 
                    case 3: {
                        return false;
                    }
                }
            }
        }

        public static final /* synthetic */ boolean access$isAlertBuilder(Companion $this, String s) {
            return $this.isAlertBuilder(s);
        }

        public static final /* synthetic */ boolean access$isAlertBuilder(Companion $this, JavaEvaluator evaluator, PsiClass cls) {
            return $this.isAlertBuilder(evaluator, cls);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

