/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastVisibility;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\u0018\u00010\u0006H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/JavaScriptInterfaceDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Companion", "android.sdktools.lint-checks"})
public final class JavaScriptInterfaceDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";
    @NotNull
    private static final String JAVASCRIPT_INTERFACE_CLS = "android.webkit.JavascriptInterface";
    @NotNull
    private static final String WEB_VIEW_CLS = "android.webkit.WebView";

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)ADD_JAVASCRIPT_INTERFACE);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List arguments = node.getValueArguments();
        if (arguments.size() != 2) {
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, WEB_VIEW_CLS)) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        PsiType evaluated = TypeEvaluator.evaluate((UElement)first);
        if (evaluated instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)evaluated).resolve();
            if (psiClass == null) {
                return;
            }
            PsiClass cls = psiClass;
            if (JavaScriptInterfaceDetector.Companion.isJavaScriptAnnotated(cls)) {
                return;
            }
            Location location = context2.getNameLocation((UElement)node);
            String message = "None of the methods in the added interface (" + cls.getName() + ") have been annotated with `@android.webkit.JavascriptInterface`; they will not be visible in API 17";
            Incident incident = new Incident(ISSUE, node, location, message);
            context2.report(incident, Constraints.targetSdkAtLeast(17));
        }
    }

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UDeclaration.class);
    }

    @Override
    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new UElementHandler(context2){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitDeclaration(UDeclaration node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getVisibility() == UastVisibility.PUBLIC) {
                    return;
                }
                for (UAnnotation annotation : node.getUAnnotations()) {
                    if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)"android.webkit.JavascriptInterface")) continue;
                    Incident incident = new Incident(JavaScriptInterfaceDetector.ISSUE, (UElement)node, this.$context.getNameLocation(node), "Must be public when using `@JavascriptInterface`");
                    this.$context.report(incident, Constraints.isAndroidProject());
                }
            }
        };
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(JavaScriptInterfaceDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "JavascriptInterface", "Missing @JavascriptInterface on methods", "\n                As of API 17, you must annotate methods in objects registered with the \\\n                `addJavascriptInterface` method with a `@JavascriptInterface` annotation.\n                ", implementation, "https://developer.android.com/reference/android/webkit/WebView.html#addJavascriptInterface(java.lang.Object, java.lang.String)", category, 8, severity, false, true, null, null, 3328, null).addMoreInfo("https://goo.gle/JavascriptInterface");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/JavaScriptInterfaceDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "ADD_JAVASCRIPT_INTERFACE", "", "JAVASCRIPT_INTERFACE_CLS", "WEB_VIEW_CLS", "isJavaScriptAnnotated", "", "clz", "Lcom/intellij/psi/PsiClass;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isJavaScriptAnnotated(PsiClass clz) {
            for (PsiClass current = clz; current != null; current = current.getSuperClass()) {
                PsiMethod[] psiMethodArray;
                PsiModifierList modifierList;
                PsiModifierList psiModifierList = modifierList = current.getModifierList();
                if ((psiModifierList != null ? psiModifierList.findAnnotation(JavaScriptInterfaceDetector.JAVASCRIPT_INTERFACE_CLS) : null) != null) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)current.getMethods(), (String)"getMethods(...)");
                for (PsiMethod method : psiMethodArray) {
                    if (method.getModifierList().findAnnotation(JavaScriptInterfaceDetector.JAVASCRIPT_INTERFACE_CLS) == null) continue;
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

