/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/IntentWillNullActionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableConstructorTypes", "", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "checkPartialResults", "Lcom/android/tools/lint/detector/api/Context;", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "buildQuickFix", "Lcom/android/tools/lint/detector/api/LintFix;", "location", "Lcom/android/tools/lint/detector/api/Location;", "afterCheckRootProject", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nIntentWillNullActionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntentWillNullActionDetector.kt\ncom/android/tools/lint/checks/IntentWillNullActionDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,213:1\n12637#2,2:214\n*S KotlinDebug\n*F\n+ 1 IntentWillNullActionDetector.kt\ncom/android/tools/lint/checks/IntentWillNullActionDetector\n*L\n85#1:214,2\n*E\n"})
public final class IntentWillNullActionDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)"android.content.Intent");
    }

    @Override
    public void visitConstructor(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Object element$iv2;
        Object[] $this$any$iv;
        block9: {
            block8: {
                boolean bl;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
                    PsiParameter[] psiParameterArray = constructor.getParameterList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                    PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])psiParameterArray);
                    if (Intrinsics.areEqual((Object)(psiParameter != null && (psiParameter = psiParameter.getType()) != null ? psiParameter.getCanonicalText() : null), (Object)"java.lang.String")) break block8;
                    PsiParameter[] psiParameterArray2 = constructor.getParameterList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray2, (String)"getParameters(...)");
                    $this$any$iv = psiParameterArray2;
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        PsiParameter it = (PsiParameter)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getCanonicalText(), (Object)"java.lang.Class<?>")) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
                if (!bl) break block9;
            }
            return;
        }
        $this$any$iv = new String[]{"android.content.Intent"};
        if (context2.getEvaluator().parametersMatch(constructor, (String[])$this$any$iv)) {
            return;
        }
        Ref.BooleanRef isIntentComponentExplicitOrActionIsSet = new Ref.BooleanRef();
        Ref.BooleanRef isIntentUsedToLaunchComponent = new Ref.BooleanRef();
        Ref.BooleanRef escaped = new Ref.BooleanRef();
        element$iv2 = SetsKt.setOf((Object)node);
        DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(isIntentComponentExplicitOrActionIsSet, isIntentUsedToLaunchComponent, escaped, (Set<? extends UCallExpression>)element$iv2){
            final /* synthetic */ Ref.BooleanRef $isIntentComponentExplicitOrActionIsSet;
            final /* synthetic */ Ref.BooleanRef $isIntentUsedToLaunchComponent;
            final /* synthetic */ Ref.BooleanRef $escaped;
            {
                this.$isIntentComponentExplicitOrActionIsSet = $isIntentComponentExplicitOrActionIsSet;
                this.$isIntentUsedToLaunchComponent = $isIntentUsedToLaunchComponent;
                this.$escaped = $escaped;
                super($super_call_param$1, null, 2, null);
            }

            /*
             * Unable to fully structure code
             */
            public void receiver(UCallExpression call) {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    var2_2 = call.getMethodName();
                    if (var2_2 == null) break block9;
                    switch (var2_2.hashCode()) {
                        case 58447160: {
                            if (!var2_2.equals("setAction")) {
                                break;
                            }
                            ** GOTO lbl19
                        }
                        case 1389455926: {
                            if (!var2_2.equals("setClass")) {
                                break;
                            }
                            ** GOTO lbl19
                        }
                        case 139480763: {
                            if (!var2_2.equals("setComponent")) {
                                break;
                            }
                            ** GOTO lbl19
                        }
                        case 1529499105: {
                            if (!var2_2.equals("setClassName")) break;
lbl19:
                            // 4 sources

                            this.$isIntentComponentExplicitOrActionIsSet.element = true;
                        }
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            public void argument(UCallExpression call, UElement reference) {
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                        var3_3 = call.getMethodName();
                        if (var3_3 == null) break block7;
                        switch (var3_3.hashCode()) {
                            case -1411698151: {
                                if (!var3_3.equals("sendBroadcast")) {
                                    break;
                                }
                                ** GOTO lbl16
                            }
                            case -1290704234: {
                                if (!var3_3.equals("sendBroadcastAsUser")) {
                                    break;
                                }
                                ** GOTO lbl16
                            }
                            case -1528850031: {
                                if (!var3_3.equals("startActivity")) break;
lbl16:
                                // 3 sources

                                this.$isIntentUsedToLaunchComponent.element = true;
                                break block8;
                            }
                        }
                    }
                    this.$escaped.element = true;
                }
            }
        };
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod parent = uMethod;
        parent.accept((UastVisitor)visitor2);
        if (!isIntentUsedToLaunchComponent.element || isIntentComponentExplicitOrActionIsSet.element || escaped.element) {
            return;
        }
        LintMap lintMap = context2.getPartialResults(ISSUE).map();
        Location location = context2.getLocation((UElement)node);
        lintMap.put(String.valueOf(lintMap.getSize()), location);
    }

    @Override
    public void checkPartialResults(@NotNull Context context2, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
        for (LintMap intents : partialResults.maps()) {
            for (String intentId : intents) {
                Location location = intents.getLocation(intentId);
                String message = "This intent has no action set and is not explicit by component. You should either make this intent explicit by component or set an action matching the targeted intent filter.";
                Location location2 = location;
                Intrinsics.checkNotNull((Object)location2);
                context2.report(new Incident(ISSUE, location2, message, this.buildQuickFix(location)));
            }
        }
    }

    private final LintFix buildQuickFix(Location location) {
        LintFix setAction = LintFix.Companion.create().name("Set action...").replace().reformat(true).range(location).end().with(".setAction(\"your.custom.action\")").select("your.custom.action").build();
        LintFix setClass = LintFix.Companion.create().name("Set class...").replace().reformat(true).range(location).end().with(".setClassName(\"app.package.name\", \"your.classname\")").select("app.package.name").build();
        LintFix[] lintFixArray = new LintFix[]{setAction, setClass};
        return this.fix().alternatives(lintFixArray);
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.isGlobalAnalysis()) {
            this.checkPartialResults(context2, context2.getPartialResults(ISSUE));
        }
    }

    static {
        Object object = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)IntentWillNullActionDetector.class, (EnumSet<Scope>)EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), (EnumSet<Scope>)object);
        object = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)object, "IntentWithNullActionLaunch", "Unsafe intent launched with no action set", "\n                    Intents that have no action and do not specify a component are a potential security risk, \\\n                    and using them will result in a crash in an upcoming version of Android. \\\n                    If a specific app is being targeted (including the case where the current app is the target) \\\n                    then set the targeted component using `setComponent()`, `setClass()`, `setClassName()`, \\\n                    or the Intent constructors that take a Class parameter. \\\n                    If the intent is not intended for a specific app then the action name should be set.\n                    ", implementation, null, category, 9, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/IntentWillNullActionDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

