/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class FirebaseAnalyticsDetector
extends Detector
implements SourceCodeScanner {
    private static final int EVENT_NAME_MAX_LENGTH = 40;
    private static final int EVENT_PARAM_NAME_MAX_LENGTH = 40;
    private static final Implementation IMPLEMENTATION = new Implementation(FirebaseAnalyticsDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue INVALID_NAME = Issue.create("InvalidAnalyticsName", "Invalid Analytics Name", "Event names and parameters must follow the naming conventions defined in the`FirebaseAnalytics#logEvent()` documentation.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://firebase.google.com/docs/reference/android/com/google/firebase/analytics/FirebaseAnalytics#logEvent(java.lang.String,%20android.os.Bundle)").setAndroidSpecific(true);

    private static boolean isReservedEventName(String name) {
        switch (name) {
            case "app_clear_data": 
            case "app_uninstall": 
            case "app_update": 
            case "error": 
            case "first_open": 
            case "in_app_purchase": 
            case "notification_dismiss": 
            case "notification_foreground": 
            case "notification_open": 
            case "notification_receive": 
            case "os_update": 
            case "session_start": 
            case "user_engagement": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression call2, PsiMethod method) {
        UExpression secondParameter;
        String firebaseAnalytics = "com.google.firebase.analytics.FirebaseAnalytics";
        if (!context2.getEvaluator().isMemberInClass((PsiMember)method, firebaseAnalytics)) {
            return;
        }
        List expressions = call2.getValueArguments();
        if (expressions.size() < 2) {
            return;
        }
        UElement firstArgumentExpression = (UElement)expressions.get(0);
        String value = ConstantEvaluator.evaluateString(context2, firstArgumentExpression, false);
        if (value == null) {
            return;
        }
        String error = FirebaseAnalyticsDetector.getErrorForEventName(value);
        if (error != null) {
            context2.report(INVALID_NAME, (UElement)call2, context2.getLocation((UElement)call2), error);
        }
        if ((secondParameter = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)expressions.get(1)))) == null) {
            return;
        }
        List<BundleModification> bundleModifications = FirebaseAnalyticsDetector.getBundleModifications(context2, secondParameter);
        if (bundleModifications != null && !bundleModifications.isEmpty()) {
            FirebaseAnalyticsDetector.validateEventParameters(context2, bundleModifications, call2);
        }
    }

    private static void validateEventParameters(JavaContext context2, List<BundleModification> parameters, UCallExpression call2) {
        for (BundleModification bundleModification : parameters) {
            String error = FirebaseAnalyticsDetector.getErrorForEventParameterName(bundleModification.mName);
            if (error == null) continue;
            Location location = context2.getLocation((UElement)call2);
            location.withSecondary(context2.getLocation((UElement)bundleModification.mLocation), error);
            context2.report(INVALID_NAME, (UElement)call2, location, "Bundle with invalid Analytics event parameters passed to `logEvent`");
        }
    }

    private static List<BundleModification> getBundleModifications(JavaContext context2, UExpression secondParameter) {
        PsiType type = secondParameter.getExpressionType();
        if (type != null && !type.getCanonicalText().equals("android.os.Bundle")) {
            return null;
        }
        if (secondParameter instanceof UCallExpression) {
            return Collections.emptyList();
        }
        List<BundleModification> modifications = null;
        if (secondParameter instanceof UReferenceExpression) {
            UReferenceExpression bundleReference = (UReferenceExpression)secondParameter;
            modifications = BundleModificationFinder.find(context2, bundleReference);
        }
        return modifications;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("logEvent");
    }

    private static String getErrorForEventName(String eventName) {
        if (eventName.length() > 40) {
            String message = "Analytics event name must be less than %1$d characters (found %2$d)";
            return String.format(message, 40, eventName.length());
        }
        if (eventName.isEmpty()) {
            return "Analytics event name cannot be empty";
        }
        if (!Character.isAlphabetic(eventName.charAt(0))) {
            String message = "Analytics event name must start with an alphabetic character (found %1$s)";
            return String.format(message, eventName);
        }
        String message = "Analytics event name must only consist of letters, numbers and underscores (found %1$s)";
        for (int i = 0; i < eventName.length(); ++i) {
            char character = eventName.charAt(i);
            if (Character.isLetterOrDigit(character) || character == '_') continue;
            return String.format(message, eventName);
        }
        if (eventName.startsWith("firebase_")) {
            return "Analytics event name should not start with `firebase_`";
        }
        if (FirebaseAnalyticsDetector.isReservedEventName(eventName)) {
            return String.format("`%1$s` is a reserved Analytics event name and cannot be used", eventName);
        }
        return null;
    }

    private static String getErrorForEventParameterName(String eventParameterName) {
        if (eventParameterName.length() > 40) {
            String message = "Analytics event parameter name must be %1$d characters or less (found %2$d)";
            return String.format(message, 40, eventParameterName.length());
        }
        if (eventParameterName.isEmpty()) {
            return "Analytics event parameter name cannot be empty";
        }
        if (!Character.isAlphabetic(eventParameterName.charAt(0))) {
            String message = "Analytics event parameter name must start with an alphabetic character (found %1$s)";
            return String.format(message, eventParameterName);
        }
        String message = "Analytics event name must only consist of letters, numbers and underscores (found %1$s)";
        for (int i = 0; i < eventParameterName.length(); ++i) {
            char character = eventParameterName.charAt(i);
            if (Character.isLetterOrDigit(character) || character == '_') continue;
            return String.format(message, eventParameterName);
        }
        if (eventParameterName.startsWith("firebase_")) {
            return "Analytics event parameter name cannot be start with `firebase_`";
        }
        return null;
    }

    private static class BundleModification {
        public final String mName;
        public final String mValue;
        public final UCallExpression mLocation;

        public BundleModification(String name, String value, UCallExpression location) {
            this.mName = name;
            this.mValue = value;
            this.mLocation = location;
        }
    }

    private static class BundleModificationFinder
    extends AbstractUastVisitor {
        private final String mBundleReference;
        private final JavaContext mContext;
        private final List<BundleModification> mParameters = new ArrayList<BundleModification>();

        private BundleModificationFinder(JavaContext context2, UReferenceExpression bundleReference) {
            this.mContext = context2;
            this.mBundleReference = bundleReference.asSourceString();
        }

        public boolean visitDeclarationsExpression(UDeclarationsExpression statement) {
            for (UElement element : statement.getDeclarations()) {
                UReferenceExpression returnReference;
                PsiMethod resolvedMethod;
                UExpression initializer;
                ULocalVariable local;
                String name;
                if (!(element instanceof ULocalVariable) || (name = (local = (ULocalVariable)element).getName()) == null || !name.equals(this.mBundleReference) || (initializer = local.getUastInitializer()) == null) continue;
                if ((initializer = UastUtils.skipParenthesizedExprDown((UExpression)initializer)) instanceof UCallExpression) {
                    resolvedMethod = ((UCallExpression)initializer).resolve();
                } else {
                    PsiElement resolved;
                    if (!(initializer instanceof UReferenceExpression) || !((resolved = ((UReferenceExpression)initializer).resolve()) instanceof PsiMethod)) continue;
                    resolvedMethod = (PsiMethod)resolved;
                }
                if (resolvedMethod == null || (returnReference = ReturnReferenceExpressionFinder.find(Lint.getUMethod(resolvedMethod))) == null) continue;
                this.addParams(BundleModificationFinder.find(this.mContext, returnReference));
            }
            return super.visitDeclarationsExpression(statement);
        }

        public boolean visitCallExpression(UCallExpression expression) {
            this.checkMethodCall(expression);
            return super.visitCallExpression(expression);
        }

        private void checkMethodCall(UCallExpression expression) {
            String method = Lint.getMethodName(expression);
            if (method == null || !method.equals("putString") && !method.equals("putLong") && !method.equals("putDouble")) {
                return;
            }
            UExpression token = expression.getReceiver();
            if (token != null) {
                token = UastUtils.skipParenthesizedExprDown((UExpression)token);
            }
            if (token == null || !this.mBundleReference.equals(token.asSourceString())) {
                return;
            }
            List expressions = expression.getValueArguments();
            String evaluatedName = ConstantEvaluator.evaluateString(this.mContext, (UElement)expressions.get(0), false);
            if (evaluatedName != null) {
                this.addParam(evaluatedName, ((UExpression)expressions.get(1)).asSourceString(), expression);
            }
        }

        private void addParam(String key, String value, UCallExpression location) {
            this.mParameters.add(new BundleModification(key, value, location));
        }

        private void addParams(Collection<BundleModification> bundleModifications) {
            this.mParameters.addAll(bundleModifications);
        }

        static List<BundleModification> find(JavaContext context2, UReferenceExpression bundleReference) {
            BundleModificationFinder scanner = new BundleModificationFinder(context2, bundleReference);
            UMethod enclosingMethod = (UMethod)UastUtils.getParentOfType((UElement)bundleReference, UMethod.class);
            if (enclosingMethod == null) {
                return Collections.emptyList();
            }
            enclosingMethod.accept((UastVisitor)scanner);
            return scanner.mParameters;
        }
    }

    private static class ReturnReferenceExpressionFinder
    extends AbstractUastVisitor {
        private UReferenceExpression mReturnReference = null;

        private ReturnReferenceExpressionFinder() {
        }

        public boolean visitReturnExpression(UReturnExpression statement) {
            UExpression returnExpression = statement.getReturnExpression();
            if (returnExpression != null) {
                returnExpression = UastUtils.skipParenthesizedExprDown((UExpression)returnExpression);
            }
            if (returnExpression instanceof UReferenceExpression) {
                this.mReturnReference = (UReferenceExpression)returnExpression;
            }
            return super.visitReturnExpression(statement);
        }

        static UReferenceExpression find(UMethod method) {
            if (method == null) {
                return null;
            }
            ReturnReferenceExpressionFinder finder = new ReturnReferenceExpressionFinder();
            method.accept((UastVisitor)finder);
            return finder.mReturnReference;
        }
    }
}

