/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001&B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0016J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0016\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/checks/DiscouragedDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "reference", "Lorg/w3c/dom/Node;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "getMessage", "getApplicableMethodNames", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "getApplicableAttributes", "", "visitAttribute", "attribute", "Lorg/w3c/dom/Attr;", "Companion", "android.sdktools.lint-checks"})
public final class DiscouragedDetector
extends AbstractAnnotationDetector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DISCOURAGED_ANNOTATION = "androidx.annotation.Discouraged";
    @NotNull
    public static final String SCHEDULE_AT_FIXED_RATE = "scheduleAtFixedRate";
    @NotNull
    public static final String SCHEDULE_WITH_FIXED_DELAY = "scheduleWithFixedDelay";
    @NotNull
    public static final String SCHEDULE = "schedule";
    @NotNull
    public static final String CLASS_SCHEDULED_EXECUTOR_SERVICE = "java.util.concurrent.ScheduledExecutorService";
    @NotNull
    public static final String CLASS_TIMER = "java.util.Timer";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)DISCOURAGED_ANNOTATION);
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type == AnnotationUsageType.METHOD_CALL || type == AnnotationUsageType.METHOD_REFERENCE || type == AnnotationUsageType.CLASS_REFERENCE || type == AnnotationUsageType.METHOD_OVERRIDE || type == AnnotationUsageType.EXTENDS || type == AnnotationUsageType.FIELD_REFERENCE || type == AnnotationUsageType.XML_REFERENCE;
    }

    @Override
    public void visitAnnotationUsage(@NotNull XmlContext context2, @NotNull Node reference, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (usageInfo.getReferenced() == null) {
            return;
        }
        Location location = reference instanceof Attr ? context2.getValueLocation((Attr)reference) : context2.getNameLocation(reference);
        String message = this.getMessage(annotationInfo);
        XmlContext.report$default(context2, ISSUE, reference, location, message, null, 16, null);
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (usageInfo.getReferenced() == null) {
            return;
        }
        Location location = context2.getNameLocation(element);
        String message = this.getMessage(annotationInfo);
        this.report(context2, ISSUE, element, location, message);
    }

    private final String getMessage(AnnotationInfo annotationInfo) {
        String message = UastLintUtils.Companion.getAnnotationStringValue(annotationInfo.getAnnotation(), "message");
        CharSequence charSequence = message;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return "Use of this API is discouraged";
        }
        return message;
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)SCHEDULE_AT_FIXED_RATE);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (Intrinsics.areEqual((Object)method.getName(), (Object)SCHEDULE_AT_FIXED_RATE)) {
            Pair pair2;
            if (JavaEvaluator.isMemberInSubClassOf$default(context2.getEvaluator(), (PsiMember)method, CLASS_SCHEDULED_EXECUTOR_SERVICE, false, 4, null)) {
                pair2 = TuplesKt.to((Object)DiscouragedDetector.visitMethodCall$scheduleAtFixedRateFix(this, SCHEDULE_WITH_FIXED_DELAY), (Object)SCHEDULE_WITH_FIXED_DELAY);
            } else if (JavaEvaluator.isMemberInSubClassOf$default(context2.getEvaluator(), (PsiMember)method, CLASS_TIMER, false, 4, null)) {
                PsiParameter psiParameter = method.getParameterList().getParameter(1);
                pair2 = Intrinsics.areEqual((Object)(psiParameter != null ? psiParameter.getType() : null), (Object)PsiTypes.longType()) ? TuplesKt.to((Object)DiscouragedDetector.visitMethodCall$scheduleAtFixedRateFix(this, SCHEDULE), (Object)SCHEDULE) : TuplesKt.to(null, (Object)SCHEDULE);
            } else {
                return;
            }
            Pair pair3 = pair2;
            LintFix fix2 = (LintFix)pair3.component1();
            String replacementFuncName = (String)pair3.component2();
            context2.report(new Incident().issue(ISSUE).scope(node).location(context2.getLocation((UElement)node)).message("Use of `scheduleAtFixedRate` is strongly discouraged because it can lead to unexpected behavior when Android processes become cached (tasks may unexpectedly execute hundreds or thousands of times in quick succession when a process changes from cached to uncached); prefer using `" + replacementFuncName + "`").fix(fix2), Constraints.isAndroidProject());
        }
    }

    @Override
    @NotNull
    public Collection<String> getApplicableAttributes() {
        Object[] objectArray = new String[]{"minAspectRatio", "maxAspectRatio", "screenOrientation", "resizeableActivity"};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        block16: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            if (!Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)attribute.getNamespaceURI())) {
                return;
            }
            LintFix fix2 = this.fix().url("https://developer.android.com/adaptive-apps").build();
            String string2 = attribute.getLocalName();
            if (string2 == null) break block16;
            int n = -1;
            switch (string2.hashCode()) {
                case -891502961: {
                    if (string2.equals("maxAspectRatio")) {
                        n = 1;
                    }
                    break;
                }
                case 227582404: {
                    if (string2.equals("screenOrientation")) {
                        n = 2;
                    }
                    break;
                }
                case -234586911: {
                    if (string2.equals("minAspectRatio")) {
                        n = 1;
                    }
                    break;
                }
                case 1642209597: {
                    if (string2.equals("resizeableActivity")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    String message = "Minimum and maximum aspect ratios will be ignored in most cases, starting from Android 16. Android is moving toward a model where apps are expected to adapt to various orientations, display sizes, and aspect ratios.";
                    context2.report(ISSUE, attribute, context2.getLocation(attribute), message, fix2);
                    break;
                }
                case 2: {
                    String message = "Fixed screen orientations will be ignored in most cases, starting from Android 16. Android is moving toward a model where apps are expected to adapt to various orientations, display sizes, and aspect ratios.";
                    context2.report(ISSUE, attribute, context2.getLocation(attribute), message, fix2);
                    break;
                }
                case 3: {
                    if (!Intrinsics.areEqual((Object)attribute.getValue(), (Object)"false")) break;
                    String message = "Setting `resizeableActivity` to `false` will be ignored in most cases, starting from Android 16. Android is moving toward a model where apps are expected to adapt to various orientations, display sizes, and aspect ratios.";
                    context2.report(ISSUE, attribute, context2.getLocation(attribute), message, fix2);
                }
            }
        }
    }

    private static final LintFix visitMethodCall$scheduleAtFixedRateFix(DiscouragedDetector this$0, String replacement) {
        return this$0.fix().replace().independent(true).text(SCHEDULE_AT_FIXED_RATE).with(replacement).build();
    }

    static {
        Object object = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation((Class<? extends Detector>)DiscouragedDetector.class, (EnumSet<Scope>)EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.JAVA_FILE), (EnumSet<Scope>)object);
        object = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        EnumSet<Platform> enumSet = Platform.UNSPECIFIED;
        ISSUE = Issue.Companion.create$default((Issue.Companion)object, "DiscouragedApi", "Using discouraged APIs", "\n                Discouraged APIs are allowed and are not deprecated, but they may be unfit for \\\n                common use (e.g. due to slow performance or subtle behavior).\n                ", implementation, null, category, 2, severity, false, null, enumSet, null, 2832, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/DiscouragedDetector$Companion;", "", "<init>", "()V", "DISCOURAGED_ANNOTATION", "", "SCHEDULE_AT_FIXED_RATE", "SCHEDULE_WITH_FIXED_DELAY", "SCHEDULE", "CLASS_SCHEDULED_EXECUTOR_SERVICE", "CLASS_TIMER", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

