/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.SourceSetType;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\f\u0010\u001b\u001a\u00020\u0010*\u00020\u001cH\u0002R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/DesugaredMethodLookup;", "", "methodDescriptors", "", "", "names", "", "<init>", "([Ljava/lang/String;Ljava/util/Set;)V", "([Ljava/lang/String;)V", "getMethodDescriptors", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getNames", "()Ljava/util/Set;", "isDesugaredName", "", "name", "isDesugaredMethod", "owner", "desc", "isClassPartiallyDesugared", "isDesugaredField", "isDesugaredClass", "compare", "", "combined", "isSymbolSeparator", "", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nDesugaredMethodLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesugaredMethodLookup.kt\ncom/android/tools/lint/checks/DesugaredMethodLookup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,748:1\n1#2:749\n*E\n"})
public final class DesugaredMethodLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] methodDescriptors;
    @NotNull
    private final Set<String> names;
    @NotNull
    private static final String[] defaultDesugaredMethods;
    @NotNull
    private static DesugaredMethodLookup lookup;

    public DesugaredMethodLookup(@NotNull String[] methodDescriptors, @NotNull Set<String> names) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptors, (String)"methodDescriptors");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        this.methodDescriptors = methodDescriptors;
        this.names = names;
    }

    @NotNull
    public final String[] getMethodDescriptors() {
        return this.methodDescriptors;
    }

    @NotNull
    public final Set<String> getNames() {
        return this.names;
    }

    public DesugaredMethodLookup(@NotNull String[] methodDescriptors) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptors, (String)"methodDescriptors");
        this(methodDescriptors, DesugaredMethodLookup.Companion.extractNames(methodDescriptors));
    }

    private final boolean isDesugaredName(String name) {
        return this.names.contains(name);
    }

    public final boolean isDesugaredMethod(@NotNull String owner, @NotNull String name, @NotNull String desc) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        boolean bl2 = bl = StringsKt.lastIndexOf$default((CharSequence)desc, (char)')', (int)0, (boolean)false, (int)6, null) + 1 == desc.length();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Comparator signatureComparator = (arg_0, arg_1) -> DesugaredMethodLookup.isDesugaredMethod$lambda$0(this, owner, name, desc, arg_0, arg_1);
        int index2 = Arrays.binarySearch(this.methodDescriptors, "placeholder", signatureComparator);
        if (index2 < 0 && Intrinsics.areEqual((Object)name, (Object)"<init>") && this.isClassPartiallyDesugared(owner)) {
            return true;
        }
        return index2 >= 0;
    }

    public final boolean isClassPartiallyDesugared(@NotNull String owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        String target2 = StringsKt.replace$default((String)owner, (char)'.', (char)'/', (boolean)false, (int)4, null);
        return Arrays.binarySearch(this.methodDescriptors, "placeholder", (arg_0, arg_1) -> DesugaredMethodLookup.isClassPartiallyDesugared$lambda$1((arg_0, arg_1) -> DesugaredMethodLookup.isClassPartiallyDesugared$lambda$0(target2, arg_0, arg_1), arg_0, arg_1)) >= 0;
    }

    public final boolean isDesugaredField(@NotNull String owner, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Comparator signatureComparator = (arg_0, arg_1) -> DesugaredMethodLookup.isDesugaredField$lambda$0(this, owner, name, arg_0, arg_1);
        return Arrays.binarySearch(this.methodDescriptors, "placeholder", signatureComparator) >= 0;
    }

    public final boolean isDesugaredClass(@NotNull String owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Comparator signatureComparator = (arg_0, arg_1) -> DesugaredMethodLookup.isDesugaredClass$lambda$0(this, owner, arg_0, arg_1);
        return Arrays.binarySearch(this.methodDescriptors, "placeholder", signatureComparator) >= 0;
    }

    @VisibleForTesting
    public final int compare(@NotNull String owner, @NotNull String name, @NotNull String desc, @NotNull String combined) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)combined, (String)"combined");
        Ref.IntRef ownerIndex = new Ref.IntRef();
        Ref.BooleanRef hadSeparator = new Ref.BooleanRef();
        Ref.IntRef nameIndex = new Ref.IntRef();
        Ref.IntRef descIndex = new Ref.IntRef();
        int lastParen = StringsKt.lastIndexOf$default((CharSequence)combined, (char)')', (int)0, (boolean)false, (int)6, null);
        int combinedLength = lastParen == -1 ? combined.length() : lastParen + 1;
        int i = 0;
        do {
            char d;
            char c;
            if ((c = DesugaredMethodLookup.compare$getNext(ownerIndex, owner, hadSeparator, nameIndex, name, descIndex, desc)) == (d = combined.charAt(i++)) || this.isSymbolSeparator(c) && this.isSymbolSeparator(d)) continue;
            return d - c;
        } while (i != combinedLength);
        return lastParen == -1 && ((CharSequence)desc).length() > 0 && StringsKt.indexOf$default((CharSequence)combined, (char)'#', (int)0, (boolean)false, (int)6, null) != -1 ? 1 : (!(ownerIndex.element != owner.length() || nameIndex.element != 0 && nameIndex.element != name.length() || descIndex.element != 0 && descIndex.element != desc.length()) ? 0 : -1);
    }

    private final boolean isSymbolSeparator(char $this$isSymbolSeparator) {
        return $this$isSymbolSeparator == '/' || $this$isSymbolSeparator == '$' || $this$isSymbolSeparator == '.';
    }

    private static final int isDesugaredMethod$lambda$0(DesugaredMethodLookup this$0, String $owner, String $name, String $desc, String o1, String string2) {
        Intrinsics.checkNotNull((Object)o1);
        return this$0.compare($owner, $name, $desc, o1);
    }

    private static final int isClassPartiallyDesugared$lambda$0(String $target, String o1, String string2) {
        Intrinsics.checkNotNull((Object)o1);
        return StringsKt.startsWith$default((String)o1, (String)$target, (boolean)false, (int)2, null) && (Intrinsics.areEqual((Object)o1, (Object)$target) || o1.charAt($target.length()) == '#') ? 0 : o1.compareTo($target);
    }

    private static final int isClassPartiallyDesugared$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int isDesugaredField$lambda$0(DesugaredMethodLookup this$0, String $owner, String $name, String o1, String string2) {
        Intrinsics.checkNotNull((Object)o1);
        return this$0.compare($owner, $name, "", o1);
    }

    private static final int isDesugaredClass$lambda$0(DesugaredMethodLookup this$0, String $owner, String o1, String string2) {
        Intrinsics.checkNotNull((Object)o1);
        return this$0.compare($owner, "", "", o1);
    }

    private static final char compare$getNext(Ref.IntRef ownerIndex, String $owner, Ref.BooleanRef hadSeparator, Ref.IntRef nameIndex, String $name, Ref.IntRef descIndex, String $desc) {
        int n;
        if (ownerIndex.element < $owner.length()) {
            int n2 = ownerIndex.element;
            ownerIndex.element = n2 + 1;
            n = $owner.charAt(n2);
        } else if (!hadSeparator.element) {
            int n3;
            int it = n3 = 35;
            boolean bl = false;
            hadSeparator.element = true;
            n = n3;
        } else if (nameIndex.element < $name.length()) {
            int n4 = nameIndex.element;
            nameIndex.element = n4 + 1;
            n = $name.charAt(n4);
        } else if (descIndex.element < $desc.length()) {
            int n5 = descIndex.element;
            descIndex.element = n5 + 1;
            n = $desc.charAt(n5);
        } else {
            n = 0;
        }
        return (char)n;
    }

    static {
        String[] stringArray = new String[]{"android/content/ContentProviderClient#close()V", "android/content/res/TypedArray#close()V", "android/drm/DrmManagerClient#close()V", "android/media/MediaDrm#close()V", "android/media/MediaMetadataRetriever#close()V", "android/os/Build#getMajorSdkVersion(I)I", "android/os/Build#getMinorSdkVersion(I)I", "android/os/Build$VERSION#SDK_INT_FULL", "android/os/Build$VERSION_CODES_FULL#BASE", "android/os/Build$VERSION_CODES_FULL#BASE_1_1", "android/os/Build$VERSION_CODES_FULL#CUPCAKE", "android/os/Build$VERSION_CODES_FULL#DONUT", "android/os/Build$VERSION_CODES_FULL#ECLAIR", "android/os/Build$VERSION_CODES_FULL#ECLAIR_0_1", "android/os/Build$VERSION_CODES_FULL#ECLAIR_MR1", "android/os/Build$VERSION_CODES_FULL#FROYO", "android/os/Build$VERSION_CODES_FULL#GINGERBREAD", "android/os/Build$VERSION_CODES_FULL#GINGERBREAD_MR1", "android/os/Build$VERSION_CODES_FULL#HONEYCOMB", "android/os/Build$VERSION_CODES_FULL#HONEYCOMB_MR1", "android/os/Build$VERSION_CODES_FULL#HONEYCOMB_MR2", "android/os/Build$VERSION_CODES_FULL#ICE_CREAM_SANDWICH", "android/os/Build$VERSION_CODES_FULL#ICE_CREAM_SANDWICH_MR1", "android/os/Build$VERSION_CODES_FULL#JELLY_BEAN", "android/os/Build$VERSION_CODES_FULL#JELLY_BEAN_MR1", "android/os/Build$VERSION_CODES_FULL#JELLY_BEAN_MR2", "android/os/Build$VERSION_CODES_FULL#KITKAT", "android/os/Build$VERSION_CODES_FULL#KITKAT_WATCH", "android/os/Build$VERSION_CODES_FULL#LOLLIPOP", "android/os/Build$VERSION_CODES_FULL#LOLLIPOP_MR1", "android/os/Build$VERSION_CODES_FULL#M", "android/os/Build$VERSION_CODES_FULL#N", "android/os/Build$VERSION_CODES_FULL#N_MR1", "android/os/Build$VERSION_CODES_FULL#O", "android/os/Build$VERSION_CODES_FULL#O_MR1", "android/os/Build$VERSION_CODES_FULL#P", "android/os/Build$VERSION_CODES_FULL#Q", "android/os/Build$VERSION_CODES_FULL#R", "android/os/Build$VERSION_CODES_FULL#S", "android/os/Build$VERSION_CODES_FULL#S_V2", "android/os/Build$VERSION_CODES_FULL#TIRAMISU", "android/os/Build$VERSION_CODES_FULL#UPSIDE_DOWN_CAKE", "android/os/Build$VERSION_CODES_FULL#VANILLA_ICE_CREAM", "android/util/SparseArray#set(ILjava/lang/Object;)V", "java/lang/Boolean#compare(ZZ)I", "java/lang/Boolean#hashCode(Z)I", "java/lang/Boolean#logicalAnd(ZZ)Z", "java/lang/Boolean#logicalOr(ZZ)Z", "java/lang/Boolean#logicalXor(ZZ)Z", "java/lang/Byte#compare(BB)I", "java/lang/Byte#compareUnsigned(BB)I", "java/lang/Byte#hashCode(B)I", "java/lang/Byte#toUnsignedInt(B)I", "java/lang/Byte#toUnsignedLong(B)J", "java/lang/CharSequence#compare(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)I", "java/lang/Character#compare(CC)I", "java/lang/Character#hashCode(C)I", "java/lang/Character#toString(I)Ljava/lang/String;", "java/lang/Double#hashCode(D)I", "java/lang/Double#isFinite(D)Z", "java/lang/Double#max(DD)D", "java/lang/Double#min(DD)D", "java/lang/Double#sum(DD)D", "java/lang/Float#hashCode(F)I", "java/lang/Float#isFinite(F)Z", "java/lang/Float#max(FF)F", "java/lang/Float#min(FF)F", "java/lang/Float#sum(FF)F", "java/lang/Integer#compare(II)I", "java/lang/Integer#compareUnsigned(II)I", "java/lang/Integer#divideUnsigned(II)I", "java/lang/Integer#hashCode(I)I", "java/lang/Integer#max(II)I", "java/lang/Integer#min(II)I", "java/lang/Integer#parseInt(Ljava/lang/CharSequence;III)I", "java/lang/Integer#parseUnsignedInt(Ljava/lang/CharSequence;III)I", "java/lang/Integer#parseUnsignedInt(Ljava/lang/String;)I", "java/lang/Integer#parseUnsignedInt(Ljava/lang/String;I)I", "java/lang/Integer#remainderUnsigned(II)I", "java/lang/Integer#sum(II)I", "java/lang/Integer#toUnsignedLong(I)J", "java/lang/Integer#toUnsignedString(I)Ljava/lang/String;", "java/lang/Integer#toUnsignedString(II)Ljava/lang/String;", "java/lang/Long#compare(JJ)I", "java/lang/Long#compareUnsigned(JJ)I", "java/lang/Long#divideUnsigned(JJ)J", "java/lang/Long#hashCode(J)I", "java/lang/Long#max(JJ)J", "java/lang/Long#min(JJ)J", "java/lang/Long#parseLong(Ljava/lang/CharSequence;III)J", "java/lang/Long#parseUnsignedLong(Ljava/lang/CharSequence;III)J", "java/lang/Long#parseUnsignedLong(Ljava/lang/String;)J", "java/lang/Long#parseUnsignedLong(Ljava/lang/String;I)J", "java/lang/Long#remainderUnsigned(JJ)J", "java/lang/Long#sum(JJ)J", "java/lang/Long#toUnsignedString(J)Ljava/lang/String;", "java/lang/Long#toUnsignedString(JI)Ljava/lang/String;", "java/lang/Math#absExact(I)I", "java/lang/Math#absExact(J)J", "java/lang/Math#addExact(II)I", "java/lang/Math#addExact(JJ)J", "java/lang/Math#ceilDiv(II)I", "java/lang/Math#ceilDiv(JI)J", "java/lang/Math#ceilDiv(JJ)J", "java/lang/Math#ceilDivExact(II)I", "java/lang/Math#ceilDivExact(JJ)J", "java/lang/Math#ceilMod(II)I", "java/lang/Math#ceilMod(JI)I", "java/lang/Math#ceilMod(JJ)J", "java/lang/Math#clamp(DDD)D", "java/lang/Math#clamp(FFF)F", "java/lang/Math#clamp(JII)I", "java/lang/Math#clamp(JJJ)J", "java/lang/Math#decrementExact(I)I", "java/lang/Math#decrementExact(J)J", "java/lang/Math#divideExact(II)I", "java/lang/Math#divideExact(JJ)J", "java/lang/Math#floorDiv(II)I", "java/lang/Math#floorDiv(JI)J", "java/lang/Math#floorDiv(JJ)J", "java/lang/Math#floorDivExact(II)I", "java/lang/Math#floorDivExact(JJ)J", "java/lang/Math#floorMod(II)I", "java/lang/Math#floorMod(JI)I", "java/lang/Math#floorMod(JJ)J", "java/lang/Math#incrementExact(I)I", "java/lang/Math#incrementExact(J)J", "java/lang/Math#multiplyExact(II)I", "java/lang/Math#multiplyExact(JI)J", "java/lang/Math#multiplyExact(JJ)J", "java/lang/Math#multiplyFull(II)J", "java/lang/Math#multiplyHigh(JJ)J", "java/lang/Math#negateExact(I)I", "java/lang/Math#negateExact(J)J", "java/lang/Math#nextDown(D)D", "java/lang/Math#nextDown(F)F", "java/lang/Math#subtractExact(II)I", "java/lang/Math#subtractExact(JJ)J", "java/lang/Math#toIntExact(J)I", "java/lang/Math#unsignedMultiplyHigh(JJ)J", "java/lang/Short#compare(SS)I", "java/lang/Short#compareUnsigned(SS)I", "java/lang/Short#hashCode(S)I", "java/lang/Short#toUnsignedInt(S)I", "java/lang/Short#toUnsignedLong(S)J", "java/lang/StrictMath#absExact(I)I", "java/lang/StrictMath#absExact(J)J", "java/lang/StrictMath#addExact(II)I", "java/lang/StrictMath#addExact(JJ)J", "java/lang/StrictMath#ceilDiv(II)I", "java/lang/StrictMath#ceilDiv(JI)J", "java/lang/StrictMath#ceilDiv(JJ)J", "java/lang/StrictMath#ceilDivExact(II)I", "java/lang/StrictMath#ceilDivExact(JJ)J", "java/lang/StrictMath#ceilMod(II)I", "java/lang/StrictMath#ceilMod(JI)I", "java/lang/StrictMath#ceilMod(JJ)J", "java/lang/StrictMath#clamp(DDD)D", "java/lang/StrictMath#clamp(FFF)F", "java/lang/StrictMath#clamp(JII)I", "java/lang/StrictMath#clamp(JJJ)J", "java/lang/StrictMath#decrementExact(I)I", "java/lang/StrictMath#decrementExact(J)J", "java/lang/StrictMath#divideExact(II)I", "java/lang/StrictMath#divideExact(JJ)J", "java/lang/StrictMath#floorDiv(II)I", "java/lang/StrictMath#floorDiv(JI)J", "java/lang/StrictMath#floorDiv(JJ)J", "java/lang/StrictMath#floorDivExact(II)I", "java/lang/StrictMath#floorDivExact(JJ)J", "java/lang/StrictMath#floorMod(II)I", "java/lang/StrictMath#floorMod(JI)I", "java/lang/StrictMath#floorMod(JJ)J", "java/lang/StrictMath#incrementExact(I)I", "java/lang/StrictMath#incrementExact(J)J", "java/lang/StrictMath#multiplyExact(II)I", "java/lang/StrictMath#multiplyExact(JI)J", "java/lang/StrictMath#multiplyExact(JJ)J", "java/lang/StrictMath#multiplyFull(II)J", "java/lang/StrictMath#multiplyHigh(JJ)J", "java/lang/StrictMath#negateExact(I)I", "java/lang/StrictMath#negateExact(J)J", "java/lang/StrictMath#nextDown(D)D", "java/lang/StrictMath#nextDown(F)F", "java/lang/StrictMath#subtractExact(II)I", "java/lang/StrictMath#subtractExact(JJ)J", "java/lang/StrictMath#toIntExact(J)I", "java/lang/StrictMath#unsignedMultiplyHigh(JJ)J", "java/lang/String#isBlank()Z", "java/lang/String#join(Ljava/lang/CharSequence;Ljava/lang/Iterable;)Ljava/lang/String;", "java/lang/String#join(Ljava/lang/CharSequence;[Ljava/lang/CharSequence;)Ljava/lang/String;", "java/lang/String#repeat(I)Ljava/lang/String;", "java/lang/String#strip()Ljava/lang/String;", "java/lang/String#stripLeading()Ljava/lang/String;", "java/lang/String#stripTrailing()Ljava/lang/String;", "java/lang/reflect/Method#getParameterCount()I", "java/math/BigDecimal#stripTrailingZeros()Ljava/math/BigDecimal;", "java/util/Collections#emptyEnumeration()Ljava/util/Enumeration;", "java/util/Collections#emptyIterator()Ljava/util/Iterator;", "java/util/Collections#emptyListIterator()Ljava/util/ListIterator;", "java/util/List#copyOf(Ljava/util/Collection;)Ljava/util/List;", "java/util/List#of()Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "java/util/List#of([Ljava/lang/Object;)Ljava/util/List;", "java/util/Map#copyOf(Ljava/util/Map;)Ljava/util/Map;", "java/util/Map#entry(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;", "java/util/Map#of()Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", "java/util/Map#ofEntries([Ljava/util/Map$Entry;)Ljava/util/Map;", "java/util/Objects#checkFromIndexSize(III)I", "java/util/Objects#checkFromIndexSize(JJJ)J", "java/util/Objects#checkFromToIndex(III)I", "java/util/Objects#checkFromToIndex(JJJ)J", "java/util/Objects#checkIndex(II)I", "java/util/Objects#checkIndex(JJ)J", "java/util/Objects#compare(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Comparator;)I", "java/util/Objects#deepEquals(Ljava/lang/Object;Ljava/lang/Object;)Z", "java/util/Objects#equals(Ljava/lang/Object;Ljava/lang/Object;)Z", "java/util/Objects#hash([Ljava/lang/Object;)I", "java/util/Objects#hashCode(Ljava/lang/Object;)I", "java/util/Objects#isNull(Ljava/lang/Object;)Z", "java/util/Objects#nonNull(Ljava/lang/Object;)Z", "java/util/Objects#requireNonNull(Ljava/lang/Object;)Ljava/lang/Object;", "java/util/Objects#requireNonNull(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "java/util/Objects#requireNonNullElse(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "java/util/Objects#toString(Ljava/lang/Object;)Ljava/lang/String;", "java/util/Objects#toString(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/String;", "java/util/Set#copyOf(Ljava/util/Collection;)Ljava/util/Set;", "java/util/Set#of()Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Set;", "java/util/Set#of([Ljava/lang/Object;)Ljava/util/Set;", "java/util/concurrent/ExecutorService#close()V", "java/util/concurrent/atomic/AtomicReference#compareAndSet(Ljava/lang/Object;Ljava/lang/Object;)Z", "java/util/concurrent/atomic/AtomicReferenceArray#compareAndSet(ILjava/lang/Object;Ljava/lang/Object;)Z", "java/util/concurrent/atomic/AtomicReferenceFieldUpdater#compareAndSet(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "sun/misc/Unsafe#compareAndSwapObject(Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z"};
        defaultDesugaredMethods = stringArray;
        lookup = new DesugaredMethodLookup(defaultDesugaredMethods, SetsKt.emptySet());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J>\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J6\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\"\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u001c\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eJ\u0014\u0010\u001f\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060$H\u0002J\b\u0010&\u001a\u00020'H\u0007J\u0010\u0010(\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006R\u001b\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\b8\u0007\u00a2\u0006\n\n\u0002\u0010,\u001a\u0004\b*\u0010+R\u001a\u0010-\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010.\"\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/android/tools/lint/checks/DesugaredMethodLookup$Companion;", "", "<init>", "()V", "extractNames", "", "", "methodDescriptors", "", "([Ljava/lang/String;)Ljava/util/Set;", "getBundledLibraryDesugaringRules", "Lcom/android/tools/lint/checks/DesugaredMethodLookup;", "project", "Lcom/android/tools/lint/detector/api/Project;", "", "minSdk", "", "isDesugaredMethod", "", "owner", "name", "desc", "sourceSetType", "Lcom/android/tools/lint/detector/api/SourceSetType;", "containingClass", "Lcom/intellij/psi/PsiClass;", "isDesugaredField", "isDesugaredClass", "getLookup", "setDesugaredMethods", "paths", "createDesugaredMethodLookup", "files", "", "Ljava/io/File;", "removeMembersFromSupportedClasses", "", "lines", "reset", "", "canBeDesugaredLater", "defaultDesugaredMethods", "getDefaultDesugaredMethods", "()[Ljava/lang/String;", "[Ljava/lang/String;", "lookup", "()Lcom/android/tools/lint/checks/DesugaredMethodLookup;", "setLookup", "(Lcom/android/tools/lint/checks/DesugaredMethodLookup;)V", "android.sdktools.lint-checks"})
    @SourceDebugExtension(value={"SMAP\nDesugaredMethodLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesugaredMethodLookup.kt\ncom/android/tools/lint/checks/DesugaredMethodLookup$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,748:1\n37#2:749\n36#2,3:750\n37#2:754\n36#2,3:755\n37#2:758\n36#2,3:759\n37#2:762\n36#2,3:763\n1#3:753\n*S KotlinDebug\n*F\n+ 1 DesugaredMethodLookup.kt\ncom/android/tools/lint/checks/DesugaredMethodLookup$Companion\n*L\n179#1:749\n179#1:750,3\n330#1:754\n330#1:755,3\n385#1:758\n385#1:759,3\n410#1:762\n410#1:763,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<String> extractNames(String[] methodDescriptors) {
            return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])methodDescriptors), Companion::extractNames$lambda$0));
        }

        @NotNull
        public final DesugaredMethodLookup getBundledLibraryDesugaringRules(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SourceSetType sourceSetType = SourceSetType.MAIN;
            DesugaredMethodLookup lookup = (DesugaredMethodLookup)project.getClientProperty((Object)sourceSetType);
            if (lookup != null) {
                return lookup;
            }
            List<String> lines = this.getBundledLibraryDesugaringRules(project.getMinSdk());
            Collection $this$toTypedArray$iv = lines;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            DesugaredMethodLookup newLookup = new DesugaredMethodLookup(thisCollection$iv.toArray(new String[0]));
            project.putClientProperty((Object)sourceSetType, newLookup);
            return newLookup;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final List<String> getBundledLibraryDesugaringRules(int minSdk) {
            List<String> list2;
            InputStream inputStream2 = DesugaredMethodLookup.class.getResourceAsStream("/desugared_apis_30_1.txt");
            if (inputStream2 != null) {
                boolean bl;
                InputStream inputStream3 = inputStream2;
                boolean bl2 = false;
                List lines = ArraysKt.toMutableList((Object[])Companion.getDefaultDesugaredMethods());
                Reader reader = new InputStreamReader(inputStream3, Charsets.UTF_8);
                int n = 8192;
                lines.addAll(TextStreamsKt.readLines((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))));
                if (minSdk >= 21) {
                    lines.add("java/util/Collection#parallelStream()Ljava/util/stream/Stream;");
                    lines.add("java/util/stream/BaseStream#parallel()Ljava/util/stream/BaseStream;");
                    lines.add("java/util/stream/DoubleStream#parallel()Ljava/util/stream/BaseStream;");
                    lines.add("java/util/stream/IntStream#parallel()Ljava/util/stream/BaseStream;");
                    lines.add("java/util/stream/LongStream#parallel()Ljava/util/stream/BaseStream;");
                }
                CollectionsKt.sort((List)lines);
                boolean bl3 = bl = !((Collection)lines).isEmpty() && !StringsKt.endsWith$default((CharSequence)((CharSequence)lines.get(0)), (char)'\r', (boolean)false, (int)2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                List<String> list3 = Companion.removeMembersFromSupportedClasses(lines);
                if (list3 != null) {
                    list2 = list3;
                    return list2;
                }
            }
            list2 = CollectionsKt.emptyList();
            return list2;
        }

        public final boolean isDesugaredMethod(@NotNull String owner, @NotNull String name, @NotNull String desc, @NotNull SourceSetType sourceSetType, @Nullable Project project, @Nullable PsiClass containingClass) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Intrinsics.checkNotNullParameter((Object)((Object)sourceSetType), (String)"sourceSetType");
            DesugaredMethodLookup lookup = this.getLookup(project, sourceSetType);
            if (lookup.isDesugaredMethod(owner, name, desc)) {
                return true;
            }
            if (containingClass != null && lookup.isDesugaredName(name)) {
                Iterator iterator = InheritanceUtil.getSuperClasses((PsiClass)containingClass).iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    PsiClass superClass = (PsiClass)iterator2.next();
                    String string2 = superClass.getQualifiedName();
                    if (string2 == null || !lookup.isDesugaredMethod(string2, name, desc)) continue;
                    return true;
                }
            }
            return false;
        }

        public static /* synthetic */ boolean isDesugaredMethod$default(Companion companion, String string2, String string3, String string4, SourceSetType sourceSetType, Project project, PsiClass psiClass, int n, Object object) {
            if ((n & 0x10) != 0) {
                project = null;
            }
            if ((n & 0x20) != 0) {
                psiClass = null;
            }
            return companion.isDesugaredMethod(string2, string3, string4, sourceSetType, project, psiClass);
        }

        public final boolean isDesugaredField(@NotNull String owner, @NotNull String name, @NotNull SourceSetType sourceSetType, @Nullable Project project, @Nullable PsiClass containingClass) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)sourceSetType), (String)"sourceSetType");
            DesugaredMethodLookup lookup = this.getLookup(project, sourceSetType);
            if (lookup.isDesugaredField(owner, name)) {
                return true;
            }
            if (containingClass != null && lookup.isDesugaredName(name)) {
                Iterator iterator = InheritanceUtil.getSuperClasses((PsiClass)containingClass).iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    PsiClass superClass = (PsiClass)iterator2.next();
                    String string2 = superClass.getQualifiedName();
                    if (string2 == null || !lookup.isDesugaredField(string2, name)) continue;
                    return true;
                }
            }
            return false;
        }

        public static /* synthetic */ boolean isDesugaredField$default(Companion companion, String string2, String string3, SourceSetType sourceSetType, Project project, PsiClass psiClass, int n, Object object) {
            if ((n & 8) != 0) {
                project = null;
            }
            if ((n & 0x10) != 0) {
                psiClass = null;
            }
            return companion.isDesugaredField(string2, string3, sourceSetType, project, psiClass);
        }

        public final boolean isDesugaredClass(@NotNull String owner, @NotNull SourceSetType sourceSetType, @Nullable Project project) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)((Object)sourceSetType), (String)"sourceSetType");
            return this.getLookup(project, sourceSetType).isDesugaredClass(owner);
        }

        public static /* synthetic */ boolean isDesugaredClass$default(Companion companion, String string2, SourceSetType sourceSetType, Project project, int n, Object object) {
            if ((n & 4) != 0) {
                project = null;
            }
            return companion.isDesugaredClass(string2, sourceSetType, project);
        }

        @NotNull
        public final DesugaredMethodLookup getLookup(@Nullable Project project, @NotNull SourceSetType sourceSetType) {
            block16: {
                block17: {
                    Collection<File> desugaredMethodsFiles;
                    Collection<File> collection;
                    block19: {
                        LintModelVariant model;
                        block18: {
                            Collection<File> collection2;
                            LintModelAndroidArtifact modelArtifact;
                            Intrinsics.checkNotNullParameter((Object)((Object)sourceSetType), (String)"sourceSetType");
                            if (project == null) break block16;
                            model = project.getBuildVariant();
                            if (model == null) break block17;
                            if ((collection = (modelArtifact = (switch (WhenMappings.$EnumSwitchMapping$0[sourceSetType.ordinal()]) {
                                case 1 -> model.getMainArtifact();
                                case 2 -> model.getAndroidTestArtifact();
                                case 3 -> model.getTestFixturesArtifact();
                                default -> null;
                            }))) == null || (collection = collection.getDesugaredMethodsFiles()) == null) break block18;
                            Collection<File> collection3 = collection;
                            if (collection3.isEmpty()) {
                                boolean bl = false;
                                collection2 = model.getDesugaredMethodsFiles();
                            } else {
                                collection2 = collection = collection3;
                            }
                            if (collection2 != null) break block19;
                        }
                        collection = model.getDesugaredMethodsFiles();
                    }
                    if (!(desugaredMethodsFiles = collection).isEmpty()) {
                        DesugaredMethodLookup lookup = (DesugaredMethodLookup)project.getClientProperty((Object)sourceSetType);
                        if (lookup != null) {
                            return lookup;
                        }
                        DesugaredMethodLookup newLookup = this.createDesugaredMethodLookup(desugaredMethodsFiles);
                        project.putClientProperty((Object)sourceSetType, newLookup);
                        return newLookup;
                    }
                    break block16;
                }
                if (project.getDesugaring().contains((Object)Desugaring.JAVA_8_LIBRARY)) {
                    DesugaredMethodLookup lookup = (DesugaredMethodLookup)project.getClientProperty((Object)sourceSetType);
                    if (lookup != null) {
                        return lookup;
                    }
                    List<String> lines = this.getBundledLibraryDesugaringRules(project.getMinSdk());
                    if (lines != null) {
                        Collection $this$toTypedArray$iv = lines;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        DesugaredMethodLookup newLookup = new DesugaredMethodLookup(thisCollection$iv.toArray(new String[0]));
                        project.putClientProperty((Object)sourceSetType, newLookup);
                        return newLookup;
                    }
                }
            }
            return this.getLookup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final String setDesugaredMethods(@NotNull List<String> paths) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            lines = new ArrayList<E>(1024);
            for (String path : paths) {
                try {
                    if (Intrinsics.areEqual((Object)path, (Object)"none")) continue;
                    if (StringsKt.startsWith$default((String)path, (String)"jar:", (boolean)false, (int)2, null)) {
                        url = new URL(path);
                        v0 = url.openConnection();
                        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type java.net.JarURLConnection");
                        connection = (JarURLConnection)v0;
                        var7_11 = connection.getJarFile();
                        var8_12 = null;
                        try {
                            jarFile = (JarFile)var7_11;
                            $i$a$-use-DesugaredMethodLookup$Companion$setDesugaredMethods$1 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)jarFile.getInputStream(connection.getJarEntry()), (String)"getInputStream(...)");
                            var12_18 = Charsets.UTF_8;
                            var13_19 = new InputStreamReader(var11_17, var12_18);
                            var14_20 = 8192;
                            TextStreamsKt.forEachLine((Reader)(var13_19 instanceof BufferedReader != false ? (BufferedReader)var13_19 : new BufferedReader(var13_19, var14_20)), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, setDesugaredMethods$lambda$0$0(java.util.ArrayList java.lang.String ), (Ljava/lang/String;)Lkotlin/Unit;)(lines));
                            var9_13 = Unit.INSTANCE;
                            continue;
                        }
                        catch (Throwable var10_15) {
                            var8_12 = var10_15;
                            throw var10_15;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var7_11, (Throwable)var8_12);
                            continue;
                        }
                    }
                    v1 = file = StringsKt.startsWith$default((String)path, (String)"file:", (boolean)false, (int)2, null) != false ? SdkUtils.urlToFile((URL)new URL(path)) : new File(path);
                    if (!file.isFile()) {
                        return path;
                    }
                    Intrinsics.checkNotNull((Object)file);
                    FilesKt.forEachLine$default((File)file, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, setDesugaredMethods$lambda$1(java.util.ArrayList java.lang.String ), (Ljava/lang/String;)Lkotlin/Unit;)(lines), (int)1, null);
                }
                catch (IOException throwable) {
                    return path;
                }
            }
            CollectionsKt.sort((List)lines);
            if (lines.isEmpty()) ** GOTO lbl-1000
            v2 = lines.get(0);
            Intrinsics.checkNotNullExpressionValue(v2, (String)"get(...)");
            if (!StringsKt.endsWith$default((CharSequence)((CharSequence)v2), (char)'\r', (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = var3_4 = false;
            }
            if (_Assertions.ENABLED && !var3_4) {
                path = "Assertion failed";
                throw new AssertionError((Object)path);
            }
            $this$toTypedArray$iv = CollectionsKt.distinct((Iterable)lines);
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            this.setLookup(new DesugaredMethodLookup(thisCollection$iv.toArray(new String[0])));
            return null;
        }

        @NotNull
        public final DesugaredMethodLookup createDesugaredMethodLookup(@NotNull Collection<? extends File> files) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            boolean bl3 = bl2 = !files.isEmpty();
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Ref.ObjectRef lines = new Ref.ObjectRef();
            lines.element = new ArrayList(1024);
            for (File file : files) {
                FilesKt.forEachLine$default((File)file, null, arg_0 -> Companion.createDesugaredMethodLookup$lambda$0(lines, arg_0), (int)1, null);
            }
            CollectionsKt.sort((List)((List)lines.element));
            if (files.size() > 1 && !((Collection)lines.element).isEmpty()) {
                lines.element = this.removeMembersFromSupportedClasses((List)lines.element);
            }
            boolean bl4 = bl = !((Collection)lines.element).isEmpty() && !StringsKt.endsWith$default((CharSequence)((CharSequence)((List)lines.element).get(0)), (char)'\r', (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Collection $this$toTypedArray$iv = (Collection)lines.element;
            boolean bl5 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new DesugaredMethodLookup(thisCollection$iv.toArray(new String[0]));
        }

        private final List<String> removeMembersFromSupportedClasses(List<String> lines) {
            if (!((Collection)lines).isEmpty()) {
                ArrayList<String> filtered = new ArrayList<String>(lines.size());
                String prev = "";
                for (String line : lines) {
                    if (Intrinsics.areEqual((Object)prev, (Object)line)) continue;
                    if (prev.compareTo(line) > 0) {
                        throw new IllegalStateException("Expected sorted file".toString());
                    }
                    if (StringsKt.indexOf$default((CharSequence)prev, (char)'#', (int)0, (boolean)false, (int)6, null) == -1 && StringsKt.startsWith$default((String)line, (String)prev, (boolean)false, (int)2, null) && line.length() > prev.length() && line.charAt(prev.length()) == '#') continue;
                    filtered.add(line);
                    prev = line;
                }
                return filtered;
            }
            return lines;
        }

        @TestOnly
        public final void reset() {
            this.setLookup(new DesugaredMethodLookup(this.getDefaultDesugaredMethods()));
        }

        public final boolean canBeDesugaredLater(@Nullable String owner) {
            boolean bl;
            if (owner == null) {
                return false;
            }
            boolean bl2 = bl = !StringsKt.contains$default((CharSequence)owner, (char)'/', (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return StringsKt.startsWith$default((String)owner, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"sun.", (boolean)false, (int)2, null);
        }

        @VisibleForTesting
        @NotNull
        public final String[] getDefaultDesugaredMethods() {
            return defaultDesugaredMethods;
        }

        @NotNull
        public final DesugaredMethodLookup getLookup() {
            return lookup;
        }

        public final void setLookup(@NotNull DesugaredMethodLookup desugaredMethodLookup) {
            Intrinsics.checkNotNullParameter((Object)desugaredMethodLookup, (String)"<set-?>");
            lookup = desugaredMethodLookup;
        }

        private static final String extractNames$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return StringsKt.contains$default((CharSequence)it, (char)'#', (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)it, (char)'#', null, (int)2, null), (char)'(', null, (int)2, null) : null;
        }

        private static final Unit setDesugaredMethods$lambda$0$0(ArrayList $lines, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (!StringsKt.isBlank((CharSequence)it)) {
                $lines.add(it);
            }
            return Unit.INSTANCE;
        }

        private static final Unit setDesugaredMethods$lambda$1(ArrayList $lines, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (!StringsKt.isBlank((CharSequence)it)) {
                $lines.add(it);
            }
            return Unit.INSTANCE;
        }

        private static final Unit createDesugaredMethodLookup$lambda$0(Ref.ObjectRef $lines, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (!StringsKt.isBlank((CharSequence)it)) {
                ((List)$lines.element).add(it);
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SourceSetType.values().length];
                try {
                    nArray[SourceSetType.MAIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SourceSetType.INSTRUMENTATION_TESTS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SourceSetType.TEST_FIXTURES.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

