/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/BidirectionalTextDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "checkBidi", "", "node", "source", "", "containsUnterminatedBidiSegment", "", "s", "Companion", "android.sdktools.lint-checks"})
public final class BidirectionalTextDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
GradleScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(BidirectionalTextDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue BIDI_SPOOFING;
    public static final char VT = '\u000b';
    public static final char FF = '\f';
    public static final char NEL = '\u0085';
    public static final char LS = '\u2028';
    public static final char PS = '\u2029';
    public static final char LRE = '\u202a';
    public static final char RLE = '\u202b';
    public static final char PDF = '\u202c';
    public static final char LRO = '\u202d';
    public static final char RLO = '\u202e';
    public static final char LRI = '\u2066';
    public static final char RLI = '\u2067';
    public static final char FSI = '\u2068';
    public static final char PDI = '\u2069';

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UFile.class, ULiteralExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new UElementHandler(this, context2){
            final /* synthetic */ BidirectionalTextDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitFile(UFile node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                for (UComment comment : node.getAllCommentsInFile()) {
                    BidirectionalTextDetector.access$checkBidi(this.this$0, this.$context, (UElement)comment, comment.getText());
                }
            }

            public void visitLiteralExpression(ULiteralExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object = node.getValue();
                String string2 = object instanceof String ? (String)object : null;
                if (string2 == null) {
                    return;
                }
                String value = string2;
                UElement uElement = (UElement)node;
                Object object2 = node.getSourcePsi();
                if ((object2 == null || (object2 = object2.getText()) == null) && (object2 = UastUtils.evaluateString((UExpression)((UExpression)node))) == null) {
                    object2 = value;
                }
                BidirectionalTextDetector.access$checkBidi(this.this$0, this.$context, uElement, (CharSequence)object2);
            }
        };
    }

    private final void checkBidi(JavaContext context2, UElement node, CharSequence source) {
        if (this.containsUnterminatedBidiSegment(source)) {
            String type = node instanceof UComment ? "Comment" : "String";
            JavaContext.report$default(context2, BIDI_SPOOFING, node, context2.getLocation(node), type + " contains misleading Unicode bidirectional text", null, 16, null);
        }
    }

    private final boolean containsUnterminatedBidiSegment(CharSequence s) {
        int embeddingCount = 0;
        int isolateCount = 0;
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u2066': 
                case '\u2067': 
                case '\u2068': {
                    ++isolateCount;
                    continue block7;
                }
                case '\u202a': 
                case '\u202b': 
                case '\u202d': 
                case '\u202e': {
                    ++embeddingCount;
                    continue block7;
                }
                case '\u2069': {
                    if (isolateCount <= 0) continue block7;
                    --isolateCount;
                    continue block7;
                }
                case '\u202c': {
                    if (embeddingCount <= 0) continue block7;
                    --embeddingCount;
                    continue block7;
                }
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    isolateCount = 0;
                    embeddingCount = 0;
                }
            }
        }
        return embeddingCount + isolateCount > 0;
    }

    public static final /* synthetic */ void access$checkBidi(BidirectionalTextDetector $this, JavaContext context2, UElement node, CharSequence source) {
        $this.checkBidi(context2, node, source);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        BIDI_SPOOFING = Issue.Companion.create$default(companion, "BidiSpoofing", "Bidirectional text spoofing", "\n                Unicode bidirectional text characters can alter the order in which the compiler processes \\\n                tokens. However, this can also be used to hide malicious code, and can be difficult to spot. \\\n                This lint check audits the source code and looks for cases where it looks like bidirectional \\\n                text has the potential to be misleading.\n                ", implementation, "https://krebsonsecurity.com/2021/11/trojan-source-bug-threatens-the-security-of-all-code/", category, 2, severity, false, null, null, null, 3840, null).addMoreInfo("https://goo.gle/BidiSpoofing");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/BidirectionalTextDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "BIDI_SPOOFING", "Lcom/android/tools/lint/detector/api/Issue;", "VT", "", "FF", "NEL", "LS", "PS", "LRE", "RLE", "PDF", "LRO", "RLO", "LRI", "RLI", "FSI", "PDI", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

