/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;

public class AppCompatResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("AppCompatResource", "Menu namespace", "When using the appcompat library, menu resources should refer to the `showAsAction` (or `actionViewClass`, or `actionProviderClass`) in the `app:` namespace, not the `android:` namespace.\n\nSimilarly, when **not** using the appcompat library, you should be using the `android:showAsAction` (or `actionViewClass`, or `actionProviderClass`) attribute.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(AppCompatResourceDetector.class, Scope.RESOURCE_FILE_SCOPE));
    public static final String ATTR_ACTION_VIEW_CLASS = "actionViewClass";
    public static final String ATTR_ACTION_PROVIDER_CLASS = "actionProviderClass";

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.MENU;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("showAsAction", ATTR_ACTION_PROVIDER_CLASS, ATTR_ACTION_VIEW_CLASS);
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        Project project = context2.getProject();
        Boolean appCompat = project.dependsOn("com.android.support:appcompat-v7");
        String localName = attribute.getLocalName();
        if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            if (context2.getFolderVersion() >= 14) {
                return;
            }
            if (appCompat == Boolean.TRUE) {
                LintFix fix2 = this.fix().replaceAttribute(attribute, "http://schemas.android.com/apk/res-auto", attribute.getLocalName(), attribute.getValue()).build();
                String message = String.format("Should use `app:%1$s` with the appcompat library with `xmlns:app=\"http://schemas.android.com/apk/res-auto\"`", localName);
                context2.report(ISSUE, attribute, context2.getLocation(attribute), message, fix2);
            }
        } else if (appCompat == Boolean.FALSE) {
            LintFix fix3 = this.fix().replaceAttribute(attribute, "http://schemas.android.com/apk/res/android", attribute.getLocalName(), attribute.getValue()).build();
            String message = String.format("Should use `android:%1$s` when not using the appcompat library", localName);
            context2.report(ISSUE, attribute, context2.getLocation(attribute), message, fix3);
        }
    }
}

