/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.leakcanarylib.parser;

import com.android.tools.leakcanarylib.data.AnalysisFailure;
import com.android.tools.leakcanarylib.data.AnalysisSuccess;
import com.android.tools.leakcanarylib.data.AnalysisUpdate;
import com.android.tools.leakcanarylib.data.Leak;
import com.android.tools.leakcanarylib.data.LeakType;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/leakcanarylib/parser/AnalysisParser;", "", "<init>", "()V", "Companion", "android.sdktools.leakcanarylib"})
public final class AnalysisParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String SEPARATOR = "====================================";

    static {
        Logger logger = Logger.getInstance((String)AnalysisParser.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002J\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00182\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002J\u0016\u0010\u0019\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/leakcanarylib/parser/AnalysisParser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SEPARATOR", "", "analysisSuccessFromString", "Lcom/android/tools/leakcanarylib/data/AnalysisSuccess;", "text", "analysisFailureFromString", "Lcom/android/tools/leakcanarylib/data/AnalysisFailure;", "analysisUpdateFromString", "Lcom/android/tools/leakcanarylib/data/AnalysisUpdate;", "extractHeapDumpDuration", "", "lines", "", "extractHeapDumpTimestamp", "extractFileFromTexts", "Ljava/io/File;", "parseMetadataMap", "", "extractHeapAnalysisDuration", "extractSection", "sectionName", "findRootCauseForException", "", "stackTrace", "android.sdktools.leakcanarylib"})
    @SourceDebugExtension(value={"SMAP\nAnalysisParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalysisParser.kt\ncom/android/tools/leakcanarylib/parser/AnalysisParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n295#2,2:198\n295#2,2:200\n295#2,2:202\n360#2,7:204\n360#2,7:211\n295#2,2:218\n*S KotlinDebug\n*F\n+ 1 AnalysisParser.kt\ncom/android/tools/leakcanarylib/parser/AnalysisParser$Companion\n*L\n135#1:198,2\n144#1:200,2\n149#1:202,2\n155#1:204,7\n156#1:211,7\n172#1:218,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AnalysisSuccess analysisSuccessFromString(@NotNull String text) {
            AnalysisSuccess analysisSuccess;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            try {
                String metadataSection = this.extractSection(text, "METADATA");
                String libraryLeakSection = this.extractSection(text, "LIBRARY LEAKS");
                String applicationLeakSection = this.extractSection(text, "APPLICATION LEAKS");
                String[] stringArray = new String[]{"\n"};
                File heapDumpFile = this.extractFileFromTexts(StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)metadataSection)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                String[] stringArray2 = new String[]{"\n"};
                long heapDumpTimestamp = this.extractHeapDumpTimestamp(StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)metadataSection)).toString(), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
                String[] stringArray3 = new String[]{"\n"};
                long heapDumpDuration = this.extractHeapDumpDuration(StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)metadataSection)).toString(), (String[])stringArray3, (boolean)false, (int)0, (int)6, null));
                String[] stringArray4 = new String[]{"\n"};
                long heapAnalysisDuration = this.extractHeapAnalysisDuration(StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)metadataSection)).toString(), (String[])stringArray4, (boolean)false, (int)0, (int)6, null));
                String[] stringArray5 = new String[]{"\n"};
                Map<String, String> metadata = this.parseMetadataMap(StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)metadataSection)).toString(), (String[])stringArray5, (boolean)false, (int)0, (int)6, null));
                List<Leak> applicationLeaks = Leak.Companion.fromString(applicationLeakSection, LeakType.APPLICATION_LEAKS);
                List<Leak> libraryLeaks = Leak.Companion.fromString(libraryLeakSection, LeakType.LIBRARY_LEAKS);
                List overallLeaks = CollectionsKt.plus((Collection)applicationLeaks, (Iterable)libraryLeaks);
                analysisSuccess = new AnalysisSuccess(heapDumpFile, heapDumpTimestamp, heapDumpDuration, heapAnalysisDuration, metadata, overallLeaks);
            }
            catch (Exception e) {
                LOG.warn("Malformed leak, returning null. Exception: " + e + ".\nAttempted to parse:\n" + text);
                analysisSuccess = null;
            }
            return analysisSuccess;
        }

        @Nullable
        public final AnalysisFailure analysisFailureFromString(@NotNull String text) {
            AnalysisFailure analysisFailure;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            try {
                String metadataSection = this.extractSection(text, "METADATA");
                String stacktraceSection = this.extractSection(text, "STACKTRACE");
                File heapDumpFile = this.extractFileFromTexts(StringsKt.lines((CharSequence)metadataSection));
                long heapDumpTimestamp = this.extractHeapDumpTimestamp(StringsKt.lines((CharSequence)metadataSection));
                long heapDumpDuration = this.extractHeapDumpDuration(StringsKt.lines((CharSequence)metadataSection));
                long heapAnalysisDuration = this.extractHeapAnalysisDuration(StringsKt.lines((CharSequence)metadataSection));
                Throwable exception = new Throwable(this.findRootCauseForException(stacktraceSection));
                analysisFailure = new AnalysisFailure(heapDumpFile, heapDumpTimestamp, heapDumpDuration, heapAnalysisDuration, exception);
            }
            catch (Exception e) {
                LOG.warn("Malformed failure report, returning null. Exception: " + e + ".\nAttempted to parse:\n" + text);
                analysisFailure = null;
            }
            return analysisFailure;
        }

        @NotNull
        public final AnalysisUpdate analysisUpdateFromString(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new AnalysisUpdate(text);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final long extractHeapDumpDuration(List<String> lines) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = lines;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"Heap dump duration:", (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            String durationMillisLine = v0;
            if (durationMillisLine == null) return -1L;
            String string2 = StringsKt.substringAfter$default((String)durationMillisLine, (String)": ", null, (int)2, null);
            if (string2 == null) return -1L;
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (string3 == null) return -1L;
            String string4 = StringsKt.removeSuffix((String)string3, (CharSequence)" ms");
            if (string4 == null) return -1L;
            Long l = StringsKt.toLongOrNull((String)string4);
            if (l == null) return -1L;
            long l2 = l;
            return l2;
        }

        private final long extractHeapDumpTimestamp(List<String> lines) {
            String timeLine;
            String string2;
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = lines;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"Heap dump timestamp:", (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return (string2 = (timeLine = (String)v0)) != null && (string2 = StringsKt.substringAfter$default((String)string2, (String)": ", null, (int)2, null)) != null && (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) != null ? Long.parseLong(string2) : 0L;
        }

        private final File extractFileFromTexts(List<String> lines) {
            String dumpFileLine;
            String string2;
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = lines;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"Heap dump file path:", (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if ((string2 = (dumpFileLine = (String)v0)) == null || (string2 = StringsKt.substringAfter$default((String)string2, (String)": ", null, (int)2, null)) == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
                return new File("/");
            }
            String dumpFilePath = string2;
            return new File(dumpFilePath);
        }

        private final Map<String, String> parseMetadataMap(List<String> lines) {
            int endIndex;
            int startIndex;
            block7: {
                int n;
                int n2;
                block6: {
                    List<String> $this$indexOfFirst$iv = lines;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        String string2;
                        String string3 = string2 = iterator.next();
                        boolean bl = false;
                        if (StringsKt.startsWith$default((String)string3, (String)"METADATA", (boolean)false, (int)2, null)) {
                            n2 = index$iv;
                            break block6;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                startIndex = n2;
                List<String> $this$indexOfFirst$iv = lines;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    String string4;
                    String it = string4 = iterator.next();
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)it, (String)"Analysis duration", (boolean)false, (int)2, null)) {
                        n = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n = endIndex = -1;
            }
            if (endIndex == -1 || startIndex + 1 > endIndex) {
                return MapsKt.emptyMap();
            }
            List<String> metadataLines = lines.subList(startIndex + 1, endIndex);
            Map metadata = new LinkedHashMap();
            for (String string5 : metadataLines) {
                String[] stringArray;
                List list2 = StringsKt.split$default((CharSequence)string5, (String[])(stringArray = new String[]{":"}), (boolean)false, (int)0, (int)6, null);
                if (list2.size() != 2 || Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)((String)list2.get(0)))).toString(), (Object)"")) continue;
                metadata.put(((Object)StringsKt.trim((CharSequence)((String)list2.get(0)))).toString(), ((Object)StringsKt.trim((CharSequence)((String)list2.get(1)))).toString());
            }
            return metadata;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final long extractHeapAnalysisDuration(List<String> lines) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = lines;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"Analysis duration:", (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            String durationLine = v0;
            if (durationLine == null) return 0L;
            String string2 = StringsKt.substringAfter$default((String)durationLine, (String)": ", null, (int)2, null);
            if (string2 == null) return 0L;
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (string3 == null) return 0L;
            String string4 = StringsKt.removeSuffix((String)string3, (CharSequence)" ms");
            if (string4 == null) return 0L;
            long l = Long.parseLong(string4);
            return l;
        }

        private final String extractSection(String text, String sectionName) {
            String string2 = text.substring(StringsKt.indexOf$default((CharSequence)text, (String)sectionName, (int)0, (boolean)false, (int)6, null) + 1, text.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String section = string2;
            int sectionIndex = StringsKt.indexOf$default((CharSequence)section, (String)AnalysisParser.SEPARATOR, (int)0, (boolean)false, (int)6, null);
            if (sectionIndex == -1) {
                return "";
            }
            String[] stringArray = new String[]{"\n"};
            List sectionSubList = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((Object)StringsKt.trim((CharSequence)StringsKt.take((String)section, (int)sectionIndex))).toString())).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            return CollectionsKt.joinToString$default((Iterable)sectionSubList.subList(1, sectionSubList.size()), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }

        private final Throwable findRootCauseForException(String stackTrace) {
            String trace = StringsKt.replace$default((String)stackTrace, (String)"\n", (String)"", (boolean)false, (int)4, null);
            String firstLine = (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)trace)).toString()));
            String string2 = firstLine;
            if (string2 == null) {
                string2 = "Unknown error during heap analysis";
            }
            return new RuntimeException(string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

