/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.leakcanarylib.data;

import com.android.tools.leakcanarylib.data.LeakTraceNodeType;
import com.android.tools.leakcanarylib.data.LeakingStatus;
import com.android.tools.leakcanarylib.data.ReferencingField;
import com.android.tools.leakcanarylib.parser.NodeParser;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000f\b\u0086\b\u0018\u0000 F2\u00020\u0001:\u0001FBS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010/\u001a\u00020\u0005H\u0016J/\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b5J\u0010\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u000208H\u0002J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\t\u0010:\u001a\u00020\u0005H\u00c6\u0003J\t\u0010;\u001a\u00020\u0007H\u00c6\u0003J\t\u0010<\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010=\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010!J\u0010\u0010>\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010!J\u000f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u00c6\u0003J\u000b\u0010@\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003Jj\u0010A\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00c6\u0001\u00a2\u0006\u0002\u0010BJ\u0013\u0010C\u001a\u0002032\b\u0010D\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010E\u001a\u00020\nH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006G"}, d2={"Lcom/android/tools/leakcanarylib/data/Node;", "", "nodeType", "Lcom/android/tools/leakcanarylib/data/LeakTraceNodeType;", "className", "", "leakingStatus", "Lcom/android/tools/leakcanarylib/data/LeakingStatus;", "leakingStatusReason", "retainedByteSize", "", "retainedObjectCount", "notes", "", "referencingField", "Lcom/android/tools/leakcanarylib/data/ReferencingField;", "<init>", "(Lcom/android/tools/leakcanarylib/data/LeakTraceNodeType;Ljava/lang/String;Lcom/android/tools/leakcanarylib/data/LeakingStatus;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/List;Lcom/android/tools/leakcanarylib/data/ReferencingField;)V", "getNodeType", "()Lcom/android/tools/leakcanarylib/data/LeakTraceNodeType;", "setNodeType", "(Lcom/android/tools/leakcanarylib/data/LeakTraceNodeType;)V", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "getLeakingStatus", "()Lcom/android/tools/leakcanarylib/data/LeakingStatus;", "setLeakingStatus", "(Lcom/android/tools/leakcanarylib/data/LeakingStatus;)V", "getLeakingStatusReason", "setLeakingStatusReason", "getRetainedByteSize", "()Ljava/lang/Integer;", "setRetainedByteSize", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getRetainedObjectCount", "setRetainedObjectCount", "getNotes", "()Ljava/util/List;", "setNotes", "(Ljava/util/List;)V", "getReferencingField", "()Lcom/android/tools/leakcanarylib/data/ReferencingField;", "setReferencingField", "(Lcom/android/tools/leakcanarylib/data/ReferencingField;)V", "toString", "firstLinePrefix", "additionalLinesPrefix", "showLeakingStatus", "", "typeName", "toString$android_sdktools_leakcanarylib", "humanReadableByteCount", "bytes", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Lcom/android/tools/leakcanarylib/data/LeakTraceNodeType;Ljava/lang/String;Lcom/android/tools/leakcanarylib/data/LeakingStatus;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/List;Lcom/android/tools/leakcanarylib/data/ReferencingField;)Lcom/android/tools/leakcanarylib/data/Node;", "equals", "other", "hashCode", "Companion", "android.sdktools.leakcanarylib"})
@SourceDebugExtension(value={"SMAP\nNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Node.kt\ncom/android/tools/leakcanarylib/data/Node\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class Node {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LeakTraceNodeType nodeType;
    @NotNull
    private String className;
    @NotNull
    private LeakingStatus leakingStatus;
    @NotNull
    private String leakingStatusReason;
    @Nullable
    private Integer retainedByteSize;
    @Nullable
    private Integer retainedObjectCount;
    @NotNull
    private List<String> notes;
    @Nullable
    private ReferencingField referencingField;
    public static final char ZERO_WIDTH_SPACE = '\u200b';

    public Node(@NotNull LeakTraceNodeType nodeType, @NotNull String className, @NotNull LeakingStatus leakingStatus, @NotNull String leakingStatusReason, @Nullable Integer retainedByteSize, @Nullable Integer retainedObjectCount, @NotNull List<String> notes, @Nullable ReferencingField referencingField) {
        Intrinsics.checkNotNullParameter((Object)((Object)nodeType), (String)"nodeType");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)((Object)leakingStatus), (String)"leakingStatus");
        Intrinsics.checkNotNullParameter((Object)leakingStatusReason, (String)"leakingStatusReason");
        Intrinsics.checkNotNullParameter(notes, (String)"notes");
        this.nodeType = nodeType;
        this.className = className;
        this.leakingStatus = leakingStatus;
        this.leakingStatusReason = leakingStatusReason;
        this.retainedByteSize = retainedByteSize;
        this.retainedObjectCount = retainedObjectCount;
        this.notes = notes;
        this.referencingField = referencingField;
    }

    @NotNull
    public final LeakTraceNodeType getNodeType() {
        return this.nodeType;
    }

    public final void setNodeType(@NotNull LeakTraceNodeType leakTraceNodeType) {
        Intrinsics.checkNotNullParameter((Object)((Object)leakTraceNodeType), (String)"<set-?>");
        this.nodeType = leakTraceNodeType;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public final void setClassName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.className = string2;
    }

    @NotNull
    public final LeakingStatus getLeakingStatus() {
        return this.leakingStatus;
    }

    public final void setLeakingStatus(@NotNull LeakingStatus leakingStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)leakingStatus), (String)"<set-?>");
        this.leakingStatus = leakingStatus;
    }

    @NotNull
    public final String getLeakingStatusReason() {
        return this.leakingStatusReason;
    }

    public final void setLeakingStatusReason(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.leakingStatusReason = string2;
    }

    @Nullable
    public final Integer getRetainedByteSize() {
        return this.retainedByteSize;
    }

    public final void setRetainedByteSize(@Nullable Integer n) {
        this.retainedByteSize = n;
    }

    @Nullable
    public final Integer getRetainedObjectCount() {
        return this.retainedObjectCount;
    }

    public final void setRetainedObjectCount(@Nullable Integer n) {
        this.retainedObjectCount = n;
    }

    @NotNull
    public final List<String> getNotes() {
        return this.notes;
    }

    public final void setNotes(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.notes = list2;
    }

    @Nullable
    public final ReferencingField getReferencingField() {
        return this.referencingField;
    }

    public final void setReferencingField(@Nullable ReferencingField referencingField) {
        this.referencingField = referencingField;
    }

    @NotNull
    public String toString() {
        return Node.toString$android_sdktools_leakcanarylib$default(this, "", "", true, null, 8, null);
    }

    @NotNull
    public final String toString$android_sdktools_leakcanarylib(@NotNull String firstLinePrefix, @NotNull String additionalLinesPrefix, boolean showLeakingStatus, @NotNull String typeName) {
        StringBuilder stringBuilder;
        String string2;
        Intrinsics.checkNotNullParameter((Object)firstLinePrefix, (String)"firstLinePrefix");
        Intrinsics.checkNotNullParameter((Object)additionalLinesPrefix, (String)"additionalLinesPrefix");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String leakStatus = switch (WhenMappings.$EnumSwitchMapping$0[this.leakingStatus.ordinal()]) {
            case 1 -> "UNKNOWN";
            case 2 -> "NO (" + this.leakingStatusReason + ")";
            case 3 -> "YES (" + this.leakingStatusReason + ")";
            default -> throw new NoWhenBranchMatchedException();
        };
        Integer n = this.retainedByteSize;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            string2 = this.humanReadableByteCount(it);
        } else {
            string2 = null;
        }
        String humanReadableRetainedHeapSize = string2;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u241.append(firstLinePrefix + this.className + " " + typeName);
        if (showLeakingStatus) {
            $this$toString_u24lambda_u241.append("\n" + additionalLinesPrefix + "Leaking: " + leakStatus);
        }
        if (humanReadableRetainedHeapSize != null) {
            $this$toString_u24lambda_u241.append("\n" + additionalLinesPrefix + "Retaining " + humanReadableRetainedHeapSize + " in " + this.retainedObjectCount + " objects");
        }
        for (String label : this.notes) {
            $this$toString_u24lambda_u241.append("\n" + additionalLinesPrefix + label);
        }
        if (this.referencingField != null) {
            $this$toString_u24lambda_u241.append(String.valueOf(this.referencingField));
        }
        String result2 = stringBuilder.toString();
        return result2;
    }

    public static /* synthetic */ String toString$android_sdktools_leakcanarylib$default(Node node, String string2, String string3, boolean bl, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            String string5 = node.nodeType.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            string4 = string5;
        }
        return node.toString$android_sdktools_leakcanarylib(string2, string3, bl, string4);
    }

    private final String humanReadableByteCount(long bytes) {
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "kMGTPE".charAt(exp - 1);
        Locale locale = Locale.ROOT;
        String string2 = "%.1f %sB";
        Object[] objectArray = new Object[]{(double)bytes / Math.pow(unit, exp), Character.valueOf(pre)};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @NotNull
    public final LeakTraceNodeType component1() {
        return this.nodeType;
    }

    @NotNull
    public final String component2() {
        return this.className;
    }

    @NotNull
    public final LeakingStatus component3() {
        return this.leakingStatus;
    }

    @NotNull
    public final String component4() {
        return this.leakingStatusReason;
    }

    @Nullable
    public final Integer component5() {
        return this.retainedByteSize;
    }

    @Nullable
    public final Integer component6() {
        return this.retainedObjectCount;
    }

    @NotNull
    public final List<String> component7() {
        return this.notes;
    }

    @Nullable
    public final ReferencingField component8() {
        return this.referencingField;
    }

    @NotNull
    public final Node copy(@NotNull LeakTraceNodeType nodeType, @NotNull String className, @NotNull LeakingStatus leakingStatus, @NotNull String leakingStatusReason, @Nullable Integer retainedByteSize, @Nullable Integer retainedObjectCount, @NotNull List<String> notes, @Nullable ReferencingField referencingField) {
        Intrinsics.checkNotNullParameter((Object)((Object)nodeType), (String)"nodeType");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)((Object)leakingStatus), (String)"leakingStatus");
        Intrinsics.checkNotNullParameter((Object)leakingStatusReason, (String)"leakingStatusReason");
        Intrinsics.checkNotNullParameter(notes, (String)"notes");
        return new Node(nodeType, className, leakingStatus, leakingStatusReason, retainedByteSize, retainedObjectCount, notes, referencingField);
    }

    public static /* synthetic */ Node copy$default(Node node, LeakTraceNodeType leakTraceNodeType, String string2, LeakingStatus leakingStatus, String string3, Integer n, Integer n2, List list2, ReferencingField referencingField, int n3, Object object) {
        if ((n3 & 1) != 0) {
            leakTraceNodeType = node.nodeType;
        }
        if ((n3 & 2) != 0) {
            string2 = node.className;
        }
        if ((n3 & 4) != 0) {
            leakingStatus = node.leakingStatus;
        }
        if ((n3 & 8) != 0) {
            string3 = node.leakingStatusReason;
        }
        if ((n3 & 0x10) != 0) {
            n = node.retainedByteSize;
        }
        if ((n3 & 0x20) != 0) {
            n2 = node.retainedObjectCount;
        }
        if ((n3 & 0x40) != 0) {
            list2 = node.notes;
        }
        if ((n3 & 0x80) != 0) {
            referencingField = node.referencingField;
        }
        return node.copy(leakTraceNodeType, string2, leakingStatus, string3, n, n2, list2, referencingField);
    }

    public int hashCode() {
        int result2 = this.nodeType.hashCode();
        result2 = result2 * 31 + this.className.hashCode();
        result2 = result2 * 31 + this.leakingStatus.hashCode();
        result2 = result2 * 31 + this.leakingStatusReason.hashCode();
        result2 = result2 * 31 + (this.retainedByteSize == null ? 0 : ((Object)this.retainedByteSize).hashCode());
        result2 = result2 * 31 + (this.retainedObjectCount == null ? 0 : ((Object)this.retainedObjectCount).hashCode());
        result2 = result2 * 31 + ((Object)this.notes).hashCode();
        result2 = result2 * 31 + (this.referencingField == null ? 0 : this.referencingField.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Node)) {
            return false;
        }
        Node node = (Node)other;
        if (this.nodeType != node.nodeType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.className, (Object)node.className)) {
            return false;
        }
        if (this.leakingStatus != node.leakingStatus) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.leakingStatusReason, (Object)node.leakingStatusReason)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.retainedByteSize, (Object)node.retainedByteSize)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.retainedObjectCount, (Object)node.retainedObjectCount)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.notes, node.notes)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.referencingField, (Object)node.referencingField);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/leakcanarylib/data/Node$Companion;", "", "<init>", "()V", "ZERO_WIDTH_SPACE", "", "fromString", "Lcom/android/tools/leakcanarylib/data/Node;", "input", "", "android.sdktools.leakcanarylib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Node fromString(@NotNull String input) {
            Node node;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (StringsKt.startsWith$default((String)input, (String)"\u2570\u2192 ", (boolean)false, (int)2, null)) {
                node = NodeParser.Companion.parseLeakNode(StringsKt.lines((CharSequence)input), "\u2570\u2192 ", "\u200b  ", "\u200b     ");
            } else {
                NodeParser.Companion companion = NodeParser.Companion;
                List list2 = StringsKt.lines((CharSequence)input);
                node = companion.parse(list2, "\u251c\u2500 ", "\u2502    ", "\u2502  ", "\u2502    \u2193");
            }
            return node;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LeakingStatus.values().length];
            try {
                nArray[LeakingStatus.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LeakingStatus.NO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LeakingStatus.YES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

