/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.leakcanarylib.data;

import com.android.tools.leakcanarylib.data.LeakTrace;
import com.android.tools.leakcanarylib.data.LeakType;
import com.android.tools.leakcanarylib.parser.LeakParser;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010 \u001a\u00020\u0007H\u0016J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003JA\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006,"}, d2={"Lcom/android/tools/leakcanarylib/data/Leak;", "", "type", "Lcom/android/tools/leakcanarylib/data/LeakType;", "retainedByteSize", "", "signature", "", "leakTraceCount", "displayedLeakTrace", "", "Lcom/android/tools/leakcanarylib/data/LeakTrace;", "<init>", "(Lcom/android/tools/leakcanarylib/data/LeakType;ILjava/lang/String;ILjava/util/List;)V", "getType", "()Lcom/android/tools/leakcanarylib/data/LeakType;", "setType", "(Lcom/android/tools/leakcanarylib/data/LeakType;)V", "getRetainedByteSize", "()I", "setRetainedByteSize", "(I)V", "getSignature", "()Ljava/lang/String;", "setSignature", "(Ljava/lang/String;)V", "getLeakTraceCount", "setLeakTraceCount", "getDisplayedLeakTrace", "()Ljava/util/List;", "setDisplayedLeakTrace", "(Ljava/util/List;)V", "toString", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "Companion", "android.sdktools.leakcanarylib"})
public final class Leak {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LeakType type;
    private int retainedByteSize;
    @NotNull
    private String signature;
    private int leakTraceCount;
    @NotNull
    private List<LeakTrace> displayedLeakTrace;

    public Leak(@NotNull LeakType type, int retainedByteSize, @NotNull String signature, int leakTraceCount, @NotNull List<LeakTrace> displayedLeakTrace) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(displayedLeakTrace, (String)"displayedLeakTrace");
        this.type = type;
        this.retainedByteSize = retainedByteSize;
        this.signature = signature;
        this.leakTraceCount = leakTraceCount;
        this.displayedLeakTrace = displayedLeakTrace;
    }

    @NotNull
    public final LeakType getType() {
        return this.type;
    }

    public final void setType(@NotNull LeakType leakType) {
        Intrinsics.checkNotNullParameter((Object)((Object)leakType), (String)"<set-?>");
        this.type = leakType;
    }

    public final int getRetainedByteSize() {
        return this.retainedByteSize;
    }

    public final void setRetainedByteSize(int n) {
        this.retainedByteSize = n;
    }

    @NotNull
    public final String getSignature() {
        return this.signature;
    }

    public final void setSignature(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.signature = string2;
    }

    public final int getLeakTraceCount() {
        return this.leakTraceCount;
    }

    public final void setLeakTraceCount(int n) {
        this.leakTraceCount = n;
    }

    @NotNull
    public final List<LeakTrace> getDisplayedLeakTrace() {
        return this.displayedLeakTrace;
    }

    public final void setDisplayedLeakTrace(@NotNull List<LeakTrace> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.displayedLeakTrace = list2;
    }

    @NotNull
    public String toString() {
        return (String)(this.retainedByteSize >= 0 ? this.retainedByteSize + " bytes retained by leaking objects\n" : "") + (String)(this.leakTraceCount > 1 ? "Displaying only 1 leak trace out of " + this.leakTraceCount + " with the same signature\n" : "") + "Signature: " + this.signature + "\n" + CollectionsKt.first(this.displayedLeakTrace);
    }

    @NotNull
    public final LeakType component1() {
        return this.type;
    }

    public final int component2() {
        return this.retainedByteSize;
    }

    @NotNull
    public final String component3() {
        return this.signature;
    }

    public final int component4() {
        return this.leakTraceCount;
    }

    @NotNull
    public final List<LeakTrace> component5() {
        return this.displayedLeakTrace;
    }

    @NotNull
    public final Leak copy(@NotNull LeakType type, int retainedByteSize, @NotNull String signature, int leakTraceCount, @NotNull List<LeakTrace> displayedLeakTrace) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(displayedLeakTrace, (String)"displayedLeakTrace");
        return new Leak(type, retainedByteSize, signature, leakTraceCount, displayedLeakTrace);
    }

    public static /* synthetic */ Leak copy$default(Leak leak, LeakType leakType, int n, String string2, int n2, List list2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            leakType = leak.type;
        }
        if ((n3 & 2) != 0) {
            n = leak.retainedByteSize;
        }
        if ((n3 & 4) != 0) {
            string2 = leak.signature;
        }
        if ((n3 & 8) != 0) {
            n2 = leak.leakTraceCount;
        }
        if ((n3 & 0x10) != 0) {
            list2 = leak.displayedLeakTrace;
        }
        return leak.copy(leakType, n, string2, n2, list2);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.retainedByteSize);
        result2 = result2 * 31 + this.signature.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.leakTraceCount);
        result2 = result2 * 31 + ((Object)this.displayedLeakTrace).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Leak)) {
            return false;
        }
        Leak leak = (Leak)other;
        if (this.type != leak.type) {
            return false;
        }
        if (this.retainedByteSize != leak.retainedByteSize) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signature, (Object)leak.signature)) {
            return false;
        }
        if (this.leakTraceCount != leak.leakTraceCount) {
            return false;
        }
        return Intrinsics.areEqual(this.displayedLeakTrace, leak.displayedLeakTrace);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/leakcanarylib/data/Leak$Companion;", "", "<init>", "()V", "fromString", "", "Lcom/android/tools/leakcanarylib/data/Leak;", "lines", "", "type", "Lcom/android/tools/leakcanarylib/data/LeakType;", "android.sdktools.leakcanarylib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Leak> fromString(@NotNull String lines, @NotNull LeakType type) {
            Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return LeakParser.Companion.fromString(lines, type);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

