/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model.component;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.manifest.parser.components.IntentFilter;
import com.android.tools.manifest.parser.components.ManifestActivityInfo;
import com.android.utils.ILogger;
import java.util.Optional;

public class Activity
extends AppComponent {
    private static final String DEFAULT_CATEGORY = "android.intent.category.LAUNCHER";
    private static final String DEFAULT_ACTION = "android.intent.action.MAIN";

    public Activity(ManifestActivityInfo info, String appId, ILogger logger) {
        super(appId, info, logger);
    }

    @Override
    public void activate(String extraFlags, AppComponent.Mode activationMode, IShellOutputReceiver receiver, IDevice device2) throws DeployerException {
        extraFlags = ((String)extraFlags).trim();
        this.logger.info("Activating Activity '%s' %s on device %s", new Object[]{this.info.getQualifiedName(), activationMode.equals((Object)AppComponent.Mode.DEBUG) ? "for debug" : "", device2.getSerialNumber()});
        if (activationMode.equals((Object)AppComponent.Mode.DEBUG) && !((String)extraFlags).contains(Flag.ENABLE_DEBUGGING.string)) {
            extraFlags = "-D" + (String)(((String)extraFlags).isEmpty() ? "" : " " + (String)extraFlags);
        }
        String command = this.getStartActivityCommand((String)extraFlags);
        this.logger.info("$ adb shell " + command, new Object[0]);
        this.runShellCommand(command, receiver, device2);
    }

    private String getStartActivityCommand(String extraFlags) {
        return "am start -n " + this.getFQEscapedName() + " -a android.intent.action.MAIN -c " + this.getIntentCategory() + (String)(extraFlags.isEmpty() ? "" : " " + extraFlags);
    }

    private String getIntentCategory() {
        Optional<String> category;
        Optional<IntentFilter> filterWithCategory = this.info.getIntentFilters().stream().filter(filter2 -> filter2.hasAction(DEFAULT_ACTION)).filter(filter2 -> !filter2.getCategories().isEmpty()).findFirst();
        if (filterWithCategory.isPresent() && (category = filterWithCategory.get().getCategories().stream().filter(c -> !c.trim().isEmpty()).findFirst()).isPresent()) {
            return category.get();
        }
        return DEFAULT_CATEGORY;
    }

    private static enum Flag {
        ENABLE_DEBUGGING("-D", false),
        WAIT_FOR_LAUNCH("-W", false),
        REPEAT("-R", true),
        STOP_FORCE("-S", false),
        START_PROFILING_WITH_STOP("-P", true),
        START_PROFILING("--START-PROFILER", true),
        OPENGL_TRACE("--OPENGL-TRACE", false),
        USER("--USER", true);

        public final String string;
        public final boolean hasArgument;

        private Flag(String flag, boolean hasArgument) {
            this.string = flag;
            this.hasArgument = hasArgument;
        }

        public static Flag getFlag(String value) {
            for (Flag v : Flag.values()) {
                if (!v.string.equalsIgnoreCase(value)) continue;
                return v;
            }
            throw new IllegalArgumentException();
        }
    }
}

