/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model;

import com.android.tools.deployer.ZipUtils;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.manifest.parser.components.ManifestActivityInfo;
import com.android.tools.manifest.parser.components.ManifestReceiverInfo;
import com.android.tools.manifest.parser.components.ManifestServiceInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class Apk
implements Serializable {
    public final String name;
    public final String checksum;
    public final String path;
    public final String packageName;
    public final boolean debuggable;
    public final List<String> libraryAbis;
    public final List<String> targetPackages;
    public final transient List<ManifestActivityInfo> activities;
    public final transient List<ManifestReceiverInfo> receivers;
    public final transient List<ManifestServiceInfo> services;
    public final Map<String, ApkEntry> apkEntries;
    public final List<String> sdkLibraries;

    private Apk(String name, String checksum, String path, String packageName, boolean debuggable, List<String> libraryAbis, List<String> targetPackages, List<ManifestServiceInfo> services, List<ManifestActivityInfo> activities, List<ManifestReceiverInfo> receivers, List<String> sdkLibraries, Map<String, ApkEntry> apkEntries) {
        this.name = name;
        this.checksum = checksum;
        this.path = path;
        this.packageName = packageName;
        this.debuggable = debuggable;
        this.libraryAbis = libraryAbis;
        this.targetPackages = targetPackages;
        this.sdkLibraries = sdkLibraries;
        this.services = services;
        this.activities = activities;
        this.receivers = receivers;
        this.apkEntries = apkEntries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<String> libraryAbis = ImmutableList.builder();
        private final ImmutableMap.Builder<String, ApkEntry> apkEntries = ImmutableMap.builder();
        private String name = "";
        private String checksum = "";
        private String path = "";
        private String packageName = "";
        private boolean debuggable;
        private List<String> targetPackages = null;
        private List<ManifestServiceInfo> services = null;
        private List<ManifestReceiverInfo> receivers;
        private List<ManifestActivityInfo> activities = null;
        private List<String> sdkLibraries = null;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setChecksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder setTargetPackages(List<String> targetPackages) {
            this.targetPackages = targetPackages;
            return this;
        }

        public Builder setServices(List<ManifestServiceInfo> services) {
            this.services = services;
            return this;
        }

        public Builder setActivities(List<ManifestActivityInfo> activities) {
            this.activities = activities;
            return this;
        }

        public Builder setReceivers(List<ManifestReceiverInfo> receivers) {
            this.receivers = receivers;
            return this;
        }

        public Builder setSdkLibraries(List<String> sdkLibraries) {
            this.sdkLibraries = sdkLibraries;
            return this;
        }

        public Builder setDebuggable(boolean debuggable) {
            this.debuggable = debuggable;
            return this;
        }

        public Builder addLibraryAbi(String abi) {
            this.libraryAbis.add((Object)abi);
            return this;
        }

        @VisibleForTesting
        public Builder addApkEntry(String name, long checksum) {
            this.apkEntries.put((Object)name, (Object)new ApkEntry(name, checksum, null));
            return this;
        }

        public Builder addApkEntry(ZipUtils.ZipEntry zipEntry) {
            this.apkEntries.put((Object)zipEntry.name, (Object)new ApkEntry(zipEntry));
            return this;
        }

        public Apk build() {
            this.targetPackages = this.targetPackages == null ? ImmutableList.of() : this.targetPackages;
            this.services = this.services == null ? ImmutableList.of() : this.services;
            this.activities = this.activities == null ? ImmutableList.of() : this.activities;
            this.sdkLibraries = this.sdkLibraries == null ? ImmutableList.of() : this.sdkLibraries;
            Apk apk = new Apk(this.name, this.checksum, this.path, this.packageName, this.debuggable, (List<String>)this.libraryAbis.build(), this.targetPackages, this.services, this.activities, this.receivers, this.sdkLibraries, (Map<String, ApkEntry>)this.apkEntries.build());
            apk.apkEntries.values().forEach(entry -> entry.setApk(apk));
            return apk;
        }
    }
}

