/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.adblib.AdbLogger;
import com.android.utils.StdLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployerRunnerAdbLogger
extends AdbLogger {
    private final StdLogger logger;
    private final StdLogger.Level level;
    private final String category;

    public DeployerRunnerAdbLogger(StdLogger.Level level, String category) {
        this.logger = new StdLogger(level);
        this.level = level;
        this.category = category;
    }

    @Override
    @NotNull
    public AdbLogger.Level getMinLevel() {
        switch (this.level) {
            case INFO: {
                return AdbLogger.Level.INFO;
            }
            case WARNING: {
                return AdbLogger.Level.WARN;
            }
            case ERROR: {
                return AdbLogger.Level.ERROR;
            }
        }
        return AdbLogger.Level.VERBOSE;
    }

    @Override
    public void log(@NotNull AdbLogger.Level level, @NotNull String message) {
        message = this.category + ":" + (String)message;
        switch (level) {
            case INFO: {
                this.logger.info((String)message, new Object[0]);
                break;
            }
            case WARN: {
                this.logger.warning((String)message, new Object[0]);
                break;
            }
            case DEBUG: 
            case VERBOSE: {
                this.logger.verbose((String)message, new Object[0]);
                break;
            }
            case ERROR: {
                this.logger.error(null, (String)message, new Object[0]);
            }
        }
    }

    @Override
    public void log(@NotNull AdbLogger.Level level, @Nullable Throwable exception, @NotNull String message) {
        message = this.category + ":" + (String)message;
        switch (level) {
            case INFO: {
                this.logger.info((String)message, new Object[0]);
                if (exception == null) break;
                this.logger.info(this.exceptionToString(exception), new Object[0]);
                break;
            }
            case WARN: {
                this.logger.warning((String)message, new Object[0]);
                if (exception == null) break;
                this.logger.warning(this.exceptionToString(exception), new Object[0]);
                break;
            }
            case DEBUG: 
            case VERBOSE: {
                this.logger.verbose((String)message, new Object[0]);
                if (exception == null) break;
                this.logger.verbose(this.exceptionToString(exception), new Object[0]);
                break;
            }
            case ERROR: {
                this.logger.error(exception, (String)message, new Object[0]);
            }
        }
    }

    private String exceptionToString(Throwable exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        return sw.toString();
    }
}

