/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkEntry;
import com.android.utils.ILogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApkChecker {
    private final String deploySessionId;
    private final ILogger logger;

    ApkChecker(String deploySessionId, ILogger logger) {
        this.deploySessionId = deploySessionId;
        this.logger = logger;
    }

    boolean log(List<Apk> apks) {
        for (Apk apk : apks) {
            String fingerprint = apk.checksum;
            Path path = Paths.get(apk.path, new String[0]);
            long size = -1L;
            String creationTime = "NOT_AVAILABLE";
            String lastModifiedTime = "NOT_AVAILABLE";
            String lastAccessTime = "NOT_AVAILABLE";
            try {
                BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                size = attr.size();
                creationTime = attr.creationTime().toString();
                lastModifiedTime = attr.lastModifiedTime().toString();
                lastAccessTime = attr.lastAccessTime().toString();
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, "Unable to perform APKChecker logging on file %s", new Object[]{path.toString()});
            }
            LinkedHashMap<String, Long> dexChecksumSorted = new LinkedHashMap<String, Long>();
            for (Map.Entry<String, ApkEntry> entry : apk.apkEntries.entrySet()) {
                String name = entry.getKey();
                if (!name.endsWith(".dex")) continue;
                dexChecksumSorted.put(entry.getKey(), entry.getValue().getChecksum());
            }
            StringBuilder dexChecksums = new StringBuilder();
            for (Map.Entry entry : dexChecksumSorted.entrySet()) {
                dexChecksums.append((String)entry.getKey());
                dexChecksums.append("='");
                dexChecksums.append(entry.getValue());
                dexChecksums.append("' ");
            }
            this.logger.info("Deploy APK Check session='%s', path='%s', size='%,d', fingerprint='%s', crTime='%s', modTime='%s', acTime='%s' %s", new Object[]{this.deploySessionId, apk.path, size, fingerprint, creationTime, lastModifiedTime, lastAccessTime, dexChecksums});
        }
        return true;
    }
}

