/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveManager;
import com.android.tools.apk.analyzer.internal.ApkArchive;
import com.android.tools.apk.analyzer.internal.AppBundleArchive;
import com.android.tools.apk.analyzer.internal.ArchiveContextImpl;
import com.android.tools.apk.analyzer.internal.MapUtils;
import com.android.tools.apk.analyzer.internal.ZipArchive;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.TraceUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipError;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchiveManagerImpl
implements ArchiveManager {
    private static final List<String> INNER_ZIP_EXTENSIONS = ImmutableList.of((Object)".zip", (Object)".apk", (Object)".jar");
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Map<Path, Archive> archives = new HashMap<Path, Archive>();
    @NotNull
    private final Map<Archive, Path> tempDirectories = new TreeMap<Archive, Path>(new ArchivePathComparator());

    public ArchiveManagerImpl(@NotNull ILogger logger) {
        this.logger = logger;
    }

    @Override
    @NotNull
    public ArchiveContext openArchive(@NotNull Path path) throws IOException {
        Archive archive = MapUtils.computeIfAbsent(this.archives, path, this::openArchiveWorker);
        return new ArchiveContextImpl(this, archive);
    }

    @Override
    @Nullable
    public Archive openInnerArchive(@NotNull Archive archive, @NotNull Path childPath) throws IOException {
        String childFileName = childPath.getFileName().toString();
        if (INNER_ZIP_EXTENSIONS.stream().noneMatch(childFileName::endsWith)) {
            return null;
        }
        this.logger.info(String.format("Opening inner archive \"%s\" of \"%s\"", childPath, archive.getPath()), new Object[0]);
        Path tempFolder = this.createTempDirectory(archive);
        Path contentRoot = archive.getContentRoot();
        Path tempFile = tempFolder.resolve(contentRoot.relativize(childPath).toString());
        return MapUtils.computeIfAbsent(this.archives, tempFile, file -> {
            this.logger.info(String.format("Extracting inner archive \"%s\"", file), new Object[0]);
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            FileUtils.copyFile((Path)childPath, (Path)file);
            try {
                return ArchiveManagerImpl.openInnerArchiveWorker(file);
            }
            catch (IOException | ZipError e) {
                this.logger.warning(String.format("Error loading entry from archive \"%s\"\n\"%s\"", file, TraceUtils.getStackTrace((Throwable)e)), new Object[0]);
                throw e;
            }
        });
    }

    @Override
    public void close() throws IOException {
        for (Archive archive : this.archives.values()) {
            this.logger.info(String.format("Closing archive \"%s\"", archive.getPath()), new Object[0]);
            archive.close();
        }
        this.archives.clear();
        for (Path dir : this.tempDirectories.values()) {
            this.logger.info(String.format("Deleting temp directory \"%s\"", dir), new Object[0]);
            FileUtils.deleteRecursivelyIfExists((File)dir.toFile());
        }
        this.tempDirectories.clear();
    }

    @NotNull
    private Path createTempDirectory(@NotNull Archive archive) throws IOException {
        return MapUtils.computeIfAbsent(this.tempDirectories, archive, archive1 -> {
            Path dir = Files.createTempDirectory(archive1.getPath().getFileName().toString(), new FileAttribute[0]);
            this.logger.info(String.format("Creating temp directory \"%s\" for archive \"%s\"", dir, archive1.getPath()), new Object[0]);
            return dir;
        });
    }

    @NotNull
    private Archive openArchiveWorker(@NotNull Path path) throws IOException {
        this.logger.info(String.format("Opening archive \"%s\"", path), new Object[0]);
        if (ArchiveManagerImpl.hasFileExtension(path, "aab")) {
            return AppBundleArchive.fromBundleFile(path);
        }
        if (ArchiveManagerImpl.hasFileExtension(path, "apk")) {
            return new ApkArchive(path);
        }
        return new ZipArchive(path);
    }

    @NotNull
    private static Archive openInnerArchiveWorker(@NotNull Path archive) throws IOException {
        if (ArchiveManagerImpl.hasFileExtension(archive, "apk")) {
            return new ApkArchive(archive);
        }
        ArchiveManagerImpl.validateZipFile(archive);
        return new ZipArchive(archive);
    }

    private static void validateZipFile(@NotNull Path archive) throws IOException {
        try (FileInputStream fis = new FileInputStream(archive.toString());
             ZipInputStream zis = new ZipInputStream(fis);){
            if (zis.getNextEntry() == null) {
                throw new ZipError("No valid contents inside");
            }
            while (zis.getNextEntry() != null) {
            }
        }
    }

    private static boolean hasFileExtension(@NotNull Path path, @NotNull String extension) {
        if (!((String)extension).startsWith(".")) {
            extension = "." + (String)extension;
        }
        return path.getFileName().toString().toLowerCase(Locale.ROOT).endsWith((String)extension);
    }

    private static class ArchivePathComparator
    implements Comparator<Archive> {
        private ArchivePathComparator() {
        }

        @Override
        public int compare(Archive o1, Archive o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }
}

