/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.ResourceIdResolver;
import com.android.xml.XmlBuilder;
import com.google.common.collect.Lists;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlAttribute;
import com.google.devrel.gmscore.tools.apk.arsc.XmlChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlEndElementChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceEndChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNamespaceStartChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlResourceMapChunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlStartElementChunk;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryXmlParser {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.######");
    private static final String[] DIMENSION_UNITS = new String[]{"px", "dp", "sp", "pt", "in", "mm"};
    private static final String[] FACTION_UNITS = new String[]{"%", "%p"};
    private static final String UNKNOWN_UNIT = "???";
    private static final int[] RADIX_SHIFTS = new int[]{23, 16, 8, 0};
    private static final int COMPLEX_RADIX_SHIFT = 4;
    private static final int COMPLEX_RADIX_MASK = 3;
    private static final int COMPLEX_MANTISSA_SHIFT = 8;
    private static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    private static final int COMPLEX_UNIT_SHIFT = 0;
    private static final int COMPLEX_UNIT_MASK = 15;

    @NotNull
    public static byte[] decodeXml(@NotNull byte[] bytes, @NotNull ResourceIdResolver resIdResolver) {
        ResourceFile file = new ResourceFile(bytes);
        List<Chunk> chunks = file.getChunks();
        if (chunks.size() != 1) {
            return bytes;
        }
        if (!(chunks.get(0) instanceof XmlChunk)) {
            return bytes;
        }
        XmlPrinter printer = new XmlPrinter(resIdResolver);
        XmlChunk xmlChunk = (XmlChunk)chunks.get(0);
        BinaryXmlParser.visitChunks(xmlChunk.getChunks(), printer);
        String reconstructedXml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + printer.getReconstructedXml();
        return reconstructedXml.getBytes(StandardCharsets.UTF_8);
    }

    @NotNull
    public static byte[] decodeXml(@NotNull byte[] bytes) {
        return BinaryXmlParser.decodeXml(bytes, ResourceIdResolver.NO_RESOLUTION);
    }

    private static void visitChunks(@NotNull Map<Integer, Chunk> chunks, @NotNull XmlChunkHandler handler2) {
        List<Chunk> contentChunks = BinaryXmlParser.sortByOffset(chunks);
        for (Chunk chunk : contentChunks) {
            if (chunk instanceof StringPoolChunk) {
                handler2.stringPool((StringPoolChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlResourceMapChunk) {
                handler2.xmlResourceMap((XmlResourceMapChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceStartChunk) {
                handler2.startNamespace((XmlNamespaceStartChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlNamespaceEndChunk) {
                handler2.endNamespace((XmlNamespaceEndChunk)chunk);
                continue;
            }
            if (chunk instanceof XmlStartElementChunk) {
                handler2.startElement((XmlStartElementChunk)chunk);
                continue;
            }
            if (!(chunk instanceof XmlEndElementChunk)) continue;
            handler2.endElement((XmlEndElementChunk)chunk);
        }
    }

    @NotNull
    private static List<Chunk> sortByOffset(Map<Integer, Chunk> contentChunks) {
        ArrayList offsets = Lists.newArrayList(contentChunks.keySet());
        Collections.sort(offsets);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(offsets.size());
        for (Integer offset : offsets) {
            chunks.add(contentChunks.get(offset));
        }
        return chunks;
    }

    public static String formatValue(@NotNull ResourceValue resValue, @Nullable StringPoolChunk stringPool, @NotNull ResourceIdResolver resourceIdResolver) {
        int data = resValue.data();
        switch (resValue.type()) {
            case NULL: {
                return data == 1 ? "@empty" : "@null";
            }
            case DYNAMIC_REFERENCE: 
            case REFERENCE: {
                if (data == 0) {
                    return "@null";
                }
                return resourceIdResolver.resolve(data);
            }
            case ATTRIBUTE: 
            case DYNAMIC_ATTRIBUTE: {
                return "?" + resourceIdResolver.resolve(data).substring(1);
            }
            case STRING: {
                return stringPool != null && data < stringPool.getStringCount() ? stringPool.getString(data) : String.format(Locale.US, "@string/0x%1$x", data);
            }
            case DIMENSION: {
                return BinaryXmlParser.complexToString(data, false);
            }
            case FRACTION: {
                return BinaryXmlParser.complexToString(data, true);
            }
            case FLOAT: {
                return DECIMAL_FORMAT.format(Float.intBitsToFloat(data));
            }
            case INT_DEC: {
                return Integer.toString(data);
            }
            case INT_HEX: {
                return "0x" + Integer.toHexString(data);
            }
            case INT_BOOLEAN: {
                return Boolean.toString(data != 0);
            }
            case INT_COLOR_ARGB8: {
                return String.format("#%08X", data);
            }
            case INT_COLOR_RGB8: {
                return String.format("#%06X", 0xFFFFFF & data);
            }
            case INT_COLOR_ARGB4: {
                return String.format("#%04X", 0xFFFF & data);
            }
            case INT_COLOR_RGB4: {
                return String.format("#%03X", 0xFFF & data);
            }
        }
        return String.format("@res/0x%x", data);
    }

    public static String formatValue(@NotNull ResourceValue resValue, @Nullable StringPoolChunk stringPool) {
        return BinaryXmlParser.formatValue(resValue, stringPool, ResourceIdResolver.NO_RESOLUTION);
    }

    private static String complexToString(int complexValue, boolean isFraction) {
        int radix = complexValue >> 4 & 3;
        long mantissa = (long)(complexValue >> 8 & 0xFFFFFF) << RADIX_SHIFTS[radix];
        float value = (float)mantissa * 1.1920929E-7f;
        if (isFraction) {
            value *= 100.0f;
        }
        int unitType = complexValue >> 0 & 0xF;
        String[] unitValues = isFraction ? FACTION_UNITS : DIMENSION_UNITS;
        String units = unitType < unitValues.length ? unitValues[unitType] : UNKNOWN_UNIT;
        return String.format("%s%s", DECIMAL_FORMAT.format(value), units);
    }

    private static class XmlPrinter
    implements XmlChunkHandler {
        private final XmlBuilder builder;
        private Map<String, String> namespaces = new HashMap<String, String>();
        private boolean namespacesAdded;
        private StringPoolChunk stringPool;
        private final ResourceIdResolver resIdResolver;

        public XmlPrinter(@NotNull ResourceIdResolver resourceIdResolver) {
            this.builder = new XmlBuilder();
            this.resIdResolver = resourceIdResolver;
        }

        @Override
        public void stringPool(@NotNull StringPoolChunk chunk) {
            this.stringPool = chunk;
        }

        @Override
        public void startNamespace(@NotNull XmlNamespaceStartChunk chunk) {
            this.namespaces.put(chunk.getUri(), chunk.getPrefix());
        }

        @Override
        public void startElement(@NotNull XmlStartElementChunk chunk) {
            this.builder.startTag(chunk.getName());
            if (!this.namespacesAdded && !this.namespaces.isEmpty()) {
                this.namespacesAdded = true;
                for (Map.Entry entry : this.namespaces.entrySet()) {
                    this.builder.attribute("xmlns", (String)entry.getValue(), (String)entry.getKey());
                }
            }
            for (XmlAttribute xmlAttribute : chunk.getAttributes()) {
                String prefix = XmlPrinter.notNullize(this.namespaces.get(xmlAttribute.namespace()));
                this.builder.attribute(prefix, xmlAttribute.name(), this.getValue(xmlAttribute));
            }
        }

        public static String notNullize(@Nullable String s) {
            return s == null ? "" : s;
        }

        @Override
        public void endElement(@NotNull XmlEndElementChunk chunk) {
            this.builder.endTag(chunk.getName());
        }

        @NotNull
        public String getReconstructedXml() {
            return this.builder.toString();
        }

        @NotNull
        private String getValue(@NotNull XmlAttribute attribute) {
            String rawValue = attribute.rawValue();
            if (rawValue != null && !rawValue.isEmpty()) {
                return rawValue;
            }
            ResourceValue resValue = attribute.typedValue();
            return BinaryXmlParser.formatValue(resValue, this.stringPool, this.resIdResolver);
        }
    }

    private static interface XmlChunkHandler {
        default public void stringPool(@NotNull StringPoolChunk chunk) {
        }

        default public void xmlResourceMap(@NotNull XmlResourceMapChunk chunk) {
        }

        default public void startNamespace(@NotNull XmlNamespaceStartChunk chunk) {
        }

        default public void endNamespace(@NotNull XmlNamespaceEndChunk chunk) {
        }

        default public void startElement(@NotNull XmlStartElementChunk chunk) {
        }

        default public void endElement(@NotNull XmlEndElementChunk chunk) {
        }
    }
}

