/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.internal.ApkArchive;
import com.android.tools.apk.analyzer.internal.AppBundleArchive;
import com.android.tools.apk.analyzer.internal.ArchiveManagerImpl;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Archives {
    @NotNull
    public static ArchiveContext open(@NotNull Path path) throws IOException {
        return Archives.open(path, NullLogger.getLogger());
    }

    @NotNull
    public static ArchiveContext open(@NotNull Path path, @NotNull ILogger logger) throws IOException {
        ArchiveManagerImpl archiveManager = new ArchiveManagerImpl(logger);
        return archiveManager.openArchive(path);
    }

    @Nullable
    public static ArchiveEntry getFirstManifestArchiveEntry(@NotNull ArchiveNode input) {
        if (input.getData().getArchive() instanceof ApkArchive) {
            Archive archive = input.getData().getArchive();
            return Archives.getTopLevelManifestEntry(input, archive);
        }
        if (input.getData().getArchive() instanceof AppBundleArchive) {
            AppBundleArchive appBundleArchive = (AppBundleArchive)input.getData().getArchive();
            ArchiveNode baseDir = Archives.getChild(input, appBundleArchive.getContentRoot().resolve("base/"));
            if (baseDir == null) {
                return null;
            }
            ArchiveNode manifestDir = Archives.getChild(baseDir, baseDir.getData().getPath().resolve("manifest/"));
            if (manifestDir == null) {
                return null;
            }
            ArchiveNode manifest = Archives.getChild(manifestDir, manifestDir.getData().getPath().resolve("AndroidManifest.xml"));
            if (manifest == null) {
                return null;
            }
            return manifest.getData();
        }
        return null;
    }

    @Nullable
    private static ArchiveNode getChild(@NotNull ArchiveNode input, @NotNull Path path) {
        return input.getChildren().stream().filter(node -> node.getData().getPath().equals(path)).findFirst().orElse(null);
    }

    @Nullable
    private static ArchiveEntry getTopLevelManifestEntry(@NotNull ArchiveNode input, Archive archive) {
        Path path = archive.getContentRoot().resolve("AndroidManifest.xml");
        return input.getChildren().stream().filter(x -> x.getData().getPath().equals(path)).map(ArchiveNode::getData).findFirst().orElse(null);
    }
}

