/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicAttrReference;
import com.android.resources.base.BasicForeignAttrResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BasicAttrResourceItem
extends BasicValueResourceItemBase
implements AttrResourceValue {
    private Set<AttributeFormat> myFormats;
    private final Map<String, Integer> myValueMap;
    private final Map<String, String> myValueDescriptionMap;
    private final String myDescription;
    private final String myGroupName;

    public BasicAttrResourceItem(String name, ResourceSourceFile sourceFile, ResourceVisibility visibility, String description, String groupName, Set<AttributeFormat> formats, Map<String, Integer> valueMap, Map<String, String> valueDescriptionMap) {
        super(ResourceType.ATTR, name, sourceFile, visibility);
        this.myDescription = description;
        this.myGroupName = groupName;
        this.myFormats = ImmutableSet.copyOf(formats);
        this.myValueMap = valueMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(valueMap);
        this.myValueDescriptionMap = valueDescriptionMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(valueDescriptionMap);
    }

    public final Set<AttributeFormat> getFormats() {
        return this.myFormats;
    }

    public final void setFormats(Set<AttributeFormat> formats) {
        this.myFormats = ImmutableSet.copyOf(formats);
    }

    public final Map<String, Integer> getAttributeValues() {
        return this.myValueMap;
    }

    public final String getValueDescription(String valueName) {
        return this.myValueDescriptionMap.get(valueName);
    }

    public final String getDescription() {
        return this.myDescription;
    }

    public final String getGroupName() {
        return this.myGroupName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicAttrResourceItem other = (BasicAttrResourceItem)obj;
        return Objects.equals(this.myDescription, other.myDescription) && Objects.equals(this.myGroupName, other.myGroupName) && this.myFormats.equals(other.myFormats) && this.myValueMap.equals(other.myValueMap) && this.myValueDescriptionMap.equals(other.myValueDescriptionMap);
    }

    public BasicAttrReference createReference() {
        BasicAttrReference attrReference = new BasicAttrReference(this.getNamespace(), this.getName(), this.getSourceFile(), this.getVisibility(), this.myDescription, this.myGroupName);
        attrReference.setNamespaceResolver(this.getNamespaceResolver());
        return attrReference;
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        BasicAttrResourceItem.serializeAttrValue(this, this.getRepository().getNamespace(), stream);
    }

    static void serializeAttrValue(AttrResourceValue attr, ResourceNamespace defaultNamespace, Base128OutputStream stream) throws IOException {
        ResourceNamespace namespace = attr.getNamespace();
        String namespaceSuffix = namespace.equals((Object)defaultNamespace) ? null : namespace.getXmlNamespaceUri().substring("http://schemas.android.com/".length());
        stream.writeString(namespaceSuffix);
        stream.writeString(attr.getDescription());
        stream.writeString(attr.getGroupName());
        int formatMask = 0;
        for (AttributeFormat format : attr.getFormats()) {
            formatMask |= 1 << format.ordinal();
        }
        stream.writeInt(formatMask);
        Map attributeValues = attr.getAttributeValues();
        stream.writeInt(attributeValues.size());
        for (Map.Entry entry : attributeValues.entrySet()) {
            String name = (String)entry.getKey();
            stream.writeString(name);
            Integer value = (Integer)entry.getValue();
            int v = value == null ? Integer.MIN_VALUE : value + 1;
            stream.writeInt(v);
            String description = attr.getValueDescription(name);
            stream.writeString(description);
        }
    }

    static BasicValueResourceItemBase deserialize(Base128InputStream stream, String name, ResourceVisibility visibility, ResourceSourceFile sourceFile, ResourceNamespace.Resolver resolver) throws IOException {
        BasicValueResourceItemBase item;
        String namespaceSuffix = stream.readString();
        String description = stream.readString();
        String groupName = stream.readString();
        int formatMask = stream.readInt();
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        AttributeFormat[] attributeFormatValues = AttributeFormat.values();
        for (int ordinal = 0; ordinal < attributeFormatValues.length && formatMask != 0; ++ordinal, formatMask >>>= 1) {
            if ((formatMask & 1) == 0) continue;
            formats.add(attributeFormatValues[ordinal]);
        }
        int n = stream.readInt();
        HashMap valueMap = n == 0 ? Collections.emptyMap() : Maps.newHashMapWithExpectedSize((int)n);
        HashMap descriptionMap = n == 0 ? Collections.emptyMap() : Maps.newHashMapWithExpectedSize((int)n);
        for (int i = 0; i < n; ++i) {
            String valueDescription;
            String valueName = stream.readString();
            int value = stream.readInt();
            if (value != Integer.MIN_VALUE) {
                valueMap.put(valueName, value - 1);
            }
            if ((valueDescription = stream.readString()) == null) continue;
            descriptionMap.put(valueName, valueDescription);
        }
        if (formats.isEmpty() && valueMap.isEmpty()) {
            ResourceNamespace resourceNamespace = namespace = namespaceSuffix == null ? sourceFile.getRepository().getNamespace() : ResourceNamespace.fromNamespaceUri((String)("http://schemas.android.com/" + namespaceSuffix));
            if (namespace == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            item = new BasicAttrReference(namespace, name, sourceFile, visibility, description, groupName);
        } else if (namespaceSuffix == null) {
            item = new BasicAttrResourceItem(name, sourceFile, visibility, description, groupName, formats, valueMap, descriptionMap);
        } else {
            namespace = ResourceNamespace.fromNamespaceUri((String)("http://schemas.android.com/" + namespaceSuffix));
            if (namespace == null) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            item = new BasicForeignAttrResourceItem(namespace, name, sourceFile, description, groupName, formats, (Map<String, Integer>)valueMap, (Map<String, String>)descriptionMap);
        }
        item.setNamespaceResolver(resolver);
        return item;
    }
}

