/*
 * Decompiled with CFR 0.152.
 */
package com.android.processmonitor.monitor;

import com.android.adblib.AdbLogger;
import com.android.processmonitor.common.ProcessEvent;
import com.android.processmonitor.common.ProcessTracker;
import com.android.processmonitor.monitor.ProcessNames;
import com.android.processmonitor.utils.RetainingMap;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020\u0007J\b\u0010 \u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/processmonitor/monitor/PerDeviceMonitor;", "Ljava/io/Closeable;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "logger", "Lcom/android/adblib/AdbLogger;", "maxProcessRetention", "", "processTracker", "Lcom/android/processmonitor/common/ProcessTracker;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/android/adblib/AdbLogger;ILcom/android/processmonitor/common/ProcessTracker;)V", "getProcessTracker", "()Lcom/android/processmonitor/common/ProcessTracker;", "scope", "getScope$annotations", "()V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "processes", "Lcom/android/processmonitor/utils/RetainingMap;", "Lcom/android/processmonitor/monitor/ProcessNames;", "start", "", "handleProcessRemoved", "it", "Lcom/android/processmonitor/common/ProcessEvent$ProcessRemoved;", "handleProcessAdded", "e", "Lcom/android/processmonitor/common/ProcessEvent$ProcessAdded;", "getProcessNames", "pid", "close", "android.sdktools.process-monitor"})
@SourceDebugExtension(value={"SMAP\nPerDeviceMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerDeviceMonitor.kt\ncom/android/processmonitor/monitor/PerDeviceMonitor\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLogger\n*L\n1#1,107:1\n46#2:108\n26#2,4:109\n47#2:113\n38#2:114\n26#2,14:115\n38#2:129\n26#2,14:130\n38#2:144\n26#2,14:145\n38#2:159\n26#2,14:160\n46#2:174\n26#2,4:175\n47#2:179\n*S KotlinDebug\n*F\n+ 1 PerDeviceMonitor.kt\ncom/android/processmonitor/monitor/PerDeviceMonitor\n*L\n61#1:108\n61#1:109,4\n61#1:113\n78#1:114\n78#1:115,14\n82#1:129\n82#1:130,14\n87#1:144\n87#1:145,14\n91#1:159\n91#1:160,14\n94#1:174\n94#1:175,4\n94#1:179\n*E\n"})
public final class PerDeviceMonitor
implements Closeable {
    @NotNull
    private final AdbLogger logger;
    @NotNull
    private final ProcessTracker processTracker;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final RetainingMap<Integer, ProcessNames> processes;

    public PerDeviceMonitor(@NotNull CoroutineScope parentScope, @NotNull AdbLogger logger, int maxProcessRetention, @NotNull ProcessTracker processTracker) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)processTracker, (String)"processTracker");
        this.logger = logger;
        this.processTracker = processTracker;
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)parentScope.getCoroutineContext().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.processes = new RetainingMap(maxProcessRetention);
    }

    @NotNull
    public final ProcessTracker getProcessTracker() {
        return this.processTracker;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @VisibleForTesting
    public static /* synthetic */ void getScope$annotations() {
    }

    public final void start() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PerDeviceMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getProcessTracker().trackProcesses().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ PerDeviceMonitor this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(ProcessEvent it, Continuation<? super Unit> $completion) {
                                ProcessEvent processEvent = it;
                                if (processEvent instanceof ProcessEvent.ProcessRemoved) {
                                    PerDeviceMonitor.access$handleProcessRemoved(this.this$0, (ProcessEvent.ProcessRemoved)it);
                                } else if (processEvent instanceof ProcessEvent.ProcessAdded) {
                                    PerDeviceMonitor.access$handleProcessAdded(this.this$0, (ProcessEvent.ProcessAdded)it);
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleProcessRemoved(ProcessEvent.ProcessRemoved it) {
        void this_$iv$iv;
        AdbLogger this_$iv = this.logger;
        boolean $i$f$debug = false;
        AdbLogger adbLogger = this_$iv;
        AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
        boolean $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            AdbLogger.Level level = level$iv$iv;
            void var8_8 = this_$iv$iv;
            boolean bl = false;
            String string2 = "Removing " + it.getPid();
            var8_8.log(level, string2);
        }
        this.processes.remove(it.getPid());
    }

    private final void handleProcessAdded(ProcessEvent.ProcessAdded e) {
        Object object;
        AdbLogger adbLogger;
        AdbLogger.Level level;
        AdbLogger this_$iv$iv;
        boolean $i$f$logIf;
        AdbLogger.Level level$iv$iv;
        AdbLogger this_$iv;
        ProcessNames newNames;
        int pid = e.getPid();
        ProcessNames names = e.toProcessNames();
        ProcessNames processNames = this.processes.get(pid);
        ProcessNames processNames2 = processNames;
        ProcessNames processNames3 = newNames = Intrinsics.areEqual((Object)(processNames2 != null ? processNames2.getProcessName() : null), (Object)e.getProcessName()) && e.getApplicationId() == null ? processNames : names;
        if (this.logger.getMinLevel().compareTo((Enum)AdbLogger.Level.VERBOSE) <= 0) {
            if (processNames == null) {
                this_$iv = this.logger;
                $i$f$verbose = false;
                AdbLogger adbLogger2 = this_$iv;
                level$iv$iv = AdbLogger.Level.VERBOSE;
                $i$f$logIf = false;
                if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                    level = level$iv$iv;
                    adbLogger = this_$iv$iv;
                    boolean bl = false;
                    object = "New process added";
                    adbLogger.log(level, (String)object);
                }
            } else if (!Intrinsics.areEqual((Object)e.getProcessName(), (Object)processNames.getProcessName())) {
                this_$iv = this.logger;
                $i$f$verbose = false;
                this_$iv$iv = this_$iv;
                level$iv$iv = AdbLogger.Level.VERBOSE;
                $i$f$logIf = false;
                if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                    level = level$iv$iv;
                    adbLogger = this_$iv$iv;
                    boolean bl = false;
                    object = "New process with same pid";
                    adbLogger.log(level, (String)object);
                }
            } else if (e.getApplicationId() == null) {
                this_$iv = this.logger;
                $i$f$verbose = false;
                this_$iv$iv = this_$iv;
                level$iv$iv = AdbLogger.Level.VERBOSE;
                $i$f$logIf = false;
                if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                    level = level$iv$iv;
                    adbLogger = this_$iv$iv;
                    boolean bl = false;
                    object = "Existing process without applicationId";
                    adbLogger.log(level, (String)object);
                }
            } else {
                this_$iv = this.logger;
                $i$f$verbose = false;
                this_$iv$iv = this_$iv;
                level$iv$iv = AdbLogger.Level.VERBOSE;
                $i$f$logIf = false;
                if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                    level = level$iv$iv;
                    adbLogger = this_$iv$iv;
                    boolean bl = false;
                    object = "Existing process with an applicationId";
                    adbLogger.log(level, (String)object);
                }
            }
        }
        this_$iv = this.logger;
        boolean $i$f$debug = false;
        this_$iv$iv = this_$iv;
        level$iv$iv = AdbLogger.Level.DEBUG;
        $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            level = level$iv$iv;
            adbLogger = this_$iv$iv;
            boolean bl = false;
            object = "Adding " + newNames;
            adbLogger.log(level, (String)object);
        }
        this.processes.set(pid, newNames);
    }

    @Nullable
    public final ProcessNames getProcessNames(int pid) {
        return this.processes.get(pid);
    }

    @Override
    public void close() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
    }

    public static final /* synthetic */ void access$handleProcessRemoved(PerDeviceMonitor $this, ProcessEvent.ProcessRemoved it) {
        $this.handleProcessRemoved(it);
    }

    public static final /* synthetic */ void access$handleProcessAdded(PerDeviceMonitor $this, ProcessEvent.ProcessAdded e) {
        $this.handleProcessAdded(e);
    }
}

