/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.CmdSets;
import com.android.jdwptracer.Command;
import com.android.jdwptracer.DdmJDWPTiming;
import com.android.jdwptracer.Event;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.NamedEvent;
import com.android.jdwptracer.Reply;
import com.android.jdwptracer.Session;
import com.android.jdwptracer.Transmission;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class SystraceOutput {
    SystraceOutput() {
    }

    static void genOutput(Session session2, Path path) {
        List<Event> events = session2.events();
        try {
            FileWriter out = new FileWriter(path.toAbsolutePath().toString());
            JsonArray root2 = new JsonArray();
            for (int i = 0; i < events.size(); ++i) {
                Event event = events.get(i);
                if (event instanceof Transmission) {
                    SystraceOutput.processTransmission(root2, (Transmission)event);
                    continue;
                }
                if (event instanceof NamedEvent) {
                    SystraceOutput.processNamedEvent(root2, (NamedEvent)event);
                    continue;
                }
                throw new IllegalStateException("Unknown type of event");
            }
            SystraceOutput.addARTTimings(session2, root2);
            SystraceOutput.nameProcess(root2, "JDWP packets, session");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            out.write(gson.toJson((JsonElement)root2));
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addARTTimings(Session session2, JsonArray root2) throws IOException {
        DdmJDWPTiming timing;
        Map<Integer, DdmJDWPTiming> idToArtTimings = session2.timings();
        List<Transmission> transmissions = SystraceOutput.event2Transmission(session2.events());
        long minDiff_ns = Long.MAX_VALUE;
        long clockDelta_ns = 0L;
        for (Transmission t : transmissions) {
            if (!t.reply().isPresent() || !idToArtTimings.containsKey(t.jdpwId())) continue;
            timing = idToArtTimings.get(t.jdpwId());
            long duration_ns = timing.duration_ns();
            long transmDuration_ns = t.reply().get().time_ns() - t.cmd().time_ns();
            long diff_ns = transmDuration_ns - duration_ns;
            if (diff_ns >= minDiff_ns) continue;
            minDiff_ns = diff_ns;
            clockDelta_ns = t.cmd().time_ns() - timing.start_ns() + (transmDuration_ns - duration_ns) / 2L;
        }
        for (Transmission t : transmissions) {
            if (!t.reply().isPresent() || !idToArtTimings.containsKey(t.jdpwId())) continue;
            timing = idToArtTimings.get(t.jdpwId());
            long startTime = timing.start_ns() + clockDelta_ns;
            SystraceOutput.emitCompleteEvent(root2, SystraceOutput.ns2us(startTime), SystraceOutput.ns2us(timing.duration_ns()), t.line(), "art");
        }
    }

    private static List<Transmission> event2Transmission(List<Event> events) {
        ArrayList<Transmission> transmissions = new ArrayList<Transmission>();
        for (Event event : events) {
            if (!(event instanceof Transmission)) continue;
            transmissions.add((Transmission)event);
        }
        return transmissions;
    }

    private static void processNamedEvent(JsonArray root2, NamedEvent event) throws IOException {
        String name = event.name();
        SystraceOutput.emitInstantEvent(root2, SystraceOutput.ns2us(event.time_ns()), event.line(), name);
        SystraceOutput.emitThreadMetadata(root2, event.line(), name);
    }

    private static void processTransmission(JsonArray root2, Transmission transmission) throws IOException {
        Command command = transmission.cmd();
        CmdSet cmdset = CmdSets.get(transmission.cmd().cmdSetID());
        String name = cmdset.name() + ":" + cmdset.cmdName(transmission.cmd().cmdID());
        if (!command.message().name().isEmpty()) {
            name = name + ":" + command.message().name();
        }
        JsonObject args = new JsonObject();
        args.addProperty("id", "0x" + Integer.toHexString(transmission.jdpwId()));
        if (transmission.reply().isPresent()) {
            Reply reply = transmission.reply().get();
            long duration = reply.time_ns() - command.time_ns();
            args.add("cmd", (JsonElement)SystraceOutput.makeMessagePayload(command.message()));
            args.add("reply", (JsonElement)SystraceOutput.makeMessagePayload(reply.message()));
            SystraceOutput.emitCompleteEvent(root2, SystraceOutput.ns2us(command.time_ns()), SystraceOutput.ns2us(duration), transmission.line(), name, args);
        } else {
            args.add("event", (JsonElement)SystraceOutput.makeMessagePayload(command.message()));
            SystraceOutput.emitInstantEvent(root2, SystraceOutput.ns2us(command.time_ns()), transmission.line(), name, args);
        }
        SystraceOutput.emitThreadMetadata(root2, transmission.line(), name);
    }

    private static JsonObject makeMessagePayload(Message message) {
        JsonObject payloadObject = new JsonObject();
        payloadObject.addProperty("length", (Number)message.payloadLength());
        JsonObject arguments = message.args();
        if (arguments.size() > 0) {
            payloadObject.add("payload", (JsonElement)arguments);
        }
        return payloadObject;
    }

    private static void emitCompleteEvent(JsonArray root2, long startTime_us, long duration_us, int line, String name) throws IOException {
        SystraceOutput.emitCompleteEvent(root2, startTime_us, duration_us, line, name, new JsonObject());
    }

    private static void emitCompleteEvent(JsonArray root2, long startTime, long duration_us, int i, String name, JsonObject args) throws IOException {
        JsonObject part = new JsonObject();
        part.addProperty("name", name);
        part.addProperty("cat", "foo");
        part.addProperty("ph", "X");
        part.addProperty("ts", (Number)startTime);
        part.addProperty("dur", (Number)duration_us);
        part.addProperty("pid", (Number)0);
        part.addProperty("tid", (Number)i);
        part.add("args", (JsonElement)args);
        root2.add((JsonElement)part);
    }

    private static void emitInstantEvent(JsonArray root2, long time_us, int lineID, String name) throws IOException {
        SystraceOutput.emitInstantEvent(root2, time_us, lineID, name, new JsonObject());
    }

    private static void emitInstantEvent(JsonArray root2, long time_us, int threadID, String name, JsonObject args) throws IOException {
        JsonObject part = new JsonObject();
        part.addProperty("name", name);
        part.addProperty("ph", "i");
        part.addProperty("ts", (Number)time_us);
        part.addProperty("pid", (Number)0);
        part.addProperty("tid", (Number)threadID);
        part.addProperty("s", "t");
        if (args != null) {
            part.add("args", (JsonElement)args);
        }
        root2.add((JsonElement)part);
    }

    private static void emitThreadMetadata(JsonArray root2, int threadID, String name) {
        JsonObject threadNameMeta = new JsonObject();
        threadNameMeta.addProperty("name", "thread_name");
        threadNameMeta.addProperty("ph", "M");
        threadNameMeta.addProperty("pid", (Number)0);
        threadNameMeta.addProperty("tid", (Number)threadID);
        JsonObject argsName = new JsonObject();
        argsName.addProperty("name", name);
        threadNameMeta.add("args", (JsonElement)argsName);
        root2.add((JsonElement)threadNameMeta);
        JsonObject part = new JsonObject();
        part.addProperty("name", "thread_sort_index");
        part.addProperty("ph", "M");
        part.addProperty("pid", (Number)0);
        part.addProperty("tid", (Number)threadID);
        JsonObject argsOrder = new JsonObject();
        argsOrder.addProperty("sort_index", (Number)threadID);
        part.add("args", (JsonElement)argsOrder);
        root2.add((JsonElement)part);
    }

    private static void nameProcess(JsonArray root2, String name) throws IOException {
        JsonObject args = new JsonObject();
        args.addProperty("name", name);
        JsonObject part = new JsonObject();
        part.addProperty("name", "process_name");
        part.addProperty("ph", "M");
        part.addProperty("pid", (Number)0);
        part.add("args", (JsonElement)args);
        root2.add((JsonElement)part);
    }

    private static long ns2us(long time_ns) {
        return time_ns / 1000L;
    }
}

