/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.threadreference.FramesCmd;
import com.android.jdwppacket.threadreference.FramesCountCmd;
import com.android.jdwppacket.threadreference.FramesCountReply;
import com.android.jdwppacket.threadreference.FramesReply;
import com.android.jdwppacket.threadreference.NameCmd;
import com.android.jdwppacket.threadreference.NameReply;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.JsonLocation;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.Session;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class CmdSetThreadReference
extends CmdSet {
    protected CmdSetThreadReference() {
        super(11, "THREAD_REF");
        this.add(1, "Name", CmdSetThreadReference::parseNameCmd, CmdSetThreadReference::parseNameReply);
        this.add(2, "Suspend");
        this.add(3, "Resume");
        this.add(4, "Status");
        this.add(5, "ThreadGroup");
        this.add(6, "Frames", CmdSetThreadReference::parseFramesCmd, CmdSetThreadReference::parseFramesReply);
        this.add(7, "FrameCount", CmdSetThreadReference::parseFramesCountCmd, CmdSetThreadReference::parseFramesCountReply);
        this.add(8, "OwnerMonitors");
        this.add(9, "CurrentContendedMonitor");
        this.add(10, "Stop");
        this.add(11, "Interrupt");
        this.add(12, "SuspendCount");
        this.add(13, "OwnerMonitorStackDepthInfo");
        this.add(14, "ForceEarlyReturn");
    }

    private static Message parseFramesCountReply(MessageReader reader, Session session2) {
        FramesCountReply reply = FramesCountReply.parse(reader);
        Message message = new Message(reader);
        message.addArg("count", reply.getCount());
        return message;
    }

    private static Message parseFramesCountCmd(MessageReader reader, Session session2) {
        FramesCountCmd cmd = FramesCountCmd.parse(reader);
        Message message = new Message(reader);
        message.addArg("threadID", cmd.getThreadID());
        return message;
    }

    private static Message parseNameReply(MessageReader reader, Session session2) {
        NameReply reply = NameReply.parse(reader);
        Message message = new Message(reader);
        message.addArg("name", reply.getName());
        return message;
    }

    private static Message parseNameCmd(MessageReader reader, Session session2) {
        NameCmd cmd = NameCmd.parse(reader);
        Message message = new Message(reader);
        message.addArg("threadID", cmd.getThreadID());
        return message;
    }

    private static Message parseFramesCmd(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        FramesCmd cmd = FramesCmd.parse(reader);
        message.addArg("threadID", cmd.getThreadID());
        message.addArg("startFrame", cmd.getStartFrame());
        message.addArg("length", cmd.getLength());
        return message;
    }

    private static Message parseFramesReply(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        FramesReply frames = FramesReply.parse(reader);
        JsonArray framesArray = new JsonArray();
        for (FramesReply.Frame frame : frames.getFrames()) {
            JsonObject jsonFrame = new JsonObject();
            jsonFrame.addProperty("frameID", (Number)frame.getId());
            jsonFrame.add("location", (JsonElement)JsonLocation.get(frame.getLocation()));
            framesArray.add((JsonElement)jsonFrame);
        }
        message.addArg("frames", (JsonElement)framesArray);
        return message;
    }
}

