/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.ui.ImageViewer;
import com.android.draw9patch.ui.PatchInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class StretchesViewer
extends JPanel {
    public static final float DEFAULT_SCALE = 2.0f;
    private static final int MARGIN = 24;
    private final Container container;
    private final ImageViewer viewer;
    private final TexturePaint texture;
    private BufferedImage image;
    private PatchInfo patchInfo;
    private StretchView horizontal;
    private StretchView vertical;
    private StretchView both;
    private Dimension size;
    private float horizontalPatchesSum;
    private float verticalPatchesSum;
    private boolean showPadding;

    StretchesViewer(Container container, ImageViewer viewer, TexturePaint texture) {
        this.container = container;
        this.viewer = viewer;
        this.texture = texture;
        this.image = viewer.getImage();
        this.patchInfo = viewer.getPatchInfo();
        viewer.addPatchUpdateListener(new ImageViewer.PatchUpdateListener(){

            @Override
            public void patchesUpdated() {
                StretchesViewer.this.computePatches();
            }
        });
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(24, 24, 24, 24));
        this.horizontal = new StretchView();
        this.vertical = new StretchView();
        this.both = new StretchView();
        this.setScale(2.0f);
        this.add((Component)this.vertical, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.horizontal, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.both, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(this.texture);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.dispose();
    }

    void setScale(float scale) {
        int patchWidth = this.image.getWidth() - 2;
        int patchHeight = this.image.getHeight() - 2;
        int scaledWidth = (int)((float)patchWidth * scale);
        int scaledHeight = (int)((float)patchHeight * scale);
        this.horizontal.scaledWidth = scaledWidth;
        this.vertical.scaledHeight = scaledHeight;
        this.both.scaledWidth = scaledWidth;
        this.both.scaledHeight = scaledHeight;
        this.size = new Dimension(scaledWidth, scaledHeight);
        this.computePatches();
    }

    void computePatches() {
        int start2;
        this.image = this.viewer.getImage();
        this.patchInfo = this.viewer.getPatchInfo();
        boolean measuredWidth = false;
        boolean endRow = true;
        int remainderHorizontal = 0;
        int remainderVertical = 0;
        if (!this.patchInfo.fixed.isEmpty()) {
            start2 = this.patchInfo.fixed.get((int)0).y;
            for (Rectangle rect : this.patchInfo.fixed) {
                if (rect.y > start2) {
                    endRow = true;
                    measuredWidth = true;
                }
                if (!measuredWidth) {
                    remainderHorizontal += rect.width;
                }
                if (!endRow) continue;
                remainderVertical += rect.height;
                endRow = false;
                start2 = rect.y;
            }
        } else {
            for (Rectangle rect : this.patchInfo.verticalPatches) {
                remainderHorizontal += rect.width;
            }
            for (Rectangle rect : this.patchInfo.horizontalPatches) {
                remainderVertical += rect.height;
            }
        }
        this.horizontal.remainderHorizontal = this.horizontal.scaledWidth - remainderHorizontal;
        this.vertical.remainderHorizontal = this.vertical.scaledWidth - remainderHorizontal;
        this.both.remainderHorizontal = this.both.scaledWidth - remainderHorizontal;
        this.horizontal.remainderVertical = this.horizontal.scaledHeight - remainderVertical;
        this.vertical.remainderVertical = this.vertical.scaledHeight - remainderVertical;
        this.both.remainderVertical = this.both.scaledHeight - remainderVertical;
        this.horizontalPatchesSum = 0.0f;
        if (!this.patchInfo.horizontalPatches.isEmpty()) {
            start2 = -1;
            for (Rectangle rect : this.patchInfo.horizontalPatches) {
                if (rect.x <= start2) continue;
                this.horizontalPatchesSum += (float)rect.width;
                start2 = rect.x;
            }
        } else {
            start2 = -1;
            for (Rectangle rect : this.patchInfo.patches) {
                if (rect.x <= start2) continue;
                this.horizontalPatchesSum += (float)rect.width;
                start2 = rect.x;
            }
        }
        this.verticalPatchesSum = 0.0f;
        if (!this.patchInfo.verticalPatches.isEmpty()) {
            start2 = -1;
            for (Rectangle rect : this.patchInfo.verticalPatches) {
                if (rect.y <= start2) continue;
                this.verticalPatchesSum += (float)rect.height;
                start2 = rect.y;
            }
        } else {
            start2 = -1;
            for (Rectangle rect : this.patchInfo.patches) {
                if (rect.y <= start2) continue;
                this.verticalPatchesSum += (float)rect.height;
                start2 = rect.y;
            }
        }
        this.setSize(this.size);
        this.container.validate();
        this.repaint();
    }

    void setPaddingVisible(boolean visible) {
        this.showPadding = visible;
        this.repaint();
    }

    private class StretchView
    extends JComponent {
        private final Color PADDING_COLOR = new Color(0.37f, 0.37f, 1.0f, 0.5f);
        int scaledWidth;
        int scaledHeight;
        int remainderHorizontal;
        int remainderVertical;

        StretchView() {
            this.scaledWidth = StretchesViewer.this.image.getWidth();
            this.scaledHeight = StretchesViewer.this.image.getHeight();
        }

        @Override
        protected void paintComponent(Graphics g) {
            int x = (this.getWidth() - this.scaledWidth) / 2;
            int y = (this.getHeight() - this.scaledHeight) / 2;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.translate(x, y);
            x = 0;
            y = 0;
            if (StretchesViewer.this.patchInfo.patches.isEmpty()) {
                g.drawImage(StretchesViewer.this.image, 0, 0, this.scaledWidth, this.scaledHeight, null);
                g2.dispose();
                return;
            }
            int fixedIndex = 0;
            int horizontalIndex = 0;
            int verticalIndex = 0;
            int patchIndex = 0;
            float vWeightSum = 1.0f;
            float vRemainder = this.remainderVertical;
            boolean vStretch = StretchesViewer.this.patchInfo.verticalStartWithPatch;
            while (y < this.scaledHeight - 1) {
                boolean hStretch = StretchesViewer.this.patchInfo.horizontalStartWithPatch;
                int height = 0;
                float vExtra = 0.0f;
                float hWeightSum = 1.0f;
                float hRemainder = this.remainderHorizontal;
                while (x < this.scaledWidth - 1) {
                    if (!vStretch) {
                        if (hStretch) {
                            r = StretchesViewer.this.patchInfo.horizontalPatches.get(horizontalIndex++);
                            extra = (float)r.width / StretchesViewer.this.horizontalPatchesSum;
                            width = (int)(extra * hRemainder / hWeightSum);
                            hWeightSum -= extra;
                            hRemainder -= (float)width;
                            g.drawImage(StretchesViewer.this.image, x, y, x + width, y + r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                            x += width;
                        } else {
                            r = StretchesViewer.this.patchInfo.fixed.get(fixedIndex++);
                            g.drawImage(StretchesViewer.this.image, x, y, x + r.width, y + r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                            x += r.width;
                        }
                        height = r.height;
                    } else if (hStretch) {
                        r = StretchesViewer.this.patchInfo.patches.get(patchIndex++);
                        vExtra = (float)r.height / StretchesViewer.this.verticalPatchesSum;
                        height = (int)(vExtra * vRemainder / vWeightSum);
                        extra = (float)r.width / StretchesViewer.this.horizontalPatchesSum;
                        width = (int)(extra * hRemainder / hWeightSum);
                        hWeightSum -= extra;
                        hRemainder -= (float)width;
                        g.drawImage(StretchesViewer.this.image, x, y, x + width, y + height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                        x += width;
                    } else {
                        r = StretchesViewer.this.patchInfo.verticalPatches.get(verticalIndex++);
                        vExtra = (float)r.height / StretchesViewer.this.verticalPatchesSum;
                        height = (int)(vExtra * vRemainder / vWeightSum);
                        g.drawImage(StretchesViewer.this.image, x, y, x + r.width, y + height, r.x, r.y, r.x + r.width, r.y + r.height, null);
                        x += r.width;
                    }
                    hStretch = !hStretch;
                }
                x = 0;
                y += height;
                if (vStretch) {
                    vWeightSum -= vExtra;
                    vRemainder -= (float)height;
                }
                vStretch = !vStretch;
            }
            if (StretchesViewer.this.showPadding) {
                g.setColor(this.PADDING_COLOR);
                g.fillRect((Integer)StretchesViewer.this.patchInfo.horizontalPadding.first, (Integer)StretchesViewer.this.patchInfo.verticalPadding.first, this.scaledWidth - (Integer)StretchesViewer.this.patchInfo.horizontalPadding.first - (Integer)StretchesViewer.this.patchInfo.horizontalPadding.second, this.scaledHeight - (Integer)StretchesViewer.this.patchInfo.verticalPadding.first - (Integer)StretchesViewer.this.patchInfo.verticalPadding.second);
            }
            g2.dispose();
        }

        @Override
        public Dimension getPreferredSize() {
            return StretchesViewer.this.size;
        }
    }
}

