/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Log;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import com.android.ddmlib.jdwp.JdwpExtension;
import com.android.ddmlib.jdwp.JdwpInterceptor;
import com.android.ddmlib.jdwp.JdwpPipe;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DdmJdwpExtension
extends JdwpExtension {
    private final ConcurrentMap<Integer, ChunkHandler> mHandlerMap = new ConcurrentHashMap<Integer, ChunkHandler>();

    @Override
    public void intercept(ClientImpl client) {
        client.addJdwpInterceptor(new DdmInterceptor(client));
    }

    public void registerHandler(int type, ChunkHandler handler2) {
        this.mHandlerMap.putIfAbsent(type, handler2);
    }

    public void broadcast(Event event, ClientImpl client) {
        Log.d("ddms", "broadcast " + (Object)((Object)event) + ": " + client);
        HashSet set2 = new HashSet(this.mHandlerMap.values());
        block6: for (ChunkHandler handler2 : set2) {
            switch (event.ordinal()) {
                case 0: {
                    try {
                        handler2.clientReady(client);
                        continue block6;
                    }
                    catch (IOException ioe) {
                        Log.w("ddms", "Got exception while broadcasting 'ready'");
                        return;
                    }
                }
                case 1: {
                    handler2.clientDisconnected(client);
                    continue block6;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    public void ddmSeen(ClientImpl client) {
        if (!client.ddmSeen()) {
            this.broadcast(Event.CLIENT_READY, client);
        }
    }

    static boolean isDdmPacket(JdwpPacket packet) {
        return !packet.isReply() && packet.is(199, 1);
    }

    public class DdmInterceptor
    extends JdwpInterceptor {
        private final ClientImpl mClient;

        public DdmInterceptor(ClientImpl client) {
            this.mClient = client;
        }

        @Override
        public JdwpPacket intercept(JdwpPipe pipe, JdwpPacket packet) {
            if (DdmJdwpExtension.isDdmPacket(packet)) {
                DdmJdwpExtension.this.ddmSeen(this.mClient);
                ByteBuffer buf = packet.getPayload();
                int type = buf.getInt(buf.position());
                ChunkHandler handler2 = (ChunkHandler)DdmJdwpExtension.this.mHandlerMap.get(type);
                if (handler2 == null) {
                    Log.w("ddms", "Received unsupported chunk type " + ChunkHandler.name(type));
                } else {
                    handler2.handlePacket(this.mClient, packet);
                }
                return null;
            }
            return packet;
        }
    }

    public static enum Event {
        CLIENT_READY,
        CLIENT_DISCONNECTED;

    }
}

