/*
 * Decompiled with CFR 0.152.
 */
package com.android.backup;

import com.android.adblib.AdbSession;
import com.android.backup.AdbServicesFactory;
import com.android.backup.AdbServicesFactoryImpl;
import com.android.backup.BackupException;
import com.android.backup.BackupMetadata;
import com.android.backup.BackupProgressListener;
import com.android.backup.BackupResult;
import com.android.backup.BackupServiceImpl;
import com.android.backup.BackupType;
import com.android.backup.ErrorCode;
import com.android.tools.environment.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\bf\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aJ8\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00a6@\u00a2\u0006\u0002\u0010\rJ(\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00a6@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u00a6@\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u001b\u00c0\u0006\u0003"}, d2={"Lcom/android/backup/BackupService;", "", "backup", "Lcom/android/backup/BackupResult;", "serialNumber", "", "applicationId", "type", "Lcom/android/backup/BackupType;", "backupFile", "Ljava/nio/file/Path;", "listener", "Lcom/android/backup/BackupProgressListener;", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/backup/BackupType;Ljava/nio/file/Path;Lcom/android/backup/BackupProgressListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restore", "(Ljava/lang/String;Ljava/nio/file/Path;Lcom/android/backup/BackupProgressListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendUpdateGmsIntent", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getForegroundApplicationId", "isInstalled", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isBackupEnabled", "isPlayStoreInstalled", "getDebuggableApps", "", "Companion", "android.sdktools.backup"})
public interface BackupService {
    @NotNull
    public static final Companion Companion = com.android.backup.BackupService$Companion.$$INSTANCE;
    @NotNull
    public static final String TOKEN_FILE = "restore_token_file";
    @NotNull
    public static final String PM_DATA_FILE = "pm_backup";
    @NotNull
    public static final String APP_DATA_FILE = "app_backup";
    @NotNull
    public static final String AUTH_DATA_FILE = "auth_backup";
    @NotNull
    public static final String PERMISSIONS_FILE = "permissions";
    @NotNull
    public static final String METADATA_FILE = "metadata.txt";
    @NotNull
    public static final String PROPERTY_APPLICATION_ID = "application-id";
    @NotNull
    public static final String PROPERTY_BACKUP_TYPE = "backup-type";

    @Nullable
    public Object backup(@NotNull String var1, @NotNull String var2, @NotNull BackupType var3, @NotNull Path var4, @Nullable BackupProgressListener var5, @NotNull Continuation<? super BackupResult> var6);

    @Nullable
    public Object restore(@NotNull String var1, @NotNull Path var2, @Nullable BackupProgressListener var3, @NotNull Continuation<? super BackupResult> var4);

    @Nullable
    public Object sendUpdateGmsIntent(@NotNull String var1, @NotNull Continuation<? super BackupResult> var2);

    @Nullable
    public Object getForegroundApplicationId(@NotNull String var1, @NotNull Continuation<? super String> var2);

    @Nullable
    public Object isInstalled(@NotNull String var1, @NotNull String var2, @NotNull Continuation<? super Boolean> var3);

    @Nullable
    public Object isBackupEnabled(@NotNull String var1, @NotNull String var2, @NotNull Continuation<? super Boolean> var3);

    @Nullable
    public Object isPlayStoreInstalled(@NotNull String var1, @NotNull Continuation<? super Boolean> var2);

    @Nullable
    public Object getDebuggableApps(@NotNull String var1, @NotNull Continuation<? super List<String>> var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0011\u0010\u001b\u001a\u00020\u0005*\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0011\u0010\u001e\u001a\u00020\u0018*\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001fJ\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/backup/BackupService$Companion;", "", "<init>", "()V", "TOKEN_FILE", "", "PM_DATA_FILE", "APP_DATA_FILE", "AUTH_DATA_FILE", "PERMISSIONS_FILE", "METADATA_FILE", "PROPERTY_APPLICATION_ID", "PROPERTY_BACKUP_TYPE", "getInstance", "Lcom/android/backup/BackupService;", "adbSession", "Lcom/android/adblib/AdbSession;", "logger", "Lcom/android/tools/environment/Logger;", "minGmsVersion", "", "adbServicesFactory", "Lcom/android/backup/AdbServicesFactory;", "validateBackupFile", "Lcom/android/backup/BackupMetadata;", "backupFile", "Ljava/nio/file/Path;", "getRestoreToken", "Ljava/util/zip/ZipFile;", "getRestoreToken$android_sdktools_backup", "getMetaData", "getMetaData$android_sdktools_backup", "getMetadata", "android.sdktools.backup"})
    @SourceDebugExtension(value={"SMAP\nBackupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupService.kt\ncom/android/backup/BackupService$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1163#2,3:149\n1#3:152\n*S KotlinDebug\n*F\n+ 1 BackupService.kt\ncom/android/backup/BackupService$Companion\n*L\n86#1:149,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String TOKEN_FILE = "restore_token_file";
        @NotNull
        public static final String PM_DATA_FILE = "pm_backup";
        @NotNull
        public static final String APP_DATA_FILE = "app_backup";
        @NotNull
        public static final String AUTH_DATA_FILE = "auth_backup";
        @NotNull
        public static final String PERMISSIONS_FILE = "permissions";
        @NotNull
        public static final String METADATA_FILE = "metadata.txt";
        @NotNull
        public static final String PROPERTY_APPLICATION_ID = "application-id";
        @NotNull
        public static final String PROPERTY_BACKUP_TYPE = "backup-type";

        private Companion() {
        }

        @NotNull
        public final BackupService getInstance(@NotNull AdbSession adbSession, @NotNull Logger logger, int minGmsVersion) {
            Intrinsics.checkNotNullParameter((Object)adbSession, (String)"adbSession");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            return new BackupServiceImpl(new AdbServicesFactoryImpl(adbSession, logger, minGmsVersion));
        }

        @NotNull
        public final BackupService getInstance(@NotNull AdbServicesFactory adbServicesFactory) {
            Intrinsics.checkNotNullParameter((Object)adbServicesFactory, (String)"adbServicesFactory");
            return new BackupServiceImpl(adbServicesFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final BackupMetadata validateBackupFile(@NotNull Path backupFile) {
            Intrinsics.checkNotNullParameter((Object)backupFile, (String)"backupFile");
            try {
                Closeable closeable = new ZipFile(((Object)backupFile).toString());
                Throwable throwable = null;
                try {
                    void destination$iv;
                    void $this$mapTo$iv;
                    ZipFile zip = (ZipFile)closeable;
                    boolean bl = false;
                    BackupMetadata metadata = $$INSTANCE.getMetaData$android_sdktools_backup(zip);
                    $$INSTANCE.getRestoreToken$android_sdktools_backup(zip);
                    Enumeration<? extends ZipEntry> enumeration = zip.entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                    Object[] objectArray = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                    Collection collection = new LinkedHashSet();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        ZipEntry zipEntry = (ZipEntry)item$iv;
                        void var13_16 = destination$iv;
                        boolean bl2 = false;
                        var13_16.add(it.getName());
                    }
                    Set filenames = (Set)destination$iv;
                    objectArray = new String[]{"pm_backup", "restore_token_file", "app_backup"};
                    if (!filenames.containsAll(CollectionsKt.listOf((Object[])objectArray))) {
                        throw new BackupException(ErrorCode.INVALID_BACKUP_FILE, "File is not a valid backup file: " + ((Object)backupFile).toString() + " (" + filenames + ")", null, 4, null);
                    }
                    BackupMetadata backupMetadata = metadata;
                    return backupMetadata;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                throw new BackupException(ErrorCode.INVALID_BACKUP_FILE, "File is not a valid backup file: " + ((Object)backupFile).toString(), e);
            }
        }

        @NotNull
        public final String getRestoreToken$android_sdktools_backup(@NotNull ZipFile $this$getRestoreToken) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)$this$getRestoreToken, (String)"<this>");
            try {
                InputStream inputStream2 = $this$getRestoreToken.getInputStream($this$getRestoreToken.getEntry("restore_token_file"));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
                InputStream inputStream3 = inputStream2;
                Charset charset = Charsets.UTF_8;
                string2 = new BigInteger(TextStreamsKt.readText((Reader)new InputStreamReader(inputStream3, charset))).toString(16);
                Intrinsics.checkNotNull((Object)string2);
            }
            catch (Exception e) {
                throw new BackupException(ErrorCode.INVALID_BACKUP_FILE, "Backup file does not contain a valid token: " + $this$getRestoreToken.getName(), e);
            }
            return string2;
        }

        @NotNull
        public final BackupMetadata getMetaData$android_sdktools_backup(@NotNull ZipFile $this$getMetaData) {
            BackupMetadata backupMetadata;
            Intrinsics.checkNotNullParameter((Object)$this$getMetaData, (String)"<this>");
            try {
                Properties properties = new Properties();
                properties.load($this$getMetaData.getInputStream($this$getMetaData.getEntry("metadata.txt")));
                String string2 = properties.getProperty("application-id");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
                String string3 = properties.getProperty("backup-type");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
                backupMetadata = new BackupMetadata(string2, BackupType.valueOf(string3));
            }
            catch (Exception e) {
                throw new BackupException(ErrorCode.INVALID_BACKUP_FILE, "Backup file does not contain metadata: " + $this$getMetaData.getName(), e);
            }
            return backupMetadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final BackupMetadata getMetadata(@NotNull Path backupFile) {
            BackupMetadata backupMetadata;
            Closeable closeable;
            Intrinsics.checkNotNullParameter((Object)backupFile, (String)"backupFile");
            try {
                closeable = new ZipFile(backupFile.toFile());
            }
            catch (Exception e) {
                throw new BackupException(ErrorCode.INVALID_BACKUP_FILE, "File is not a valid backup file: " + backupFile, e);
            }
            ZipFile zipFile = closeable;
            closeable = zipFile;
            Throwable throwable = null;
            try {
                Closeable it = closeable;
                boolean bl = false;
                backupMetadata = $$INSTANCE.getMetaData$android_sdktools_backup((ZipFile)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return backupMetadata;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

