/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging.packets.impl;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\bA\b\u0080\u0081\u0002\u0018\u0000 E2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001EB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bD\u00a8\u0006F"}, d2={"Lcom/android/adblib/tools/debugging/packets/impl/JdwpErrorCode;", "", "errorCode", "", "errorMessage", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getErrorCode", "()I", "getErrorMessage", "()Ljava/lang/String;", "NONE", "INVALID_THREAD", "INVALID_THREAD_GROUP", "INVALID_PRIORITY", "THREAD_NOT_SUSPENDED", "THREAD_SUSPENDED", "THREAD_NOT_ALIVE", "INVALID_OBJECT", "INVALID_CLASS", "CLASS_NOT_PREPARED", "INVALID_METHODID", "INVALID_LOCATION", "INVALID_FIELDID", "INVALID_FRAMEID", "NO_MORE_FRAMES", "OPAQUE_FRAME", "NOT_CURRENT_FRAME", "TYPE_MISMATCH", "INVALID_SLOT", "DUPLICATE", "NOT_FOUND", "INVALID_MONITOR", "NOT_MONITOR_OWNER", "INTERRUPT", "INVALID_CLASS_FORMAT", "CIRCULAR_CLASS_DEFINITION", "FAILS_VERIFICATION", "ADD_METHOD_NOT_IMPLEMENTED", "SCHEMA_CHANGE_NOT_IMPLEMENTED", "INVALID_TYPESTATE", "HIERARCHY_CHANGE_NOT_IMPLEMENTED", "DELETE_METHOD_NOT_IMPLEMENTED", "UNSUPPORTED_VERSION", "NAMES_DONT_MATCH", "CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED", "METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED", "NOT_IMPLEMENTED", "NULL_POINTER", "ABSENT_INFORMATION", "INVALID_EVENT_TYPE", "ILLEGAL_ARGUMENT", "OUT_OF_MEMORY", "ACCESS_DENIED", "VM_DEAD", "INTERNAL", "UNATTACHED_THREAD", "INVALID_TAG", "ALREADY_INVOKING", "INVALID_INDEX", "INVALID_LENGTH", "INVALID_STRING", "INVALID_CLASS_LOADER", "INVALID_ARRAY", "TRANSPORT_LOAD", "TRANSPORT_INIT", "NATIVE_METHOD", "INVALID_COUNT", "Companion", "android.sdktools.adblib.tools"})
public final class JdwpErrorCode
extends Enum<JdwpErrorCode> {
    @NotNull
    public static final Companion Companion;
    private final int errorCode;
    @NotNull
    private final String errorMessage;
    public static final /* enum */ JdwpErrorCode NONE;
    public static final /* enum */ JdwpErrorCode INVALID_THREAD;
    public static final /* enum */ JdwpErrorCode INVALID_THREAD_GROUP;
    public static final /* enum */ JdwpErrorCode INVALID_PRIORITY;
    public static final /* enum */ JdwpErrorCode THREAD_NOT_SUSPENDED;
    public static final /* enum */ JdwpErrorCode THREAD_SUSPENDED;
    public static final /* enum */ JdwpErrorCode THREAD_NOT_ALIVE;
    public static final /* enum */ JdwpErrorCode INVALID_OBJECT;
    public static final /* enum */ JdwpErrorCode INVALID_CLASS;
    public static final /* enum */ JdwpErrorCode CLASS_NOT_PREPARED;
    public static final /* enum */ JdwpErrorCode INVALID_METHODID;
    public static final /* enum */ JdwpErrorCode INVALID_LOCATION;
    public static final /* enum */ JdwpErrorCode INVALID_FIELDID;
    public static final /* enum */ JdwpErrorCode INVALID_FRAMEID;
    public static final /* enum */ JdwpErrorCode NO_MORE_FRAMES;
    public static final /* enum */ JdwpErrorCode OPAQUE_FRAME;
    public static final /* enum */ JdwpErrorCode NOT_CURRENT_FRAME;
    public static final /* enum */ JdwpErrorCode TYPE_MISMATCH;
    public static final /* enum */ JdwpErrorCode INVALID_SLOT;
    public static final /* enum */ JdwpErrorCode DUPLICATE;
    public static final /* enum */ JdwpErrorCode NOT_FOUND;
    public static final /* enum */ JdwpErrorCode INVALID_MONITOR;
    public static final /* enum */ JdwpErrorCode NOT_MONITOR_OWNER;
    public static final /* enum */ JdwpErrorCode INTERRUPT;
    public static final /* enum */ JdwpErrorCode INVALID_CLASS_FORMAT;
    public static final /* enum */ JdwpErrorCode CIRCULAR_CLASS_DEFINITION;
    public static final /* enum */ JdwpErrorCode FAILS_VERIFICATION;
    public static final /* enum */ JdwpErrorCode ADD_METHOD_NOT_IMPLEMENTED;
    public static final /* enum */ JdwpErrorCode SCHEMA_CHANGE_NOT_IMPLEMENTED;
    public static final /* enum */ JdwpErrorCode INVALID_TYPESTATE;
    public static final /* enum */ JdwpErrorCode HIERARCHY_CHANGE_NOT_IMPLEMENTED;
    public static final /* enum */ JdwpErrorCode DELETE_METHOD_NOT_IMPLEMENTED;
    public static final /* enum */ JdwpErrorCode UNSUPPORTED_VERSION;
    public static final /* enum */ JdwpErrorCode NAMES_DONT_MATCH;
    public static final /* enum */ JdwpErrorCode CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED;
    public static final /* enum */ JdwpErrorCode METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED;
    public static final /* enum */ JdwpErrorCode NOT_IMPLEMENTED;
    public static final /* enum */ JdwpErrorCode NULL_POINTER;
    public static final /* enum */ JdwpErrorCode ABSENT_INFORMATION;
    public static final /* enum */ JdwpErrorCode INVALID_EVENT_TYPE;
    public static final /* enum */ JdwpErrorCode ILLEGAL_ARGUMENT;
    public static final /* enum */ JdwpErrorCode OUT_OF_MEMORY;
    public static final /* enum */ JdwpErrorCode ACCESS_DENIED;
    public static final /* enum */ JdwpErrorCode VM_DEAD;
    public static final /* enum */ JdwpErrorCode INTERNAL;
    public static final /* enum */ JdwpErrorCode UNATTACHED_THREAD;
    public static final /* enum */ JdwpErrorCode INVALID_TAG;
    public static final /* enum */ JdwpErrorCode ALREADY_INVOKING;
    public static final /* enum */ JdwpErrorCode INVALID_INDEX;
    public static final /* enum */ JdwpErrorCode INVALID_LENGTH;
    public static final /* enum */ JdwpErrorCode INVALID_STRING;
    public static final /* enum */ JdwpErrorCode INVALID_CLASS_LOADER;
    public static final /* enum */ JdwpErrorCode INVALID_ARRAY;
    public static final /* enum */ JdwpErrorCode TRANSPORT_LOAD;
    public static final /* enum */ JdwpErrorCode TRANSPORT_INIT;
    public static final /* enum */ JdwpErrorCode NATIVE_METHOD;
    public static final /* enum */ JdwpErrorCode INVALID_COUNT;
    private static final /* synthetic */ JdwpErrorCode[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private JdwpErrorCode(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public static JdwpErrorCode[] values() {
        return (JdwpErrorCode[])$VALUES.clone();
    }

    public static JdwpErrorCode valueOf(String value) {
        return Enum.valueOf(JdwpErrorCode.class, value);
    }

    @NotNull
    public static EnumEntries<JdwpErrorCode> getEntries() {
        return $ENTRIES;
    }

    static {
        NONE = new JdwpErrorCode(0, "No error has occurred.");
        INVALID_THREAD = new JdwpErrorCode(10, "Passed thread is null, is not a valid thread or has exited.");
        INVALID_THREAD_GROUP = new JdwpErrorCode(11, "Thread group invalid.");
        INVALID_PRIORITY = new JdwpErrorCode(12, "Invalid priority.");
        THREAD_NOT_SUSPENDED = new JdwpErrorCode(13, "If the specified thread has not been suspended by an event.");
        THREAD_SUSPENDED = new JdwpErrorCode(14, "Thread already suspended.");
        THREAD_NOT_ALIVE = new JdwpErrorCode(15, "Thread has not been started or is now dead.");
        INVALID_OBJECT = new JdwpErrorCode(20, "If this reference type has been unloaded and garbage collected.");
        INVALID_CLASS = new JdwpErrorCode(21, "Invalid class.");
        CLASS_NOT_PREPARED = new JdwpErrorCode(22, "Class has been loaded but not yet prepared.");
        INVALID_METHODID = new JdwpErrorCode(23, "Invalid method.");
        INVALID_LOCATION = new JdwpErrorCode(24, "Invalid location.");
        INVALID_FIELDID = new JdwpErrorCode(25, "Invalid field.");
        INVALID_FRAMEID = new JdwpErrorCode(30, "Invalid jframeID.");
        NO_MORE_FRAMES = new JdwpErrorCode(31, "There are no more Java or JNI frames on the call stack.");
        OPAQUE_FRAME = new JdwpErrorCode(32, "Information about the frame is not available.");
        NOT_CURRENT_FRAME = new JdwpErrorCode(33, "Operation can only be performed on current frame.");
        TYPE_MISMATCH = new JdwpErrorCode(34, "The variable is not an appropriate type for the function used.");
        INVALID_SLOT = new JdwpErrorCode(35, "Invalid slot.");
        DUPLICATE = new JdwpErrorCode(40, "Item already set.");
        NOT_FOUND = new JdwpErrorCode(41, "Desired element not found.");
        INVALID_MONITOR = new JdwpErrorCode(50, "Invalid monitor.");
        NOT_MONITOR_OWNER = new JdwpErrorCode(51, "This thread doesn't own the monitor.");
        INTERRUPT = new JdwpErrorCode(52, "The call has been interrupted before completion.");
        INVALID_CLASS_FORMAT = new JdwpErrorCode(60, "The virtual machine attempted to read a class file and determined that the file is malformed or otherwise cannot be interpreted as a class file.");
        CIRCULAR_CLASS_DEFINITION = new JdwpErrorCode(61, "A circularity has been detected while initializing a class.");
        FAILS_VERIFICATION = new JdwpErrorCode(62, "The verifier detected that a class file, though well formed, contained some sort of internal inconsistency or security problem.");
        ADD_METHOD_NOT_IMPLEMENTED = new JdwpErrorCode(63, "Adding methods has not been implemented.");
        SCHEMA_CHANGE_NOT_IMPLEMENTED = new JdwpErrorCode(64, "Schema change has not been implemented.");
        INVALID_TYPESTATE = new JdwpErrorCode(65, "The state of the thread has been modified, and is now inconsistent.");
        HIERARCHY_CHANGE_NOT_IMPLEMENTED = new JdwpErrorCode(66, "A direct superclass is different for the new class version, or the set of directly implemented interfaces is different and canUnrestrictedlyRedefineClasses is false.");
        DELETE_METHOD_NOT_IMPLEMENTED = new JdwpErrorCode(67, "The new class version does not declare a method declared in the old class version and canUnrestrictedlyRedefineClasses is false.");
        UNSUPPORTED_VERSION = new JdwpErrorCode(68, "A class file has a version number not supported by this VM.");
        NAMES_DONT_MATCH = new JdwpErrorCode(69, "The class name defined in the new class file is different from the name in the old class object.");
        CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED = new JdwpErrorCode(70, "The new class version has different modifiers and canUnrestrictedlyRedefineClasses is false.");
        METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED = new JdwpErrorCode(71, "A method in the new class version has different modifiers than its counterpart in the old class version and canUnrestrictedlyRedefineClasses is false.");
        NOT_IMPLEMENTED = new JdwpErrorCode(99, "The functionality is not implemented in this virtual machine.");
        NULL_POINTER = new JdwpErrorCode(100, "Invalid pointer.");
        ABSENT_INFORMATION = new JdwpErrorCode(101, "Desired information is not available.");
        INVALID_EVENT_TYPE = new JdwpErrorCode(102, "The specified event type id is not recognized.");
        ILLEGAL_ARGUMENT = new JdwpErrorCode(103, "Illegal argument.");
        OUT_OF_MEMORY = new JdwpErrorCode(110, "The function needed to allocate memory and no more memory was available for allocation.");
        ACCESS_DENIED = new JdwpErrorCode(111, "Debugging has not been enabled in this virtual machine. JVMTI cannot be used.");
        VM_DEAD = new JdwpErrorCode(112, "The virtual machine is not running.");
        INTERNAL = new JdwpErrorCode(113, "An unexpected internal error has occurred.");
        UNATTACHED_THREAD = new JdwpErrorCode(115, "The thread being used to call this function is not attached to the virtual machine. Calls must be made from attached threads.");
        INVALID_TAG = new JdwpErrorCode(500, "object type id or class tag.");
        ALREADY_INVOKING = new JdwpErrorCode(502, "Previous invoke not complete.");
        INVALID_INDEX = new JdwpErrorCode(503, "Index is invalid.");
        INVALID_LENGTH = new JdwpErrorCode(504, "The length is invalid.");
        INVALID_STRING = new JdwpErrorCode(506, "The string is invalid.");
        INVALID_CLASS_LOADER = new JdwpErrorCode(507, "The class loader is invalid.");
        INVALID_ARRAY = new JdwpErrorCode(508, "The array is invalid.");
        TRANSPORT_LOAD = new JdwpErrorCode(509, "Unable to load the transport.");
        TRANSPORT_INIT = new JdwpErrorCode(510, "Unable to initialize the transport.");
        NATIVE_METHOD = new JdwpErrorCode(511, "[n/a]");
        INVALID_COUNT = new JdwpErrorCode(512, "The count is invalid.");
        $VALUES = jdwpErrorCodeArray = new JdwpErrorCode[]{JdwpErrorCode.NONE, JdwpErrorCode.INVALID_THREAD, JdwpErrorCode.INVALID_THREAD_GROUP, JdwpErrorCode.INVALID_PRIORITY, JdwpErrorCode.THREAD_NOT_SUSPENDED, JdwpErrorCode.THREAD_SUSPENDED, JdwpErrorCode.THREAD_NOT_ALIVE, JdwpErrorCode.INVALID_OBJECT, JdwpErrorCode.INVALID_CLASS, JdwpErrorCode.CLASS_NOT_PREPARED, JdwpErrorCode.INVALID_METHODID, JdwpErrorCode.INVALID_LOCATION, JdwpErrorCode.INVALID_FIELDID, JdwpErrorCode.INVALID_FRAMEID, JdwpErrorCode.NO_MORE_FRAMES, JdwpErrorCode.OPAQUE_FRAME, JdwpErrorCode.NOT_CURRENT_FRAME, JdwpErrorCode.TYPE_MISMATCH, JdwpErrorCode.INVALID_SLOT, JdwpErrorCode.DUPLICATE, JdwpErrorCode.NOT_FOUND, JdwpErrorCode.INVALID_MONITOR, JdwpErrorCode.NOT_MONITOR_OWNER, JdwpErrorCode.INTERRUPT, JdwpErrorCode.INVALID_CLASS_FORMAT, JdwpErrorCode.CIRCULAR_CLASS_DEFINITION, JdwpErrorCode.FAILS_VERIFICATION, JdwpErrorCode.ADD_METHOD_NOT_IMPLEMENTED, JdwpErrorCode.SCHEMA_CHANGE_NOT_IMPLEMENTED, JdwpErrorCode.INVALID_TYPESTATE, JdwpErrorCode.HIERARCHY_CHANGE_NOT_IMPLEMENTED, JdwpErrorCode.DELETE_METHOD_NOT_IMPLEMENTED, JdwpErrorCode.UNSUPPORTED_VERSION, JdwpErrorCode.NAMES_DONT_MATCH, JdwpErrorCode.CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED, JdwpErrorCode.METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED, JdwpErrorCode.NOT_IMPLEMENTED, JdwpErrorCode.NULL_POINTER, JdwpErrorCode.ABSENT_INFORMATION, JdwpErrorCode.INVALID_EVENT_TYPE, JdwpErrorCode.ILLEGAL_ARGUMENT, JdwpErrorCode.OUT_OF_MEMORY, JdwpErrorCode.ACCESS_DENIED, JdwpErrorCode.VM_DEAD, JdwpErrorCode.INTERNAL, JdwpErrorCode.UNATTACHED_THREAD, JdwpErrorCode.INVALID_TAG, JdwpErrorCode.ALREADY_INVOKING, JdwpErrorCode.INVALID_INDEX, JdwpErrorCode.INVALID_LENGTH, JdwpErrorCode.INVALID_STRING, JdwpErrorCode.INVALID_CLASS_LOADER, JdwpErrorCode.INVALID_ARRAY, JdwpErrorCode.TRANSPORT_LOAD, JdwpErrorCode.TRANSPORT_INIT, JdwpErrorCode.NATIVE_METHOD, JdwpErrorCode.INVALID_COUNT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/android/adblib/tools/debugging/packets/impl/JdwpErrorCode$Companion;", "", "<init>", "()V", "errorName", "", "errorCode", "", "errorMessage", "binarySearch", "Lcom/android/adblib/tools/debugging/packets/impl/JdwpErrorCode;", "android.sdktools.adblib.tools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String errorName(int errorCode) {
            Object object = this.binarySearch(errorCode);
            if (object == null || (object = object.name()) == null) {
                object = String.valueOf(errorCode);
            }
            return object;
        }

        @NotNull
        public final String errorMessage(int errorCode) {
            Object object = this.binarySearch(errorCode);
            if (object == null || (object = object.getErrorMessage()) == null) {
                object = "[n/a]";
            }
            return object;
        }

        private final JdwpErrorCode binarySearch(int errorCode) {
            JdwpErrorCode[] entries = JdwpErrorCode.values();
            int low = 0;
            int high = entries.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                JdwpErrorCode entry = entries[mid];
                int cmp = entry.getErrorCode() - errorCode;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return entry;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

