/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging;

import com.android.adblib.InstructionSet;
import com.android.adblib.tools.debugging.JdwpProcessProperties;
import com.android.adblib.tools.debugging.OptionalValue;
import com.android.adblib.tools.debugging.OptionalValueKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0002*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a=\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n2\u0006\u0010\r\u001a\u0002H\u000bH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"toLegacyDescription", "", "Lcom/android/adblib/InstructionSet;", "fromLegacyDescription", "Lcom/android/adblib/InstructionSet$Companion;", "value", "mergeWith", "Lcom/android/adblib/tools/debugging/JdwpProcessProperties;", "newer", "mergeWithTerminalValue", "Lcom/android/adblib/tools/debugging/OptionalValue;", "T", "", "terminalValue", "(Lcom/android/adblib/tools/debugging/OptionalValue;Lcom/android/adblib/tools/debugging/OptionalValue;Ljava/lang/Object;)Lcom/android/adblib/tools/debugging/OptionalValue;", "android.sdktools.adblib.tools"})
public final class JdwpProcessPropertiesKt {
    @NotNull
    public static final String toLegacyDescription(@NotNull InstructionSet $this$toLegacyDescription) {
        Intrinsics.checkNotNullParameter((Object)$this$toLegacyDescription, (String)"<this>");
        String instructionSetDescription = StringsKt.contains$default((CharSequence)$this$toLegacyDescription.getText(), (CharSequence)"64", (boolean)false, (int)2, null) ? "64-bit" : "32-bit";
        return ((CharSequence)$this$toLegacyDescription.getText()).length() == 0 ? instructionSetDescription : instructionSetDescription + " (" + $this$toLegacyDescription.getText() + ")";
    }

    @NotNull
    public static final InstructionSet fromLegacyDescription(@NotNull InstructionSet.Companion $this$fromLegacyDescription, @NotNull String value) {
        InstructionSet instructionSet;
        Intrinsics.checkNotNullParameter((Object)$this$fromLegacyDescription, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int index1 = StringsKt.indexOf$default((CharSequence)value, (char)'(', (int)0, (boolean)false, (int)6, null);
        int index2 = StringsKt.indexOf$default((CharSequence)value, (char)')', (int)0, (boolean)false, (int)6, null);
        if (index1 >= 0 && index2 > index1) {
            String string2 = value.substring(index1 + 1, index2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            instructionSet = $this$fromLegacyDescription.fromString(string2);
        } else {
            instructionSet = $this$fromLegacyDescription.fromString(value);
        }
        return instructionSet;
    }

    @NotNull
    public static final JdwpProcessProperties mergeWith(@NotNull JdwpProcessProperties $this$mergeWith, @NotNull JdwpProcessProperties newer) {
        Intrinsics.checkNotNullParameter((Object)$this$mergeWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newer, (String)"newer");
        JdwpProcessProperties current = $this$mergeWith;
        OptionalValue<String> optionalValue = OptionalValueKt.orElse(newer.getProcessName(), current.getProcessName());
        OptionalValue<Integer> optionalValue2 = OptionalValueKt.orElse(newer.getUserId(), current.getUserId());
        OptionalValue<List<String>> optionalValue3 = OptionalValueKt.orElse(newer.getPackageNames(), current.getPackageNames());
        OptionalValue<String> optionalValue4 = OptionalValueKt.orElse(newer.getVmIdentifier(), current.getVmIdentifier());
        OptionalValue<InstructionSet> optionalValue5 = OptionalValueKt.orElse(newer.getInstructionSet(), current.getInstructionSet());
        OptionalValue<String> optionalValue6 = OptionalValueKt.orElse(newer.getJvmFlags(), current.getJvmFlags());
        OptionalValue<Boolean> optionalValue7 = OptionalValueKt.orElse(newer.isNativeDebuggable(), current.isNativeDebuggable());
        OptionalValue<List<String>> optionalValue8 = OptionalValueKt.orElse(newer.getFeatures(), current.getFeatures());
        OptionalValue<Boolean> optionalValue9 = JdwpProcessPropertiesKt.mergeWithTerminalValue(current.isWaitingForDebugger(), newer.isWaitingForDebugger(), false);
        return JdwpProcessProperties.copy$default(current, 0, optionalValue, optionalValue3, optionalValue2, optionalValue4, optionalValue5, optionalValue6, optionalValue7, optionalValue9, optionalValue8, 1, null);
    }

    private static final <T> OptionalValue<T> mergeWithTerminalValue(OptionalValue<T> $this$mergeWithTerminalValue, OptionalValue<T> newer, T terminalValue) {
        if (Intrinsics.areEqual(OptionalValueKt.getOrNull($this$mergeWithTerminalValue), terminalValue)) {
            return $this$mergeWithTerminalValue;
        }
        return OptionalValueKt.orElse(newer, $this$mergeWithTerminalValue);
    }
}

