/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.ListWithErrors;
import com.android.adblib.ReverseSocketInfo;
import com.android.adblib.SocketSpec;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/adblib/impl/ReverseSocketListParser;", "", "<init>", "()V", "lineRegex", "Lkotlin/text/Regex;", "parse", "Lcom/android/adblib/ListWithErrors;", "Lcom/android/adblib/ReverseSocketInfo;", "Lcom/android/adblib/ReverseSocketList;", "input", "", "parseOneShortFormatLine", "", "builder", "Lcom/android/adblib/ListWithErrors$Builder;", "lineIndex", "", "lineText", "android.sdktools.adblib"})
public final class ReverseSocketListParser {
    @NotNull
    private final Regex lineRegex = new Regex("([^ ]+) ([^ ]+) ([^ ]+)");

    @NotNull
    public final ListWithErrors<ReverseSocketInfo> parse(@NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ListWithErrors.Builder<ReverseSocketInfo> builder = new ListWithErrors.Builder<ReverseSocketInfo>();
        if (input.length() == 0) {
            return builder.build();
        }
        Object object = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)input, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = ((Iterable)lines).iterator();
        int n = 0;
        while (object.hasNext()) {
            int lineIndex = n++;
            String line = (String)object.next();
            if (!(((CharSequence)line).length() > 0)) continue;
            this.parseOneShortFormatLine(builder, lineIndex, line);
        }
        return builder.build();
    }

    private final void parseOneShortFormatLine(ListWithErrors.Builder<ReverseSocketInfo> builder, int lineIndex, CharSequence lineText) {
        MatchResult matchResult = Regex.find$default((Regex)this.lineRegex, (CharSequence)lineText, (int)0, (int)2, null);
        if (matchResult == null) {
            builder.addError("Forward line format is not recognized", lineIndex, ((Object)lineText).toString());
            return;
        }
        String transportName = (String)matchResult.getGroupValues().get(1);
        if (((CharSequence)transportName).length() == 0) {
            builder.addError("Transport name is empty", lineIndex, lineText);
            return;
        }
        String remote = (String)matchResult.getGroupValues().get(2);
        if (((CharSequence)remote).length() == 0) {
            builder.addError("Remote address is empty", lineIndex, lineText);
            return;
        }
        SocketSpec remoteAddress = SocketSpec.Companion.fromQueryString(remote);
        String local = (String)matchResult.getGroupValues().get(3);
        if (((CharSequence)local).length() == 0) {
            builder.addError("Local address is empty", lineIndex, lineText);
            return;
        }
        SocketSpec localAddress2 = SocketSpec.Companion.fromQueryString(local);
        builder.addEntry(new ReverseSocketInfo(transportName, remoteAddress, localAddress2));
    }
}

