/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AdbChannelFactory;
import com.android.adblib.AdbDeviceServices;
import com.android.adblib.AdbHostServices;
import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbServerChannelProvider;
import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.ClosedSessionException;
import com.android.adblib.CoroutineScopeCache;
import com.android.adblib.impl.AdbDeviceServicesImpl;
import com.android.adblib.impl.AdbHostServicesImpl;
import com.android.adblib.impl.channels.AdbChannelFactoryImpl;
import com.android.adblib.utils.CoroutineUtilsKt;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020/H\u0016J\b\u00101\u001a\u00020\u0018H\u0016J\b\u00102\u001a\u00020\"H\u0002J\b\u00103\u001a\u00020&H\u0002R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00065"}, d2={"Lcom/android/adblib/impl/AdbSessionImpl;", "Lcom/android/adblib/AdbSession;", "parentSession", "host", "Lcom/android/adblib/AdbSessionHost;", "channelProvider", "Lcom/android/adblib/AdbServerChannelProvider;", "connectionTimeoutMillis", "", "<init>", "(Lcom/android/adblib/AdbSession;Lcom/android/adblib/AdbSessionHost;Lcom/android/adblib/AdbServerChannelProvider;J)V", "getParentSession", "()Lcom/android/adblib/AdbSession;", "getHost", "()Lcom/android/adblib/AdbSessionHost;", "getChannelProvider", "()Lcom/android/adblib/AdbServerChannelProvider;", "logger", "Lcom/android/adblib/AdbLogger;", "id", "", "closed", "", "description", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "channelFactory", "Lcom/android/adblib/AdbChannelFactory;", "getChannelFactory", "()Lcom/android/adblib/AdbChannelFactory;", "hostServices", "Lcom/android/adblib/AdbHostServices;", "getHostServices", "()Lcom/android/adblib/AdbHostServices;", "deviceServices", "Lcom/android/adblib/AdbDeviceServices;", "getDeviceServices", "()Lcom/android/adblib/AdbDeviceServices;", "_cache", "Lcom/android/adblib/CoroutineScopeCache;", "cache", "getCache", "()Lcom/android/adblib/CoroutineScopeCache;", "throwIfClosed", "", "close", "toString", "createHostServices", "createDeviceServices", "Companion", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nAdbSessionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdbSessionImpl.kt\ncom/android/adblib/impl/AdbSessionImpl\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLoggerKt\n+ 3 AdbLogger.kt\ncom/android/adblib/AdbLogger\n*L\n1#1,131:1\n127#2:132\n120#2:133\n46#3:134\n26#3,4:135\n47#3:139\n*S KotlinDebug\n*F\n+ 1 AdbSessionImpl.kt\ncom/android/adblib/impl/AdbSessionImpl\n*L\n42#1:132\n42#1:133\n99#1:134\n99#1:135,4\n99#1:139\n*E\n"})
public final class AdbSessionImpl
implements AdbSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final AdbSession parentSession;
    @NotNull
    private final AdbSessionHost host;
    @NotNull
    private final AdbServerChannelProvider channelProvider;
    private final long connectionTimeoutMillis;
    @NotNull
    private final AdbLogger logger;
    private final int id;
    private boolean closed;
    @NotNull
    private final String description;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AdbChannelFactory channelFactory;
    @NotNull
    private final AdbHostServices hostServices;
    @NotNull
    private final AdbDeviceServices deviceServices;
    @NotNull
    private final CoroutineScopeCache _cache;
    @NotNull
    private static final AtomicInteger sessionId = new AtomicInteger(0);

    /*
     * WARNING - void declaration
     */
    public AdbSessionImpl(@Nullable AdbSession parentSession, @NotNull AdbSessionHost host, @NotNull AdbServerChannelProvider channelProvider2, long connectionTimeoutMillis) {
        void $this$adbLogger$iv;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)channelProvider2, (String)"channelProvider");
        this.parentSession = parentSession;
        this.host = host;
        this.channelProvider = channelProvider2;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        AdbSessionImpl adbSessionImpl = this;
        AdbSessionHost host$iv = this.getHost();
        boolean $i$f$adbLogger = false;
        void var9_8 = $this$adbLogger$iv;
        AdbLoggerFactory loggerFactory$iv$iv = host$iv.getLoggerFactory();
        boolean $i$f$adbLogger2 = false;
        this.logger = loggerFactory$iv$iv.createLogger(AdbSessionImpl.class);
        this.id = sessionId.incrementAndGet();
        this.description = this.getParentSession() == null ? Reflection.getOrCreateKotlinClass(AdbSession.class).getSimpleName() + "(id=" + this.id + ", 'ROOT')" : Reflection.getOrCreateKotlinClass(AdbSession.class).getSimpleName() + "(id=" + this.id + ", parent=" + this.getParentSession() + ")";
        AdbSession adbSession = this.getParentSession();
        if (adbSession == null || (adbSession = adbSession.getScope()) == null || (adbSession = CoroutineUtilsKt.createChildScope((CoroutineScope)adbSession, true, this.getHost().getParentContext())) == null) {
            adbSession = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.getHost().getParentContext().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)this.getHost().getIoDispatcher()));
        }
        this.scope = adbSession;
        this.channelFactory = new AdbChannelFactoryImpl(this);
        this.hostServices = this.createHostServices();
        this.deviceServices = this.createDeviceServices();
        this._cache = CoroutineScopeCache.Companion.create(this.getScope(), this.description);
    }

    @Override
    @Nullable
    public AdbSession getParentSession() {
        return this.parentSession;
    }

    @Override
    @NotNull
    public AdbSessionHost getHost() {
        return this.host;
    }

    @NotNull
    public final AdbServerChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    @Override
    @NotNull
    public CoroutineScope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public AdbChannelFactory getChannelFactory() {
        this.throwIfClosed();
        return this.channelFactory;
    }

    @Override
    @NotNull
    public AdbHostServices getHostServices() {
        this.throwIfClosed();
        return this.hostServices;
    }

    @Override
    @NotNull
    public AdbDeviceServices getDeviceServices() {
        this.throwIfClosed();
        return this.deviceServices;
    }

    @Override
    @NotNull
    public CoroutineScopeCache getCache() {
        this.throwIfClosed();
        return this._cache;
    }

    @Override
    public void throwIfClosed() {
        if (this.closed) {
            throw new ClosedSessionException("Session has been closed");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        if (!this.closed) {
            void this_$iv$iv;
            this.closed = true;
            AdbLogger this_$iv = this.logger;
            boolean $i$f$debug = false;
            AdbLogger adbLogger = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
            boolean $i$f$logIf = false;
            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                void var7_7 = this_$iv$iv;
                boolean bl = false;
                String string2 = "Closing session and cancelling session scope";
                var7_7.log(level, string2);
            }
            this._cache.close();
            CoroutineScopeKt.cancel$default((CoroutineScope)this.getScope(), (String)"adblib session has been cancelled", null, (int)2, null);
        }
    }

    @NotNull
    public String toString() {
        return this.description;
    }

    private final AdbHostServices createHostServices() {
        return new AdbHostServicesImpl(this, this.channelProvider, this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    private final AdbDeviceServices createDeviceServices() {
        return new AdbDeviceServicesImpl(this, this.channelProvider, this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/adblib/impl/AdbSessionImpl$Companion;", "", "<init>", "()V", "sessionId", "Ljava/util/concurrent/atomic/AtomicInteger;", "android.sdktools.adblib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

