/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.meta;

import com.android.repository.Revision;
import com.android.repository.impl.meta.PackageDisplayNameQualifier;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionUtils;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.Library;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlTransient;

public final class DetailsTypes {
    private DetailsTypes() {
    }

    public static String getPlatformPath(AndroidVersion version) {
        return "platforms;" + version.getPlatformHashString();
    }

    public static String getSourcesPath(AndroidVersion version) {
        return "sources;" + version.getPlatformHashString();
    }

    public static String getLldbPath(Revision revision) {
        return "lldb;" + revision.getMajor() + "." + revision.getMinor();
    }

    public static String getAddonPath(IdDisplay vendor, AndroidVersion version, IdDisplay name) {
        return "add-ons;addon-" + name.getId() + "-" + vendor.getId() + "-" + version.getApiStringWithExtension();
    }

    public static String getSysImgPath(IdDisplay vendor, AndroidVersion version, IdDisplay name, String abi) {
        return "system-images;" + version.getPlatformHashString() + ';' + name.getId() + ';' + abi;
    }

    public static String getBuildToolsPath(Revision revision) {
        return "build-tools;" + revision.toString("-");
    }

    @XmlTransient
    @Deprecated
    public static interface MavenType {
    }

    @XmlTransient
    public static interface SysImgDetailsType
    extends ApiDetailsType {
        @Deprecated
        default public void setAbi(String abi) {
            List<String> abis = this.getAbis();
            abis.clear();
            abis.add(abi);
        }

        @Deprecated
        default public boolean isValidAbi(String value) {
            return this.isValidAbis(value);
        }

        @Deprecated
        default public String getAbi() {
            return this.getAbis().get(0);
        }

        @Override
        default public List<String> getAbis() {
            return Collections.singletonList(this.getAbi());
        }

        default public boolean isValidAbis(String value) {
            return value != null && value.matches(Arrays.stream(Abi.values()).map(Abi::toString).collect(Collectors.joining("|")));
        }

        @Override
        default public List<String> getTranslatedAbis() {
            return Collections.emptyList();
        }

        default public boolean isValidTranslatedAbis(String value) {
            return value == null || value.matches("armeabi|armeabi-v7a|arm64-v8a|x86|x86_64|mips|mips64|riscv64");
        }

        default public List<IdDisplay> getTags() {
            return new AbstractList<IdDisplay>(){

                @Override
                public int size() {
                    return SystemImageTags.DEFAULT_TAG.equals(this.getTag()) ? 0 : 1;
                }

                @Override
                public IdDisplay get(int index) {
                    return this.getTag();
                }

                @Override
                public void add(int index, IdDisplay element) {
                    if (index != 0 || this.size() != 0) {
                        throw new IllegalArgumentException("Only one element can be added");
                    }
                    this.setTag(element);
                }

                @Override
                public IdDisplay set(int index, IdDisplay element) {
                    if (index == 0 && this.size() == 1) {
                        IdDisplay oldValue = this.getTag();
                        this.setTag(element);
                        return oldValue;
                    }
                    throw new IndexOutOfBoundsException();
                }

                @Override
                public boolean isEmpty() {
                    return SystemImageTags.DEFAULT_TAG.equals(this.getTag());
                }
            };
        }

        @Deprecated
        default public IdDisplay getTag() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        default public void setTag(IdDisplay tag) {
            throw new UnsupportedOperationException();
        }

        public void setVendor(IdDisplay var1);

        public IdDisplay getVendor();

        @Override
        default public String getQualifierTemplate() {
            return " " + AndroidVersionUtils.getFullApiName(this.getAndroidVersion()) + " (revision {0})";
        }
    }

    @XmlTransient
    public static interface AddonDetailsType
    extends ApiDetailsType {
        public void setVendor(IdDisplay var1);

        public IdDisplay getVendor();

        public Libraries getLibraries();

        public void setLibraries(Libraries var1);

        public void setTag(IdDisplay var1);

        public IdDisplay getTag();

        public String getDefaultSkin();

        @Override
        default public List<String> getAbis() {
            Abi abi = this.getTag().equals(SystemImageTags.GOOGLE_APIS_X86_TAG) ? Abi.X86 : Abi.ARMEABI;
            return Collections.singletonList(((Object)((Object)abi)).toString());
        }

        @Override
        default public List<String> getTranslatedAbis() {
            return Collections.emptyList();
        }

        public static abstract class Libraries {
            public abstract List<Library> getLibrary();
        }
    }

    @XmlTransient
    public static interface ExtraDetailsType {
        public void setVendor(IdDisplay var1);

        public IdDisplay getVendor();
    }

    @XmlTransient
    public static interface PlatformDetailsType
    extends ApiDetailsType {
        public void setLayoutlib(LayoutlibType var1);

        public LayoutlibType getLayoutlib();

        @Override
        default public List<String> getAbis() {
            return Collections.singletonList(Abi.ARMEABI.toString());
        }

        @Override
        default public List<String> getTranslatedAbis() {
            return Collections.emptyList();
        }

        @XmlTransient
        public static abstract class LayoutlibType {
            public abstract void setApi(int var1);

            public abstract int getApi();
        }
    }

    @XmlTransient
    public static interface SourceDetailsType
    extends ApiDetailsType {
        @Override
        default public List<String> getAbis() {
            throw new UnsupportedOperationException();
        }

        @Override
        default public List<String> getTranslatedAbis() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ApiDetailsType
    extends PackageDisplayNameQualifier {
        default public AndroidVersion getAndroidVersion() {
            return new AndroidVersion(this.getApiLevel(), this.getApiMinorLevel(), this.getCodename(), this.getExtensionLevel(), this.isBaseExtension());
        }

        default public void setApiLevel(int apiLevel) {
            if (this.isBaseExtension()) {
                this.setApiLevelString(String.valueOf(apiLevel));
            } else {
                this.setApiLevelString(apiLevel + "x");
            }
        }

        default public int getApiLevel() {
            return ApiDetailsType.getApiLevelInt(this.getApiLevelString());
        }

        default public int getApiMinorLevel() {
            try {
                return ApiDetailsType.getApiMinorLevelInt(this.getApiLevelString());
            }
            catch (UnsupportedOperationException e) {
                return 0;
            }
        }

        default public String getApiLevelString() {
            throw new UnsupportedOperationException();
        }

        default public void setApiLevelString(String apiLevelString) {
            throw new UnsupportedOperationException();
        }

        default public boolean isBaseExtension() {
            return true;
        }

        default public void setBaseExtension(boolean isBaseExtension) {
            throw new UnsupportedOperationException();
        }

        default public Integer getExtensionLevel() {
            return null;
        }

        default public void setExtensionLevel(Integer extensionLevel) {
            throw new UnsupportedOperationException();
        }

        public void setCodename(String var1);

        public String getCodename();

        default public String getQualifierTemplate() {
            return " (revision {0})";
        }

        public static int getApiLevelInt(String apiLevel) {
            if (apiLevel == null) {
                return 0;
            }
            try {
                if (apiLevel.contains(".")) {
                    return Integer.parseInt(apiLevel.substring(0, apiLevel.indexOf(46)));
                }
                if (apiLevel.endsWith("x")) {
                    return Integer.parseInt(apiLevel.substring(0, apiLevel.length() - 1));
                }
                return Integer.parseInt(apiLevel);
            }
            catch (NumberFormatException exception) {
                return 0;
            }
        }

        public static int getApiMinorLevelInt(String apiLevel) {
            if (apiLevel == null) {
                return 0;
            }
            if (apiLevel.contains(".")) {
                try {
                    return Integer.parseInt(apiLevel.substring(apiLevel.indexOf(46) + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0;
        }

        public List<String> getAbis();

        public List<String> getTranslatedAbis();
    }
}

