/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.RemoteSystemImage;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.SystemImageManager;
import com.android.utils.ILogger;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SystemImageSupplier {
    private final RepoManager repoManager;
    private final SystemImageManager systemImageManager;
    private final ILogger logger;

    public SystemImageSupplier(RepoManager repoManager, SystemImageManager systemImageManager, ILogger logger) {
        this.repoManager = repoManager;
        this.systemImageManager = systemImageManager;
        this.logger = logger;
    }

    public Iterable<ISystemImage> get() {
        return this.repoManager.getPackages().getConsolidatedPkgs().values().stream().map(UpdatablePackage::getRepresentative).filter(SystemImageSupplier::hasSystemImage).map(this::from).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static boolean hasSystemImage(RepoPackage repoPackage) {
        TypeDetails details = repoPackage.getTypeDetails();
        return details instanceof DetailsTypes.SysImgDetailsType || details instanceof DetailsTypes.PlatformDetailsType && ((DetailsTypes.PlatformDetailsType)details).getApiLevel() <= 13 || details instanceof DetailsTypes.AddonDetailsType && SystemImageSupplier.hasSystemImage((DetailsTypes.AddonDetailsType)details);
    }

    private static boolean hasSystemImage(DetailsTypes.AddonDetailsType details) {
        return details.getVendor().getId().equals("google") && SystemImageTags.TAGS_WITH_GOOGLE_API.contains(details.getTag()) && details.getApiLevel() <= 19;
    }

    private ISystemImage from(RepoPackage repoPackage) {
        if (repoPackage instanceof RemotePackage) {
            return new RemoteSystemImage((RemotePackage)repoPackage);
        }
        if (repoPackage instanceof LocalPackage) {
            return this.get((LocalPackage)repoPackage);
        }
        this.logger.warning("%s %s", new Object[]{repoPackage.getPath(), repoPackage.getClass()});
        return null;
    }

    private ISystemImage get(LocalPackage localPackage) {
        Collection images = this.systemImageManager.getImageMap().get((Object)localPackage);
        switch (images.size()) {
            case 0: {
                this.logger.warning("No system images for %s", new Object[]{localPackage.getPath()});
                return null;
            }
            case 1: {
                return (ISystemImage)images.iterator().next();
            }
        }
        this.logger.warning("Multiple images for %s. Returning the first.", new Object[]{localPackage.getPath()});
        return (ISystemImage)images.iterator().next();
    }
}

