/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.LocalBuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0016\u0018\u0000 #2\u00020\u0001:\u0004 !\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\tJ\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u0006J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006J\"\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001d2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\tJ \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleInstallationManager;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "myCachedGradleHomeFromPath", "Lcom/intellij/openapi/util/Ref;", "Ljava/nio/file/Path;", "myBuildLayoutParametersCache", "", "", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "guessBuildLayoutParameters", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "getGradleHomePath", "linkedProjectPath", "getGradleHome", "Ljava/io/File;", "getAutodetectedGradleHome", "suggestBetterGradleHomePath", "path", "getGradleJvmPath", "getGradleHomeFromPath", "getGradleHomeFromEnvProperty", "isGradleSdkHome", "", "file", "getClassRoots", "", "rootProjectPath", "findGradleSdkClasspath", "ProjectManagerLayoutParametersCacheCleanupListener", "DynamicPluginLayoutParametersCacheCleanupListener", "TaskNotificationLayoutParametersCacheCleanupListener", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleInstallationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleInstallationManager.kt\norg/jetbrains/plugins/gradle/service/GradleInstallationManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,527:1\n1#2:528\n37#3:529\n36#3,3:530\n*S KotlinDebug\n*F\n+ 1 GradleInstallationManager.kt\norg/jetbrains/plugins/gradle/service/GradleInstallationManager\n*L\n323#1:529\n323#1:530,3\n*E\n"})
public class GradleInstallationManager
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Ref<Path> myCachedGradleHomeFromPath;
    @NotNull
    private final Map<String, BuildLayoutParameters> myBuildLayoutParametersCache = new ConcurrentHashMap();
    @JvmField
    @NotNull
    public static final Pattern GRADLE_JAR_FILE_PATTERN;
    @NotNull
    private static final Pattern ANY_GRADLE_JAR_FILE_PATTERN;
    @NotNull
    private static final Pattern ANT_JAR_PATTERN;
    @NotNull
    private static final Pattern IVY_JAR_PATTERN;
    @NotNull
    private static final String[] GRADLE_START_FILE_NAMES;
    @Nullable
    private static final String GRADLE_ENV_PROPERTY_NAME;
    @NotNull
    private static final Path BREW_GRADLE_LOCATION;
    @NotNull
    private static final String LIBEXEC = "libexec";

    @ApiStatus.Experimental
    @NotNull
    public final BuildLayoutParameters guessBuildLayoutParameters(@NotNull Project project, @Nullable String projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = projectPath;
        if (string == null) {
            string = GradleInstallationManager.Companion.getDefaultProjectKey(project);
        }
        String cacheKey = string;
        BuildLayoutParameters buildLayoutParameters = this.myBuildLayoutParametersCache.computeIfAbsent(cacheKey, arg_0 -> GradleInstallationManager.guessBuildLayoutParameters$lambda$1(arg_0 -> GradleInstallationManager.guessBuildLayoutParameters$lambda$0(projectPath, project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)buildLayoutParameters, (String)"computeIfAbsent(...)");
        return buildLayoutParameters;
    }

    @Nullable
    public final Path getGradleHomePath(@Nullable Project project, @NotNull String linkedProjectPath) {
        Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
        if (project == null) {
            return null;
        }
        BuildLayoutParameters buildLayoutParameters = this.guessBuildLayoutParameters(project, linkedProjectPath);
        return GradleTargetUtil.maybeGetLocalValue(buildLayoutParameters.getGradleHome());
    }

    @Deprecated(message="Use getGradleHomePath(Project, String) instead")
    @Nullable
    public final File getGradleHome(@Nullable Project project, @NotNull String linkedProjectPath) {
        Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
        Path path = this.getGradleHomePath(project, linkedProjectPath);
        return path != null ? path.toFile() : null;
    }

    @Nullable
    public final Path getAutodetectedGradleHome(@Nullable Project project) {
        Path pathValue = this.getGradleHomeFromPath(project);
        if (pathValue != null) {
            return pathValue;
        }
        Path envValue = this.getGradleHomeFromEnvProperty(project);
        if (envValue != null) {
            return envValue;
        }
        if (SystemInfo.isMac) {
            return GradleInstallationManager.Companion.getGradleHomeFromBrew();
        }
        return null;
    }

    @Nullable
    public final Path suggestBetterGradleHomePath(@Nullable Project project, @NotNull Path path) {
        Path libexecPath;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.startsWith(BREW_GRADLE_LOCATION) && this.isGradleSdkHome(project, libexecPath = path.resolve(LIBEXEC))) {
            return libexecPath;
        }
        return null;
    }

    @Nullable
    public String getGradleJvmPath(@NotNull Project project, @NotNull String linkedProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(linkedProjectPath);
        if (gradleProjectSettings == null) {
            return GradleInstallationManager.Companion.getAvailableJavaHome(project);
        }
        GradleProjectSettings settings = gradleProjectSettings;
        String gradleJvm = settings.getGradleJvm();
        SdkLookupProvider sdkLookupProvider = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, settings);
        SdkLookupProvider.SdkInfo sdkInfo2 = (SdkLookupProvider.SdkInfo)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SdkLookupProvider.SdkInfo>, Object>(sdkLookupProvider, project, linkedProjectPath, gradleJvm, null){
            int label;
            final /* synthetic */ SdkLookupProvider $sdkLookupProvider;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $linkedProjectPath;
            final /* synthetic */ String $gradleJvm;
            {
                this.$sdkLookupProvider = $sdkLookupProvider;
                this.$project = $project;
                this.$linkedProjectPath = $linkedProjectPath;
                this.$gradleJvm = $gradleJvm;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = GradleJvmUtil.resolveGradleJvmInfo(this.$sdkLookupProvider, this.$project, this.$linkedProjectPath, this.$gradleJvm, (Continuation<? super SdkLookupProvider.SdkInfo>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SdkLookupProvider.SdkInfo> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Resolved) {
            return ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo2).getHomePath();
        }
        return null;
    }

    private final Path getGradleHomeFromPath(Project project) {
        Ref<Path> ref = this.myCachedGradleHomeFromPath;
        if (ref != null) {
            return (Path)ref.get();
        }
        String string = System.getenv("PATH");
        if (string == null) {
            return null;
        }
        String path = string;
        CharSequence charSequence = path;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        for (String pathEntry : StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            Path dir = Path.of(pathEntry, new String[0]);
            Intrinsics.checkNotNull((Object)dir);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            for (String fileName : GRADLE_START_FILE_NAMES) {
                Path candidate;
                Path startFile = dir.resolve(fileName);
                Intrinsics.checkNotNull((Object)startFile);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isRegularFile(startFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || !this.isGradleSdkHome(project, candidate = dir.getParent())) continue;
                this.myCachedGradleHomeFromPath = new Ref((Object)candidate);
                return candidate;
            }
        }
        return null;
    }

    private final Path getGradleHomeFromEnvProperty(Project project) {
        String string = System.getenv(GRADLE_ENV_PROPERTY_NAME);
        if (string == null) {
            return null;
        }
        String path = string;
        Path candidate = Path.of(path, new String[0]);
        if (this.isGradleSdkHome(project, candidate)) {
            return candidate;
        }
        return null;
    }

    public final boolean isGradleSdkHome(@Nullable Project project, @Nullable Path file) {
        if (file == null) {
            return false;
        }
        Project actualProject = project;
        if (actualProject == null) {
            Project project2;
            ProjectManager projectManager = ProjectManager.getInstance();
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Project[] openProjects = projectArray;
            if (!(openProjects.length == 0)) {
                project2 = openProjects[0];
            } else {
                Project project3 = projectManager.getDefaultProject();
                Intrinsics.checkNotNull((Object)project3);
                project2 = project3;
            }
            actualProject = project2;
        }
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.Companion.getExtensions(projectSystemId)) {
            if (!(executionAware instanceof GradleExecutionAware) || !((GradleExecutionAware)executionAware).isGradleInstallationHomeDir(actualProject, file)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final List<Path> getClassRoots(@Nullable Project project, @Nullable String rootProjectPath) {
        if (project == null) {
            return null;
        }
        if (rootProjectPath == null) {
            for (Module module : ModuleManager.Companion.getInstance(project).getModules()) {
                String path = ExternalSystemModulePropertyManager.Companion.getInstance(module).getRootProjectPath();
                List<Path> result = this.findGradleSdkClasspath(project, path);
                if (result.isEmpty()) continue;
                return result;
            }
        } else {
            return this.findGradleSdkClasspath(project, rootProjectPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Path> findGradleSdkClasspath(Project project, String rootProjectPath) {
        if (rootProjectPath == null) {
            return CollectionsKt.emptyList();
        }
        Path path = this.getGradleHomePath(project, rootProjectPath);
        if (path == null) {
            return CollectionsKt.emptyList();
        }
        Path gradleHome = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(gradleHome, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        ArrayList result = new ArrayList();
        Path src = gradleHome.resolve("src");
        Intrinsics.checkNotNull((Object)src);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.isDirectory(src, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            Path[] pathArray = src.resolve("org");
            Intrinsics.checkNotNullExpressionValue((Object)pathArray, (String)"resolve(...)");
            Path[] pathArray2 = pathArray;
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.isDirectory((Path)pathArray2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                pathArray2 = new Path[]{src};
                GradleInstallationManager.Companion.addRoots(result, pathArray2);
            } else {
                pathArray2 = src;
                Closeable closeable = Files.newDirectoryStream((Path)pathArray2, "*");
                Throwable throwable = null;
                try {
                    DirectoryStream directoryStream = (DirectoryStream)closeable;
                    Intrinsics.checkNotNull((Object)directoryStream);
                    Iterable iterable = directoryStream;
                    for (Path it : iterable) {
                        boolean bl = false;
                        Path[] pathArray3 = new Path[]{it};
                        GradleInstallationManager.Companion.addRoots(result, pathArray3);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        List list = GradleInstallationManager.Companion.getAllLibraries(gradleHome);
        if (list == null) {
            return result;
        }
        List libraries = list;
        for (Path file : libraries) {
            if (!GradleInstallationManager.Companion.isGradleBuildClasspathLibrary(file)) continue;
            ContainerUtil.addIfNotNull((Collection)result, (Object)file);
        }
        return result;
    }

    private static final BuildLayoutParameters guessBuildLayoutParameters$lambda$0(String $projectPath, Project $project, String it) {
        BuildLayoutParameters buildLayoutParameters;
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.Companion.getExtensions(projectSystemId)) {
            BuildLayoutParameters buildLayoutParameters2;
            BuildLayoutParameters buildLayoutParameters3;
            if (!(executionAware instanceof GradleExecutionAware)) continue;
            if ($projectPath == null) {
                buildLayoutParameters3 = ((GradleExecutionAware)executionAware).getDefaultBuildLayoutParameters($project);
            } else {
                GradleExecutionAware gradleExecutionAware = (GradleExecutionAware)executionAware;
                Path path = Path.of($projectPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                buildLayoutParameters3 = gradleExecutionAware.getBuildLayoutParameters($project, path);
            }
            if ((buildLayoutParameters2 = buildLayoutParameters3) == null) continue;
            return buildLayoutParameters2;
        }
        if ($projectPath != null) {
            LocalGradleExecutionAware localGradleExecutionAware = new LocalGradleExecutionAware();
            Path path = Path.of($projectPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            buildLayoutParameters = localGradleExecutionAware.getBuildLayoutParameters($project, path);
        } else {
            buildLayoutParameters = new LocalGradleExecutionAware().getDefaultBuildLayoutParameters($project);
        }
        return buildLayoutParameters;
    }

    private static final BuildLayoutParameters guessBuildLayoutParameters$lambda$1(Function1 $tmp0, Object p0) {
        return (BuildLayoutParameters)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final GradleInstallationManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @ApiStatus.Experimental
    @NotNull
    public static final BuildLayoutParameters defaultBuildLayoutParameters(@NotNull Project project) {
        return Companion.defaultBuildLayoutParameters(project);
    }

    @JvmStatic
    @Nullable
    public static final String getGradleVersion(@Nullable Path gradleHome) {
        return Companion.getGradleVersion(gradleHome);
    }

    @JvmStatic
    @Deprecated(message="Use {@link GradleInstallationManager#getGradleVersion(Path)} instead.")
    @Nullable
    public static final String getGradleVersion(@Nullable String gradleHome) {
        return Companion.getGradleVersion(gradleHome);
    }

    @JvmStatic
    @Nullable
    public static final GradleVersion guessGradleVersion(@NotNull GradleProjectSettings settings) {
        return Companion.guessGradleVersion(settings);
    }

    @JvmStatic
    @Nullable
    public static final GradleVersion parseDistributionVersion(@NotNull String path) {
        return Companion.parseDistributionVersion(path);
    }

    @JvmStatic
    @Nullable
    public static final GradleVersion getGradleVersionSafe(@NotNull String gradleVersion) {
        return Companion.getGradleVersionSafe(gradleVersion);
    }

    static {
        Pattern pattern = Pattern.compile(System.getProperty("gradle.pattern.core.jar", "gradle-(core-)?(\\d.*)\\.jar"));
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        GRADLE_JAR_FILE_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile(System.getProperty("gradle.pattern.core.jar", "gradle-(.*)\\.jar"));
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        ANY_GRADLE_JAR_FILE_PATTERN = pattern2;
        Pattern pattern3 = Pattern.compile("ant(-(.*))?\\.jar");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        ANT_JAR_PATTERN = pattern3;
        Pattern pattern4 = Pattern.compile("ivy(-(.*))?\\.jar");
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        IVY_JAR_PATTERN = pattern4;
        String string = System.getProperty("gradle.start.file.names", "gradle:gradle.cmd:gradle.sh");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex(":");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        GRADLE_START_FILE_NAMES = thisCollection$iv.toArray(new String[0]);
        GRADLE_ENV_PROPERTY_NAME = System.getProperty("gradle.home.env.key", "GRADLE_HOME");
        Path path = Paths.get("/usr/local/Cellar/gradle/", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        BREW_GRADLE_LOCATION = path;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0014H\u0007J\u0014\u0010 \u001a\u0004\u0018\u00010\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0014H\u0002J/\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140*2\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u000e\"\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\u000fH\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203H\u0007J\u0012\u00104\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u00020\u000fH\u0007J\u0012\u00106\u001a\u0004\u0018\u0001012\u0006\u00107\u001a\u00020\u000fH\u0007J\u0012\u00108\u001a\u0004\u0018\u00010\u001a2\u0006\u00102\u001a\u000203H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0015\u0010\u0011\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleInstallationManager$Companion;", "", "<init>", "()V", "GRADLE_JAR_FILE_PATTERN", "Ljava/util/regex/Pattern;", "ANY_GRADLE_JAR_FILE_PATTERN", "getANY_GRADLE_JAR_FILE_PATTERN", "()Ljava/util/regex/Pattern;", "ANT_JAR_PATTERN", "getANT_JAR_PATTERN", "IVY_JAR_PATTERN", "getIVY_JAR_PATTERN", "GRADLE_START_FILE_NAMES", "", "", "[Ljava/lang/String;", "GRADLE_ENV_PROPERTY_NAME", "Lorg/jetbrains/annotations/NonNls;", "BREW_GRADLE_LOCATION", "Ljava/nio/file/Path;", "LIBEXEC", "getInstance", "Lorg/jetbrains/plugins/gradle/service/GradleInstallationManager;", "getDefaultProjectKey", "project", "Lcom/intellij/openapi/project/Project;", "defaultBuildLayoutParameters", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "getAllLibraries", "", "gradleHome", "getGradleVersion", "gradleHomeFromBrew", "getGradleHomeFromBrew", "()Ljava/nio/file/Path;", "isGradleBuildClasspathLibrary", "", "file", "addRoots", "", "result", "", "files", "(Ljava/util/List;[Ljava/nio/file/Path;)V", "isGroovyJar", "name", "getAvailableJavaHome", "guessGradleVersion", "Lorg/gradle/util/GradleVersion;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "parseDistributionVersion", "path", "getGradleVersionSafe", "gradleVersion", "findProject", "intellij.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleInstallationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleInstallationManager.kt\norg/jetbrains/plugins/gradle/service/GradleInstallationManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,527:1\n30#2,2:528\n*S KotlinDebug\n*F\n+ 1 GradleInstallationManager.kt\norg/jetbrains/plugins/gradle/service/GradleInstallationManager$Companion\n*L\n330#1:528,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getANY_GRADLE_JAR_FILE_PATTERN() {
            return ANY_GRADLE_JAR_FILE_PATTERN;
        }

        @NotNull
        public final Pattern getANT_JAR_PATTERN() {
            return ANT_JAR_PATTERN;
        }

        @NotNull
        public final Pattern getIVY_JAR_PATTERN() {
            return IVY_JAR_PATTERN;
        }

        @JvmStatic
        @NotNull
        public final GradleInstallationManager getInstance() {
            ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service = false;
            Class<GradleInstallationManager> serviceClass$iv = GradleInstallationManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GradleInstallationManager)object;
        }

        private final String getDefaultProjectKey(Project project) {
            String string = project.getLocationHash();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationHash(...)");
            return string;
        }

        @JvmStatic
        @ApiStatus.Experimental
        @NotNull
        public final BuildLayoutParameters defaultBuildLayoutParameters(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance().guessBuildLayoutParameters(project, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<Path> getAllLibraries(Path gradleHome) {
            Iterable iterable;
            DirectoryStream directoryStream;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(gradleHome, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            ArrayList<Path> result = new ArrayList<Path>();
            Path path = gradleHome.resolve("lib");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path path2 = path;
            Closeable closeable = Files.newDirectoryStream(path2, "*");
            Throwable throwable = null;
            try {
                directoryStream = (DirectoryStream)closeable;
                Intrinsics.checkNotNull((Object)directoryStream);
                iterable = directoryStream;
                for (Path it : iterable) {
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)((Object)it.getFileName()).toString(), (String)".jar", (boolean)false, (int)2, null)) continue;
                    result.add(it);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Path path3 = gradleHome.resolve("lib/plugins");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            path2 = path3;
            closeable = Files.newDirectoryStream(path2, "*");
            throwable = null;
            try {
                directoryStream = (DirectoryStream)closeable;
                Intrinsics.checkNotNull((Object)directoryStream);
                iterable = directoryStream;
                for (Path it : iterable) {
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)((Object)it.getFileName()).toString(), (String)".jar", (boolean)false, (int)2, null)) continue;
                    result.add(it);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return result.isEmpty() ? null : (List)result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final String getGradleVersion(@Nullable Path gradleHome) {
            if (gradleHome == null) {
                return null;
            }
            Path libs = gradleHome.resolve("lib");
            Intrinsics.checkNotNull((Object)libs);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(libs, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            try {
                AutoCloseable autoCloseable = Files.list(libs);
                Throwable throwable = null;
                try {
                    Stream children = (Stream)autoCloseable;
                    boolean bl = false;
                    String string = children.map(arg_0 -> Companion.getGradleVersion$lambda$6$lambda$3(Companion::getGradleVersion$lambda$6$lambda$2, arg_0)).filter(arg_0 -> Companion.getGradleVersion$lambda$6$lambda$5(Companion::getGradleVersion$lambda$6$lambda$4, arg_0)).findFirst().orElse(null);
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @JvmStatic
        @Deprecated(message="Use {@link GradleInstallationManager#getGradleVersion(Path)} instead.")
        @Nullable
        public final String getGradleVersion(@Nullable String gradleHome) {
            if (gradleHome == null) {
                return null;
            }
            return this.getGradleVersion(NioPathUtil.toNioPathOrNull((String)gradleHome));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Path getGradleHomeFromBrew() {
            try {
                Closeable closeable = Files.newDirectoryStream(BREW_GRADLE_LOCATION);
                Throwable throwable = null;
                try {
                    DirectoryStream ds = (DirectoryStream)closeable;
                    boolean bl = false;
                    Path bestPath = null;
                    Version highestVersion = null;
                    Iterator iterator = ds.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                    Iterator iterator2 = iterator;
                    while (iterator2.hasNext()) {
                        Path path = (Path)iterator2.next();
                        String fileName = ((Object)path.getFileName()).toString();
                        try {
                            Version version = Version.parseVersion((String)fileName);
                            if (version == null || highestVersion != null && version.compareTo(highestVersion) <= 0) continue;
                            highestVersion = version;
                            bestPath = path;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (bestPath != null) {
                        Path path = bestPath.resolve(GradleInstallationManager.LIBEXEC);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                        Path libexecPath = path;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.exists(libexecPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            Path path2 = libexecPath;
                            return path2;
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private final boolean isGradleBuildClasspathLibrary(Path file) {
            String fileName = ((Object)file.getFileName()).toString();
            return this.getANY_GRADLE_JAR_FILE_PATTERN().matcher(fileName).matches() || this.getANT_JAR_PATTERN().matcher(fileName).matches() || this.getIVY_JAR_PATTERN().matcher(fileName).matches() || this.isGroovyJar(fileName);
        }

        private final void addRoots(List<Path> result, Path ... files) {
            for (Path file : files) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                result.add(file);
            }
        }

        private final boolean isGroovyJar(String name) {
            String name2 = name;
            String string = StringUtil.toLowerCase((String)name2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            name2 = string;
            return StringsKt.startsWith$default((String)name2, (String)"groovy-", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name2, (String)".jar", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)name2, (CharSequence)"src", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)name2, (CharSequence)"doc", (boolean)false, (int)2, null);
        }

        private final String getAvailableJavaHome(Project project) {
            Pair pair = ExternalSystemJdkUtil.getAvailableJdk((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"getAvailableJdk(...)");
            Pair sdkPair = pair;
            if (ExternalSystemJdkUtil.isValidJdk((Sdk)((Sdk)sdkPair.second))) {
                Object object = sdkPair.second;
                Intrinsics.checkNotNull((Object)object);
                return ((Sdk)object).getHomePath();
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final GradleVersion guessGradleVersion(@NotNull GradleProjectSettings settings) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            DistributionType distributionType = settings.getDistributionType();
            if (distributionType == null) {
                return null;
            }
            BuildLayoutParameters buildLayoutParameters = null;
            Project project = this.findProject(settings);
            if (project == null) {
                Project project2 = ProjectManager.getInstance().getDefaultProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
                Project defaultProject = project2;
                String string = settings.getExternalProjectPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
                Path path = NioPathUtil.toNioPathOrNull((String)string);
                buildLayoutParameters = new LocalBuildLayoutParameters(defaultProject, settings, path){
                    final /* synthetic */ GradleProjectSettings $settings;
                    {
                        this.$settings = $settings;
                        super($defaultProject, $super_call_param$1);
                    }

                    public GradleProjectSettings getGradleProjectSettings() {
                        return this.$settings;
                    }
                };
            } else {
                buildLayoutParameters = this.getInstance().guessBuildLayoutParameters(project, settings.getExternalProjectPath());
            }
            return buildLayoutParameters.getGradleVersion();
        }

        @JvmStatic
        @Nullable
        public final GradleVersion parseDistributionVersion(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String path2 = path;
            String string = StringUtil.substringAfterLast((String)path2, (String)"/");
            if (string == null) {
                return null;
            }
            path2 = string;
            String string2 = StringUtil.substringAfterLast((String)path2, (String)"gradle-");
            if (string2 == null) {
                return null;
            }
            path2 = string2;
            int i = StringsKt.lastIndexOf$default((CharSequence)path2, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (i <= 0) {
                return null;
            }
            String string3 = path2.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return this.getGradleVersionSafe(string3);
        }

        @JvmStatic
        @Nullable
        public final GradleVersion getGradleVersionSafe(@NotNull String gradleVersion) {
            Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
            try {
                return GradleVersion.version((String)gradleVersion);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        private final Project findProject(GradleProjectSettings settings) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                GradleProjectSettings linkedProjectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(settings.getExternalProjectPath());
                if (linkedProjectSettings != settings) continue;
                return project;
            }
            return null;
        }

        private static final String getGradleVersion$lambda$6$lambda$2(Path path) {
            Matcher matcher;
            Path path2 = path;
            Intrinsics.checkNotNull((Object)path2);
            Path fileName = path2.getFileName();
            if (fileName != null && (matcher = GRADLE_JAR_FILE_PATTERN.matcher(((Object)fileName).toString())).matches()) {
                return matcher.group(2);
            }
            return null;
        }

        private static final String getGradleVersion$lambda$6$lambda$3(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final boolean getGradleVersion$lambda$6$lambda$4(String it) {
            return Objects.nonNull(it);
        }

        private static final boolean getGradleVersion$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleInstallationManager$DynamicPluginLayoutParametersCacheCleanupListener;", "Lcom/intellij/ide/plugins/DynamicPluginListener;", "<init>", "()V", "beforePluginUnload", "", "pluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "isUpdate", "", "intellij.gradle"})
    @ApiStatus.Internal
    public static final class DynamicPluginLayoutParametersCacheCleanupListener
    implements DynamicPluginListener {
        public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
            Companion.getInstance().myBuildLayoutParametersCache.clear();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleInstallationManager$ProjectManagerLayoutParametersCacheCleanupListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "<init>", "()V", "projectClosed", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.gradle"})
    @ApiStatus.Internal
    public static final class ProjectManagerLayoutParametersCacheCleanupListener
    implements ProjectManagerListener {
        public void projectClosed(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Companion.getInstance().myBuildLayoutParametersCache.clear();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleInstallationManager$TaskNotificationLayoutParametersCacheCleanupListener;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "<init>", "()V", "onStart", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "onEnd", "intellij.gradle"})
    @ApiStatus.Internal
    public static final class TaskNotificationLayoutParametersCacheCleanupListener
    implements ExternalSystemTaskNotificationListener {
        public void onStart(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Companion.getInstance().myBuildLayoutParametersCache.remove(projectPath);
        }

        public void onEnd(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (id.getProjectSystemId() != GradleConstants.SYSTEM_ID || id.getType() != ExternalSystemTaskType.RESOLVE_PROJECT) {
                return;
            }
            Project project = id.findProject();
            if (project == null) {
                return;
            }
            GradleInstallationManager installationManager = Companion.getInstance();
            installationManager.myBuildLayoutParametersCache.remove(Companion.getDefaultProjectKey(project));
            GradleSettings gradleSettings = GradleSettings.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
            GradleSettings settings = gradleSettings;
            for (GradleProjectSettings linkedSettings : settings.getLinkedProjectsSettings()) {
                String path = linkedSettings.getExternalProjectPath();
                installationManager.myBuildLayoutParametersCache.remove(path);
            }
        }
    }
}

