/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.model.fragments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.CpuProcessSlice;
import trebuchet.model.fragments.ProcessModelFragment;
import trebuchet.model.fragments.ThreadModelFragment;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001'B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Ltrebuchet/model/fragments/SchedulingProcessFragment;", "Ltrebuchet/model/CpuProcessSlice;", "process", "Ltrebuchet/model/fragments/ProcessModelFragment;", "thread", "Ltrebuchet/model/fragments/ThreadModelFragment;", "startTime", "", "<init>", "(Ltrebuchet/model/fragments/ProcessModelFragment;Ltrebuchet/model/fragments/ThreadModelFragment;D)V", "getProcess", "()Ltrebuchet/model/fragments/ProcessModelFragment;", "getThread", "()Ltrebuchet/model/fragments/ThreadModelFragment;", "getStartTime", "()D", "endTime", "getEndTime", "setEndTime", "(D)V", "cpuTime", "getCpuTime", "setCpuTime", "name", "", "getName", "()Ljava/lang/String;", "threadName", "getThreadName", "threadId", "", "getThreadId", "()I", "id", "getId", "didNotFinish", "", "getDidNotFinish", "()Z", "Builder", "intellij.android.profilers.atrace"})
public final class SchedulingProcessFragment
implements CpuProcessSlice {
    @NotNull
    private final ProcessModelFragment process;
    @NotNull
    private final ThreadModelFragment thread;
    private final double startTime;
    private double endTime;
    private double cpuTime;

    public SchedulingProcessFragment(@NotNull ProcessModelFragment process, @NotNull ThreadModelFragment thread, double startTime) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.process = process;
        this.thread = thread;
        this.startTime = startTime;
        this.endTime = Double.MAX_VALUE;
    }

    @NotNull
    public final ProcessModelFragment getProcess() {
        return this.process;
    }

    @NotNull
    public final ThreadModelFragment getThread() {
        return this.thread;
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public double getEndTime() {
        return this.endTime;
    }

    public void setEndTime(double d) {
        this.endTime = d;
    }

    @Override
    public double getCpuTime() {
        return this.cpuTime;
    }

    public void setCpuTime(double d) {
        this.cpuTime = d;
    }

    @Override
    @NotNull
    public String getName() {
        String string;
        if (this.process.getName() != null) {
            String string2 = this.process.getName();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            string = String.valueOf(this.process.getId());
        }
        return string;
    }

    @Override
    @NotNull
    public String getThreadName() {
        if (this.thread.getName() != null) {
            String string = this.thread.getName();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        return String.valueOf(this.getThreadId());
    }

    @Override
    public int getThreadId() {
        return this.thread.getId();
    }

    @Override
    public int getId() {
        return this.process.getId();
    }

    @Override
    public boolean getDidNotFinish() {
        return this.getEndTime() == Double.MAX_VALUE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Ltrebuchet/model/fragments/SchedulingProcessFragment$Builder;", "", "<init>", "()V", "_slices", "", "Ltrebuchet/model/fragments/SchedulingProcessFragment;", "slices", "", "getSlices", "()Ljava/util/List;", "switchProcess", "", "process", "Ltrebuchet/model/fragments/ProcessModelFragment;", "thread", "Ltrebuchet/model/fragments/ThreadModelFragment;", "timestamp", "", "intellij.android.profilers.atrace"})
    public static final class Builder {
        @NotNull
        private final List<SchedulingProcessFragment> _slices = new ArrayList();

        @NotNull
        public final List<SchedulingProcessFragment> getSlices() {
            return this._slices;
        }

        public final void switchProcess(@NotNull ProcessModelFragment process, @NotNull ThreadModelFragment thread, double timestamp) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            if (!((Collection)this._slices).isEmpty() && ((SchedulingProcessFragment)CollectionsKt.last(this._slices)).getEndTime() == Double.MAX_VALUE) {
                ((SchedulingProcessFragment)CollectionsKt.last(this._slices)).setEndTime(timestamp);
            }
            if (thread.getId() != 0) {
                this._slices.add(new SchedulingProcessFragment(process, thread, timestamp));
            }
        }
    }
}

