/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.importers.ftrace;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.importers.ImportFeedback;
import trebuchet.importers.Importer;
import trebuchet.importers.ImporterFactory;
import trebuchet.importers.ftrace.FtraceImporterState;
import trebuchet.importers.ftrace.FtraceLine;
import trebuchet.io.DataSlice;
import trebuchet.io.GenericByteBuffer;
import trebuchet.io.StreamingLineReader;
import trebuchet.io.StreamingReader;
import trebuchet.model.fragments.ModelFragment;
import trebuchet.util.StringSearchKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ltrebuchet/importers/ftrace/FtraceImporter;", "Ltrebuchet/importers/Importer;", "feedback", "Ltrebuchet/importers/ImportFeedback;", "<init>", "(Ltrebuchet/importers/ImportFeedback;)V", "getFeedback", "()Ltrebuchet/importers/ImportFeedback;", "foundHeader", "", "getFoundHeader", "()Z", "setFoundHeader", "(Z)V", "state", "Ltrebuchet/importers/ftrace/FtraceImporterState;", "getState", "()Ltrebuchet/importers/ftrace/FtraceImporterState;", "setState", "(Ltrebuchet/importers/ftrace/FtraceImporterState;)V", "parser", "Ltrebuchet/importers/ftrace/FtraceLine$Parser;", "getParser", "()Ltrebuchet/importers/ftrace/FtraceLine$Parser;", "lineReaderCallback", "Lkotlin/Function1;", "Ltrebuchet/io/DataSlice;", "", "ftraceParserCallback", "Ltrebuchet/importers/ftrace/FtraceLine;", "coreStartedRegex", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "import", "Ltrebuchet/model/fragments/ModelFragment;", "stream", "Ltrebuchet/io/StreamingReader;", "handleLine", "line", "Factory", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nFtraceImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FtraceImporter.kt\ntrebuchet/importers/ftrace/FtraceImporter\n+ 2 DataSlice.kt\ntrebuchet/io/DataSlice\n*L\n1#1,85:1\n31#2:86\n31#2:87\n*S KotlinDebug\n*F\n+ 1 FtraceImporter.kt\ntrebuchet/importers/ftrace/FtraceImporter\n*L\n54#1:86\n63#1:87\n*E\n"})
public final class FtraceImporter
implements Importer {
    @NotNull
    private final ImportFeedback feedback;
    private boolean foundHeader;
    @NotNull
    private FtraceImporterState state;
    @NotNull
    private final FtraceLine.Parser parser;
    @NotNull
    private final Function1<DataSlice, Unit> lineReaderCallback;
    @NotNull
    private Function1<? super FtraceLine, Unit> ftraceParserCallback;
    private final Pattern coreStartedRegex;

    public FtraceImporter(@NotNull ImportFeedback feedback) {
        Intrinsics.checkNotNullParameter((Object)feedback, (String)"feedback");
        this.feedback = feedback;
        this.state = new FtraceImporterState(this.feedback);
        this.parser = new FtraceLine.Parser(this.state.getStringCache());
        this.lineReaderCallback = (Function1)new Function1<DataSlice, Unit>((Object)this){

            public final void invoke(DataSlice p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((FtraceImporter)this.receiver).handleLine(p0);
            }
        };
        this.ftraceParserCallback = (Function1)new Function1<FtraceLine, Unit>((Object)this.state){

            public final void invoke(FtraceLine p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((FtraceImporterState)this.receiver).importLine(p0);
            }
        };
        this.coreStartedRegex = Pattern.compile("^#+ CPU \\d buffer started #+");
    }

    @NotNull
    public final ImportFeedback getFeedback() {
        return this.feedback;
    }

    public final boolean getFoundHeader() {
        return this.foundHeader;
    }

    public final void setFoundHeader(boolean bl) {
        this.foundHeader = bl;
    }

    @NotNull
    public final FtraceImporterState getState() {
        return this.state;
    }

    public final void setState(@NotNull FtraceImporterState ftraceImporterState) {
        Intrinsics.checkNotNullParameter((Object)ftraceImporterState, (String)"<set-?>");
        this.state = ftraceImporterState;
    }

    @NotNull
    public final FtraceLine.Parser getParser() {
        return this.parser;
    }

    @Override
    @Nullable
    public ModelFragment import(@NotNull StreamingReader stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        StreamingLineReader lineReader = new StreamingLineReader(1024, stream);
        this.foundHeader = false;
        lineReader.forEachLine(this.lineReaderCallback);
        return this.state.finish();
    }

    public final void handleLine(@NotNull DataSlice line) {
        block8: {
            DataSlice this_$iv;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (line.getBuffer().length < 2) {
                return;
            }
            DataSlice dataSlice = line;
            int i$iv = 1;
            boolean $i$f$get = false;
            if (this_$iv.getBuffer()[this_$iv.getStartIndex() + i$iv] == 35 && this.coreStartedRegex.matcher(line.toString()).matches()) {
                this.state = new FtraceImporterState(this.feedback);
                this.ftraceParserCallback = (Function1)new Function1<FtraceLine, Unit>((Object)this.state){

                    public final void invoke(FtraceLine p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((FtraceImporterState)this.receiver).importLine(p0);
                    }
                };
            } else {
                this_$iv = line;
                i$iv = 0;
                $i$f$get = false;
                if (this_$iv.getBuffer()[this_$iv.getStartIndex() + i$iv] == 35) {
                    this.foundHeader = true;
                } else if (this.foundHeader) {
                    try {
                        this.parser.parseLine(line, this.ftraceParserCallback);
                    }
                    catch (Exception ex) {
                        if (!(!StringsKt.isBlank((CharSequence)line.toString()))) break block8;
                        this.feedback.reportImportWarning("Failed to parse: '" + line + "'");
                        this.feedback.reportImportException(ex);
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ltrebuchet/importers/ftrace/FtraceImporter$Factory;", "Ltrebuchet/importers/ImporterFactory;", "<init>", "()V", "importerFor", "Ltrebuchet/importers/Importer;", "buffer", "Ltrebuchet/io/GenericByteBuffer;", "feedback", "Ltrebuchet/importers/ImportFeedback;", "intellij.android.profilers.atrace"})
    public static final class Factory
    implements ImporterFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @Nullable
        public Importer importerFor(@NotNull GenericByteBuffer buffer, @NotNull ImportFeedback feedback) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)feedback, (String)"feedback");
            if (StringSearchKt.contains(buffer, "# tracer: nop\n", 1000)) {
                return new FtraceImporter(feedback);
            }
            return null;
        }
    }
}

