/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.taskbased.pastrecordings;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.taskbased.TaskEntranceTabModel;
import com.android.tools.profilers.taskbased.home.selections.recordings.RecordingListModel;
import com.android.tools.profilers.taskbased.task.TaskGridModel;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0012J\b\u0010\u001a\u001a\u00020\u0017H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/profilers/taskbased/pastrecordings/PastRecordingsTabModel;", "Lcom/android/tools/profilers/taskbased/TaskEntranceTabModel;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;)V", "recordingListModel", "Lcom/android/tools/profilers/taskbased/home/selections/recordings/RecordingListModel;", "getRecordingListModel", "()Lcom/android/tools/profilers/taskbased/home/selections/recordings/RecordingListModel;", "selectedRecording", "Lcom/android/tools/profilers/sessions/SessionItem;", "getSelectedRecording$annotations", "()V", "getSelectedRecording", "()Lcom/android/tools/profilers/sessions/SessionItem;", "_isBannerClosed", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "isBannerClosed", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "onRecordingBannerClose", "", "onRecordingBannerDontShowAgainClick", "isRecordingBannerNotShownAgain", "doEnterTaskButton", "Companion", "intellij.android.profilers"})
public final class PastRecordingsTabModel
extends TaskEntranceTabModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RecordingListModel recordingListModel;
    @NotNull
    private final MutableStateFlow<Boolean> _isBannerClosed;
    @NotNull
    private final StateFlow<Boolean> isBannerClosed;
    @NotNull
    public static final String DONT_SHOWN_AGAIN_RECORDING_BANNER = "DONT_SHOW_AGAIN_RECORDING_BANNER";

    public PastRecordingsTabModel(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        super(profilers);
        Map<ProfilerTaskType, ProfilerTaskHandler> map = this.getTaskHandlers();
        Intrinsics.checkNotNullExpressionValue(map, (String)"<get-taskHandlers>(...)");
        this.recordingListModel = new RecordingListModel(profilers, map, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this.getTaskGridModel()){

            public final void invoke() {
                ((TaskGridModel)this.receiver).resetTaskSelection();
            }
        }), (Function1<? super ProfilerTaskType, Unit>)((Function1)new Function1<ProfilerTaskType, Unit>((Object)this.getTaskGridModel()){

            public final void invoke(ProfilerTaskType p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                ((TaskGridModel)this.receiver).onTaskSelection(p0);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((PastRecordingsTabModel)this.receiver).onEnterTaskButtonClick();
            }
        }));
        this._isBannerClosed = StateFlowKt.MutableStateFlow((Object)false);
        this.isBannerClosed = FlowKt.asStateFlow(this._isBannerClosed);
    }

    @NotNull
    public final RecordingListModel getRecordingListModel() {
        return this.recordingListModel;
    }

    @Nullable
    public final SessionItem getSelectedRecording() {
        return (SessionItem)this.recordingListModel.getSelectedRecording().getValue();
    }

    @VisibleForTesting
    public static /* synthetic */ void getSelectedRecording$annotations() {
    }

    @NotNull
    public final StateFlow<Boolean> isBannerClosed() {
        return this.isBannerClosed;
    }

    public final void onRecordingBannerClose() {
        this._isBannerClosed.setValue((Object)true);
    }

    public final void onRecordingBannerDontShowAgainClick() {
        this.onRecordingBannerClose();
        this.getProfilers().getIdeServices().getPersistentProfilerPreferences().setBoolean(DONT_SHOWN_AGAIN_RECORDING_BANNER, true);
    }

    public final boolean isRecordingBannerNotShownAgain() {
        return this.getProfilers().getIdeServices().getPersistentProfilerPreferences().getBoolean(DONT_SHOWN_AGAIN_RECORDING_BANNER, false);
    }

    @Override
    protected void doEnterTaskButton() {
        SessionItem sessionItem = this.getSelectedRecording();
        Intrinsics.checkNotNull((Object)sessionItem);
        Common.Session selectedSession = sessionItem.getSession();
        this.getProfilers().getSessionsManager().setCurrentTaskType(this.getSelectedTaskType());
        this.getProfilers().getSessionsManager().setSession(selectedSession);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/profilers/taskbased/pastrecordings/PastRecordingsTabModel$Companion;", "", "<init>", "()V", "DONT_SHOWN_AGAIN_RECORDING_BANNER", "", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

